/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class InstallCert {
    private static ILogger logger = ILPLogManager.getLogger(InstallCert.class);
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public boolean installCert(String string, String string2, String string3) {
        boolean bl = false;
        char[] cArray = string2.toCharArray();
        logger.b("Retrieving server certificates, using java: " + System.getProperty("java.home"));
        OutputStream outputStream = null;
        try {
            Object object;
            Object object2;
            Object object3;
            File file;
            File file2 = new File(string3);
            URL uRL = new URL(string);
            String string4 = uRL.getHost();
            int n2 = uRL.getPort();
            if (n2 < 0) {
                n2 = 443;
            }
            if (!(file = file2).isFile()) {
                char c2 = File.separatorChar;
                object3 = new File(String.valueOf(System.getProperty("java.home")) + c2 + "lib" + c2 + "security");
                file = new File((File)object3, "jssecacerts");
                if (!file.isFile()) {
                    file = new File((File)object3, "cacerts");
                }
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            object3 = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                logger.b("Loading truststore");
                ((KeyStore)object3).load(fileInputStream, cArray);
            }
            catch (Exception exception) {
                try {
                    object2 = "changeit".toCharArray();
                    ((KeyStore)object3).load(null, (char[])object2);
                    object = new FileOutputStream(file);
                    ((KeyStore)object3).store((OutputStream)object, cArray);
                    ((FileOutputStream)object).close();
                }
                catch (Exception exception2) {
                    logger.c("Could not create truststore: " + string3);
                }
            }
            ((InputStream)fileInputStream).close();
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object2).init((KeyStore)object3);
            object = (X509TrustManager)((TrustManagerFactory)object2).getTrustManagers()[0];
            SavingTrustManager savingTrustManager = new SavingTrustManager((X509TrustManager)object);
            sSLContext.init(null, new TrustManager[]{savingTrustManager}, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            logger.a("Opening connection to " + string4 + ":" + n2 + "...");
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string4, n2);
            sSLSocket.setSoTimeout(10000);
            try {
                logger.a("Starting SSL handshake...");
                sSLSocket.startHandshake();
                sSLSocket.close();
                logger.a("No errors, certificate is already trusted");
            }
            catch (SSLException sSLException) {
                try {
                    if (!sSLException.getLocalizedMessage().contains("the trustAnchors parameter must be non-empty")) {
                        logger.c("Could not fetch certificates from server: " + sSLException.getLocalizedMessage());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            X509Certificate[] x509CertificateArray = savingTrustManager.chain;
            if (x509CertificateArray == null) {
                logger.c("Could not obtain server certificate chain");
                return false;
            }
            try {
                logger.a("Server sent " + x509CertificateArray.length + " certificate(s):");
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
                outputStream = new FileOutputStream(file2);
                int n3 = 0;
                while (n3 < x509CertificateArray.length) {
                    X509Certificate x509Certificate = x509CertificateArray[n3];
                    messageDigest.update(x509Certificate.getEncoded());
                    messageDigest2.update(x509Certificate.getEncoded());
                    String string5 = String.valueOf(string4) + "-" + (n3 + 1);
                    ((KeyStore)object3).setCertificateEntry(string5, x509Certificate);
                    ((KeyStore)object3).store(outputStream, cArray);
                    ++n3;
                }
                bl = true;
            }
            catch (Exception exception) {
                logger.d("Could not install certs in trustStore: " + exception.getLocalizedMessage());
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        int n2;
        Object object;
        if (stringArray.length != 1 && stringArray.length != 2) {
            logger.a("Usage: java InstallCert [:port] [passphrase]");
            return;
        }
        Object object2 = stringArray[0].split(":");
        String string = object2[0];
        int n3 = ((String[])object2).length == 1 ? 443 : Integer.parseInt(object2[1]);
        Object object3 = stringArray.length == 1 ? "changeit" : stringArray[1];
        char[] cArray = ((String)object3).toCharArray();
        object2 = new File("jssecacerts");
        if (!((File)object2).isFile()) {
            char c2 = File.separatorChar;
            object = new File(String.valueOf(System.getProperty("java.home")) + c2 + "lib" + c2 + "security");
            object2 = new File((File)object, "jssecacerts");
            if (!((File)object2).isFile()) {
                object2 = new File((File)object, "cacerts");
            }
        }
        logger.a("Loading KeyStore " + object2 + "...");
        object3 = new FileInputStream((File)object2);
        object = KeyStore.getInstance(KeyStore.getDefaultType());
        ((KeyStore)object).load((InputStream)object3, cArray);
        ((InputStream)object3).close();
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)object);
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        SavingTrustManager savingTrustManager = new SavingTrustManager(x509TrustManager);
        sSLContext.init(null, new TrustManager[]{savingTrustManager}, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        logger.a("Opening connection to " + string + ":" + n3 + "...");
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n3);
        sSLSocket.setSoTimeout(10000);
        try {
            logger.a("Starting SSL handshake...");
            sSLSocket.startHandshake();
            sSLSocket.close();
            logger.a("No errors, certificate is already trusted");
        }
        catch (SSLException sSLException) {
            logger.d("SSLException while getting certificate: " + sSLException.getLocalizedMessage(), sSLException);
        }
        X509Certificate[] x509CertificateArray = savingTrustManager.chain;
        if (x509CertificateArray == null) {
            logger.a("Could not obtain server certificate chain");
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        logger.a("Server sent " + x509CertificateArray.length + " certificate(s):");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
        int n4 = 0;
        while (n4 < x509CertificateArray.length) {
            X509Certificate x509Certificate = x509CertificateArray[n4];
            logger.a(" " + (n4 + 1) + " Subject " + x509Certificate.getSubjectDN());
            logger.a("   Issuer  " + x509Certificate.getIssuerDN());
            messageDigest.update(x509Certificate.getEncoded());
            logger.a("   sha1    " + InstallCert.toHexString(messageDigest.digest()));
            messageDigest2.update(x509Certificate.getEncoded());
            logger.a("   md5     " + InstallCert.toHexString(messageDigest2.digest()));
            ++n4;
        }
        logger.a("Enter certificate to add to trusted keystore or 'q' to quit: [1]");
        String string2 = bufferedReader.readLine().trim();
        try {
            n2 = string2.length() == 0 ? 0 : Integer.parseInt(string2) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            logger.a("KeyStore not changed");
            return;
        }
        X509Certificate x509Certificate = x509CertificateArray[n2];
        String string3 = String.valueOf(string) + "-" + (n2 + 1);
        ((KeyStore)object).setCertificateEntry(string3, x509Certificate);
        FileOutputStream fileOutputStream = new FileOutputStream("jssecacerts");
        ((KeyStore)object).store(fileOutputStream, cArray);
        ((OutputStream)fileOutputStream).close();
        logger.a(x509Certificate);
        logger.a("Added certificate to keystore 'jssecacerts' using alias '" + string3 + "'");
    }

    private static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 3);
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byArray2[n3];
            stringBuilder.append(HEXDIGITS[(n4 &= 0xFF) >> 4]);
            stringBuilder.append(HEXDIGITS[n4 & 0xF]);
            stringBuilder.append(' ');
            ++n3;
        }
        return stringBuilder.toString();
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager x509TrustManager) {
            this.tm = x509TrustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.chain;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.chain = x509CertificateArray;
            this.tm.checkServerTrusted(x509CertificateArray, string);
        }
    }
}

