/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.fo.b;
import ch.ionesoft.ilp.base.fo.z;
import ch.ionesoft.ilp.base.he.StringHelper;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.SystemUtils;

public class ImageHelper {
    private static ILogger logger = ILPLogManager.getLogger(ImageHelper.class);

    public static b fitSize_inSize(b b2, b b3) {
        b b4 = ImageHelper.fitHeight_inSize(b2, b3);
        b4 = ImageHelper.fitWidth_inSize(b4, b3);
        return b4;
    }

    public static b forceFitSize_inSize(b b2, b b3) {
        float f2 = Math.abs(b2.a - b3.a);
        float f3 = Math.abs(b2.b - b3.b);
        b b4 = b2;
        b4 = f2 < f3 ? ImageHelper.forceFitHeight_inSize(b2, b3) : ImageHelper.forceFitWidth_inSize(b4, b3);
        return b4;
    }

    public static b fitHeight_inSize(b b2, b b3) {
        b b4 = b2;
        if (b4.b != 0.0f && b4.b > b3.b) {
            float f2 = b3.b / b4.b;
            b4.a *= f2;
            b4.b *= f2;
        }
        return b4;
    }

    public static b forceFitHeight_inSize(b b2, b b3) {
        b b4 = b2;
        float f2 = b3.b / b4.b;
        b4.a *= f2;
        b4.b *= f2;
        return b4;
    }

    public static b fitWidth_inSize(b b2, b b3) {
        b b4 = b2;
        if (b4.a != 0.0f && b4.a >= b3.a) {
            float f2 = b3.a / b4.a;
            b4.a *= f2;
            b4.b *= f2;
        }
        return b4;
    }

    public static b forceFitWidth_inSize(b b2, b b3) {
        b b4 = b2;
        float f2 = b3.a / b4.a;
        b4.a *= f2;
        b4.b *= f2;
        return b4;
    }

    public static float aspectRatioOf(b b2) {
        return b2.a / b2.b;
    }

    public static z imageWithUrlString(String string) {
        try {
            String string2;
            if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_WINDOWS) {
                string = string.replace("http://localhost/", h.W());
            }
            String string3 = StringHelper.decodeFromPercentEscapeString(string);
            z z2 = f.b().I().loadImageWithUrl(new URL(string3));
            if (z2 == null) {
                z2 = f.b().I().loadImageWithUrl(new URL(string));
            }
            if (z2 == null) {
                string2 = string.replace("http://localhost/", "");
                z2 = z.a(string2);
            }
            if (z2 == null) {
                string2 = string.replace("http://localhost/", "");
                string2 = string2.replace("imageresource/", "");
                z2 = z.a(string2);
            }
            if (z2 == null) {
                string2 = string3;
                z2 = z.a(string2);
            }
            return z2;
        }
        catch (Exception exception) {
            logger.d("Could not load image with urlString: " + string + ". " + exception);
            return null;
        }
    }

    public static b imageSizeOfImageWithUrlString(String string) {
        z z2 = null;
        try {
            z2 = ImageHelper.imageWithUrlString(string);
            if (z2 != null) {
                b b2 = z2.k();
                return b2;
            }
        }
        catch (Exception exception) {
            logger.d("Could not determine size of image: " + string, exception);
        }
        finally {
            if (z2 != null) {
                z2.i();
            }
        }
        return null;
    }

    public static b imageSizeOfImage(z z2) {
        try {
            if (z2 != null) {
                b b2 = z2.k();
                return b2;
            }
        }
        catch (Exception exception) {
            logger.d("Could not determine size of image: " + z2, exception);
        }
        finally {
            if (z2 != null) {
                z2.i();
            }
        }
        return null;
    }

    public static b imageSizeOfImageWithData(byte[] byArray) {
        z z2 = z.a(byArray);
        if (z2 != null) {
            return z2.k();
        }
        return null;
    }

    public static boolean convertFormat(String string, String string2, String string3) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            boolean bl;
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
            BufferedImage bufferedImage = ImageIO.read(fileInputStream);
            boolean bl2 = bl = ImageIO.write((RenderedImage)bufferedImage, string3, fileOutputStream);
            return bl2;
        }
        catch (Exception exception) {
            f.b().D().displayNoticeCode("message.image.annotation.fileError", string2);
            logger.d("Could not convert image: " + string + " into: " + string2 + ", format: " + string3, exception);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static BufferedImage loadImageWithOrientationFromUrl(URL uRL) throws ImageProcessingException, IOException, MetadataException {
        File file = new File(uRL.getPath());
        if (!file.exists()) {
            return null;
        }
        Metadata metadata = ImageMetadataReader.readMetadata((File)file);
        Directory directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        JpegDirectory jpegDirectory = (JpegDirectory)metadata.getFirstDirectoryOfType(JpegDirectory.class);
        if (directory == null || !directory.containsTag(274) || jpegDirectory == null) {
            return null;
        }
        int n2 = directory.getInt(274);
        int n3 = jpegDirectory.getImageWidth();
        int n4 = jpegDirectory.getImageHeight();
        AffineTransform affineTransform = ImageHelper.getExifTransformation(n2, n3, n4);
        BufferedImage bufferedImage = ImageIO.read(file);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
        Rectangle2D rectangle2D = affineTransformOp.getBounds2D(bufferedImage);
        BufferedImage bufferedImage2 = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), bufferedImage.getType());
        bufferedImage2 = affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private static AffineTransform getExifTransformation(int n2, int n3, int n4) {
        AffineTransform affineTransform = new AffineTransform();
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-n3, 0.0);
                break;
            }
            case 3: {
                affineTransform.translate(n3, n4);
                affineTransform.rotate(Math.PI);
                break;
            }
            case 4: {
                affineTransform.scale(1.0, -1.0);
                affineTransform.translate(0.0, -n4);
                break;
            }
            case 5: {
                affineTransform.rotate(-1.5707963267948966);
                affineTransform.scale(-1.0, 1.0);
                break;
            }
            case 6: {
                affineTransform.translate(n4, 0.0);
                affineTransform.rotate(1.5707963267948966);
                break;
            }
            case 7: {
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-n4, 0.0);
                affineTransform.translate(0.0, n3);
                affineTransform.rotate(4.71238898038469);
                break;
            }
            case 8: {
                affineTransform.translate(0.0, n3);
                affineTransform.rotate(4.71238898038469);
            }
        }
        return affineTransform;
    }

    public static File storeAWTImageAsTempFile(Image image) {
        try {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            File file = File.createTempFile("clipboardImage", ".png");
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            return file;
        }
        catch (Exception exception) {
            logger.d("Could not store awtImage as tempFile", exception);
            return null;
        }
    }
}

