/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILogger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ILPLogHelper {
    private StringBuffer content = new StringBuffer(500);

    public void add(String string) {
        this.content.append("\n");
        this.content.append(string);
    }

    public String getContent() {
        return this.content.toString();
    }

    public void clear() {
        this.content = new StringBuffer(500);
    }

    public static String logStatementForLicenseInfo(String string, LogAttentionType logAttentionType, int n2) {
        String string2 = "";
        int n3 = 0;
        while (n3 < n2) {
            string2 = String.valueOf(string2) + "\t";
            ++n3;
        }
        return String.format(Locale.ENGLISH, "\t\t%s%s%s", logAttentionType.getSign(), string2, string);
    }

    public static void printStackTrace(Thread thread, ILogger iLogger) {
        if (iLogger == null || thread == null) {
            return;
        }
        try {
            iLogger.b("================================================");
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            int n2 = 2;
            while (n2 < stackTraceElementArray.length) {
                iLogger.b("at " + stackTraceElementArray[n2]);
                ++n2;
            }
            iLogger.b("================================================");
        }
        catch (Exception exception) {
            iLogger.d("Could not log stackstrace from thread: " + thread, exception);
        }
    }

    public static enum LogAttentionType {
        LOG_ATTENTION_TYPE_NONE(0, " "),
        LOG_ATTENTION_TYPE_OK(1, "\u2714"),
        LOG_ATTENTION_TYPE_WARN(2, "\u26a0"),
        LOG_ATTENTION_TYPE_HINT(3, "\u25b7"),
        LOG_ATTENTION_TYPE_IMPORTANT(3, "\u25b6"),
        LOG_ATTENTION_TYPE_FATAL(4, "\u2716");

        private static final Map<Integer, LogAttentionType> lookup;
        private int code;
        private String sign;

        static {
            lookup = new HashMap<Integer, LogAttentionType>();
            for (LogAttentionType logAttentionType : EnumSet.allOf(LogAttentionType.class)) {
                lookup.put(logAttentionType.getCode(), logAttentionType);
            }
        }

        private LogAttentionType(int n3, String string2) {
            this.code = n3;
            this.sign = string2;
        }

        private LogAttentionType(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public String getSign() {
            return this.sign;
        }

        public static LogAttentionType get(int n2) {
            return lookup.get(n2);
        }

        public static LogAttentionType get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }
}

