/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.StringLevenshtein;
import java.io.File;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Locale;
import org.apache.commons.lang3.SystemUtils;

public class HardwareInfo {
    private static HardwareInfo instance = new HardwareInfo();
    private String info;

    public static HardwareInfo getInstance() {
        return instance;
    }

    public String getInfo() {
        if (this.info == null) {
            this.info = this.buildInfo();
        }
        return this.info;
    }

    public String buildInfo() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(" user.name=").append(System.getProperty("user.name").replace(" ", "_"));
        stringBuffer.append(" user.home=").append(System.getProperty("user.home").replace(" ", "_"));
        stringBuffer.append(" os.arch=").append(System.getProperty("os.arch").replace(" ", "_"));
        stringBuffer.append(" os.name=").append(System.getProperty("os.name").replace(" ", "_"));
        stringBuffer.append(" os.version=").append(System.getProperty("os.version").replace(" ", "_"));
        try {
            object = NetworkInterface.getNetworkInterfaces();
            while (object != null && object.hasMoreElements()) {
                NetworkInterface networkInterface = (NetworkInterface)object.nextElement();
                String string = networkInterface.getName();
                byte[] byArray = networkInterface.getHardwareAddress();
                if (byArray == null) continue;
                StringBuilder stringBuilder = new StringBuilder(18);
                byte[] byArray2 = byArray;
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    byte by = byArray2[n3];
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(':');
                    }
                    stringBuilder.append(String.format(Locale.ENGLISH, "%02x", by));
                    ++n3;
                }
                stringBuffer.append(String.valueOf(string) + "=");
                stringBuffer.append(stringBuilder.toString());
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        object = SystemUtils.IS_OS_WINDOWS ? "C:/" : "/";
        long l2 = new File((String)object).getTotalSpace();
        stringBuffer.append(" total.space=").append(l2);
        return stringBuffer.toString();
    }

    public String hexInfo() {
        String string = this.getInfo();
        String string2 = StringHelper.toHex(string);
        return string2;
    }

    public boolean isSameHardware(String string) {
        String string2;
        StringLevenshtein stringLevenshtein = new StringLevenshtein();
        String string3 = this.getInfo();
        float f2 = stringLevenshtein.compareDifferenceWithString(string3, string2 = StringHelper.fromHex(string));
        return f2 < 20.0f;
    }
}

