/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.fo.i;
import ch.ionesoft.ilp.base.fo.p;
import ch.ionesoft.ilp.base.he.StringHelper;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import org.rtf.RtfHtml;
import org.rtf.RtfParseException;
import org.rtf.RtfReader;

public class HTMLUtils {
    private static ILogger logger = ILPLogManager.getLogger(HTMLUtils.class);
    private static final String CRLF = System.getProperty("line.separator");

    public static boolean htmlContainsTextOrObjects(String string) {
        if (string == null) {
            return false;
        }
        if (string.contains("<a") || string.contains("<img")) {
            return true;
        }
        return HTMLUtils.stringByConvertingHTMLToPlainText(string).length() > 0;
    }

    public static String stringByConvertingHTMLToPlainText(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        i i2 = i.a(String.format(Locale.ENGLISH, "< \t\n\r%C%C%C%C", 133, 12, 8232, 8233));
        i i3 = i.a(String.format(Locale.ENGLISH, " \t\n\r%C%C%C%C", 133, 12, 8232, 8233));
        i i4 = i.a("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        p p2 = new p(string);
        p2.a((i)null);
        p2.a(true);
        p.c c2 = new p.c();
        p.c c3 = new p.c();
        boolean bl = false;
        boolean bl2 = false;
        do {
            if (p2.b(i2, c3)) {
                stringBuffer.append(c3.a);
                c3.a = null;
                bl2 = false;
            }
            if (p2.a("<", null)) {
                bl2 = false;
                if (p2.a("!--", null)) {
                    p2.b("-->", null);
                    p2.a("-->", null);
                    continue;
                }
                if (p2.a("/", null)) {
                    c2.a = "";
                    bl = false;
                    if (p2.a(i4, c2)) {
                        string2 = c2.a.toLowerCase();
                        boolean bl3 = bl = string2.equals("a") || string2.equals("b") || string2.equals("i") || string2.equals("q") || string2.equals("span") || string2.equals("em") || string2.equals("strong") || string2.equals("cite") || string2.equals("abbr") || string2.equals("acronym") || string2.equals("label");
                    }
                    if (!bl && stringBuffer.length() > 0 && !p2.b()) {
                        stringBuffer.append(" ");
                    }
                    if (c2.a.equalsIgnoreCase("br")) {
                        stringBuffer.append("\n");
                    }
                    if (c2.a.equalsIgnoreCase("ol") || c2.a.equalsIgnoreCase("ul")) {
                        stringBuffer.append("\n");
                    }
                }
                p2.b(">", c2);
                p2.a(">", null);
                if (c2.a.equalsIgnoreCase("br")) {
                    stringBuffer.append("\n");
                }
                if (!c2.a.equalsIgnoreCase("li")) continue;
                stringBuffer.append("\n- ");
                continue;
            }
            if (!p2.a(i3, null) || stringBuffer.length() <= 0 || p2.b() || bl2) continue;
            stringBuffer.append(" ");
            bl2 = true;
        } while (!p2.b());
        string2 = HTMLUtils.stringByDecodingHTMLEntities(stringBuffer.toString());
        string2 = StringHelper.trimAll(string2);
        return string2;
    }

    public static String prettyPrintHTMLToPlainText(String string) {
        String string2;
        if (string == null) {
            return "";
        }
        i i2 = i.a(String.format(Locale.ENGLISH, "< \t\n\r%C%C%C%C", 133, 12, 8232, 8233));
        i i3 = i.a();
        i i4 = i.a("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        p p2 = new p(string);
        p2.a((i)null);
        p2.a(true);
        p.c c2 = new p.c();
        p.c c3 = new p.c();
        boolean bl = false;
        boolean bl2 = false;
        do {
            if (p2.b(i2, c3)) {
                stringBuffer.append(c3.a);
                c3.a = null;
                bl2 = false;
            }
            if (p2.a("<", null)) {
                bl2 = false;
                if (p2.a("!--", null)) {
                    p2.b("-->", null);
                    p2.a("-->", null);
                    continue;
                }
                if (p2.a("/", null)) {
                    c2.a = null;
                    bl = false;
                    if (p2.a(i4, c2)) {
                        string2 = c2.a.toLowerCase();
                        boolean bl3 = bl = string2.equals("a") || string2.equals("b") || string2.equals("i") || string2.equals("q") || string2.equals("span") || string2.equals("em") || string2.equals("strong") || string2.equals("cite") || string2.equals("abbr") || string2.equals("acronym") || string2.equals("label");
                    }
                    if (!bl && stringBuffer.length() > 0 && !p2.b()) {
                        stringBuffer.append(" ");
                    }
                    if (c2.a.equalsIgnoreCase("h")) {
                        stringBuffer.append(String.valueOf(CRLF) + CRLF);
                    }
                    if (c2.a.startsWith("li")) {
                        stringBuffer.append(CRLF);
                    }
                    if (c2.a.startsWith("tr")) {
                        stringBuffer.append(CRLF);
                    }
                    if (c2.a.startsWith("td")) {
                        stringBuffer.append(" | ");
                    }
                    if (c2.a.startsWith("br")) {
                        stringBuffer.append(CRLF);
                    }
                    if (c2.a.startsWith("ol") || c2.a.startsWith("ul")) {
                        stringBuffer.append(CRLF);
                    }
                }
                p2.b(">", c2);
                p2.a(">", null);
                if (c2.a.equalsIgnoreCase("h")) {
                    stringBuffer.append(CRLF);
                }
                if (c2.a.startsWith("br")) {
                    stringBuffer.append(CRLF);
                }
                if (c2.a.startsWith("li")) {
                    stringBuffer.append(String.valueOf(CRLF) + " - ");
                }
                if (c2.a.startsWith("tr")) {
                    stringBuffer.append(String.valueOf(CRLF) + "|");
                }
                if (!c2.a.startsWith("hr")) continue;
                stringBuffer.append(String.valueOf(CRLF) + "-------------------------" + CRLF);
                continue;
            }
            if (!p2.a(i3, null) || stringBuffer.length() <= 0 || p2.b() || bl2) continue;
            stringBuffer.append(" ");
            bl2 = true;
        } while (!p2.b());
        string2 = HTMLUtils.stringByDecodingHTMLEntities(stringBuffer.toString());
        return string2;
    }

    public static String stringByDecodingHTMLEntities(String string) {
        return StringEscapeUtils.unescapeHtml4((String)string);
    }

    public static String stringByEncodingHTMLEntities(String string) {
        return StringEscapeUtils.escapeHtml4((String)string);
    }

    public static String stringWithNewLinesAsBRs(String string) {
        p p2 = new p(string);
        p2.a((i)null);
        StringBuffer stringBuffer = new StringBuffer();
        p.c c2 = new p.c();
        i i2 = i.a(String.format(Locale.ENGLISH, "\n\r%c%c%c%c", 133, 12, 8232, 8233));
        do {
            c2.a = null;
            p2.b(i2, c2);
            if (c2.a != null) {
                stringBuffer.append(c2.a);
            }
            c2.a = null;
            if (p2.a("\r\n", null)) {
                stringBuffer.append("<br />");
                continue;
            }
            if (!p2.a(i2, c2) || c2.a == null) continue;
            int n2 = 0;
            while (n2 < c2.a.length()) {
                stringBuffer.append("<br />");
                ++n2;
            }
        } while (!p2.b());
        String string2 = stringBuffer.toString();
        return string2;
    }

    public static String stringByRemovingTags(String string, String[] stringArray) {
        String string2 = string;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            string2 = HTMLUtils.stringByRemovingTag(string2, string3);
            ++n2;
        }
        return string2;
    }

    public static String stringByRemovingTag(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String string3 = "<" + string2;
        String string4 = "/>";
        String string5 = "</" + string2 + ">";
        p p2 = p.a(string);
        p2.a(false);
        while (!p2.b()) {
            p.c c2 = new p.c();
            if (p2.b(string3, c2) && p2.a(string3, null)) {
                String string6 = c2.a;
                if (string6 != null) {
                    stringBuffer.append(string6);
                }
                if (p2.b()) break;
                int n2 = p2.c();
                int n3 = string.length();
                int n4 = string.length();
                if (p2.b(string4, null) && p2.a(string4, null)) {
                    n3 = p2.c();
                }
                p2.a(n2);
                if (p2.b(string5, null) && p2.a(string5, null)) {
                    n4 = p2.c();
                }
                if (n3 < n4) {
                    p2.a(n3);
                    continue;
                }
                p2.a(n4);
                continue;
            }
            stringBuffer.append(c2.a);
        }
        return stringBuffer.toString();
    }

    public static String rtfToHtml(String string, boolean bl) {
        String string2 = null;
        try {
            RtfReader rtfReader = new RtfReader();
            rtfReader.parse(string);
            RtfHtml rtfHtml = new RtfHtml();
            string2 = rtfHtml.format(rtfReader.root, bl);
        }
        catch (RtfParseException rtfParseException) {
            logger.d("Could not parse rtf to html: " + string, rtfParseException);
        }
        return string2;
    }
}

