/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.fo.o;
import ch.ionesoft.ilp.base.fo.s;
import ch.ionesoft.ilp.base.he.Helper;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;

public class FileHelper {
    public static int MAX_FILENAME_LENGTH = 255;
    private static ILogger logger = ILPLogManager.getLogger(FileHelper.class);

    public static File convertToLocalFile(String string) {
        try {
            if (string != null && string.startsWith("file:")) {
                String string2 = FileHelper.removeFilePrefix(string);
                File file = new File(string2);
                if (file.exists()) {
                    return file;
                }
                return FileHelper.convertToLocalFile(new URL(string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.d("Could not convert urlString: " + string + " to local file", malformedURLException);
        }
        return new File(string);
    }

    public static File convertToLocalFile(URL uRL) {
        Object object;
        try {
            object = uRL.toURI();
            if (((URI)object).getAuthority() != null && ((URI)object).getAuthority().length() > 0) {
                object = new URL("file://" + uRL.toExternalForm().substring("file:".length())).toURI();
                uRL = ((URI)object).toURL();
            }
        }
        catch (Exception exception) {
            logger.d("Could not convert url: " + uRL + " to unc compatible url", exception);
        }
        object = uRL.toExternalForm();
        object = FileHelper.removeFilePrefix((String)object);
        if (uRL.getHost() != null && uRL.getHost().length() > 0 && uRL.getHost().equals(StringHelper.extractStringFrom_until((String)object, "/"))) {
            object = String.valueOf(uRL.getHost()) + ":/" + StringHelper.extractString_after((String)object, "/");
        }
        object = StringHelper.decodeFromPercentEscapeString((String)object);
        File file = new File((String)object);
        return file;
    }

    public static String removeFilePrefix(String string) {
        string = string.startsWith("file://") ? StringHelper.extractString_after(string, "file://") : (string.startsWith("file:/") ? StringHelper.extractString_after(string, "file:") : StringHelper.extractString_after(string, "file:"));
        return string;
    }

    public static boolean isImageFilename(String string) {
        String string2 = "";
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            string2 = string.substring(n2 + 1).toLowerCase();
        }
        return "jpg".equals(string2) || "jpeg".equals(string2) || "png".equals(string2) || "bmp".equals(string2) || "tiff".equals(string2) || "tif".equals(string2) || "gif".equals(string2);
    }

    public static boolean isVideoFilename(String string) {
        String string2 = "";
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            string2 = string.substring(n2 + 1).toLowerCase();
        }
        return "mp4".equals(string2);
    }

    public static URL urlForResourceSynchFile(String string) throws MalformedURLException {
        URL uRL = null;
        if (string == null) {
            return null;
        }
        File file = new File(h.q(), string);
        try {
            if (file.exists()) {
                uRL = file.toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public static URL urlForFileSynchFile(String string) throws MalformedURLException {
        URL uRL = null;
        if (string == null) {
            return null;
        }
        File file = new File(h.v(), string);
        try {
            if (file.exists()) {
                uRL = file.toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public static String pathForResourcesFile(String string) {
        File file = new File(f.b().B(), string);
        return file.toString();
    }

    public static URL urlForBundleResource(String string) throws MalformedURLException {
        String string2;
        String string3 = string2 = f.b().C() != null ? f.b().C().toExternalForm() : "";
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        string2 = String.valueOf(string2) + string;
        string2 = string2.replace("\\", "/");
        URL uRL = new URL(string2);
        return uRL;
    }

    public static URL urlForBundleResource(String string, String string2) throws MalformedURLException {
        String string3 = String.format("platform:/plugin/%s/resources/%s", string, string2);
        string3 = string3.replace("\\", "/");
        URL uRL = new URL(string3);
        return uRL;
    }

    public static URL urlForImageCacheResource(String string) {
        URL uRL = null;
        if (string == null) {
            return null;
        }
        File file = new File(h.s(), string);
        try {
            if (file.exists()) {
                uRL = file.toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public static s urlRequestForBundleResource(String string) {
        s s2 = null;
        try {
            URL uRL = FileHelper.urlForBundleResource(string);
            s2 = s.a(uRL);
        }
        catch (Exception exception) {
            Helper.logActionText_withException("Resource not found: " + string, exception);
        }
        return s2;
    }

    public static s urlRequestForBundleResource(String string, String string2) {
        s s2 = null;
        try {
            URL uRL = FileHelper.urlForBundleResource(string, string2);
            s2 = s.a(uRL);
        }
        catch (Exception exception) {
            Helper.logActionText_withException("Resource not found: " + string2, exception);
        }
        return s2;
    }

    public static boolean fileExistsAtPath(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.exists();
    }

    public static boolean containsFiles(String string) {
        File file = new File(string);
        return file.isDirectory() && file.list().length > 0;
    }

    public static boolean containsFiles(File file) {
        return file.isDirectory() && file.list().length > 0;
    }

    public static boolean isDirectory(String string) {
        File file = new File(string);
        return file.isDirectory();
    }

    public static void createDirectory(String string) {
        if (string != null) {
            FileHelper.createDirectory(new File(string));
        }
    }

    public static void createDirectory(File file) {
        if (file != null) {
            try {
                FileUtils.forceMkdir((File)file);
            }
            catch (IOException iOException) {
                logger.d("Directory could not be created: " + file + ". Reason: " + iOException);
            }
        }
    }

    public static boolean deleteDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
            return true;
        }
        catch (IOException iOException) {
            logger.d("Directory could not be deleted: " + file + ". Reason: " + iOException);
            return false;
        }
    }

    public static boolean removeDirectory(String string) {
        File file = new File(string);
        return FileHelper.removeDirectory(file);
    }

    public static boolean removeDirectory(File file) {
        block4: {
            try {
                if (file.exists()) break block4;
                return true;
            }
            catch (Exception exception) {
                logger.d("Could not delete directory " + file);
                return false;
            }
        }
        if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
            return true;
        }
        return false;
    }

    public static boolean moveDirectoryFromPath_toPath(String string, String string2) {
        return FileHelper.moveDirectoryFrom_to(new File(string), new File(string2));
    }

    public static boolean moveDirectoryFrom_to(File file, File file2) {
        if (file.exists()) {
            try {
                FileUtils.moveDirectory((File)file, (File)file2);
            }
            catch (IOException iOException) {
                logger.d("Could not move directory: " + file + " to: " + file2, iOException);
                return false;
            }
            return true;
        }
        logger.c(String.format("Cannot move from %s to %s since the former path does not exist", file, file2));
        return false;
    }

    public static void deleteAllFilesInFolder_matching_keepFilesWithPrefix(File file, final String string, final String string2) {
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string3) {
                if (StringUtils.isNotBlank((CharSequence)string2) && string3.startsWith(string2)) {
                    return false;
                }
                return StringUtils.isBlank((CharSequence)string) || string3.startsWith(string);
            }
        });
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                File file2 = new File(file, string3);
                if (!FileUtils.deleteQuietly((File)file2)) {
                    logger.c("Could not delete file at path: " + file2);
                }
                ++n3;
            }
        }
    }

    public static void deleteAllFilesInFolder(File file) {
        try {
            FileUtils.cleanDirectory((File)file);
        }
        catch (IOException iOException) {
            logger.c("Could not clean directory at path: " + file);
        }
    }

    public static void deleteEmptyFoldersRecursive(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        try {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file2 = fileArray[n3];
                    if (file2.isDirectory()) {
                        FileHelper.deleteEmptyFoldersRecursive(file2);
                    }
                    ++n3;
                }
            }
            if (file.isDirectory() && file.list().length == 0) {
                file.delete();
            }
        }
        catch (Exception exception) {
            logger.d("Could not delete empty folders of: " + file, exception);
        }
    }

    public static boolean removeFileAtPath(String string) {
        File file = new File(string);
        if (file.exists()) {
            return FileUtils.deleteQuietly((File)file);
        }
        return true;
    }

    public static boolean renameFileAtPath_toPath(String string, String string2) {
        try {
            FileUtils.moveFile((File)new File(string), (File)new File(string2));
            return true;
        }
        catch (IOException iOException) {
            logger.d("Could not move file: " + string + " to: " + string2, iOException);
            return false;
        }
    }

    public static void assureDirectoryExistsForFilePath(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        file2.mkdirs();
    }

    public static void assureDirectoryExistsForFilePath(File file) {
        File file2 = file.getParentFile();
        file2.mkdirs();
    }

    public static void assureDirectoryExistsForPath(File file) {
        file.mkdirs();
    }

    public static String filePathFromURL_dataPath(URL uRL, String string) {
        if (uRL.getProtocol().equals("file")) {
            return uRL.getPath();
        }
        String string2 = uRL.toString();
        string2 = FileHelper.encodeURLString(string2);
        string2 = StringHelper.trimUnique_toLength(string2, MAX_FILENAME_LENGTH - string.length());
        String string3 = StringHelper.stringByAppendingPathComponent(string, string2);
        return string3;
    }

    public static String filePathWithoutQueryParamFromURL_dataPath(URL uRL, String string) {
        if (uRL == null) {
            return null;
        }
        if (uRL.getProtocol().equals("file")) {
            return uRL.getPath();
        }
        String string2 = uRL.toExternalForm();
        string2 = StringHelper.removeURLParams(string2);
        string2 = FileHelper.encodeURLString(string2);
        string2 = StringHelper.trimUnique_toLength(string2, MAX_FILENAME_LENGTH - string.length());
        String string3 = StringHelper.stringByAppendingPathComponent(string, string2);
        return string3;
    }

    public static String filePathNiceWithoutQueryParamFromURL_dataPath(URL uRL, String string, String string2) {
        if (uRL == null) {
            return null;
        }
        if (uRL.getProtocol().equals("file")) {
            return uRL.getPath();
        }
        String string3 = uRL.toExternalForm();
        string3 = StringHelper.removeURLParams(string3);
        String string4 = FileHelper.uniqueFileName(string3);
        String string5 = StringUtils.isNotEmpty((CharSequence)string2) ? StringHelper.stringByAppendingPathComponent(string, string2) : string;
        String string6 = StringHelper.stringByAppendingPathComponent(string5, string4);
        return string6;
    }

    public static String uniqueFileName(String string) {
        String string2 = StringHelper.lastPathComponent(string);
        String string3 = StringHelper.pathExtension(string2);
        String string4 = StringHelper.stringByDeletingPathExtension(string2);
        string4 = StringHelper.fixUmlautCharacters(string4);
        String string5 = new SimpleDateFormat("yyyyMMdd_HHmmssSSS").format(new Date());
        String string6 = String.format("%s_%s.%s", string4, string5, string3);
        return string6;
    }

    public static String contentsOfConfigBundleResource(String string) {
        ClassLoader classLoader = f.b().O();
        String string2 = "ch.ionesoft.ilp.config";
        return FileHelper.contentsOfBundleResource_classLoader_bundleName(string, classLoader, string2);
    }

    public static InputStream contentsOfConfigBundleResourceStream(String string) {
        ClassLoader classLoader = f.b().O();
        String string2 = "ch.ionesoft.ilp.config";
        return FileHelper.contentsOfBundleResource_classLoader_bundleName_inputstream(string, classLoader, string2);
    }

    public static String contentsOfAppConfigBundleResource(String string) {
        ClassLoader classLoader = f.b().N();
        String string2 = h.ar();
        return FileHelper.contentsOfBundleResource_classLoader_bundleName(string, classLoader, string2);
    }

    public static InputStream streamForAppConfigBundleResource(String string) {
        ClassLoader classLoader = f.b().N();
        String string2 = h.ar();
        return FileHelper.streamForBundleResource_classLoader_bundleName(string, classLoader, string2);
    }

    public static InputStream streamForConfigBundleResource(String string) {
        ClassLoader classLoader = f.b().O();
        String string2 = "ch.ionesoft.ilp.config";
        return FileHelper.streamForBundleResource_classLoader_bundleName(string, classLoader, string2);
    }

    public static InputStream streamForBundleResource_classLoader_bundleName(String string, ClassLoader classLoader, String string2) {
        InputStream inputStream = null;
        try {
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream == null) {
                inputStream = f.b().I().streamForBundleResource(string, string2);
            }
        }
        catch (Exception exception) {
            logger.c("Could not load bundleResource: " + string + " from bundle: " + string2 + " using classLoader: " + classLoader, exception);
        }
        return inputStream;
    }

    public static String contentsOfBundleResource_classLoader_bundleName(String string, ClassLoader classLoader, String string2) {
        InputStream inputStream = null;
        try {
            inputStream = FileHelper.streamForBundleResource_classLoader_bundleName(string, classLoader, string2);
            if (inputStream != null) {
                String string3 = FileHelper.contentsOfFile(inputStream);
                return string3;
            }
        }
        catch (Exception exception) {
            logger.c("Could not load bundleResource: " + string + " from bundle: " + string2 + " using classLoader: " + classLoader, exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static InputStream contentsOfBundleResource_classLoader_bundleName_inputstream(String string, ClassLoader classLoader, String string2) {
        Object var3_3 = null;
        try {
            return FileHelper.streamForBundleResource_classLoader_bundleName(string, classLoader, string2);
        }
        catch (Exception exception) {
            logger.c("Could not load bundleResource: " + string + " from bundle: " + string2 + " using classLoader: " + classLoader, exception);
            return null;
        }
    }

    public static String localizedContentsOfAppConfigBundleResource(String string) {
        ClassLoader classLoader = f.b().N();
        String string2 = h.ar();
        return FileHelper.localizedContentsOfBundleResource_classLoader_bundleName(string, classLoader, string2);
    }

    public static String localizedContentsOfBundleResource_classLoader_bundleName(String string, ClassLoader classLoader, String string2) {
        String string3 = g.a().e();
        String string4 = String.valueOf(string3) + "/" + string;
        String string5 = FileHelper.contentsOfBundleResource_classLoader_bundleName(string4, classLoader, string2);
        if (string5 == null && (string5 = FileHelper.contentsOfBundleResource_classLoader_bundleName(string, classLoader, string2)) == null && (string5 = FileHelper.contentsOfBundleResource_classLoader_bundleName("webResources/" + string, classLoader, string2)) == null) {
            logger.c("Could not load contents from " + string4 + ", nor " + string);
        }
        return string5;
    }

    public static String contentsOfFile(InputStream inputStream) throws IOException {
        String string = "UTF-8";
        return FileHelper.contentsOfFile(inputStream, string);
    }

    public static String contentsOfFile(InputStream inputStream, String string) throws IOException {
        byte[] byArray = FileHelper.readFile(inputStream);
        return new String(byArray, string);
    }

    public static String contentsOfFile(File file) throws IOException {
        return FileHelper.contentsOfFile(file, "UTF-8");
    }

    public static String contentsOfFile(File file, String string) throws IOException {
        byte[] byArray = FileHelper.readFile(file);
        return new String(byArray, string);
    }

    public static String contentsOfFile(URL uRL) throws IOException {
        return FileHelper.contentsOfFile(uRL, "UTF-8");
    }

    public static String contentsOfFile(URL uRL, String string) throws IOException {
        byte[] byArray = FileHelper.readFile(uRL);
        return new String(byArray, string);
    }

    public static byte[] readFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = FileHelper.readFile(fileInputStream);
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.d("Could not open file: " + StringHelper.removeURLParams(file.toString()), fileNotFoundException);
            throw fileNotFoundException;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] readUrl(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            byte[] byArray = FileHelper.readFile(inputStream);
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.d("Could not open file: " + StringHelper.removeURLParams(uRL.toString()), fileNotFoundException);
            throw fileNotFoundException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String contentsOfBundleResource(String string) throws IOException {
        try {
            URL uRL = FileHelper.urlForBundleResource(string);
            String string2 = FileHelper.contentsOfFile(uRL);
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.d("Could not load bundle resource: " + string, fileNotFoundException);
            return null;
        }
    }

    public static byte[] readFile(InputStream inputStream) throws IOException {
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[16384];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            logger.d("Could not read inputstream: " + StringHelper.removeURLParams(iOException.getMessage()));
            throw iOException;
        }
    }

    public static byte[] readFile(URL uRL) throws IOException {
        return FileHelper.readFile(uRL.openStream());
    }

    public static void appendFile(File file, String string) throws IOException {
        FileUtils.write((File)file, (CharSequence)string, (Charset)Charset.forName("UTF-8"), (boolean)true);
    }

    public static void writeFile(File file, String string) throws IOException {
        FileUtils.write((File)file, (CharSequence)string, (Charset)Charset.forName("UTF-8"));
    }

    public static void writeFile(File file, BufferedReader bufferedReader) throws IOException {
        String string;
        FileUtils.deleteQuietly((File)file);
        while ((string = bufferedReader.readLine()) != null) {
            FileUtils.write((File)file, (CharSequence)string, (boolean)true);
        }
    }

    public static void writeFile(File file, byte[] byArray) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
    }

    public static void writeFile(File file, o o2) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])o2.c());
    }

    public static boolean copyItemAtPath_targetPath(String string, String string2) {
        try {
            File file = new File(string);
            File file2 = new File(string2);
            if (file.isDirectory()) {
                FileUtils.copyDirectory((File)file, (File)file2);
            } else if (file.exists() && file2.isFile()) {
                FileUtils.copyFile((File)new File(string), (File)new File(string2));
            } else if (file.exists() && file2.isDirectory()) {
                FileUtils.copyFileToDirectory((File)new File(string), (File)new File(string2));
            } else {
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            logger.c("Could not copy file from " + StringHelper.removeURLParams(string) + " to " + string2);
            return false;
        }
    }

    public static boolean backupFile(File file) {
        File file2 = null;
        try {
            file2 = new File(String.valueOf(file.getAbsolutePath()) + ".bak");
            FileUtils.copyFile((File)file, (File)file2);
            return true;
        }
        catch (IOException iOException) {
            logger.c("Could not backup file from " + file + " to " + file2);
            return false;
        }
    }

    public static boolean restoreFile(File file) {
        File file2 = null;
        try {
            file2 = new File(String.valueOf(file.getAbsolutePath()) + ".bak");
            FileUtils.copyFile((File)file2, (File)file);
            return true;
        }
        catch (IOException iOException) {
            logger.c("Could not restore file from " + file + " to " + file2);
            return false;
        }
    }

    public static boolean removeBackup(File file) {
        File file2 = null;
        file2 = new File(String.valueOf(file.getAbsolutePath()) + ".bak");
        if (file2.exists()) {
            return file2.delete();
        }
        return false;
    }

    public static String encodeURL(URL uRL) {
        String string = uRL.toExternalForm();
        return string;
    }

    public static String encodeURLString(String string) {
        String string2 = StringHelper.pathExtension(string);
        String string3 = StringHelper.stringByDeletingPathExtension(string);
        string3 = string3.replace("?", "_");
        string3 = string3.replace("/", "-");
        string3 = string3.replace(".", "_");
        string3 = string3.replace(":", "_");
        string3 = string3.replace("%20", "_");
        if (string2.length() > 0) {
            return String.format(Locale.ENGLISH, "%s.%s", string3, string2);
        }
        return string3;
    }

    public static boolean copyFromBundle_intoDir_atRelativePath_overwrite(String string, String string2, String string3, boolean bl) {
        boolean bl2 = false;
        try {
            File file;
            boolean bl3;
            String string4 = string2;
            if (string3 != null) {
                string4 = StringHelper.stringByAppendingPathComponent(string2, string3);
            }
            if ((bl3 = (file = new File(string4)).exists()) && bl && !file.isDirectory() && !FileHelper.removeFileAtPath(string4)) {
                logger.c("Could not remove existing file: " + string4);
            }
            if (bl2 = f.b().I().copyItemfromBundleUrl_toTargetPath(string, file)) {
                logger.b(String.format(Locale.ENGLISH, "Copied bundle file %s to %s", string, string4));
            } else {
                logger.d("Could not copy bundle " + string);
            }
        }
        catch (Exception exception) {
            logger.d("Exception while copying bundle file: " + string + ": " + exception.getMessage(), exception);
            return false;
        }
        return bl2;
    }

    public static boolean copyFromBundle_intoLibraryPrivateDocumentsPath_overwrite(String string, String string2, boolean bl) {
        return FileHelper.copyFromBundle_intoDir_atRelativePath_overwrite(string, SystemHelper.libraryPrivateDocumentsDirectory(), string2, bl);
    }

    public static boolean copyFromBundle_intoDocumentsPath_overwrite(String string, String string2, boolean bl) {
        return FileHelper.copyFromBundle_intoDir_atRelativePath_overwrite(string, SystemHelper.documentDirectory(), string2, bl);
    }

    public static void zipFiles(Collection<File> collection, File file) throws IOException {
        file.getParentFile().mkdirs();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        for (File file2 : collection) {
            try {
                int n2;
                FileInputStream fileInputStream = new FileInputStream(file2);
                zipOutputStream.putNextEntry(new ZipEntry(file2.getName()));
                byte[] byArray = new byte[1024];
                while ((n2 = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n2);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            catch (Exception exception) {
                logger.d("Could not add file: " + file2 + " to zipFile: " + file + ". Reson: " + exception);
            }
        }
        zipOutputStream.close();
    }

    public static Date getFileModificationDate(String string) {
        File file = new File(string);
        return new Date(file.lastModified());
    }

    public static Date getFileCreationDate(File file) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return new Date(basicFileAttributes.creationTime().toMillis());
        }
        catch (IOException iOException) {
            logger.d("Could not detect creationDate of file: " + file, iOException);
            return null;
        }
    }

    public static void modifyFileAtPath_creationDate(String string, Date date) {
        File file = new File(string);
        file.setLastModified(date.getTime());
    }

    public static void createFileAtPath(String string) throws IOException {
        File file = new File(string);
        FileHelper.createFileAtPath(file);
    }

    public static void createFileAtPath(File file) throws IOException {
        file.createNewFile();
    }

    public static String getMSDOSName(String string) {
        int n2;
        byte[] byArray;
        block3: {
            try {
                String string2 = FileHelper.getAbsolutePath(string);
                Process process = Runtime.getRuntime().exec("cmd /c for %I in (\"" + string2 + "\") do @echo %~fsI");
                process.waitFor();
                byArray = new byte[65536];
                n2 = process.getInputStream().read(byArray);
                if (n2 > 0) break block3;
                byte[] byArray2 = new byte[65536];
                int n3 = process.getErrorStream().read(byArray2);
                String string3 = new String(byArray2, 0, n3);
                logger.d("Could not get MSDOS filename for: " + string + ". cmd returned an empty result. Exit value: " + process.exitValue() + ", error: " + string3);
                return null;
            }
            catch (Exception exception) {
                logger.d("Could not get MSDOS filename for: " + string, exception);
                return string;
            }
        }
        return new String(byArray, 0, n2).replaceAll("\\r\\n", "");
    }

    public static String getAbsolutePath(String string) throws IOException {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (!file.exists()) {
            file = new File(string2);
        }
        string2 = file.getCanonicalPath();
        if (file.isDirectory() && !string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        return string2;
    }

    public static boolean isDownloadableFileUrl(String string) {
        String string2 = StringHelper.extractStringFrom_until(string, "?");
        string2 = StringHelper.extractStringFrom_until(string, "&");
        return string2.endsWith(".doc") || string2.endsWith(".docx") || string2.endsWith(".ppt") || string2.endsWith(".pptx") || string2.endsWith(".xls") || string2.endsWith(".xlsx") || string2.endsWith(".zip");
    }

    public static void removeBOM(File file) {
        try {
            File file2 = File.createTempFile(file.getName(), "tmp");
            BOMInputStream bOMInputStream = new BOMInputStream((InputStream)new FileInputStream(file), false);
            FileUtils.copyInputStreamToFile((InputStream)bOMInputStream, (File)file2);
            bOMInputStream.close();
            file.delete();
            file2.renameTo(file);
        }
        catch (IOException iOException) {
            logger.d("Could not remove BOM on file: " + file, iOException);
        }
    }

    public static String[] splitPath(File file) {
        return FileHelper.splitPath(file.getAbsolutePath());
    }

    public static String[] splitPath(String string) {
        string = string.replaceAll("\\\\", "/");
        string = StringUtils.removeStart((String)string, (String)"/");
        string = StringUtils.removeEnd((String)string, (String)"/");
        return string.split("/");
    }

    public static String fileToValidS3Key(File file) {
        return FileHelper.stringToValidS3Key(file.toString());
    }

    public static String stringToValidS3Key(String string) {
        return string.replaceAll("\\\\", "/");
    }

    public static String getMimeTypeOfFile(File file) {
        try {
            Tika tika = new Tika();
            return tika.detect(file);
        }
        catch (IOException iOException) {
            logger.d("Could not determine mime type of file: " + file.getAbsolutePath(), iOException);
            return "";
        }
    }

    public static boolean isFileLocked(File file) {
        return !file.renameTo(file);
    }
}

