/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.ex.g;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.base.he.UnZip;
import ch.ionesoft.ilp.base.he.Zip;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.io.FileUtils;

public class DESEncrypter {
    private static ILogger logger = ILPLogManager.getLogger(DESEncrypter.class);
    private Cipher ecipher;
    private Cipher dcipher;
    private static final String defaultIv = "9eod8alc";

    public DESEncrypter(String string) throws Exception {
        this(string, defaultIv);
    }

    public DESEncrypter(String string, String string2) throws Exception {
        if (string2.length() != 8) {
            throw new IllegalArgumentException("Length of ivString must be exactly 8 chars");
        }
        byte[] byArray = string2.getBytes();
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        this.ecipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        this.dcipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        SecretKey secretKey = this.generateSecretKey(string);
        this.ecipher.init(1, (Key)secretKey, ivParameterSpec);
        this.dcipher.init(2, (Key)secretKey, ivParameterSpec);
    }

    protected SecretKey generateSecretKey(String string) {
        try {
            DESKeySpec dESKeySpec = new DESKeySpec(string.getBytes());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESKeySpec);
            return secretKey;
        }
        catch (Exception exception) {
            logger.d("Could not generate key: " + exception.getMessage());
            return null;
        }
    }

    public synchronized void encrypt(InputStream inputStream, OutputStream outputStream) throws Exception {
        outputStream = new CipherOutputStream(outputStream, this.ecipher);
        int n2 = 0;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.close();
    }

    public synchronized void encrypt(File file, File file2) throws Exception {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            this.encrypt(fileInputStream, fileOutputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public synchronized void decrypt(InputStream inputStream, OutputStream outputStream) throws Exception {
        inputStream = new CipherInputStream(inputStream, this.dcipher);
        int n2 = 0;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.close();
    }

    public synchronized void decrypt(File file, File file2) throws Exception {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            this.decrypt(fileInputStream, fileOutputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public synchronized void encrypt(File file) throws Exception {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File file2 = File.createTempFile(SystemHelper.createUUID(), ".tmp");
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            this.encrypt(fileInputStream, fileOutputStream);
            file.delete();
            FileUtils.moveFile((File)file2, (File)file);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (file2.exists()) {
                file2.delete();
            }
        }
    }

    public synchronized void decrypt(File file) throws Exception {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        File file2 = File.createTempFile(SystemHelper.createUUID(), ".tmp");
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            this.decrypt(fileInputStream, fileOutputStream);
            fileInputStream.close();
            fileInputStream = null;
            file.delete();
            FileUtils.moveFile((File)file2, (File)file);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (file2.exists()) {
                file2.delete();
            }
        }
    }

    public void decryptZip(File file, File file2) {
        try {
            logger.a("Start decrypting zip/epub. File: " + file.getAbsolutePath());
            File file3 = Files.createTempDirectory(SystemHelper.createUUID(), new FileAttribute[0]).toFile();
            UnZip.unzip(file, file3);
            this.loopOrDecrypFile(file3.listFiles());
            Zip zip = new Zip();
            zip.zipFolder(file3, file2);
            file3.deleteOnExit();
            logger.a("Finished decrypting zip/epub.");
        }
        catch (Exception exception) {
            logger.d("Could not decrypt zip", exception);
        }
    }

    private void loopOrDecrypFile(File[] fileArray) throws Exception {
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray2[n3];
            if (file.isDirectory()) {
                this.loopOrDecrypFile(file.listFiles());
            } else {
                this.decrypt(file);
            }
            ++n3;
        }
    }

    public synchronized String encryptString(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            String string2 = f.b().I().base64EncodeAsString(this.ecipher.doFinal(byArray));
            return string2;
        }
        catch (Exception exception) {
            throw new g("Could not encode: " + exception.getMessage());
        }
    }

    public synchronized byte[] encryptStringAsBytes(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = this.ecipher.doFinal(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            throw new g("Could not encode: " + exception.getMessage());
        }
    }

    public synchronized String decryptString(String string) {
        try {
            byte[] byArray = f.b().I().base64Decode(string);
            byte[] byArray2 = this.dcipher.doFinal(byArray);
            return new String(byArray2, "UTF-8");
        }
        catch (Exception exception) {
            throw new g("Could not decode: " + exception.getMessage());
        }
    }

    public synchronized String decryptString(byte[] byArray) {
        try {
            byte[] byArray2 = this.dcipher.doFinal(byArray);
            return new String(byArray2, "UTF-8");
        }
        catch (Exception exception) {
            throw new g("Could not decode: " + exception.getMessage());
        }
    }

    public synchronized byte[] decryptBytes(byte[] byArray) {
        try {
            return this.dcipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new g("Could not decode: " + exception.getMessage());
        }
    }

    public OutputStream wrapOutputStreamEncrypt(OutputStream outputStream) {
        return new CipherOutputStream(outputStream, this.ecipher);
    }

    public OutputStream wrapOutputStreamDecrypt(OutputStream outputStream) {
        return new CipherOutputStream(outputStream, this.dcipher);
    }

    public InputStream wrapInputStreamDecrypt(InputStream inputStream) {
        return new CipherInputStream(inputStream, this.dcipher);
    }

    public InputStream wrapInputStreamEncrypt(InputStream inputStream) {
        return new CipherInputStream(inputStream, this.ecipher);
    }
}

