/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.DateHelper;
import ch.ionesoft.ilp.base.he.StringHelper;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ConverterUtil {
    private static ILogger logger = ILPLogManager.getLogger(ConverterUtil.class);
    private static List<String> BLOCKED_EXTENSIONS = ConverterUtil.createBlockedExtensionsList();
    private static final Map<String, String> MIMETYPE_MAP = ConverterUtil.createMimetypeMap();

    public static String dateNowAsDDMMYYYYString() {
        return ConverterUtil.formatDateDDMMYYYY(new Date());
    }

    public static String timeNowString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    public static String formatDateDDMMYYYY(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String formatDateYearOrDDMMYYYY(Date date) {
        if (date == null) {
            return "";
        }
        if (ConverterUtil.dayOfYear(date) == 1) {
            return ConverterUtil.formatDateYYYY(date);
        }
        return ConverterUtil.formatDateDDMMYYYY(date);
    }

    public static int dayOfYear(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("D");
        String string = simpleDateFormat.format(date);
        return Integer.parseInt(string);
    }

    public static String formatDateYYYYMMDDHHmmss_SSS(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String formatDateYYYYMMDDHyphenated(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String formatDateYYYY(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String formatDateDDMMYYYY_timeZoneAbbreviation(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        String string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static String formatDateISODateString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String formatDateISODateHHmmssString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date == null) {
            return null;
        }
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String formatDateISODateString_timeZoneAbbreviation(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        String string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static String formatLongDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        return simpleDateFormat.format(date);
    }

    public static String formatLongDate_timeZoneAbbreviation(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        return simpleDateFormat.format(date);
    }

    public static String formatShortDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yy");
        return simpleDateFormat.format(date);
    }

    public static String formatShortDate_timeZoneAbbreviation(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        return simpleDateFormat.format(date);
    }

    public static String formatShortTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        return simpleDateFormat.format(date);
    }

    public static String formatShortTime_timeZoneAbbreviation(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        return simpleDateFormat.format(date);
    }

    public static String formatTimeAndDay(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm (dd.)");
        return simpleDateFormat.format(date);
    }

    public static String formatTimeAndDay_timeZoneAbbreviation(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm (dd.)");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        return simpleDateFormat.format(date);
    }

    public static String formatTimeHHMM(Date date) {
        if (DateHelper.timeIntervalSinceReferenceDate() == 0L) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String formatTimeHHMM_timeZoneAbbreviation(Date date, String string) {
        if (DateHelper.timeIntervalSinceReferenceDate() == 0L) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        String string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static Date dateWithZeroTime(Date date) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date2 = simpleDateFormat.parse(simpleDateFormat.format(date));
        return date2;
    }

    public static String formatTimeAnnotatedSince(Date date) {
        String string = ConverterUtil.formatTimeSince(date);
        return string.length() > 0 ? String.format(Locale.ENGLISH, "\u231a %s", string) : "";
    }

    public static String formatTimeSince(Date date) {
        if (DateHelper.timeIntervalSinceReferenceDate() == 0L) {
            return "";
        }
        Date date2 = new Date();
        int n2 = (int)((date2.getTime() - date.getTime()) / 1000L);
        int n3 = n2 / 60;
        if (n3 < 59) {
            return ConverterUtil.formatSeconds2String(n2);
        }
        int n4 = n3 / 60;
        return String.format(Locale.ENGLISH, "%d h %d min", n4, n3 - n4 * 60);
    }

    public static String formatElapsedTimeSince(Date date) {
        if (DateHelper.timeIntervalSinceReferenceDate() == 0L) {
            return "";
        }
        Date date2 = new Date();
        int n2 = (int)(date2.getTime() - date.getTime());
        int n3 = n2 % 1000;
        int n4 = n2 / 1000;
        int n5 = n2 / 60000;
        if (n5 == 0) {
            return String.format(Locale.ENGLISH, "%d.%03d secs", n4, n3);
        }
        return String.format(Locale.ENGLISH, "%d min %d.%d secs", n5, n4 - n5 * 60, n3);
    }

    public static String formatCurrentTimestampAsFileBasename() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS");
        return simpleDateFormat.format(new Date());
    }

    public static String formatCurrentDateAsFileBasename() {
        Date date = new Date();
        return ConverterUtil.formatDateAsFileBasename(date);
    }

    public static String formatDateAsFileBasename(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        return simpleDateFormat.format(date);
    }

    public static String formatTimestamp(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static String formatTimestampNicely(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String string = simpleDateFormat.format(date);
        if (string.endsWith(" 00:00:00")) {
            string = StringHelper.extractStringFrom_until(string, " 00:00:00");
        }
        return string;
    }

    public static String formatISOTimestamp(DateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return ConverterUtil.formatISOTimestamp(dateTime.toDate());
    }

    public static String formatISOTimestamp(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return simpleDateFormat.format(date).replaceAll("(\\d\\d)(\\d\\d)$", "$1:$2");
    }

    public static String formatMinutes2String(Integer n2) {
        if (n2 != null && n2 > 0) {
            int n3 = n2;
            if (n3 > 60) {
                return String.format(Locale.ENGLISH, "%d h %02d min", n3 / 60, n3 % 60);
            }
            return String.format(Locale.ENGLISH, "%d min", n3);
        }
        return "";
    }

    public static String formatMinutes2CompactString(Integer n2) {
        if (n2 != null && n2 > 0) {
            int n3 = n2;
            if (n3 > 60) {
                return String.format(Locale.ENGLISH, "%dh %02d'", n3 / 60, n3 % 60);
            }
            return String.format(Locale.ENGLISH, "%d'", n3);
        }
        return "";
    }

    public static String formatSeconds2String(Integer n2) {
        if (n2 != null && n2 > 0) {
            int n3 = n2;
            if (n3 > 60) {
                return String.format(Locale.ENGLISH, "%d min %d s", n3 / 60, n3 % 60);
            }
            return String.format(Locale.ENGLISH, "%d s", n3);
        }
        return "";
    }

    public static String formatSeconds2TimeString(Integer n2) {
        int n3 = n2;
        int n4 = n3 % 60;
        int n5 = n3 / 60 % 60;
        int n6 = n3 / 3600;
        if (n6 > 0) {
            return String.format(Locale.ENGLISH, "%02d:%02d:%02d", n6, n5, n4);
        }
        return String.format(Locale.ENGLISH, "%02d:%02d", n5, n4);
    }

    public static String formatSeconds2CalmTimeString(Integer n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = n2;
        int n5 = n4 / 60 / 60;
        if (n5 > 0) {
            stringBuilder.append(n5);
            stringBuilder.append(" h");
            n4 -= n5 * 60 * 60;
        }
        if ((n3 = n4 / 60) > 0 || n5 > 0) {
            stringBuilder.append(n3);
            stringBuilder.append(" min");
            n4 -= n3 * 60;
        } else {
            stringBuilder.append(n4);
            stringBuilder.append(" sec");
        }
        return stringBuilder.toString();
    }

    public static int formatMinutesFloat2SecondsInteger(Float f2) {
        int n2 = (int)(f2.floatValue() * 60.0f);
        return n2;
    }

    public static String formatBytesNicely(long l2) {
        if (l2 == 0L) {
            return "0";
        }
        if (l2 > 0x40000000L) {
            return String.format("%.1f GB", (double)l2 * 1.0 / 1.073741824E9);
        }
        if (l2 > 0x100000L) {
            return String.format("%.1f MB", (double)l2 * 1.0 / 1048576.0);
        }
        if (l2 > 1024L) {
            return String.format("%.0f kB", (double)l2 * 1.0 / 1024.0);
        }
        return "" + l2;
    }

    public static String readableFileSize(long l2) {
        if (l2 <= 0L) {
            return "0";
        }
        String[] stringArray = new String[]{"B", "kB", "MB", "GB", "TB"};
        int n2 = (int)(Math.log10(l2) / Math.log10(1024.0));
        return String.valueOf(new DecimalFormat("#,##0.#").format((double)l2 / Math.pow(1024.0, n2))) + " " + stringArray[n2];
    }

    public static Date parseDateDDMMYYYY(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
            return simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            logger.c("Could not parse dateString: " + string + ", " + exception);
            return null;
        }
    }

    public static Date parseDateYYYY(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        return simpleDateFormat.parse(string);
    }

    public static Date parseDateYYYYMMdd_timeHHMMSS(String string) {
        Date date = null;
        if (string == null || StringHelper.isEmpty(string)) {
            return null;
        }
        if (date == null) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static Date parseDateDDMMYYYY_timeHHSS(String string, String string2) throws ParseException {
        if (string == null) {
            return null;
        }
        return ConverterUtil.parseDateISO_timeHHMMSS(String.format(Locale.ENGLISH, "%s %s", string, string2));
    }

    public static Date parseDateDDMMYYYY_timeHHSS_timeZoneAbbreviation(String string, String string2, String string3) throws ParseException {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
        return simpleDateFormat.parse(String.format(Locale.ENGLISH, "%s %s", string, string2));
    }

    public static Date parseDateDDMMYY_timeHHSS_timeZoneAbbreviation(String string, String string2, String string3) throws ParseException {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yy, HH:mm");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
        return simpleDateFormat.parse(String.format(Locale.ENGLISH, "%s %s", string, string2));
    }

    public static Date parseDateISO(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.parse(string);
    }

    public static Date parseTimestampFromAnyFormat(String string) {
        Date date;
        block22: {
            date = null;
            if (string == null) {
                return null;
            }
            try {
                date = ConverterUtil.parseDateISOTimestamp(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (date == null) {
                    date = ConverterUtil.parseDateRFC1123(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (date == null) {
                    date = ConverterUtil.parseDateISO_timeHHMMSSMilis_z(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (date == null) {
                    date = ConverterUtil.parseDateISO_timeHHMMSS_zzz(string);
                }
            }
            catch (Exception exception) {
                if (date != null) break block22;
                String string2 = string.replace(" T ", " ");
                try {
                    date = ConverterUtil.parseDateISO_timeHHMMSS_zzz(string2);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        try {
            if (date == null) {
                date = ConverterUtil.parseDateISO_timeHHMMSS(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (date == null && string.charAt(string.length() - 4) == ' ') {
                String string3 = string.substring(0, string.length() - 3);
                date = ConverterUtil.parseDateISO_timeHHMMSS(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            date = ConverterUtil.parseDateFromAnyFormat(string);
        }
        if (date == null) {
            logger.c("Could not parse timestamp with any known format: " + string);
        }
        return date;
    }

    public static Date parseDateISO_timeHHMMSS(String string) throws ParseException {
        if (string == null || StringHelper.isEmpty(string)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.parse(string);
    }

    public static Date parseDateISO_timeHHMMSS(String string, String string2) throws ParseException {
        if (string == null) {
            return null;
        }
        return ConverterUtil.parseDateISO_timeHHMMSS(String.format(Locale.ENGLISH, "%s %s", string, string2));
    }

    public static Date parseDateISO_timeHHMMSS_zzz(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ENGLISH);
        Date date = simpleDateFormat.parse(string);
        return date;
    }

    public static Date parseDateISO_timeHHMMSSMilis_z(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
        DateTime dateTime = dateTimeFormatter.parseDateTime(string);
        if (dateTime != null) {
            return dateTime.toDate();
        }
        return null;
    }

    public static Date parseDateISO_timeHHMMSS_timeZoneAbbreviation(String string, String string2, String string3) throws ParseException {
        if (string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
        return simpleDateFormat.parse(String.format(Locale.ENGLISH, "%s %s", string, string2));
    }

    public static Date parseDateISOTimestamp(String string) throws ParseException {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeNoMillis();
        DateTime dateTime = dateTimeFormatter.parseDateTime(string);
        if (dateTime != null) {
            return dateTime.toDate();
        }
        return null;
    }

    public static Date parseDateRFC1123(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "EEE, dd MMM yyyy HH:mm:ss Z";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.ENGLISH);
        try {
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (ParseException parseException) {
            String string3 = "EEE, dd MMM yyyy HH:mm:ss z";
            simpleDateFormat = new SimpleDateFormat(string3, Locale.ENGLISH);
            try {
                Date date = simpleDateFormat.parse(string);
                return date;
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }

    public static Date parseDateFromAnyFormat(String string) {
        SimpleDateFormat simpleDateFormat;
        Date date = null;
        if (string == null) {
            return null;
        }
        try {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (date == null) {
            try {
                simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                simpleDateFormat = new SimpleDateFormat("dd.MM.yy");
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                simpleDateFormat = new SimpleDateFormat("MM/dd/yy");
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                simpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                simpleDateFormat = new SimpleDateFormat("dd MMMM yyyy HH:mm:ss");
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static DateTime parseDateTimeFromAnyFormat(String string) {
        DateTimeFormatter dateTimeFormatter;
        if (string == null || StringHelper.isEmpty(string) || string.equalsIgnoreCase("null")) {
            return null;
        }
        DateTime dateTime = null;
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss z").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"dd-MM-yyyy").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"dd-MMM-yyyy").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"dd.MM.yyyy").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"dd.MM.yy").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"MM/dd/yy").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"MM/dd/yyyy").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"dd MMM yyyy HH:mm:ss").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"dd MMMM yyyy HH:mm:ss").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (dateTime == null) {
            try {
                dateTimeFormatter = DateTimeFormat.forPattern((String)"dd MMMM yyyy HH:mm:ss").withZoneUTC();
                dateTime = DateTime.parse((String)string, (DateTimeFormatter)dateTimeFormatter);
                return dateTime;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return dateTime;
    }

    public static boolean isDate(String string) {
        Date date = ConverterUtil.parseDateFromAnyFormat(string);
        return date != null;
    }

    public static String formatBoolean2String(Boolean bl) {
        if (bl != null) {
            if (bl.booleanValue()) {
                return o.a().d("label.yes");
            }
            return o.a().d("label.no");
        }
        return "";
    }

    public static String convertBooleanToString(Boolean bl) {
        if (bl != null) {
            return String.format(Locale.ENGLISH, "%s", bl != false ? "true" : "false");
        }
        return "";
    }

    public static String convertNumberToString_defaultValue(Number number, String string) {
        if (number != null) {
            return String.format(Locale.ENGLISH, "%s", "" + number);
        }
        return string;
    }

    public static String convertFloatToTrimmedFraction_maxDigits(Float f2, int n2) {
        int n3 = 0;
        double d2 = 0.0;
        n3 = 0;
        while (n3 <= n2) {
            d2 = (double)Math.round((double)f2.floatValue() * Math.pow(10.0, n3)) / Math.pow(10.0, n3) - (double)f2.floatValue();
            if (Math.abs(d2) < 0.5 * Math.pow(10.0, -n2)) break;
            ++n3;
        }
        String string = "%." + n3 + "f";
        return String.format(Locale.ENGLISH, string, f2);
    }

    public static Boolean convertToBoolean_defaultValue(String string, Boolean bl) {
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            return bl;
        }
        if ("0".equals(string = string.toLowerCase()) || "0.0".equals(string) || "n".equals(string) || "no".equals(string) || "false".equals(string) || "nein".equals(string)) {
            return Boolean.FALSE;
        }
        if ("1".equals(string) || "1.0".equals(string) || "y".equals(string) || "yes".equals(string) || "true".equals(string) || "ja".equals(string) || "x".equals(string)) {
            return Boolean.TRUE;
        }
        return bl;
    }

    public static Integer convertToInteger_defaultValue(String string, Integer n2) {
        if (string == null || string.length() == 0) {
            return n2;
        }
        if (StringHelper.isDecimalString(string)) {
            return Double.valueOf(string).intValue();
        }
        if (StringHelper.isNumericString(string)) {
            return Integer.parseInt(string);
        }
        return n2;
    }

    public static Number convertToNumber(String string) throws ParseException {
        DecimalFormat decimalFormat = new DecimalFormat();
        Number number = decimalFormat.parse(string);
        return number;
    }

    public static Integer convertDecimalStringToInteger_defaultValue(String string, Integer n2) {
        if (string == null || string.length() == 0) {
            return n2;
        }
        try {
            Number number = ConverterUtil.convertToNumber(string);
            return (int)Math.rint(number.doubleValue());
        }
        catch (Exception exception) {
            logger.c("Could not parse " + string + " to integer, reason: " + exception);
            return n2;
        }
    }

    public static Long convertDecimalStringToLong_defaultValue(String string, Long l2) {
        if (string == null || string.length() == 0) {
            return l2;
        }
        try {
            Number number = ConverterUtil.convertToNumber(string);
            return number.longValue();
        }
        catch (Exception exception) {
            logger.c("Could not parse " + string + " to long, reason: " + exception);
            return l2;
        }
    }

    public static Float convertDecimalStringToFloat_defaultValue(String string, Float f2) {
        if (string == null || string.length() == 0) {
            return f2;
        }
        try {
            String string2 = string.replaceFirst("\\.", "#");
            string2 = string2.replace(".", "");
            string2 = string2.replaceFirst("#", ".");
            Float f3 = Float.valueOf(Float.parseFloat(string2));
            return f3;
        }
        catch (Exception exception) {
            logger.c("Could not convert " + string, exception);
            return f2;
        }
    }

    public static Properties convertStringToProperties(String string, String string2, String string3, boolean bl) {
        if (StringHelper.isBlank(string)) {
            return null;
        }
        String[] stringArray = string.split(string2);
        Properties properties = new Properties();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string4 = stringArray2[n3];
            String string5 = StringHelper.trimAll(StringHelper.extractStringFrom_until(string4, string3));
            String string6 = StringHelper.trimAll(StringHelper.extractString_after(string4, string3));
            if (bl && string6.startsWith("\"") && string6.endsWith("\"")) {
                string6 = StringHelper.substringWithRange(string6, 1, string6.length() - 1);
            }
            properties.put(string5, string6);
            ++n3;
        }
        return properties;
    }

    public static List convertForeignCollectionToList(ForeignCollection foreignCollection) {
        ArrayList<Object> arrayList = new ArrayList<Object>(foreignCollection.size());
        CloseableIterator closeableIterator = foreignCollection.closeableIterator();
        try {
            while (closeableIterator.hasNext()) {
                Object object = closeableIterator.next();
                arrayList.add(object);
            }
        }
        finally {
            closeableIterator.closeQuietly();
        }
        return arrayList;
    }

    public static float roundFloatWithPrecision(float f2, float f3) {
        if (f3 <= 0.0f) {
            return f2;
        }
        return (float)Math.round(f2 / f3) * f3;
    }

    public static String mimeTypeForFilename(String string) {
        String string2;
        String string3;
        if (string.startsWith("content://com.android.providers.media.documents/document/image")) {
            return "image/jpeg";
        }
        if (string.toLowerCase().startsWith("http") && string.contains("?")) {
            string = StringHelper.extractStringFrom_until(string, "?");
        }
        if ((string3 = MIMETYPE_MAP.get(string2 = StringHelper.pathExtension(string).toLowerCase())) == null) {
            string3 = "";
        }
        return string3;
    }

    public static String getMimeTypeForFileExtension(String string) {
        return MIMETYPE_MAP.get(string);
    }

    public static String getFileExtensionForMimeType(String string) {
        if (string != null && MIMETYPE_MAP.containsValue(string)) {
            for (String string2 : MIMETYPE_MAP.keySet()) {
                if (!MIMETYPE_MAP.get(string2).equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    public static boolean isMimeTypeJpg(String string) {
        if (string != null) {
            return string.equals(MIMETYPE_MAP.get("jpeg"));
        }
        return false;
    }

    public static boolean containsBlockedFileNameText(String string) {
        return string.contains("+");
    }

    public static boolean containsBlockedExtensions(String string) {
        block4: {
            if (!StringUtils.isEmpty((CharSequence)string)) break block4;
            return false;
        }
        try {
            String string2 = FilenameUtils.getExtension((String)string);
            if (StringUtils.isNotEmpty((CharSequence)string2) && BLOCKED_EXTENSIONS.contains(string2.toLowerCase())) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.d("Could not check filepath for blocked extension: " + string);
        }
        return false;
    }

    private static List<String> createBlockedExtensionsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("exe");
        arrayList.add("bat");
        arrayList.add("sh");
        arrayList.add("msi");
        arrayList.add("ps1");
        arrayList.add("bin");
        arrayList.add("pif");
        arrayList.add("application");
        arrayList.add("gadget");
        arrayList.add("msp");
        arrayList.add("com");
        arrayList.add("scr");
        arrayList.add("hta");
        arrayList.add("cpl");
        arrayList.add("msc");
        arrayList.add("jar");
        arrayList.add("cmd");
        arrayList.add("vb");
        arrayList.add("vbs");
        arrayList.add("vbe");
        arrayList.add("js");
        arrayList.add("jse");
        arrayList.add("ws");
        arrayList.add("wsf");
        arrayList.add("wsc");
        arrayList.add("wsh");
        arrayList.add("ps1xml");
        arrayList.add("ps2");
        arrayList.add("ps2xml");
        arrayList.add("psc1");
        arrayList.add("psc2");
        arrayList.add("msh");
        arrayList.add("msh1");
        arrayList.add("msh2");
        arrayList.add("mshxml");
        arrayList.add("msh1xml");
        arrayList.add("msh2xml");
        arrayList.add("scf");
        arrayList.add("lnk");
        arrayList.add("inf");
        arrayList.add("reg");
        arrayList.add("heif");
        arrayList.add("heic");
        return arrayList;
    }

    private static Map<String, String> createMimetypeMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("eot", "application/vnd.ms-fontobject");
        hashMap.put("woff", "application/font-woff");
        hashMap.put("otf", "font/opentype");
        hashMap.put("ttf", "application/font-ttf");
        hashMap.put("ttc", "application/x-font-ttf");
        hashMap.put("svg", "image/svg+xml");
        hashMap.put("hqx", "application/mac-binhex40");
        hashMap.put("cpt", "application/mac-compactpro");
        hashMap.put("doc", "application/msword");
        hashMap.put("dot", "application/msword");
        hashMap.put("docx", "application/msword");
        hashMap.put("dotx", "application/msword");
        hashMap.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        hashMap.put("docm", "application/vnd.ms-word.document.macroEnabled.12");
        hashMap.put("dotm", "application/vnd.ms-word.template.macroEnabled.12");
        hashMap.put("xls", "application/vnd.ms-excel");
        hashMap.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        hashMap.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        hashMap.put("xlsm", "application/vnd.ms-excel.sheet.macroEnabled.12");
        hashMap.put("xltm", "application/vnd.ms-excel.template.macroEnabled.12");
        hashMap.put("xlam", "application/vnd.ms-excel.addin.macroEnabled.12");
        hashMap.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroEnabled.12");
        hashMap.put("ppt", "application/vnd.ms-powerpoint");
        hashMap.put("pt", " application/vnd.ms-powerpoint");
        hashMap.put("ot", " application/vnd.ms-powerpoint");
        hashMap.put("ps", " application/vnd.ms-powerpoint");
        hashMap.put("pa", " application/vnd.ms-powerpoint");
        hashMap.put("ptx", "application/vnd.openxmlformats-officedocumen.presentationml.presentation");
        hashMap.put("xotx", "application/vnd.openxmlformats-officedocument.presentationml.template");
        hashMap.put("xpsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        hashMap.put("xpam", "application/vnd.ms-powerpoint.addin.macroEnabled.12");
        hashMap.put("xptm", "application/vnd.ms-powerpoint.presentation.macroEnabled.12");
        hashMap.put("xotm", "application/vnd.ms-powerpoint.template.macroEnabled.12");
        hashMap.put("xpsm", "application/vnd.ms-powerpoint.slideshow.macroEnabled.12");
        hashMap.put("bin", "application/macbinary");
        hashMap.put("dms", "application/octet-stream");
        hashMap.put("lha", "application/octet-stream");
        hashMap.put("lzh", "application/octet-stream");
        hashMap.put("exe", "application/octet-stream");
        hashMap.put("class", "application/octet-stream");
        hashMap.put("psd", "application/octet-stream");
        hashMap.put("so", "application/octet-stream");
        hashMap.put("sea", "application/octet-stream");
        hashMap.put("dll", "application/octet-stream");
        hashMap.put("oda", "application/oda");
        hashMap.put("pdf", "application/pdf");
        hashMap.put("ai", "application/postscript");
        hashMap.put("eps", "application/postscript");
        hashMap.put("ps", "application/postscript");
        hashMap.put("smi", "application/smil");
        hashMap.put("smil", "application/smil");
        hashMap.put("mif", "application/vnd.mif");
        hashMap.put("wbxml", "application/vnd.wap.wbxml");
        hashMap.put("wmlc", "application/vnd.wap.wmlc");
        hashMap.put("dcr", "application/x-director");
        hashMap.put("dir", "application/x-director");
        hashMap.put("dxr", "application/x-director");
        hashMap.put("dvi", "application/x-dvi");
        hashMap.put("gtar", "application/x-gtar");
        hashMap.put("php", "application/x-httpd-php");
        hashMap.put("php4", "application/x-httpd-php");
        hashMap.put("php3", "application/x-httpd-php");
        hashMap.put("phtml", "application/x-httpd-php");
        hashMap.put("phps", "application/x-httpd-php-source");
        hashMap.put("swf", "application/x-shockwave-flash");
        hashMap.put("sit", "application/x-stuffit");
        hashMap.put("tar", "application/x-tar");
        hashMap.put("tgz", "application/x-tar");
        hashMap.put("xhtml", "application/xhtml+xml");
        hashMap.put("xht", "application/xhtml+xml");
        hashMap.put("zip", "application/zip");
        hashMap.put("mid", "audio/midi");
        hashMap.put("midi", "audio/midi");
        hashMap.put("mpga", "audio/mpeg");
        hashMap.put("mp2", "audio/mpeg");
        hashMap.put("mp3", "audio/mpeg");
        hashMap.put("m4v", "audio/mpeg");
        hashMap.put("aif", "audio/x-aiff");
        hashMap.put("aiff", "audio/x-aiff");
        hashMap.put("aifc", "audio/x-aiff");
        hashMap.put("ram", "audio/x-pn-realaudio");
        hashMap.put("rm", "audio/x-pn-realaudio");
        hashMap.put("rpm", "audio/x-pn-realaudio-plugin");
        hashMap.put("ra", "audio/x-realaudio");
        hashMap.put("rv", "video/vnd.rn-realvideo");
        hashMap.put("wav", "audio/x-wav");
        hashMap.put("bmp", "image/bmp");
        hashMap.put("gif", "image/gif");
        hashMap.put("jpeg", "image/jpeg");
        hashMap.put("jpg", "image/jpeg");
        hashMap.put("jpe", "image/jpeg");
        hashMap.put("png", "image/png");
        hashMap.put("tiff", "image/tiff");
        hashMap.put("tif", "image/tiff");
        hashMap.put("js", "text/javascript");
        hashMap.put("css", "text/css");
        hashMap.put("html", "text/html");
        hashMap.put("htm", "text/html");
        hashMap.put("shtml", "text/html");
        hashMap.put("txt", "text/plain");
        hashMap.put("text", "text/plain");
        hashMap.put("log", "text/plain");
        hashMap.put("strings", "text/plain");
        hashMap.put("rtx", "text/richtext");
        hashMap.put("rtf", "text/rtf");
        hashMap.put("xml", "text/xml");
        hashMap.put("xsl", "text/xml");
        hashMap.put("csv", "text/csv");
        hashMap.put("vtt", "text/vtt");
        hashMap.put("strings", "text/plain");
        hashMap.put("mpeg", "video/mpeg");
        hashMap.put("mpg", "video/mpeg");
        hashMap.put("mpe", "video/mpeg");
        hashMap.put("mp4", "video/mp4");
        hashMap.put("qt", "video/quicktime");
        hashMap.put("mov", "video/quicktime");
        hashMap.put("avi", "video/x-msvideo");
        hashMap.put("movie", "video/x-sgi-movie");
        hashMap.put("eml", "message/rfc822");
        hashMap.put("ncx", "application/x-dtbncx+xml");
        return Collections.unmodifiableMap(hashMap);
    }
}

