/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.StringHelper;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.AbstractVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class ConnectionHelper {
    private static ILogger logger = ILPLogManager.getLogger(ConnectionHelper.class);

    public static void installAllTrustManager(URLConnection uRLConnection) {
        if (!(uRLConnection instanceof HttpsURLConnection)) {
            logger.b("Connection is not Https");
            return;
        }
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(sSLSocketFactory);
        }
        catch (Exception exception) {
            logger.d("Could not install TrustManager for connection: " + StringHelper.removeURLParams(uRLConnection.getURL()) + ": " + StringHelper.removeURLParams(exception.getLocalizedMessage()));
        }
    }

    public static void installHostnameVerifier(URLConnection uRLConnection) {
        if (!(uRLConnection instanceof HttpsURLConnection)) {
            return;
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
        try {
            httpsURLConnection.setHostnameVerifier((HostnameVerifier)ConnectionHelper.createCustomHostnameVerifier());
        }
        catch (Exception exception) {
            logger.d("Could not install Hostname verifier for connection: " + StringHelper.removeURLParams(uRLConnection.getURL()) + ": " + StringHelper.removeURLParams(exception.getLocalizedMessage()));
        }
    }

    protected static X509HostnameVerifier createCustomHostnameVerifier() {
        return new AbstractVerifier(){

            public final void verify(String string, String[] stringArray, String[] stringArray2) throws SSLException {
                if (!this.accept(string, stringArray, stringArray2, new String[]{".ioneaccess.ch", ".beook.it", ".beook.work", ".beook.name", ".ihk-lernenmobil.it", "ihk-lernenmobil.it", ".ihklernenmobil.work", ".swissmem.it", "swissmem.name", "swissmem.work", "ihk-biz.fsz.kit.edu", "docs.google.com", ".s3.eu-central-1.amazonaws.com"})) {
                    throw new SSLException("Hostname " + string + " does not match certificate, check ConnectionHelper");
                }
            }

            boolean accept(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
                String string2 = stringArray[0];
                if (string.equals(string2)) {
                    return true;
                }
                String[] stringArray4 = stringArray3;
                int n2 = stringArray3.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = stringArray4[n3];
                    if (string.endsWith(string3)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
        };
    }
}

