/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.CSSHelper;
import ch.ionesoft.ilp.base.he.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class CSSWrapper {
    private static ILogger logger = ILPLogManager.getLogger(CSSWrapper.class);
    private LinkedHashMap<String, HashMap<String, String>> cssMap;
    private List<File> cssFiles;

    public CSSWrapper(File file) {
        ArrayList<String> arrayList = new ArrayList();
        try {
            arrayList = FileUtils.readLines((File)file, (String)"UTF-8");
        }
        catch (IOException iOException) {
            logger.c("Could not read lines of file: " + file, iOException);
            return;
        }
        this.setCssFiles(new ArrayList<File>());
        this.getCssFiles().add(file);
        this.setCssMap(this.fileAsLinesToCssMap(arrayList));
    }

    public CSSWrapper(List<File> list) {
        this.setCssFiles(new ArrayList<File>());
        for (File file : list) {
            this.getCssFiles().add(file);
            ArrayList<String> arrayList = new ArrayList();
            try {
                arrayList = FileUtils.readLines((File)file, (String)"UTF-8");
            }
            catch (IOException iOException) {
                logger.c("Could not read lines of file: " + file, iOException);
                return;
            }
            if (this.getCssMap() == null) {
                this.setCssMap(this.fileAsLinesToCssMap(arrayList));
                continue;
            }
            this.addLinesToCssMap(arrayList, this.getCssMap());
        }
    }

    private LinkedHashMap<String, HashMap<String, String>> fileAsLinesToCssMap(List<String> list) {
        LinkedHashMap<String, HashMap<String, String>> linkedHashMap = new LinkedHashMap<String, HashMap<String, String>>();
        this.addLinesToCssMap(list, linkedHashMap);
        return linkedHashMap;
    }

    private void addLinesToCssMap(List<String> list, LinkedHashMap<String, HashMap<String, String>> linkedHashMap) {
        for (String string : list) {
            String string2;
            if (!this.isSelectorLine(string)) continue;
            String string3 = StringHelper.extractStringFrom_until(string, "{");
            String[] stringArray = string3.split(",");
            String string4 = CSSHelper.cssDeclarationsForSelectorLineAsString(string, list);
            String[] stringArray2 = string4.split(";");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray3 = stringArray2;
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                string2 = stringArray3[n3];
                String string5 = StringHelper.trimAll(StringHelper.extractStringFrom_until(string2, ":"));
                String string6 = StringHelper.trimAll(StringHelper.extractString_after(string2, ":"));
                hashMap.put(string5, string6);
                ++n3;
            }
            stringArray3 = stringArray;
            n2 = stringArray.length;
            n3 = 0;
            while (n3 < n2) {
                string2 = stringArray3[n3];
                linkedHashMap.put(StringHelper.trimAll(string2), hashMap);
                ++n3;
            }
        }
    }

    private boolean isSelectorLine(String string) {
        return string.contains("{");
    }

    public String valueForIdAndKey(String string, String string2, String string3) {
        String string4 = "#" + string2;
        return this.cssValueForSelectorAndKey(string, string4, string3);
    }

    public String valueForClassNameAndKey(String string, String string2, String string3) {
        String string4 = "." + string2;
        return this.cssValueForSelectorAndKey(string, string4, string3);
    }

    private String cssValueForSelectorAndKey(String string, String string2, String string3) {
        HashMap<String, String> hashMap = this.getCssMap().get(String.valueOf(string3) + string2);
        if (hashMap == null || hashMap.isEmpty()) {
            hashMap = this.getCssMap().get(string2);
        }
        if (hashMap == null || hashMap.isEmpty()) {
            return null;
        }
        return hashMap.get(string);
    }

    public String highestPrioValueForClassNamesAndKey(String[] stringArray, String string, String string2) {
        List<String> list = this.orderClassNamesAccordingToPrio(stringArray, string);
        for (String string3 : list) {
            String string4 = this.valueForClassNameAndKey(string2, string3, string);
            if (!StringUtils.isNotBlank((CharSequence)string4)) continue;
            return string4;
        }
        return null;
    }

    private List<String> orderClassNamesAccordingToPrio(String[] stringArray, String string) {
        return Arrays.asList(stringArray);
    }

    public LinkedHashMap<String, HashMap<String, String>> getCssMap() {
        return this.cssMap;
    }

    public void setCssMap(LinkedHashMap<String, HashMap<String, String>> linkedHashMap) {
        this.cssMap = linkedHashMap;
    }

    public List<File> getCssFiles() {
        return this.cssFiles;
    }

    public void setCssFiles(List<File> list) {
        this.cssFiles = list;
    }
}

