/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.base.he;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.gdata.b;
import ch.ionesoft.ilp.base.gdata.f;
import ch.ionesoft.ilp.base.he.CSSWrapper;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.base.he.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class CSSHelper {
    private static ILogger logger = ILPLogManager.getLogger(CSSHelper.class);

    public static List<File> getCssFiles(f f2, File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("_def_ns", "http://www.w3.org/1999/xhtml");
        hashMap.put("epub", "http://www.idpf.org/2007/ops");
        List<f> list = f2.a("//_def_ns:head/_def_ns:link[ends-with(@href, '.css')]", hashMap);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (f f3 : list) {
            String string = f3.c("href", "");
            arrayList.add(new File(file.getParentFile(), string));
        }
        return arrayList;
    }

    public static File retrieveCssFileForRootAndClassNameOrId(String string, f f2, File file) {
        List<File> list = CSSHelper.getCssFiles(f2, file);
        File file2 = null;
        for (File file3 : list) {
            try {
                String string2 = FileHelper.contentsOfFile(file3);
                if (!string2.contains(string)) continue;
                file2 = file3;
            }
            catch (IOException iOException) {
                logger.c("Could not read contents of file: " + file3, iOException);
            }
        }
        return file2;
    }

    public static List<File> retrieveCssFileForRootAndElementName(String string, f f2, File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        List<File> list = CSSHelper.getCssFiles(f2, file);
        for (File file2 : list) {
            try {
                String string2 = FileHelper.contentsOfFile(file2);
                if (!string2.contains(string)) continue;
                arrayList.add(file2);
            }
            catch (IOException iOException) {
                logger.c("Could not read contents of file: " + file2, iOException);
            }
        }
        return arrayList;
    }

    public static String getCssValueForKeyForElement(f f2, f f3, String string, File file, String string2) {
        Object object;
        Object object2;
        List<File> list;
        String string3 = CSSHelper.getInlineCssPropertyValueForKey(string, f2);
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            return string3;
        }
        if (StringUtils.isBlank((CharSequence)string3) && StringUtils.isNotBlank((CharSequence)((Object)(list = f2.c("id", ""))))) {
            object2 = CSSHelper.retrieveCssFileForRootAndClassNameOrId((String)((Object)list), f3, file);
            object = CSSHelper.cssAttributesAsPropertiesForId((String)((Object)list), f2.a(), (File)object2, string2);
            if (object != null) {
                string3 = ((Properties)object).getProperty(string);
            }
        }
        if (StringUtils.isBlank((CharSequence)string3) && StringUtils.isNotBlank((CharSequence)((Object)(list = f2.c("class", ""))))) {
            String[] stringArray = object2 = ((String)((Object)list)).split(" ");
            int n2 = ((String[])object2).length;
            int n3 = 0;
            while (n3 < n2) {
                Properties properties;
                object = stringArray[n3];
                File file2 = CSSHelper.retrieveCssFileForRootAndClassNameOrId((String)object, f3, file);
                if (file2 != null && (properties = CSSHelper.cssAttributesAsPropertiesForClassname((String)object, f2.a(), file2, string2)) != null && StringUtils.isNotBlank((CharSequence)(string3 = properties.getProperty(string)))) break;
                ++n3;
            }
        }
        if (StringUtils.isBlank((CharSequence)string3)) {
            list = CSSHelper.retrieveCssFileForRootAndElementName(f2.a(), f3, file);
            if (list == null || list.isEmpty()) {
                return string3;
            }
            object2 = (File)list.get(list.size() - 1);
            object = CSSHelper.cssAttributesAsPropertiesForElementName(f2.a(), (File)object2, string2);
            if (object == null) {
                return string3;
            }
            string3 = ((Properties)object).getProperty(string);
            if (StringUtils.isNotBlank((CharSequence)string3)) {
                return string3;
            }
        }
        return string3;
    }

    public static String getCssValueForKeyForElement(f f2, String string, CSSWrapper cSSWrapper, String string2) {
        String[] stringArray;
        String string3 = CSSHelper.getInlineCssPropertyValueForKey(string, f2);
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            return string3;
        }
        String string4 = f2.c("id", "");
        if (StringUtils.isNotBlank((CharSequence)string4) && StringUtils.isNotBlank((CharSequence)(string3 = cSSWrapper.valueForIdAndKey(string, string4, f2.a())))) {
            return string3;
        }
        String string5 = f2.c("class", "");
        if (StringUtils.isNotBlank((CharSequence)string5) && StringUtils.isNotBlank((CharSequence)(string3 = cSSWrapper.highestPrioValueForClassNamesAndKey(stringArray = string5.split(" "), f2.a(), string)))) {
            return string3;
        }
        return null;
    }

    private static String getInlineCssPropertyValueForKey(String string, f f2) {
        String string2 = "";
        if (f2.g("style") != null) {
            Properties properties = ConverterUtil.convertStringToProperties(f2.g("style").b(), ";", ":", false);
            string2 = properties.getProperty(string);
        }
        return string2;
    }

    private static Properties cssAttributesAsPropertiesForElementName(String string, File file, String string2) {
        return CSSHelper.cssAttributesAsPropertiesForSelector(string, string, file, string2);
    }

    public static Properties cssAttributesAsPropertiesForClassname(String string, String string2, File file, String string3) {
        String string4 = "." + string;
        return CSSHelper.cssAttributesAsPropertiesForSelector(string4, string2, file, string3);
    }

    public static Properties cssAttributesAsPropertiesForId(String string, String string2, File file, String string3) {
        String string4 = "#" + string;
        return CSSHelper.cssAttributesAsPropertiesForSelector(string4, string2, file, string3);
    }

    public static Properties cssAttributesAsPropertiesForSelector(String string, String string2, File file, String string3) {
        String string4 = "";
        if (file == null) {
            return null;
        }
        try {
            string4 = FileHelper.contentsOfFile(file, string3);
        }
        catch (Exception exception) {
            logger.c("Could not read file as string: '" + file + "'.", exception);
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string4.split("\n")));
        for (String string5 : arrayList) {
            String[] stringArray;
            if (!string5.contains(string)) continue;
            String string6 = StringHelper.extractStringFrom_until(string5, "{");
            String[] stringArray2 = stringArray = string6.split(",");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string7 = stringArray2[n3];
                if ((string7 = StringHelper.trimAll(string7.trim())).equals(string) || string7.equals(String.valueOf(string2) + string)) {
                    String string8 = CSSHelper.cssDeclarationsForSelectorLineAsString(string5, arrayList);
                    return ConverterUtil.convertStringToProperties(string8, ";", ":", false);
                }
                ++n3;
            }
        }
        logger.c("Could not get css attributes as properties for selector '" + string + "' and file '" + file + "'.");
        return null;
    }

    public static String cssDeclarationsForSelectorLineAsString(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n2 = list.indexOf(string);
        while (n2 < list.size()) {
            String string2 = list.get(n2);
            if (!StringUtils.isBlank((CharSequence)string2)) {
                if (string2.contains("{") && !bl) {
                    string2 = StringHelper.extractPostfixAfter(string2, "{");
                    bl = true;
                }
                if (string2.contains("}") && bl) {
                    stringBuilder.append(StringHelper.extractStringFrom_until(string2, "}"));
                    break;
                }
                stringBuilder.append(string2);
            }
            ++n2;
        }
        String string3 = stringBuilder.toString();
        return string3;
    }

    public static String getCssValueForKeyFromElementOrParent(f f2, f f3, String string, File file, String string2) {
        f f4;
        String string3 = CSSHelper.getCssValueForKeyForElement(f2, f3, string, file, string2);
        if (StringUtils.isBlank((CharSequence)string3) && !(f4 = f2.q()).a().equals("body") && StringUtils.isBlank((CharSequence)string3)) {
            string3 = CSSHelper.getCssValueForKeyForElement(f4, f3, string, file, string2);
        }
        return string3;
    }

    public static void replaceIdSelectorInStyleSheet(String string, String string2, f f2, File file, String string3) {
        File file2 = CSSHelper.retrieveCssFileForRootAndClassNameOrId(string, f2, file);
        if (file2 == null) {
            return;
        }
        String string4 = null;
        try {
            string4 = FileHelper.contentsOfFile(file2, string3);
        }
        catch (Exception exception) {
            logger.c("Could not read file as string: '" + file2 + "'.");
        }
        if (string4 != null) {
            String string5 = string4.replaceAll("#" + string + "(\\s|,|\\{)", "#" + string2 + "$1");
            try {
                FileHelper.writeFile(file2, string5);
            }
            catch (IOException iOException) {
                logger.d("Could not write css file: " + file2, iOException);
            }
        }
    }

    public static void replaceIdAddClassForExistingIdAndAddInStylesheet(String string, f f2, f f3, File file, String string2) {
        String string3 = f2.c("id", "");
        if (StringUtils.isBlank((CharSequence)string3)) {
            return;
        }
        f2.h("id");
        CSSHelper.addAttributeValueToAttributeWithName(f2, "class", string3, false);
        File file2 = CSSHelper.retrieveCssFileForRootAndClassNameOrId(string3, f3, file);
        if (file2 == null) {
            logger.a("Did not find css file for class name or id '" + string3 + "'.");
            return;
        }
        String string4 = null;
        try {
            string4 = FileHelper.contentsOfFile(file2, string2);
        }
        catch (Exception exception) {
            logger.c("Could not read file as string: '" + file2 + "'.", exception);
        }
        if (string4 != null) {
            String string5 = string4.replaceAll("(#" + string3 + ")(\\s|,|\\{)", "$1, " + f2.a() + "#" + string + "." + string3 + "$2");
            try {
                FileHelper.writeFile(file2, string5);
            }
            catch (IOException iOException) {
                logger.d("Could not write css file: " + file2, iOException);
            }
        }
    }

    public static Properties getAttributesAsProperties(List<b> list) {
        Properties properties = new Properties();
        for (b b2 : list) {
            properties.setProperty(b2.a(), b2.b());
        }
        return properties;
    }

    public static void addAttributeValueToAttributeWithName(f f2, String string, String string2, Boolean bl) {
        if (f2.g(string) == null) {
            if (!string2.endsWith(";") && bl.booleanValue()) {
                string2 = String.valueOf(string2) + ";";
            }
            b b2 = new b(string, string2);
            f2.a(b2);
        } else {
            b b3 = f2.g(string);
            CSSHelper.addAttributeValue(b3, string2, bl);
        }
    }

    public static void addStyleAttributeValue(f f2, String string) {
        CSSHelper.addAttributeValueToAttributeWithName(f2, "style", string, true);
    }

    public static void addCSSClassName(f f2, String string) {
        CSSHelper.addAttributeValueToAttributeWithName(f2, "class", string, false);
    }

    public static void addAttributeValue(b b2, String string, Boolean bl) {
        if (b2 != null && !b2.b().isEmpty() && !b2.b().endsWith(" ")) {
            b2.a(String.valueOf(b2.b()) + " ");
        }
        if (bl.booleanValue() && !string.endsWith(";")) {
            string = String.valueOf(string) + ";";
        }
        b2.a(String.valueOf(b2.b()) + string);
    }

    public static void addAdditionalSelectorToAllDeclarationsInFile(File file, String string) {
        String string2 = null;
        try {
            string2 = FileHelper.contentsOfFile(file);
        }
        catch (IOException iOException) {
            logger.d("Could not read file as string: '" + file + "'. Not adding additional selector.", iOException);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string2.split("\n")));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : arrayList) {
            if (string3.contains("{")) {
                String string4;
                String string5 = StringHelper.extractStringFrom_until(string3, "{");
                String[] stringArray = string5.split(",");
                StringBuilder stringBuilder2 = new StringBuilder();
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    string4 = stringArray2[n3];
                    String string6 = String.valueOf(string) + " " + string4;
                    if (string4.startsWith("@font-face")) {
                        string6 = string4;
                    }
                    stringBuilder2.append(string6);
                    ++n3;
                }
                string4 = string3.replace(string5, stringBuilder2.toString());
                stringBuilder.append(String.valueOf(string4) + "\n");
                continue;
            }
            stringBuilder.append(String.valueOf(string3) + "\n");
        }
        try {
            FileHelper.writeFile(file, stringBuilder.toString());
        }
        catch (IOException iOException) {
            logger.d("Could not write css File after adding additional selector. File: " + file, iOException);
        }
    }
}

