/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.scenario;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.ex.h;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.au.c;
import ch.ionesoft.ilp.book.co.ILPBookHelper;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAbstractProduct;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPIssueProduct;
import ch.ionesoft.ilp.book.mo.ILPQuestion;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPScenario;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPScenarioElementResult;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.mo.ILPTransientAnswer;
import ch.ionesoft.ilp.book.mo.SharingModel;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask;
import ch.ionesoft.ilp.book.scenario.a;
import ch.ionesoft.ilp.book.scenario.b;
import ch.ionesoft.ilp.book.scenario.c;
import ch.ionesoft.ilp.book.scenario.f;
import ch.ionesoft.ilp.book.scenario.g;
import ch.ionesoft.ilp.book.scenario.m;
import ch.ionesoft.ilp.book.scenario.n;
import ch.ionesoft.ilp.book.scenario.q;
import ch.ionesoft.ilp.book.scenario.r;
import ch.ionesoft.ilp.book.scenario.s;
import ch.ionesoft.ilp.book.scenario.t;
import ch.ionesoft.ilp.book.syn.ex.j;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.joda.time.DateTime;
import org.json.ionesoft.i;
import org.yaml.snakeyaml.Yaml;

public class ILPScenarioManager {
    private static ILogger logger = ILPLogManager.getLogger(ILPScenarioManager.class);
    private static ILPScenarioManager instance = null;
    private ILPScenario currentScenario;
    private ILPScenarioDefinition currentEditingScenarioDef;
    private ILPScenarioElementResult activeElementResult;
    private b playConfig;

    private ILPScenarioManager() {
        this.initializeScenarioManager();
    }

    public static synchronized ILPScenarioManager getInstance() {
        if (instance == null) {
            instance = new ILPScenarioManager();
        }
        return instance;
    }

    public static void reset() {
        if (instance != null) {
            instance.setCurrentScenario(null);
            instance.setCurrentEditingScenarioDef(null);
            instance.setActiveElementResult(null);
            instance.setPlayConfiguration(null);
            instance.initializeScenarioManager();
        }
    }

    private void initializeScenarioManager() {
        this.fetchEditingScenarioDef();
        this.fetchCurrentScenario();
        this.fetchActiveElementResult();
    }

    private void fetchCurrentScenario() {
        this.setCurrentScenario(ch.ionesoft.ilp.book.pe.f.a().g(true));
    }

    private void fetchEditingScenarioDef() {
        this.setCurrentEditingScenarioDef(ch.ionesoft.ilp.book.pe.f.a().h(true));
    }

    private void fetchActiveElementResult() {
        if (this.getCurrentScenario() != null) {
            this.setActiveElementResult(ch.ionesoft.ilp.book.pe.f.a().a(this.getCurrentScenario()));
        }
    }

    private void fetchFirstIncorrectElementResultAsActiveElement() {
        this.setActiveElementResult(ch.ionesoft.ilp.book.pe.f.a().e(this.getCurrentScenario(), 0));
    }

    private void fetchFirstElementResultAsActiveElement() {
        this.setActiveElementResult(ch.ionesoft.ilp.book.pe.f.a().c(this.getCurrentScenario(), 1));
    }

    public void setCurrentEditingScenarioDef(ILPScenarioDefinition iLPScenarioDefinition) {
        this.currentEditingScenarioDef = iLPScenarioDefinition;
    }

    public ILPScenarioDefinition getCurrentEditingScenarioDef() {
        return this.currentEditingScenarioDef;
    }

    public void setCurrentScenario(ILPScenario iLPScenario) {
        this.currentScenario = iLPScenario;
    }

    public ILPScenario getCurrentScenario() {
        return this.currentScenario;
    }

    public void setActiveElementResult(ILPScenarioElementResult iLPScenarioElementResult) {
        this.activeElementResult = iLPScenarioElementResult;
    }

    public ILPScenarioElementResult getActiveElementResult() {
        return this.activeElementResult;
    }

    public boolean hasEditingScenario() {
        return this.getCurrentEditingScenarioDef() != null;
    }

    public boolean hasActiveElementResult() {
        return this.getActiveElementResult() != null;
    }

    public List<ILPScenario> getRunningETests() {
        try {
            return ch.ionesoft.ilp.book.pe.f.a().a(ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_ETEST, ILPScenario.ScenarioStatus.SCENARIO_STATUS_RUNNING);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not get running eTests", (Throwable)exception);
            return new ArrayList<ILPScenario>();
        }
    }

    private void resetCurrentScenario() throws SQLException {
        ch.ionesoft.ilp.book.pe.f.a().an();
        this.setCurrentScenario(null);
    }

    private void resetEditingScenarioDef() throws SQLException {
        ch.ionesoft.ilp.book.pe.f.a().ao();
        this.setCurrentEditingScenarioDef(null);
    }

    public void setScenarioDefAsEditing(ILPScenarioDefinition iLPScenarioDefinition) throws SQLException {
        this.resetEditingScenarioDef();
        iLPScenarioDefinition.setEditing(true);
        iLPScenarioDefinition.touchAndStore();
        this.fetchEditingScenarioDef();
    }

    public void setScenarioAsCurrent(ILPScenario iLPScenario) throws SQLException {
        this.resetCurrentScenario();
        iLPScenario.setCurrent(true);
        ch.ionesoft.ilp.book.pe.g.a().aN().update((Object)iLPScenario);
        this.fetchCurrentScenario();
    }

    public String createScenarioIdForTaskScenario(ILPScenarioSpecification iLPScenarioSpecification) {
        return String.format("%s_%s", iLPScenarioSpecification.getId(), "1");
    }

    public String getAbbreviatedTitleOfEditingScenarioDef(int n2) {
        return StringUtils.abbreviate((String)this.getTitleOfEditingScenarioDef(), (int)n2);
    }

    public String getTitleOfEditingScenarioDef() {
        block3: {
            try {
                if (this.hasEditingScenario()) break block3;
                return "";
            }
            catch (Exception exception) {
                logger.d((Object)("Could not get title of editing scenarioDef: " + this.currentEditingScenarioDef), (Throwable)exception);
                return "";
            }
        }
        return this.getCurrentEditingScenarioDef().getName();
    }

    public boolean hasScenarioDefReferencedElements(ILPScenarioDefinition iLPScenarioDefinition) {
        block3: {
            try {
                if (iLPScenarioDefinition != null) break block3;
                return false;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not check if scenarioDef has elements. scenarioDef: " + iLPScenarioDefinition), (Throwable)exception);
                return false;
            }
        }
        List<ILPScenarioElement> list = iLPScenarioDefinition.getScenarioElementsNotDeleted();
        return list != null && !list.isEmpty();
    }

    public List<ILPScenarioDefinition> getStaticDefinitionsWithModelContent(ILPScenarioDefinition.ScenarioModelContent scenarioModelContent) {
        try {
            List<ILPScenarioSpecification> list = ch.ionesoft.ilp.book.pe.f.a().ab();
            ArrayList<ILPScenarioDefinition> arrayList = new ArrayList<ILPScenarioDefinition>();
            if (CollectionUtils.isEmpty(list)) {
                return arrayList;
            }
            for (ILPScenarioSpecification iLPScenarioSpecification : list) {
                try {
                    ILPScenarioDefinition iLPScenarioDefinition;
                    if (iLPScenarioSpecification == null || iLPScenarioSpecification.getSharingTypeEnum() == SharingModel.SharingType.SHARING_TYPE_RECEIVED || (iLPScenarioDefinition = iLPScenarioSpecification.getScenarioDefinition()) == null || !iLPScenarioDefinition.isAllowedToAddElementsWithModelContent(scenarioModelContent)) continue;
                    arrayList.add(iLPScenarioDefinition);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not check if specification is allowed to modelContent: " + (Object)((Object)scenarioModelContent)), (Throwable)exception);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get static definition with modelContent: " + (Object)((Object)scenarioModelContent)), (Throwable)exception);
            return new ArrayList<ILPScenarioDefinition>();
        }
    }

    public boolean staticScenarioDefWithModelContentExists(ILPScenarioDefinition.ScenarioModelContent scenarioModelContent) {
        List<ILPScenarioDefinition> list = ILPScenarioManager.getInstance().getStaticDefinitionsWithModelContent(scenarioModelContent);
        return !CollectionUtils.isEmpty(list);
    }

    public void addModelsArrayToScenarioDef(Integer n2, Object[] objectArray) {
        try {
            if (n2 == null) {
                throw new n("Could not add models to scenarioDef. DefinitonPk is null");
            }
            ILPScenarioDefinition iLPScenarioDefinition = ch.ionesoft.ilp.book.pe.f.a().q(n2);
            this.addModelsArrayToScenarioDef(iLPScenarioDefinition, objectArray);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not add models to definition with pk: " + n2 + ". models: " + ArrayUtils.toString((Object)objectArray)), (Throwable)exception);
            ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.scenario.addModels.error", new Object[0]);
        }
    }

    public void addModelsArrayToScenarioDef(ILPScenarioDefinition iLPScenarioDefinition, Object[] objectArray) {
        try {
            if (objectArray == null) {
                throw new n("Could not add models to scenarioDef. models are null");
            }
            int n2 = objectArray.length;
            logger.b((Object)("Adding " + n2 + " element(s) to editing scenario definition"));
            if (iLPScenarioDefinition == null) {
                throw new n("Could not add models to scenarioDef. scenarioDef is null");
            }
            Integer n3 = ch.ionesoft.ilp.book.pe.f.a().c(iLPScenarioDefinition);
            ArrayList<ILPScenarioElement> arrayList = new ArrayList<ILPScenarioElement>();
            this.createScenarioElementListFromModels(objectArray, iLPScenarioDefinition, n3, arrayList);
            if (CollectionUtils.isNotEmpty(arrayList)) {
                ch.ionesoft.ilp.book.pe.g.a().aP().create(arrayList);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.scenario.addModels.success", new Object[]{arrayList.size(), iLPScenarioDefinition.getName()});
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not add models to scenarioDefinition: " + iLPScenarioDefinition + ". models: " + objectArray), (Throwable)exception);
            ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.scenario.addModels.error", new Object[0]);
        }
    }

    private int createScenarioElementListFromModels(Object[] objectArray, ILPScenarioDefinition iLPScenarioDefinition, int n2, List<ILPScenarioElement> list) {
        int n3 = 0;
        while (n3 < objectArray.length) {
            Object object = objectArray[n3];
            try {
                if (this.isModelAllowedForScenario(object)) {
                    boolean bl2 = false;
                    if (CollectionUtils.isEmpty(list)) {
                        ILPScenarioElement iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().a(iLPScenarioDefinition);
                        if (iLPScenarioElement != null && iLPScenarioElement.getModel().equals(object)) {
                            bl2 = true;
                        }
                    } else if (list.size() > 0 && list.get(list.size() - 1).equals(object)) {
                        bl2 = true;
                    }
                    if (bl2) {
                        ch.ionesoft.ilp.base.co.f.b().D().displayWarning(o.a().d("message.scenario.addModels.alreadyExists"));
                    } else {
                        Object object2;
                        boolean bl3 = object instanceof ILPTopic;
                        if (bl3 && ((ILPTopic)(object2 = (ILPTopic)object)).isUserTopic().booleanValue() && ((ILPTopic)object2).getTopicType() == ILPTopic.TopicType.TOPIC_TYPE_LINK) {
                            ch.ionesoft.ilp.base.co.f.b().D().displayWarning(o.a().d("message.scenario.addModels.userTopicLink"));
                        } else {
                            list.add(this.createScenarioElement(object, n2, iLPScenarioDefinition));
                            ++n2;
                            if (bl3 && CollectionUtils.isNotEmpty((Collection)(object2 = ch.ionesoft.ilp.book.pe.f.a().c((ILPTopic)object)))) {
                                logger.b((Object)("Adding " + object2.size() + " hidden topic(s) as scenarioElements from parentTopic: " + (ILPTopic)object));
                                n2 = this.createScenarioElementListFromModels(object2.toArray(), iLPScenarioDefinition, n2, list);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.d((Object)"Could not add model as element to scenarioDef", (Throwable)exception);
            }
            ++n3;
        }
        return n2;
    }

    private boolean isModelAllowedForScenario(Object object) {
        return object instanceof ILPTopic || object instanceof ILPExercise || object instanceof ILPResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDynamicDefinition(final String string, final String string2, final boolean bl2, final String string3, final String string4, final boolean bl3, final List<ILPExercise> list, String string5) throws n {
        try {
            logger.b((Object)"Creating dynamic scenario definition");
            final ILPScenarioDefinition iLPScenarioDefinition = new ILPScenarioDefinition();
            iLPScenarioDefinition.setType(ILPScenarioDefinition.ScenarioType.SCENARIO_TYPE_DYNAMIC);
            iLPScenarioDefinition.addModelContent(ILPScenarioDefinition.ScenarioModelContent.SCENARIO_MODELCONTENT_EXERCISE);
            iLPScenarioDefinition.setRule(string5);
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ILPScenarioManager.this.createNewDefinition(iLPScenarioDefinition, string, string2, bl2, string3, string4, bl3, true);
                            ILPScenarioManager.this.createScenarioElementsForDynamicDefinition(iLPScenarioDefinition, list);
                            ILPScenarioManager.this.setScenarioDefAsEditing(iLPScenarioDefinition);
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not create dynamic definition in db", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            String string6 = String.format(Locale.ENGLISH, "Could not create dynamic scenario definition with provided attributes. name %s. description %s. playModeChangeable %b. duration %f. playMode %s", string, string2, bl2, string3, string4);
            this.fetchEditingScenarioDef();
            throw new n(string6, exception);
        }
    }

    private void createScenarioElementsForDynamicDefinition(ILPScenarioDefinition iLPScenarioDefinition, List<ILPExercise> list) throws SQLException {
        int n2 = 1;
        ArrayList<ILPScenarioElement> arrayList = new ArrayList<ILPScenarioElement>();
        for (ILPExercise iLPExercise : list) {
            arrayList.add(this.createScenarioElement(iLPExercise, n2, iLPScenarioDefinition));
            ++n2;
        }
        ch.ionesoft.ilp.book.pe.g.a().aP().create(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDynamicScenario(final ILPScenarioDefinition iLPScenarioDefinition, final String string, final String string2, final boolean bl2, final String string3, final String string4, final boolean bl3, final List<ILPExercise> list, final String string5) throws n {
        try {
            if (iLPScenarioDefinition == null) {
                throw new n("Could not update dynamic scenarioDef. given scenarioDef is null");
            }
            logger.b((Object)("Update dynamic scenario definition: " + iLPScenarioDefinition));
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ch.ionesoft.ilp.book.pe.f.a().e(iLPScenarioDefinition);
                            ch.ionesoft.ilp.book.pe.g.a().aO().refresh((Object)iLPScenarioDefinition);
                            ILPScenarioManager.this.updateDefinition(iLPScenarioDefinition, string, string2, bl2, string3, string4, bl3, string5, true);
                            ILPScenarioManager.this.createScenarioElementsForDynamicDefinitionAndRebuildDependentRelations(iLPScenarioDefinition, list);
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not update definition and elements in db", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            String string6 = "Could not update dynamic scenarioDefinition: " + iLPScenarioDefinition + ". with name: " + string + ". description: " + string2 + ". playMode: " + string4 + ". elements: " + ArrayUtils.toString(list);
            throw new n(string6, exception);
        }
    }

    public void updateDynamicScenarioExercises(ILPScenarioDefinition iLPScenarioDefinition, List<ILPExercise> list) throws n {
        try {
            if (iLPScenarioDefinition == null) {
                throw new n("Could not update exercises of dynamic scenarioDef. given scenarioDef is null");
            }
            this.updateDynamicScenario(iLPScenarioDefinition, iLPScenarioDefinition.getName(), iLPScenarioDefinition.getDescription(), iLPScenarioDefinition.isPlayModeChangeable(), iLPScenarioDefinition.hasMaxDuration() ? String.valueOf(iLPScenarioDefinition.getMaxDuration().floatValue() / 60.0f) : null, String.valueOf(iLPScenarioDefinition.getPlayMode().getCode()), iLPScenarioDefinition.isAnnotatable(), list, iLPScenarioDefinition.getRule());
        }
        catch (Exception exception) {
            String string = "Could not update exercises of dynamic scenarioDefinition: " + iLPScenarioDefinition;
            throw new n(string, exception);
        }
    }

    public void buildDynamicScenarioElements(ILPScenarioSpecification iLPScenarioSpecification) {
        try {
            if (!iLPScenarioSpecification.isLoaded()) {
                return;
            }
            ILPScenarioDefinition iLPScenarioDefinition = iLPScenarioSpecification.getScenarioDefinition();
            ch.ionesoft.ilp.book.search.f f2 = new ch.ionesoft.ilp.book.search.f();
            f2.a(iLPScenarioDefinition.getRule());
            List<ILPExercise> list = ch.ionesoft.ilp.book.pe.f.a().b(f2);
            if (list == null || list.isEmpty()) {
                return;
            }
            ILPScenarioManager.getInstance().createScenarioElementsForDynamicDefinitionAndRebuildDependentRelations(iLPScenarioDefinition, list);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not buily dynamic scenario elements for scenarioSpecification: " + iLPScenarioSpecification));
        }
    }

    public void createScenarioElementsForDynamicDefinitionAndRebuildDependentRelations(ILPScenarioDefinition iLPScenarioDefinition, List<ILPExercise> list) throws SQLException {
        this.createScenarioElementsForDynamicDefinition(iLPScenarioDefinition, list);
        ch.ionesoft.ilp.book.pe.g.a().aO().refresh((Object)iLPScenarioDefinition);
        this.rebuildDependentRelation(iLPScenarioDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStaticDefinition(final String string, final String string2, final boolean bl2, final String string3, final String string4, final boolean bl3, final boolean bl4) throws n {
        try {
            logger.b((Object)("Creating static scenario definition. name: " + string + ". playMode: " + string4 + ". annotatable: " + bl3));
            final ILPScenarioDefinition iLPScenarioDefinition = new ILPScenarioDefinition();
            iLPScenarioDefinition.setType(ILPScenarioDefinition.ScenarioType.SCENARIO_TYPE_STATIC);
            iLPScenarioDefinition.addModelContent(ILPScenarioDefinition.ScenarioModelContent.SCENARIO_MODELCONTENT_UNDEFINED);
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ILPScenarioManager.this.createNewDefinition(iLPScenarioDefinition, string, string2, bl2, string3, string4, bl3, bl4);
                            ILPScenarioManager.this.setScenarioDefAsEditing(iLPScenarioDefinition);
                        }
                        catch (Exception exception) {
                            logger.d((Object)("Could not create scenario: " + iLPScenarioDefinition), (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            String string5 = String.format(Locale.ENGLISH, "Could not create static scenario definition with provided attributes. name %s. description %s. playModeChangeable %b. duration %s. playMode %s", string, string2, bl2, string3, string4);
            this.fetchEditingScenarioDef();
            throw new n(string5, exception);
        }
    }

    private void createNewDefinition(ILPScenarioDefinition iLPScenarioDefinition, String string, String string2, boolean bl2, String string3, String string4, boolean bl3, boolean bl4) throws Exception {
        iLPScenarioDefinition.setPlayMode(ILPScenarioDefinition.ScenarioPlayMode.get(string4));
        iLPScenarioDefinition.setPlayModeChangeable(bl2);
        iLPScenarioDefinition.setMaxDuration(this.convertDurationFromString(string3));
        iLPScenarioDefinition.setActive(true);
        iLPScenarioDefinition.setEditing(false);
        iLPScenarioDefinition.setAnnotatable(bl3);
        iLPScenarioDefinition.setLoadSaveAnswersOnScenario(bl4);
        if (!this.validateScenarioDefinition(iLPScenarioDefinition)) {
            throw new n("ScenarioDefinition Validation failed. scenarioDef: " + iLPScenarioDefinition);
        }
        iLPScenarioDefinition.touchAndStore();
        ILPScenarioSpecification iLPScenarioSpecification = new ILPScenarioSpecification();
        iLPScenarioSpecification.setName(string);
        iLPScenarioSpecification.setDescription(string2);
        iLPScenarioSpecification.setSpecificationVersionLegacy();
        iLPScenarioSpecification.setScenarioDefinition(iLPScenarioDefinition);
        iLPScenarioSpecification.setCreationDate(DateTime.now());
        ch.ionesoft.ilp.book.pe.g.a().aM().create((Object)iLPScenarioSpecification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefinitionAndElements(final ILPScenarioDefinition iLPScenarioDefinition, final String string, final String string2, final boolean bl2, final String string3, final String string4, final boolean bl3, final List<Integer> list, final Integer n2, final Integer n3, final String string5, final boolean bl4) throws n {
        try {
            if (iLPScenarioDefinition == null) {
                throw new n("Could not update scenarioDef. given scenarioDef is null");
            }
            logger.b((Object)("Update scenario definition: " + iLPScenarioDefinition));
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ILPScenarioManager.this.updateDefinition(iLPScenarioDefinition, string, string2, bl2, string3, string4, bl3, string5, bl4);
                            ILPScenarioManager.this.updateDefinitionProlog(iLPScenarioDefinition, n2);
                            ILPScenarioManager.this.updateDefinitionEpilog(iLPScenarioDefinition, n3);
                            ILPScenarioManager.this.updateDefinitionElements(iLPScenarioDefinition, list);
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not update definition and elements in db", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            String string6 = "Could not update scenarioDefinition: " + iLPScenarioDefinition + ". with name: " + string + ". description: " + string2 + ". playMode: " + string4 + ". elements: " + ArrayUtils.toString(list);
            throw new n(string6, exception);
        }
    }

    public void updateDefinitionAndElements(ILPScenarioDefinition iLPScenarioDefinition, String string2, String string3, boolean bl2, String string4, String string5, boolean bl3, String[] stringArray, String string6, String string7, String string8, boolean bl4) throws n {
        List<Integer> list = Arrays.asList(stringArray).stream().filter(string -> string != null && !string.isEmpty()).map(Integer::parseInt).collect(Collectors.toList());
        this.updateDefinitionAndElements(iLPScenarioDefinition, string2, string3, bl2, string4, string5, bl3, list, StringUtils.isBlank((CharSequence)string6) ? null : Integer.valueOf(string6), StringUtils.isBlank((CharSequence)string7) ? null : Integer.valueOf(string7), string8, bl4);
    }

    private void updateDefinition(ILPScenarioDefinition iLPScenarioDefinition, String string, String string2, boolean bl2, String string3, String string4, boolean bl3, String string5, boolean bl4) throws Exception {
        iLPScenarioDefinition.setPlayMode(ILPScenarioDefinition.ScenarioPlayMode.get(string4));
        iLPScenarioDefinition.setPlayModeChangeable(bl2);
        iLPScenarioDefinition.setMaxDuration(this.convertDurationFromString(string3));
        iLPScenarioDefinition.setAnnotatable(bl3);
        iLPScenarioDefinition.setRule(string5);
        iLPScenarioDefinition.setLoadSaveAnswersOnScenario(bl4);
        if (!this.validateScenarioDefinition(iLPScenarioDefinition)) {
            throw new Exception("ScenarioDefinition Validation failed. scenarioDef: " + iLPScenarioDefinition);
        }
        iLPScenarioDefinition.touchAndStore();
        ch.ionesoft.ilp.book.pe.g.a().aO().refresh((Object)iLPScenarioDefinition);
        ILPScenarioSpecification iLPScenarioSpecification = iLPScenarioDefinition.getScenarioSpecification();
        iLPScenarioSpecification.setName(string);
        iLPScenarioSpecification.setDescription(string2);
        iLPScenarioSpecification.touchAndStore();
    }

    private void updateDefinitionProlog(ILPScenarioDefinition iLPScenarioDefinition, Integer n2) {
        try {
            ILPScenarioElement iLPScenarioElement;
            ILPScenarioElement iLPScenarioElement2 = iLPScenarioDefinition.getProlog();
            if (iLPScenarioElement2 != null && (n2 == null || iLPScenarioElement2.getPk() != n2.intValue())) {
                iLPScenarioElement2.setDeleted(false);
                iLPScenarioElement2.setType(ILPScenarioElement.ScenarioElementType.SCENARIO_ELEMENT_TYPE_MODEL);
                ch.ionesoft.ilp.book.pe.g.a().aP().update((Object)iLPScenarioElement2);
            }
            if (n2 != null && (iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().s(n2)).hasTopic()) {
                iLPScenarioElement.setType(ILPScenarioElement.ScenarioElementType.SCENARIO_ELEMENT_TYPE_PROLOG);
                ch.ionesoft.ilp.book.pe.g.a().aP().update((Object)iLPScenarioElement);
            }
            ch.ionesoft.ilp.book.pe.g.a().aO().refresh((Object)iLPScenarioDefinition);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not update definition prolog", (Throwable)exception);
        }
    }

    private void updateDefinitionEpilog(ILPScenarioDefinition iLPScenarioDefinition, Integer n2) {
        try {
            ILPScenarioElement iLPScenarioElement;
            ILPScenarioElement iLPScenarioElement2 = iLPScenarioDefinition.getEpilog();
            if (iLPScenarioElement2 != null && (n2 == null || iLPScenarioElement2.getPk() != n2.intValue())) {
                iLPScenarioElement2.setDeleted(false);
                iLPScenarioElement2.setType(ILPScenarioElement.ScenarioElementType.SCENARIO_ELEMENT_TYPE_MODEL);
                ch.ionesoft.ilp.book.pe.g.a().aP().update((Object)iLPScenarioElement2);
            }
            if (n2 != null && (iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().s(n2)).hasTopic()) {
                iLPScenarioElement.setType(ILPScenarioElement.ScenarioElementType.SCENARIO_ELEMENT_TYPE_EPILOG);
                ch.ionesoft.ilp.book.pe.g.a().aP().update((Object)iLPScenarioElement);
            }
            ch.ionesoft.ilp.book.pe.g.a().aO().refresh((Object)iLPScenarioDefinition);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not update definition prolog", (Throwable)exception);
        }
    }

    private void updateDefinitionElements(ILPScenarioDefinition iLPScenarioDefinition, List<Integer> list) throws SQLException {
        for (ILPScenarioElement iLPScenarioElement : iLPScenarioDefinition.getScenarioElementsNotDeleted()) {
            int n2 = list.indexOf(iLPScenarioElement.getPk());
            if (n2 != -1) {
                iLPScenarioElement.setOrder(n2 + 1);
                ch.ionesoft.ilp.book.pe.g.a().aP().update((Object)iLPScenarioElement);
                continue;
            }
            this.deleteScenarioElement(iLPScenarioElement);
        }
        iLPScenarioDefinition.touchAndStore();
        this.rebuildDependentRelation(iLPScenarioDefinition);
    }

    public void rebuildDependentRelation(ILPScenarioDefinition iLPScenarioDefinition) {
        if (iLPScenarioDefinition == null) {
            return;
        }
        ch.ionesoft.ilp.book.pe.f.a().f(iLPScenarioDefinition);
        for (ILPCourseDef iLPCourseDef : iLPScenarioDefinition.getRelatedCoursesOfElements()) {
            try {
                iLPScenarioDefinition.addCourseObject(iLPCourseDef);
            }
            catch (SQLException sQLException) {
                logger.d((Object)("Could not create relation between course: " + iLPCourseDef + " and scenarioDef: " + iLPScenarioDefinition), (Throwable)sQLException);
            }
        }
        if (iLPScenarioDefinition.getScenarioSpecification().getVersion() == 1) {
            iLPScenarioDefinition.touchAndStore();
        } else {
            iLPScenarioDefinition.store();
        }
    }

    private Float convertDurationFromString(String string) {
        Float f2 = Float.valueOf(0.0f);
        if (StringUtils.isNotEmpty((CharSequence)string) && NumberUtils.isParsable((String)string)) {
            f2 = Float.valueOf(this.getDurationFromUserInput(Float.valueOf(string).floatValue()));
        }
        return f2;
    }

    public float getDurationFromUserInput(float f2) {
        return Math.max(0.0f, f2 * 60.0f);
    }

    public String getDurationForUserOutput(float f2, boolean bl2) {
        int n2 = Math.round(f2 / 60.0f);
        if (!bl2 && n2 == 0) {
            return "<1";
        }
        return ConverterUtil.convertNumberToString_defaultValue((Number)n2, (String)"");
    }

    private boolean validateScenarioDefinition(ILPScenarioDefinition iLPScenarioDefinition) {
        return true;
    }

    public void deleteScenarioElement(ILPScenarioElement iLPScenarioElement) {
        try {
            iLPScenarioElement.setDeleted(true);
            ch.ionesoft.ilp.book.pe.g.a().aP().update((Object)iLPScenarioElement);
            iLPScenarioElement.getScenarioDefinition().touchAndStore();
            logger.b((Object)("Successfully set deleted flag on scenarioElement: " + iLPScenarioElement));
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not delete scenarioElement: " + iLPScenarioElement));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteScenarioDefinitionFromDatabase(final ILPScenarioDefinition iLPScenarioDefinition) throws n {
        try {
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            List<ILPScenario> list = ch.ionesoft.ilp.book.pe.f.a().b(iLPScenarioDefinition);
                            if (list != null && !list.isEmpty()) {
                                ch.ionesoft.ilp.book.pe.f.a().i(list);
                                try {
                                    ch.ionesoft.ilp.book.pe.g.a().aN().delete(list);
                                }
                                catch (Exception exception) {
                                    logger.d((Object)"Could not delete scenarios", (Throwable)exception);
                                }
                            }
                            ch.ionesoft.ilp.book.pe.f.a().e(iLPScenarioDefinition);
                            ch.ionesoft.ilp.book.pe.g.a().aO().delete((Object)iLPScenarioDefinition);
                            ILPScenarioManager.this.fetchEditingScenarioDef();
                            ILPScenarioSpecification iLPScenarioSpecification = iLPScenarioDefinition.getScenarioSpecification();
                            iLPScenarioSpecification.setScenarioDefinition(null);
                            ch.ionesoft.ilp.book.pe.g.a().aM().update((Object)iLPScenarioSpecification);
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not delete scenarioDef with relations in db", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not delete scenarioDef " + iLPScenarioDefinition + " from database. "), (Throwable)sQLException);
        }
    }

    public void deleteScenarioDefinitionWithReferences(ILPScenarioDefinition iLPScenarioDefinition) throws n {
        try {
            if (iLPScenarioDefinition == null) {
                return;
            }
            ILPScenarioSpecification iLPScenarioSpecification = iLPScenarioDefinition.getScenarioSpecification();
            if (iLPScenarioSpecification == null) {
                return;
            }
            this.deleteScenarioDefinitionFromDatabase(iLPScenarioDefinition);
            logger.b((Object)("Successfully set deleted flag on scenarioSpecification to deleted: " + iLPScenarioSpecification));
        }
        catch (Exception exception) {
            this.fetchEditingScenarioDef();
            throw new n("Could not delete scenarioDef: " + iLPScenarioDefinition, exception);
        }
    }

    public void createScenarioFromDefinition(ILPScenarioDefinition iLPScenarioDefinition, ILPScenarioDefinition.ScenarioPlayMode scenarioPlayMode, boolean bl2) throws n {
        this.createScenarioFromDefinition(iLPScenarioDefinition, scenarioPlayMode, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createScenarioFromDefinition(final ILPScenarioDefinition iLPScenarioDefinition, final ILPScenarioDefinition.ScenarioPlayMode scenarioPlayMode, final boolean bl2, final String string) throws n {
        try {
            logger.b((Object)"Create and starting scenario from definition");
            if (iLPScenarioDefinition == null) {
                throw new n("Could not create scenario from definition. defintion is null");
            }
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ILPScenario iLPScenario = ILPScenarioManager.this.createScenario(iLPScenarioDefinition, scenarioPlayMode, string);
                            ch.ionesoft.ilp.book.pe.f.a().i(Arrays.asList(iLPScenario));
                            ILPScenarioManager.this.createScenarioElementResults(iLPScenarioDefinition, iLPScenario, bl2);
                            ILPScenarioManager.this.setScenarioAsCurrent(iLPScenario);
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not create scenario in db", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            this.fetchCurrentScenario();
            String string2 = "Could not create scenario from scenario definition: " + iLPScenarioDefinition + ". with playMode: " + (Object)((Object)scenarioPlayMode);
            throw new n(string2, exception);
        }
    }

    private ILPScenario createScenario(ILPScenarioDefinition iLPScenarioDefinition, ILPScenarioDefinition.ScenarioPlayMode scenarioPlayMode, String string) throws SQLException {
        ILPScenario iLPScenario = new ILPScenario();
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            iLPScenario.setId(string);
        }
        iLPScenario.setScenarioDefinition(iLPScenarioDefinition);
        iLPScenario.setName(iLPScenarioDefinition.getName());
        iLPScenario.setCreationDate(new Date());
        iLPScenario.setStartDate(new Date());
        iLPScenario.setDuration(iLPScenarioDefinition.getMaxDuration());
        iLPScenario.setCurrent(false);
        iLPScenario.setStatus(ILPScenario.ScenarioStatus.SCENARIO_STATUS_CREATED);
        iLPScenario.setProlog(iLPScenarioDefinition.getProlog());
        iLPScenario.setEpilog(iLPScenarioDefinition.getEpilog());
        iLPScenario.setLoadSaveAnswersOnScenario(iLPScenarioDefinition.isLoadSaveAnswersOnScenario());
        if (iLPScenarioDefinition.isPlayModeChangeable() && scenarioPlayMode != ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_UNDEFINED) {
            iLPScenario.setPlayMode(scenarioPlayMode);
        } else if (iLPScenarioDefinition.getPlayMode() != ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_FREE_CHOICE) {
            iLPScenario.setPlayMode(iLPScenarioDefinition.getPlayMode());
        } else {
            iLPScenario.setPlayMode(ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_EDITONLY);
        }
        ch.ionesoft.ilp.book.pe.g.a().aN().create((Object)iLPScenario);
        ch.ionesoft.ilp.book.pe.g.a().aN().refresh((Object)iLPScenario);
        iLPScenarioDefinition.touchAndStore();
        return iLPScenario;
    }

    private void createScenarioElementResults(ILPScenarioDefinition iLPScenarioDefinition, ILPScenario iLPScenario, boolean bl2) throws SQLException {
        boolean bl3 = true;
        int n2 = 1;
        ArrayList<ILPScenarioElementResult> arrayList = new ArrayList<ILPScenarioElementResult>();
        List<ILPScenarioElement> list = iLPScenarioDefinition.getScenarioElementsNotDeleted();
        if (bl2) {
            Collections.shuffle(list);
        }
        for (ILPScenarioElement iLPScenarioElement : list) {
            try {
                ILPScenarioElementResult iLPScenarioElementResult = new ILPScenarioElementResult();
                iLPScenarioElementResult.setOrder(n2);
                iLPScenarioElementResult.setScenario(iLPScenario);
                iLPScenarioElementResult.setScenarioElement(iLPScenarioElement);
                iLPScenarioElementResult.setProcessed(false);
                if (bl3) {
                    iLPScenarioElementResult.setCurrent(true);
                    bl3 = false;
                }
                arrayList.add(iLPScenarioElementResult);
                ++n2;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not create ILPScenarioElementResult from ILPScenarioElement: " + iLPScenarioElement), (Throwable)exception);
            }
        }
        ch.ionesoft.ilp.book.pe.g.a().aQ().create(arrayList);
    }

    public ILPScenarioElement createScenarioElement(Object object, int n2, ILPScenarioDefinition iLPScenarioDefinition) {
        ILPScenarioElement iLPScenarioElement = new ILPScenarioElement();
        iLPScenarioElement.setModel(object);
        iLPScenarioElement.setOrder(n2);
        iLPScenarioElement.setType(ILPScenarioElement.ScenarioElementType.SCENARIO_ELEMENT_TYPE_MODEL);
        iLPScenarioElement.setConfiguration("");
        iLPScenarioElement.setScenarioDefinition(iLPScenarioDefinition);
        ILPCourseDef iLPCourseDef = iLPScenarioElement.getCourseOfModel();
        if (iLPCourseDef != null && !iLPScenarioDefinition.getReferencedCourses().contains(iLPCourseDef)) {
            try {
                iLPScenarioDefinition.addCourseObject(iLPCourseDef);
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not add course to scenarioDef: ", (Throwable)sQLException);
            }
        }
        iLPScenarioDefinition.touchAndStore();
        return iLPScenarioElement;
    }

    private void startScenario(ILPScenario iLPScenario) throws SQLException, n {
        this.setPlayConfigurationByMode(iLPScenario);
        this.updateScenarioStatus(iLPScenario, ILPScenario.ScenarioStatus.SCENARIO_STATUS_RUNNING);
        this.setScenarioAsCurrent(iLPScenario);
        this.fetchActiveElementResult();
        this.setupNextActiveElementResult(this.getActiveElementResult());
    }

    public void startCurrentScenario() throws SQLException, n {
        this.startScenario(this.currentScenario);
    }

    public void updateScenarioStatus(ILPScenario iLPScenario, ILPScenario.ScenarioStatus scenarioStatus) throws SQLException {
        iLPScenario.setStatus(scenarioStatus);
        ch.ionesoft.ilp.book.pe.g.a().aN().update((Object)iLPScenario);
    }

    public void continueTaskScenario(ILPScenario iLPScenario, ILPLessonsTask iLPLessonsTask) throws n {
        if (iLPScenario == null) {
            throw new n("Could not continue task scenario. scenario is null");
        }
        logger.b((Object)("Continue scenario: " + iLPScenario + " from task: " + iLPLessonsTask));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueScenario(final ILPScenario iLPScenario) throws n {
        try {
            if (iLPScenario == null) {
                throw new n("Could not continue scenario. scenario is null");
            }
            logger.b((Object)("Continue scenario: " + iLPScenario));
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ILPScenarioManager.this.setScenarioAsCurrent(iLPScenario);
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not continue scenario", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            this.fetchCurrentScenario();
            String string = "Could not continue scenario: " + iLPScenario;
            throw new n(string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyScenario(ILPScenario iLPScenario, ILPScenarioDefinition.ScenarioPlayMode scenarioPlayMode, List<ILPScenarioElementResult> list) throws n {
        try {
            if (iLPScenario == null) {
                throw new n("Could not copy/repeat scenario. scenario is null");
            }
            logger.b((Object)("Copy/Repeat scenario: " + iLPScenario));
            Collections.sort(list, new Comparator<ILPScenarioElementResult>(){

                public int a(ILPScenarioElementResult iLPScenarioElementResult, ILPScenarioElementResult iLPScenarioElementResult2) {
                    return Integer.compare(iLPScenarioElementResult.getOrder(), iLPScenarioElementResult2.getOrder());
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((ILPScenarioElementResult)object, (ILPScenarioElementResult)object2);
                }
            });
            final ILPScenario iLPScenario2 = new ILPScenario();
            iLPScenario2.setScenarioDefinition(iLPScenario.getScenarioDefinition());
            iLPScenario2.setName(iLPScenario.getName());
            iLPScenario2.setCreationDate(new Date());
            iLPScenario2.setStartDate(new Date());
            iLPScenario2.setDuration(iLPScenario.getDuration());
            iLPScenario2.setStatus(ILPScenario.ScenarioStatus.SCENARIO_STATUS_CREATED);
            if (scenarioPlayMode == ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_UNDEFINED && (scenarioPlayMode = iLPScenario.getPlayMode()) == ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_FREE_CHOICE) {
                scenarioPlayMode = ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_EDITONLY;
            }
            iLPScenario2.setPlayMode(scenarioPlayMode);
            final ArrayList<ILPScenarioElementResult> arrayList = new ArrayList<ILPScenarioElementResult>();
            boolean bl2 = true;
            int n2 = 1;
            for (ILPScenarioElementResult object2 : list) {
                ILPScenarioElementResult iLPScenarioElementResult = new ILPScenarioElementResult();
                iLPScenarioElementResult.setOrder(n2);
                iLPScenarioElementResult.setScenario(iLPScenario2);
                iLPScenarioElementResult.setScenarioElement(object2.getScenarioElement());
                iLPScenarioElementResult.setProcessed(false);
                if (bl2) {
                    iLPScenarioElementResult.setCurrent(true);
                    bl2 = false;
                }
                arrayList.add(iLPScenarioElementResult);
                ++n2;
            }
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ch.ionesoft.ilp.book.pe.g.a().aN().create((Object)iLPScenario2);
                            ch.ionesoft.ilp.book.pe.g.a().aN().refresh((Object)iLPScenario2);
                            ch.ionesoft.ilp.book.pe.g.a().aQ().create((Collection)arrayList);
                            ILPScenarioManager.this.setScenarioAsCurrent(iLPScenario2);
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not copy scenario from db", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            this.fetchCurrentScenario();
            String string = "Could not copy scenario: " + iLPScenario;
            throw new n(string, exception);
        }
    }

    public void copyFullScenario(ILPScenario iLPScenario, ILPScenarioDefinition.ScenarioPlayMode scenarioPlayMode) throws n {
        List<ILPScenarioElementResult> list = ch.ionesoft.ilp.book.pe.f.a().h(iLPScenario);
        this.copyScenario(iLPScenario, scenarioPlayMode, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviewIncorrectFromScenario(final ILPScenario iLPScenario) throws n {
        try {
            if (iLPScenario == null) {
                throw new n("Could not review incorrect answers from scenario. scenario is null");
            }
            logger.b((Object)("Review incorrect answers from scenario: " + iLPScenario));
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ILPScenarioManager.this.reviewScenario(iLPScenario, new t());
                            ILPScenarioManager.this.fetchFirstIncorrectElementResultAsActiveElement();
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not review scenario", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            this.fetchCurrentScenario();
            String string = "Could not review incorrect answers from scenario: " + iLPScenario;
            throw new n(string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviewAllFromScenario(final ILPScenario iLPScenario) throws n {
        try {
            if (iLPScenario == null) {
                throw new n("Could not review all answers from scenario. scenario is null");
            }
            logger.b((Object)("Review all answers from scenario: " + iLPScenario));
            ConnectionSource connectionSource = ch.ionesoft.ilp.book.pe.g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)ch.ionesoft.ilp.book.pe.g.a().I(), (Callable)new Callable<Void>(){

                    public Void a() throws Exception {
                        try {
                            ILPScenarioManager.this.reviewScenario(iLPScenario, new s(iLPScenario.isETest()));
                            ILPScenarioManager.this.fetchFirstElementResultAsActiveElement();
                        }
                        catch (Exception exception) {
                            logger.d((Object)"Could not review all from scenario", (Throwable)exception);
                            throw exception;
                        }
                        return null;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                });
            }
        }
        catch (Exception exception) {
            this.fetchCurrentScenario();
            String string = "Could not review all answers from scenario: " + iLPScenario;
            throw new n(string, exception);
        }
    }

    private void reviewScenario(ILPScenario iLPScenario, b b2) throws SQLException {
        this.setPlayConfiguration(b2);
        this.setScenarioAsCurrent(iLPScenario);
    }

    public void finishCurrentScenario(float f2, ILPScenario.ScenarioStatus scenarioStatus) {
        try {
            logger.b((Object)("Finish current scenario: " + this.getCurrentScenario()));
            if (this.getPlayConfiguration().b()) {
                this.updateLastElement(this.getActiveElementResult(), f2);
            }
            if (this.handleScenarioStatus()) {
                this.updateFinishedScenarioStatus(this.getCurrentScenario(), scenarioStatus);
            }
            this.setActiveElementResult(null);
            this.setPlayConfiguration(null);
            ILPProfileManager.instance().getCurrentProfile().setCurrentETestingTime(0, this.currentScenario);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not finish current scenario: " + this.getCurrentScenario()), (Throwable)exception);
        }
    }

    private void updateFinishedScenarioStatus(ILPScenario iLPScenario, ILPScenario.ScenarioStatus scenarioStatus) {
        try {
            if (iLPScenario == null) {
                throw new n("Could not update scenario status. scenario is null");
            }
            if (iLPScenario.isFinished()) {
                iLPScenario.setCompletionDate(new Date());
                iLPScenario.setStatus(ILPScenario.ScenarioStatus.SCENARIO_STATUS_FINISHED);
            } else if (scenarioStatus != null) {
                iLPScenario.setStatus(scenarioStatus);
            } else {
                iLPScenario.setStatus(ILPScenario.ScenarioStatus.SCENARIO_STATUS_RUNNING);
            }
            ch.ionesoft.ilp.book.pe.g.a().aN().update((Object)iLPScenario);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not update scenario to finished state: " + iLPScenario), (Throwable)exception);
        }
    }

    public boolean activeElementHasTopic() {
        try {
            if (this.hasActiveElementResult()) {
                return this.getActiveElementResult().getScenarioElement().hasTopic();
            }
        }
        catch (Exception exception) {
            logger.c((Object)("Could not check if active scenarioElementResult has a topic referenced: " + this.activeElementResult));
        }
        return false;
    }

    public boolean activeElementHasExercise() {
        try {
            if (this.hasActiveElementResult()) {
                return this.getActiveElementResult().getScenarioElement().hasExercise();
            }
        }
        catch (Exception exception) {
            logger.c((Object)("Could not check if active scenarioElementResult has an exercise referenced: " + this.activeElementResult));
        }
        return false;
    }

    public boolean activeElementHasResource() {
        try {
            if (this.hasActiveElementResult()) {
                return this.getActiveElementResult().getScenarioElement().hasResource();
            }
        }
        catch (Exception exception) {
            logger.c((Object)("Could not check if active scenarioElementResult has a resource referenced: " + this.activeElementResult));
        }
        return false;
    }

    public boolean activeElementHasEmbeddedContent() {
        try {
            if (this.hasActiveElementResult()) {
                return this.getActiveElementResult().getScenarioElement().hasEmbeddedContent();
            }
        }
        catch (Exception exception) {
            logger.c((Object)("Could not check if active scenarioElementResult has a embeddedContent referenced: " + this.activeElementResult));
        }
        return false;
    }

    public ILPTopic getTopicOfActiveElementResult() {
        if (this.activeElementHasTopic()) {
            return this.getActiveElementResult().getScenarioElement().getTopic();
        }
        return null;
    }

    public ILPExercise getExerciseOfActiveElementResult() {
        if (this.activeElementHasExercise()) {
            return this.getActiveElementResult().getScenarioElement().getExercise();
        }
        return null;
    }

    public boolean hasNextElementResult() {
        return this.fetchFollowingElementResult() != null;
    }

    public boolean hasPreviousElementResult() {
        return this.fetchPrecedingElementResult() != null;
    }

    public ILPScenarioElementResult getNextElementResult(float f2) {
        return this.navigateToElementResult(this.fetchFollowingElementResult(), f2);
    }

    private ILPScenarioElementResult fetchFollowingElementResult() {
        return this.getPlayConfiguration().a(this.getCurrentScenario(), this.getActiveElementResult().getOrder());
    }

    public ILPScenarioElementResult getPreviousElementResult(float f2) {
        return this.navigateToElementResult(this.fetchPrecedingElementResult(), f2);
    }

    private ILPScenarioElementResult fetchPrecedingElementResult() {
        return this.getPlayConfiguration().b(this.getCurrentScenario(), this.getActiveElementResult().getOrder());
    }

    public ILPScenarioElementResult navigateToElementResult(ILPScenarioElementResult iLPScenarioElementResult, float f2) {
        block4: {
            try {
                if (iLPScenarioElementResult != null) break block4;
                return null;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not get navigate to element result from current scenario. elementToShow: " + iLPScenarioElementResult), (Throwable)exception);
                return this.getActiveElementResult();
            }
        }
        if (this.getPlayConfiguration().b()) {
            this.processPreviousElementResult(this.getActiveElementResult(), f2);
            this.setupNextActiveElementResult(iLPScenarioElementResult);
        }
        this.setActiveElementResult(iLPScenarioElementResult);
        return iLPScenarioElementResult;
    }

    private void processPreviousElementResult(ILPScenarioElementResult iLPScenarioElementResult, float f2) {
        if (iLPScenarioElementResult == null) {
            return;
        }
        this.handleElementProccessed(iLPScenarioElementResult);
        iLPScenarioElementResult.setCurrent(false);
        iLPScenarioElementResult.increaseDuration(Float.valueOf(f2));
        this.persistProcessedElementResult(iLPScenarioElementResult, f2);
    }

    private void updateLastElement(ILPScenarioElementResult iLPScenarioElementResult, float f2) {
        if (iLPScenarioElementResult == null) {
            return;
        }
        this.handleElementProccessed(iLPScenarioElementResult);
        iLPScenarioElementResult.increaseDuration(Float.valueOf(f2));
        this.persistProcessedElementResult(iLPScenarioElementResult, f2);
    }

    private void handleElementProccessed(ILPScenarioElementResult iLPScenarioElementResult) {
        try {
            if (!iLPScenarioElementResult.getScenarioElement().hasExercise()) {
                iLPScenarioElementResult.setProcessed(true);
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not handle element processed", (Throwable)exception);
        }
    }

    private void persistProcessedElementResult(ILPScenarioElementResult iLPScenarioElementResult, float f2) {
        try {
            ch.ionesoft.ilp.book.pe.g.a().aQ().update((Object)iLPScenarioElementResult);
            iLPScenarioElementResult.getScenario().getScenarioDefinition().touchAndStore();
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not update current scenarioElementResult: " + iLPScenarioElementResult));
        }
    }

    private ILPScenarioElementResult setupNextActiveElementResult(ILPScenarioElementResult iLPScenarioElementResult) throws SQLException {
        iLPScenarioElementResult.setCurrent(true);
        if (iLPScenarioElementResult.getEntryTime() == null) {
            iLPScenarioElementResult.setEntryTime(new Date());
        }
        ch.ionesoft.ilp.book.pe.g.a().aQ().update((Object)iLPScenarioElementResult);
        ch.ionesoft.ilp.book.pe.g.a().aQ().refresh((Object)iLPScenarioElementResult);
        return iLPScenarioElementResult;
    }

    public ILPScenario getLatestScenario(ILPScenarioDefinition iLPScenarioDefinition) {
        ch.ionesoft.ilp.book.pe.g.a().b(iLPScenarioDefinition);
        return this.getLatestScenarioWithDefinitionPK(iLPScenarioDefinition.getPk());
    }

    public ILPScenario getLatestScenarioWithDefinitionPK(int n2) {
        return ch.ionesoft.ilp.book.pe.f.a().t(n2);
    }

    public void storeResultOnActiveElementResult(String string, boolean bl2) throws SQLException {
        ILPScenarioElementResult iLPScenarioElementResult = this.getActiveElementResult();
        iLPScenarioElementResult.setResult(string);
        iLPScenarioElementResult.setProcessed(bl2);
        ch.ionesoft.ilp.book.pe.g.a().aQ().update((Object)iLPScenarioElementResult);
        ch.ionesoft.ilp.book.pe.g.a().aQ().refresh((Object)this.getActiveElementResult());
        iLPScenarioElementResult.getScenario().getScenarioDefinition().getScenarioSpecification().touchAndStore();
    }

    public void storeRatingOnActiveElementResult(Float f2) throws SQLException {
        ILPScenarioElementResult iLPScenarioElementResult = this.getActiveElementResult();
        iLPScenarioElementResult.setRating(f2);
        ch.ionesoft.ilp.book.pe.g.a().aQ().update((Object)iLPScenarioElementResult);
        ch.ionesoft.ilp.book.pe.g.a().aQ().refresh((Object)this.getActiveElementResult());
    }

    public Float getRatingOnActiveElementResult() {
        ILPScenarioElementResult iLPScenarioElementResult = this.getActiveElementResult();
        return iLPScenarioElementResult.getRating();
    }

    public boolean isActiveElementResultCorrect() {
        Float f2 = this.getActiveElementResult().getRating();
        if (f2 == null) {
            return true;
        }
        return f2.floatValue() == 1.0f;
    }

    public void formatExerciseAnswersToJSON(List<ILPAnswer> list, ILPQuestion iLPQuestion, i i2) throws n {
        this.getPlayConfiguration().a(list, iLPQuestion, i2);
    }

    public List<ILPAnswer> getAnswersFromJSON(ILPQuestion iLPQuestion) {
        return this.getPlayConfiguration().a(iLPQuestion, this.getActiveElementResult().getResult());
    }

    public ILPTransientAnswer getSingleAnswerFromJSON(ILPQuestion iLPQuestion) {
        return this.getPlayConfiguration().b(iLPQuestion, this.getActiveElementResult().getResult());
    }

    public ILPTransientAnswer getSingleAnswerFromJSONByNumber(Integer n2, ILPQuestion iLPQuestion) {
        return this.getPlayConfiguration().a(n2, iLPQuestion, this.getActiveElementResult().getResult());
    }

    public void loadModelOfActiveElementResult(a.a a2) throws n {
        try {
            if (!this.hasActiveElementResult() || this.getActiveElementResult().getScenarioElement() == null) {
                return;
            }
            this.getActiveElementResult().getScenarioElement().getElementStrategy().b(a2);
        }
        catch (Exception exception) {
            String string = "Could not load model of active element result: " + this.getActiveElementResult();
            logger.d((Object)string, (Throwable)exception);
            throw new n(string, exception);
        }
    }

    public void storeModelOfActiveElementResult(a.a a2) {
        try {
            if (!this.hasActiveElementResult() || !this.getPlayConfiguration().a()) {
                return;
            }
            this.getActiveElementResult().getScenarioElement().getElementStrategy().a(a2);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not store model of active element result: " + this.getActiveElementResult()), (Throwable)exception);
        }
    }

    public void modelOfActiveElementResultDidFinishLoad(a.a a2) throws h {
        try {
            if (!this.hasActiveElementResult()) {
                return;
            }
            this.getActiveElementResult().getScenarioElement().getElementStrategy().c(a2);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not setup js for model of active element result: " + this.getActiveElementResult()), (Throwable)exception);
        }
    }

    public AbstractCoreDataModel getModelOfActiveElementResult() {
        block3: {
            try {
                if (this.hasActiveElementResult()) break block3;
                return null;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not get model of active element result: " + this.getActiveElementResult()), (Throwable)exception);
                return null;
            }
        }
        return this.getActiveElementResult().getScenarioElement().getElementStrategy().l();
    }

    public boolean isModelOfActiveElementResultFixedLayout() {
        block3: {
            try {
                if (this.hasActiveElementResult()) break block3;
                return false;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not check if model of active element result is fixed Layout. elemRes: " + this.getActiveElementResult()), (Throwable)exception);
                return false;
            }
        }
        return this.getActiveElementResult().getScenarioElement().getElementStrategy().m();
    }

    public Map<String, Object> getEventRequestForActiveModel() {
        try {
            if (!this.hasActiveElementResult()) {
                return new HashMap<String, Object>();
            }
            return this.getActiveElementResult().getScenarioElement().getElementStrategy().k();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get event request for model of active element result: " + this.getActiveElementResult()), (Throwable)exception);
            return new HashMap<String, Object>();
        }
    }

    public ILPCourseDef getCourseDefOfActiveElementResult() {
        block3: {
            try {
                if (this.hasActiveElementResult()) break block3;
                return null;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not get courseDef for model of active element result: " + this.getActiveElementResult()), (Throwable)exception);
                return null;
            }
        }
        return this.getActiveElementResult().getScenarioElement().getElementStrategy().i();
    }

    public ILPIssueDef getIssueDefOfActiveElementResult() {
        block3: {
            try {
                if (this.hasActiveElementResult()) break block3;
                return null;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not get issueDef for model of active element result: " + this.getActiveElementResult()), (Throwable)exception);
                return null;
            }
        }
        return this.getActiveElementResult().getScenarioElement().getElementStrategy().j();
    }

    public float getRelativePositionOfActiveScenarioElement() {
        try {
            float f2 = this.getActiveElementResult().getOrder().intValue();
            float f3 = this.getCurrentScenario().getScenarioElementResults().size();
            float f4 = f2 / f3;
            return Math.max(Math.min(f4, 1.0f), 0.0f) * 100.0f;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not calculate relative position of active element result: " + this.activeElementResult));
            return 0.0f;
        }
    }

    public boolean showExitDialog() {
        try {
            if (this.getPlayConfiguration() != null && this.getPlayConfiguration() instanceof c) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not check if exit dialog should be shown", (Throwable)exception);
        }
        return false;
    }

    public b getPlayConfiguration(ILPScenarioDefinition iLPScenarioDefinition) throws n {
        String string = null;
        try {
            string = iLPScenarioDefinition.getScenarioSpecification().getProperty();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get propertyJson from specification of scenarioDef: " + iLPScenarioDefinition), (Throwable)exception);
        }
        return this.getPlayConfigurationByModeWithProperty(iLPScenarioDefinition.getPlayMode(), string);
    }

    public b getPlayConfiguration(ILPScenario iLPScenario) throws n {
        String string = null;
        try {
            string = iLPScenario.getScenarioDefinition().getScenarioSpecification().getProperty();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get propertyJson from specification of scenario: " + iLPScenario), (Throwable)exception);
        }
        return this.getPlayConfigurationByModeWithProperty(iLPScenario.getPlayMode(), string);
    }

    private b getPlayConfigurationByModeWithProperty(ILPScenarioDefinition.ScenarioPlayMode scenarioPlayMode, String string) throws n {
        switch (scenarioPlayMode) {
            case SCENARIO_PLAYMODE_CORRECTION: {
                return new f(string);
            }
            case SCENARIO_PLAYMODE_EDITONLY: {
                return new g(string);
            }
            case SCENARIO_PLAYMODE_EXAM: {
                return new m(string);
            }
            case SCENARIO_PLAYMODE_ETEST: {
                return new c(string);
            }
            case SCENARIO_PLAYER_PLAYMODE: {
                return new q(string);
            }
            case SCENARIO_PLAYER_PLAYMODE_REVIEW: {
                return new r(string);
            }
        }
        throw new n("Could not set PlayConfig based on received ScenarioPlayMode. playmode: " + (Object)((Object)scenarioPlayMode) + " not supported for this operation");
    }

    private void setPlayConfigurationByMode(ILPScenario iLPScenario) throws n {
        this.setPlayConfiguration(this.getPlayConfiguration(iLPScenario));
    }

    private b getPlayConfiguration() {
        return this.playConfig;
    }

    public void setPlayConfiguration(b b2) {
        this.playConfig = b2;
    }

    public boolean isScenarioRunning() {
        return this.playConfig != null;
    }

    public boolean markersAndAnnotationsAllowed() {
        if (this.getCurrentScenario() == null) {
            return true;
        }
        return this.getCurrentScenario().getScenarioDefinition().isAnnotatable();
    }

    public boolean markersAndAnnotationsAllowedByPlayMode() {
        if (this.getCurrentScenario() == null) {
            return true;
        }
        return this.getPlayConfiguration().g();
    }

    public boolean isStoreModels() {
        if (this.getCurrentScenario() == null) {
            return true;
        }
        return this.getPlayConfiguration().a();
    }

    public boolean loadExerciseWithCorrection() {
        if (this.getPlayConfiguration() == null || !ILPBookHelper.hasApplicationFeatureAccess(c.b.g)) {
            return false;
        }
        return this.getPlayConfiguration().d();
    }

    public boolean solutionModeAllowed() {
        if (this.getPlayConfiguration() == null || !ILPBookHelper.hasApplicationFeatureAccess(c.b.f)) {
            return false;
        }
        return this.getPlayConfiguration().e();
    }

    public boolean correctionModeAllowed() {
        if (this.getPlayConfiguration() == null || !ILPBookHelper.hasApplicationFeatureAccess(c.b.g)) {
            return false;
        }
        return this.getPlayConfiguration().f();
    }

    public boolean showCorrectnessInOverlay() {
        if (this.getPlayConfiguration() == null) {
            return false;
        }
        return this.getPlayConfiguration().o();
    }

    public boolean blockExternalLinks() {
        if (this.getPlayConfiguration() == null) {
            return false;
        }
        return this.getPlayConfiguration().h();
    }

    public boolean disableInputFields() {
        if (this.getPlayConfiguration() == null) {
            return false;
        }
        return this.getPlayConfiguration().q();
    }

    public boolean showSolutionPriorToNavigation() {
        if (this.getPlayConfiguration() == null || !ILPBookHelper.hasApplicationFeatureAccess(c.b.g)) {
            return false;
        }
        return this.getPlayConfiguration().c();
    }

    public boolean abortScenarioWhenMaxDurationReached() {
        if (this.getPlayConfiguration() == null) {
            return false;
        }
        return this.getPlayConfiguration().i();
    }

    public boolean blockToolbar() {
        if (this.getPlayConfiguration() == null) {
            return false;
        }
        return this.getPlayConfiguration().j();
    }

    public boolean handleScenarioStatus() {
        block3: {
            try {
                if (this.getPlayConfiguration() != null) break block3;
                return true;
            }
            catch (Exception exception) {
                logger.d((Object)"Could not check if scenario is in review mode", (Throwable)exception);
                return false;
            }
        }
        return this.getPlayConfiguration().p();
    }

    public boolean isETestingMode() {
        return this.blockToolbar();
    }

    public boolean isCurrentScenarioLoadSaveOnScenario() {
        block3: {
            try {
                if (this.currentScenario != null) break block3;
                return false;
            }
            catch (Exception exception) {
                logger.d((Object)"Could not check if current scenario is load / save on scenario", (Throwable)exception);
                return true;
            }
        }
        return this.currentScenario.isLoadSaveAnswersOnScenario();
    }

    public void generateScenarioSpecificationsByGroupAndCourse(ILPCourseProduct iLPCourseProduct) {
        ArrayList<String> arrayList;
        block29: {
            CloseableIterator closeableIterator;
            block28: {
                closeableIterator = iLPCourseProduct.getIssueProducts().closeableIterator();
                arrayList = new ArrayList<String>();
                File file = new File(ch.ionesoft.ilp.base.co.h.x() + "/etests/" + iLPCourseProduct.getCourseReference());
                try {
                    try {
                        Object object;
                        List<ILPExercise.ExerciseGroup> list;
                        Object object2;
                        Object object3 = new HashMap();
                        ArrayList arrayList2 = new ArrayList();
                        object3.put("scenario_map", arrayList2);
                        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                        arrayList2.add(linkedHashMap);
                        ArrayList<Object> arrayList3 = new ArrayList<Object>();
                        linkedHashMap.put("etests", arrayList3);
                        String string = iLPCourseProduct.getLanguageCode().toLowerCase();
                        linkedHashMap.put("language", string);
                        linkedHashMap.put("course_id", iLPCourseProduct.getCourseIdentifier());
                        while (closeableIterator.hasNext()) {
                            object2 = (ILPIssueProduct)closeableIterator.next();
                            list = ch.ionesoft.ilp.book.pe.f.a().I(((ILPIssueProduct)object2).getIssue());
                            if (list == null || list.isEmpty()) continue;
                            object = new LinkedHashMap();
                            arrayList3.add(object);
                            ArrayList arrayList4 = new ArrayList();
                            object.put("variants", arrayList4);
                            String string2 = ((ILPAbstractProduct)object2).getTitle();
                            String string3 = StringHelper.extractPostfixNumber((String)string2);
                            if (StringUtils.isNotBlank((CharSequence)string3)) {
                                object.put("etest_id", string3);
                            } else {
                                object.put("etest_id", string2);
                            }
                            object.put("max_duration", Math.round(this.convertDurationFromString(this.getDuration(((ILPIssueProduct)object2).getIssueIdentifier()).toString()).floatValue()));
                            object.put("issue_id", ((ILPIssueProduct)object2).getIssueIdentifier());
                            String string4 = ch.ionesoft.ilp.base.co.g.a().N();
                            ILPTopic iLPTopic = this.getPrologTopic(((ILPIssueProduct)object2).getIssue(), string4);
                            if (linkedHashMap.get("prolog_issue_id") == null) {
                                linkedHashMap.put("prolog_issue_id", iLPTopic.getIssue().getIssueId());
                                linkedHashMap.put("prolog_issue_reference", iLPTopic.getIssue().getReference());
                                linkedHashMap.put("prolog_topic_access_path", iLPTopic.getAccessPath());
                                linkedHashMap.put("prolog_topic_title", iLPTopic.getTitle());
                                linkedHashMap.put("prolog_topic_order", iLPTopic.getOrder());
                                linkedHashMap.put("prolog_topic_level", iLPTopic.getLevel());
                            }
                            int n2 = 1;
                            for (ILPExercise.ExerciseGroup exerciseGroup : list) {
                                try {
                                    Object object42;
                                    AbstractCoreDataModel abstractCoreDataModel;
                                    logger.b((Object)("Generate ScenarioSpecification for Issue: " + ((ILPIssueProduct)object2).getIssueIdentifier() + ", ExerciseGroup: " + exerciseGroup));
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    ILPScenarioDefinition iLPScenarioDefinition = new ILPScenarioDefinition();
                                    iLPScenarioDefinition.setType(ILPScenarioDefinition.ScenarioType.SCENARIO_TYPE_STATIC);
                                    iLPScenarioDefinition.addModelContent(ILPScenarioDefinition.ScenarioModelContent.SCENARIO_MODELCONTENT_EXERCISE);
                                    String string5 = ((ILPAbstractProduct)object2).getTitle();
                                    String string6 = ((ILPAbstractProduct)object2).getTitle();
                                    this.createNewDefinition(iLPScenarioDefinition, string5, string6, false, this.getDuration(((ILPIssueProduct)object2).getIssueIdentifier()).toString(), String.valueOf(ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_ETEST.getCode()), false, true);
                                    iLPScenarioDefinition.addCourseObject(iLPCourseProduct.getCourse());
                                    List<ILPExercise> list2 = ch.ionesoft.ilp.book.pe.f.a().c(((ILPIssueProduct)object2).getIssue(), exerciseGroup);
                                    this.addModelsArrayToScenarioDef(iLPScenarioDefinition, list2.toArray());
                                    if (iLPTopic != null) {
                                        this.addModelsArrayToScenarioDef(iLPScenarioDefinition, new Object[]{iLPTopic});
                                        abstractCoreDataModel = null;
                                        for (Object object42 : iLPScenarioDefinition.getScenarioElements()) {
                                            if (!((ILPScenarioElement)object42).hasTopic()) continue;
                                            abstractCoreDataModel = object42;
                                            ((ILPScenarioElement)abstractCoreDataModel).setDeleted(true);
                                            break;
                                        }
                                        this.updateDefinitionProlog(iLPScenarioDefinition, abstractCoreDataModel.getPk());
                                    }
                                    abstractCoreDataModel = iLPScenarioDefinition.getScenarioSpecification();
                                    ((ILPScenarioSpecification)abstractCoreDataModel).setDescription(String.valueOf(this.getVarianPrefix(string)) + n2++);
                                    if (((ILPIssueProduct)object2).getIssueIdentifier().contains("CE")) {
                                        object42 = String.valueOf(((ILPIssueProduct)object2).getIssueIdentifier()) + exerciseGroup.localizedPluralName().substring(exerciseGroup.localizedPluralName().length() - 1) + "_" + ((ILPIssueProduct)object2).getCourseProduct().getLanguageCode();
                                        logger.b((Object)("new identifier: " + (String)object42));
                                        ((ILPScenarioSpecification)abstractCoreDataModel).setId((String)object42);
                                    } else {
                                        object42 = String.format("%s_%s_%s_scenario-%s_%s", iLPCourseProduct.getCourseIdentifier(), iLPCourseProduct.getCourseReference(), ((ILPIssueProduct)object2).getIssueIdentifier(), StringUtils.isNotBlank((CharSequence)string3) ? string3 : string2, exerciseGroup.getCode());
                                        logger.b((Object)("scenario identifier: " + (String)object42));
                                        ((ILPScenarioSpecification)abstractCoreDataModel).setId((String)object42);
                                    }
                                    object42 = String.valueOf(iLPCourseProduct.getCourseReference()) + "_" + ((ILPIssueProduct)object2).getIssue().getIssueId() + "_" + exerciseGroup.name() + ".xml";
                                    File file2 = new File(file, (String)object42);
                                    j j2 = new j();
                                    j2.a(true);
                                    j2.a((ILPScenarioSpecification)abstractCoreDataModel, file2, true);
                                    hashMap.put("etest_variant", exerciseGroup.getCode());
                                    hashMap.put("scenario_reference", ((ILPScenarioSpecification)abstractCoreDataModel).getId());
                                    arrayList4.add(hashMap);
                                    arrayList.add("Successfully create ScenarioSpecification: " + ((ILPScenarioSpecification)abstractCoreDataModel).getId() + ", exported to: " + file2);
                                    this.deleteScenarioDefinitionFromDatabase(iLPScenarioDefinition);
                                    ch.ionesoft.ilp.book.pe.g.a().aM().delete((Object)abstractCoreDataModel);
                                }
                                catch (Exception exception) {
                                    logger.d((Object)("Could not create and export scenario specification for issue: " + ((ILPIssueProduct)object2).getIssue() + ", and exerciseGroup: " + exerciseGroup), (Throwable)exception);
                                }
                            }
                        }
                        object2 = new Yaml();
                        list = null;
                        object = null;
                        try {
                            try {
                                object = new FileWriter(new File(file, "scenario_map.yaml"));
                                object2.dump(object3, (Writer)object);
                                logger.b((Object)"Successfully created yaml file.. ");
                            }
                            catch (IOException iOException) {
                                logger.d((Object)("Could not write yaml file to: " + list), (Throwable)iOException);
                                if (object != null) {
                                    ((OutputStreamWriter)object).close();
                                }
                                break block28;
                            }
                        }
                        catch (Throwable throwable) {
                            if (object != null) {
                                ((OutputStreamWriter)object).close();
                            }
                            throw throwable;
                        }
                        if (object != null) {
                            ((OutputStreamWriter)object).close();
                        }
                    }
                    catch (Exception exception) {
                        logger.d((Object)("Could not export generated scenarioSpecifications for courseProduct: " + iLPCourseProduct), (Throwable)exception);
                        if (closeableIterator != null) {
                            closeableIterator.closeQuietly();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (closeableIterator != null) {
                        closeableIterator.closeQuietly();
                    }
                    throw throwable;
                }
            }
            if (closeableIterator != null) {
                closeableIterator.closeQuietly();
            }
        }
        if (!arrayList.isEmpty()) {
            logger.b((Object)"========================== EXPORT REPORT ================================");
            for (Object object3 : arrayList) {
                logger.b(object3);
            }
            logger.b((Object)"=========================================================================");
        }
    }

    private ILPTopic getPrologTopic(ILPIssueDef iLPIssueDef, String string) {
        ILPTopic iLPTopic = null;
        try {
            List<ILPIssueDef> list = ch.ionesoft.ilp.book.pe.f.a().h(iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference());
            for (ILPIssueDef iLPIssueDef2 : list) {
                iLPTopic = ch.ionesoft.ilp.book.pe.f.a().b(string, iLPIssueDef2);
                if (iLPTopic == null) {
                    continue;
                }
                break;
            }
        }
        catch (ch.ionesoft.ilp.book.pe.j j2) {
            logger.d((Object)("Could not fetch prolog topic with name: " + string), (Throwable)j2);
        }
        if (iLPTopic == null) {
            logger.c((Object)("Could not find prolog topic with name: " + string));
        }
        return iLPTopic;
    }

    private Float getDuration(String string) {
        try {
            HashMap<String, Float> hashMap = new HashMap<String, Float>();
            hashMap.put("SBKT00", Float.valueOf(8.0f));
            hashMap.put("SBKT02", Float.valueOf(8.0f));
            hashMap.put("SBKT03", Float.valueOf(8.0f));
            hashMap.put("CE100", Float.valueOf(15.0f));
            hashMap.put("CE101", Float.valueOf(30.0f));
            hashMap.put("CE102", Float.valueOf(15.0f));
            hashMap.put("CE103", Float.valueOf(15.0f));
            hashMap.put("CE104", Float.valueOf(30.0f));
            hashMap.put("CE105", Float.valueOf(15.0f));
            hashMap.put("CE106", Float.valueOf(15.0f));
            hashMap.put("CE107", Float.valueOf(30.0f));
            hashMap.put("CE108", Float.valueOf(15.0f));
            hashMap.put("CE109", Float.valueOf(15.0f));
            hashMap.put("CE110", Float.valueOf(30.0f));
            hashMap.put("CE111", Float.valueOf(30.0f));
            hashMap.put("CE112", Float.valueOf(30.0f));
            return (Float)hashMap.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getVarianPrefix(String string) {
        if ("fr".equals(string)) {
            return "Questions ";
        }
        return "Aufgaben ";
    }
}

