/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo.lr;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.lr.ILPFeedback;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@DatabaseTable(tableName="ZILPFEEDBACKDATA")
public class ILPFeedbackData
extends AbstractCoreDataModel {
    private static final long serialVersionUID = 1L;
    private static ILogger logger = ILPLogManager.getLogger(ILPFeedbackData.class);
    public static final String ID_FIELD_NAME = "ZID";
    public static final String FORMAT_FIELD_NAME = "ZFORMAT";
    public static final String DATA_ENTRY_FIELD_NAME = "ZDATAENTRY";
    public static final String FEEDBACK_FK_FIELD_NAME = "ZFEEDBACK";
    @DatabaseField(columnName="ZID", canBeNull=false, index=true)
    private String id;
    @DatabaseField(columnName="ZFORMAT")
    private Integer format;
    @DatabaseField(columnName="ZDATAENTRY")
    private String dataEntry;
    @DatabaseField(columnName="ZFEEDBACK", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPFeedback feedback;

    public ILPFeedbackData() {
    }

    public ILPFeedbackData(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public FeedbackDataEntryFormat getFormat() {
        return FeedbackDataEntryFormat.get(this.format);
    }

    public void setFormat(Integer n2) {
        this.format = n2;
    }

    public void setFormat(FeedbackDataEntryFormat feedbackDataEntryFormat) {
        this.format = feedbackDataEntryFormat.getCode();
    }

    public String getDataEntry() {
        return this.dataEntry;
    }

    public void setDataEntry(String string) {
        this.dataEntry = string;
    }

    public ILPFeedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(ILPFeedback iLPFeedback) {
        this.feedback = iLPFeedback;
    }

    @Override
    public String toString() {
        return "ILPFeedbackData [id=" + this.id + ", format=" + this.format + ", dataEntry=" + this.dataEntry + ", feedback=" + this.feedback + "]";
    }

    public static enum FeedbackDataEntryFormat {
        FEEDBACK_DATA_ENTRY_FORMAT_UNDEFINED(0, "UNDEFINED"),
        FEEDBACK_DATA_ENTRY_FORMAT_XML(1, "XML"),
        FEEDBACK_DATA_ENTRY_FORMAT_HTML(2, "HTML"),
        FEEDBACK_DATA_ENTRY_FORMAT_XHTML(3, "XHTML"),
        FEEDBACK_DATA_ENTRY_FORMAT_JSON(4, "JSON"),
        FEEDBACK_DATA_ENTRY_FORMAT_PLAIN(5, "PLAIN");

        private static final Map<Integer, FeedbackDataEntryFormat> codeLookup;
        private static final Map<String, FeedbackDataEntryFormat> valueLookup;
        private String value;
        private int code;

        static {
            codeLookup = new HashMap<Integer, FeedbackDataEntryFormat>();
            valueLookup = new HashMap<String, FeedbackDataEntryFormat>();
            for (FeedbackDataEntryFormat feedbackDataEntryFormat : EnumSet.allOf(FeedbackDataEntryFormat.class)) {
                codeLookup.put(feedbackDataEntryFormat.getCode(), feedbackDataEntryFormat);
                valueLookup.put(feedbackDataEntryFormat.getValue(), feedbackDataEntryFormat);
            }
        }

        private FeedbackDataEntryFormat(int n3, String string2) {
            this.code = n3;
            this.value = string2;
        }

        public static FeedbackDataEntryFormat get(int n2) {
            try {
                return codeLookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined feedbackDataEntryFormat code: " + n2 + ", defaulting to " + FEEDBACK_DATA_ENTRY_FORMAT_UNDEFINED.name()));
                return FEEDBACK_DATA_ENTRY_FORMAT_UNDEFINED;
            }
        }

        public static FeedbackDataEntryFormat get(String string) {
            try {
                return valueLookup.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined feedbackDataEntryFormat value: " + string + ", defaulting to " + FEEDBACK_DATA_ENTRY_FORMAT_UNDEFINED.name()));
                return FEEDBACK_DATA_ENTRY_FORMAT_UNDEFINED;
            }
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }
    }
}

