/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo.lr;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask;
import ch.ionesoft.ilp.book.mo.lr.ILPFeedbackData;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPFEEDBACK")
public class ILPFeedback
extends AbstractCoreDataModel {
    private static final long serialVersionUID = 1L;
    private static ILogger logger = ILPLogManager.getLogger(ILPFeedback.class);
    public static final String ID_FIELD_NAME = "ZID";
    public static final String SCENARIO_ELEMENT_ID_FIELD_NAME = "ZELEMENTID";
    public static final String DATA_FORMAT_FIELD_NAME = "ZDATAFORMAT";
    public static final String SCORE_MIN_FIELD_NAME = "ZSCOREMIN";
    public static final String SCORE_MAX_FIELD_NAME = "ZSCOREMAX";
    public static final String SCORE_RAW_FIELD_NAME = "ZSCORERAW";
    public static final String SCORE_SCALED_FIELD_NAME = "ZSCORESCALED";
    public static final String SUCCESS_FIELD_NAME = "ZSUCCESS";
    public static final String DATE_FIELD_NAME = "ZDATE";
    public static final String IS_READ_FIELD_NAME = "ZISREAD";
    public static final String ELEMENT_FK_FIELD_NAME = "ZELEMENT";
    public static final String USER_FK_FIELD_NAME = "ZUSER";
    public static final String SPECIFICATION_FK_FIELD_NAME = "ZSPECIFICATION";
    public static final String TASK_FK_FIELD_NAME = "ZTASK";
    @DatabaseField(columnName="ZID", canBeNull=false, index=true)
    private String id;
    @DatabaseField(columnName="ZELEMENTID")
    private String elementId;
    @DatabaseField(columnName="ZDATAFORMAT")
    private Integer dataFormat;
    @DatabaseField(columnName="ZSCOREMIN")
    private Float scoreMin;
    @DatabaseField(columnName="ZSCOREMAX")
    private Float scoreMax;
    @DatabaseField(columnName="ZSCORERAW")
    private Float scoreRaw;
    @DatabaseField(columnName="ZSCORESCALED")
    private Float scoreScaled;
    @DatabaseField(columnName="ZSUCCESS")
    private Boolean success;
    @DatabaseField(columnName="ZDATE")
    private DateTime feedbackDate;
    @DatabaseField(columnName="ZISREAD", canBeNull=true)
    private Boolean isRead;
    @DatabaseField(columnName="ZELEMENT", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPScenarioElement element;
    @DatabaseField(columnName="ZUSER", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPUser user;
    @DatabaseField(columnName="ZSPECIFICATION", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPScenarioSpecification specification;
    @DatabaseField(columnName="ZTASK", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPLessonsTask task;
    @ForeignCollectionField
    private ForeignCollection<ILPFeedbackData> feedbackData;

    public ILPFeedback() {
    }

    public ILPFeedback(String string) {
        this.id = string;
    }

    public ForeignCollection<ILPFeedbackData> getFeebackData() {
        if (this.feedbackData == null) {
            try {
                g.a().aW().assignEmptyForeignCollection((Object)this, "feedbackData");
                this.feedbackData.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for feedback.feedbackData", (Throwable)sQLException);
                f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.feedbackData;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String string) {
        this.elementId = string;
    }

    public FeedbackDataFormat getDataFormat() {
        return FeedbackDataFormat.get(this.dataFormat);
    }

    public void setDataFormat(Integer n2) {
        this.dataFormat = n2;
    }

    public void setDataFormat(FeedbackDataFormat feedbackDataFormat) {
        this.dataFormat = feedbackDataFormat.getCode();
    }

    public Float getScoreMin() {
        return this.scoreMin;
    }

    public void setScoreMin(Float f2) {
        this.scoreMin = f2;
    }

    public Float getScoreMax() {
        return this.scoreMax;
    }

    public void setScoreMax(Float f2) {
        this.scoreMax = f2;
    }

    public Float getScoreRaw() {
        return this.scoreRaw;
    }

    public void setScoreRaw(Float f2) {
        this.scoreRaw = f2;
    }

    public Float getScoreScaled() {
        return this.scoreScaled;
    }

    public void setScoreScaled(Float f2) {
        this.scoreScaled = f2;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean bl2) {
        this.success = bl2;
    }

    public Boolean isRead() {
        return this.isRead;
    }

    public void setIsRead(Boolean bl2) {
        this.isRead = bl2;
    }

    public DateTime getFeedbackDate() {
        return this.feedbackDate;
    }

    public void setFeedbackDate(DateTime dateTime) {
        this.feedbackDate = dateTime;
    }

    public ILPScenarioElement getElement() {
        return this.element;
    }

    public void setElement(ILPScenarioElement iLPScenarioElement) {
        this.element = iLPScenarioElement;
    }

    public ILPUser getUser() {
        return this.user;
    }

    public void setUser(ILPUser iLPUser) {
        this.user = iLPUser;
    }

    public ILPScenarioSpecification getSpecification() {
        return this.specification;
    }

    public void setSpecification(ILPScenarioSpecification iLPScenarioSpecification) {
        this.specification = iLPScenarioSpecification;
    }

    public ILPLessonsTask getTask() {
        return this.task;
    }

    public void setTask(ILPLessonsTask iLPLessonsTask) {
        this.task = iLPLessonsTask;
    }

    @Override
    public String toString() {
        return "ILPFeedback [id=" + this.id + ", elementId=" + this.elementId + ", dataFormat=" + this.dataFormat + ", scoreMin=" + this.scoreMin + ", scoreMax=" + this.scoreMax + ", scoreRaw=" + this.scoreRaw + ", scoreScaled=" + this.scoreScaled + ", success=" + this.success + ", feedbackDate=" + this.feedbackDate + ", element=" + this.element + ", user=" + this.user + ", specification=" + this.specification + ", task=" + this.task + ", feedbackData=" + this.feedbackData + "]";
    }

    public static enum FeedbackDataFormat {
        FEEDBACK_DATA_FORMAT_UNDEFINED(0, "UNDEFINED"),
        FEEDBACK_DATA_FORMAT_PARTIAL(1, "PARTIAL"),
        FEEDBACK_DATA_FORMAT_WHOLE(2, "WHOLE");

        private static final Map<Integer, FeedbackDataFormat> codeLookup;
        private static final Map<String, FeedbackDataFormat> valueLookup;
        private String value;
        private int code;

        static {
            codeLookup = new HashMap<Integer, FeedbackDataFormat>();
            valueLookup = new HashMap<String, FeedbackDataFormat>();
            for (FeedbackDataFormat feedbackDataFormat : EnumSet.allOf(FeedbackDataFormat.class)) {
                codeLookup.put(feedbackDataFormat.getCode(), feedbackDataFormat);
                valueLookup.put(feedbackDataFormat.getValue(), feedbackDataFormat);
            }
        }

        private FeedbackDataFormat(int n3, String string2) {
            this.code = n3;
            this.value = string2;
        }

        public static FeedbackDataFormat get(int n2) {
            try {
                return codeLookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined feedbackDataFormat code: " + n2 + ", defaulting to " + FEEDBACK_DATA_FORMAT_UNDEFINED.name()));
                return FEEDBACK_DATA_FORMAT_UNDEFINED;
            }
        }

        public static FeedbackDataFormat get(String string) {
            try {
                return valueLookup.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined feedbackDataFormat value: " + string + ", defaulting to " + FEEDBACK_DATA_FORMAT_UNDEFINED.name()));
                return FEEDBACK_DATA_FORMAT_UNDEFINED;
            }
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }
    }
}

