/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo.lms;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.angular.model.af;
import ch.ionesoft.ilp.book.angular.model.an;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.ia.d;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPGroup;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsContent;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsFolder;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask_Group;
import ch.ionesoft.ilp.book.mo.lr.ILPFeedback;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPLESSONSTASK")
public class ILPLessonsTask
extends AbstractCoreDataModel
implements ILPLessonsContent.LessonsContentModel {
    private static final long serialVersionUID = 1L;
    private static ILogger logger = ILPLogManager.getLogger(ILPLessonsTask.class);
    public static final String TASK_ID_FIELD_NAME = "ZTASKID";
    public static final String TASK_ASSIGNMENT_ID_FIELD_NAME = "ZTASKASSIGNMENTID";
    public static final String PROCESSING_STATE_FIELD_NAME = "ZPROCESSINGSTATE";
    public static final String STATE_FIELD_NAME = "ZSTATE";
    public static final String TASK_SYNC_STATE_FIELD_NAME = "ZTASKSYNCSTATE";
    public static final String EXERCISE_ANSWER_DISPLAY_MODE_FIELD_NAME = "ZEXERCISEANSWERDISPLAYMODE";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String DESCRIPTION_FIELD_NAME = "ZDESCRIPTION";
    public static final String PUBLISHED_AT_FIELD_NAME = "ZPUBLISHEDAT";
    public static final String CREATED_AT_FIELD_NAME = "ZCREATEDAT";
    public static final String RECEIVED_AT_FIELD_NAME = "ZRECEIVEDAT";
    public static final String STARTED_AT_FIELD_NAME = "ZSTARTEDAT";
    public static final String ESTIMATED_AT_FIELD_NAME = "ZESTIMATEDAT";
    public static final String DELIVERED_AT_FIELD_NAME = "ZCOMPLETEDAT";
    public static final String LAST_MODIFIED_AT_FIELD_NAME = "ZLASTMODIFIEDAT";
    public static final String USER_SUBMITTED_AT_FIELD_NAME = "ZUSERSUBMITTEDAT";
    public static final String LEARNING_ANALYTICS_ENABLED_FIELD_NAME = "ZLEARNINGANALYTICSENABLED";
    public static final String LAST_SYNC_DATE_FIELD_NAME = "ZLASTSYNCDATE";
    public static final String OWNER_FK_FIELD_NAME = "ZOWNER";
    public static final String FOLDER_FK_FIELD_NAME = "ZFOLDER";
    public static final String SCENARIO_SPECIFICATION_FK_FIELD_NAME = "ZSCENARIOSPECIFICATION";
    @DatabaseField(columnName="ZTASKID", canBeNull=false, unique=true)
    private String taskId;
    @DatabaseField(columnName="ZTASKASSIGNMENTID", canBeNull=false, unique=true)
    private String taskAssignmentId;
    @DatabaseField(columnName="ZTASKSYNCSTATE", canBeNull=false, index=true)
    private Integer taskSyncState;
    @DatabaseField(columnName="ZSTATE", canBeNull=false, index=true)
    private Integer state;
    @DatabaseField(columnName="ZTYPE", canBeNull=false, index=true)
    private Integer type;
    @DatabaseField(columnName="ZPROCESSINGSTATE", canBeNull=false, index=true)
    private Integer processingState;
    @DatabaseField(columnName="ZEXERCISEANSWERDISPLAYMODE")
    private Integer exerciseAnswerDisplayMode;
    @DatabaseField(columnName="ZTITLE", index=true)
    private String title;
    @DatabaseField(columnName="ZDESCRIPTION")
    private String description;
    @DatabaseField(columnName="ZPUBLISHEDAT")
    private DateTime publishedAt;
    @DatabaseField(columnName="ZCREATEDAT")
    private DateTime createdAt;
    @DatabaseField(columnName="ZRECEIVEDAT")
    private DateTime receivedAt;
    @DatabaseField(columnName="ZSTARTEDAT")
    private DateTime startedAt;
    @DatabaseField(columnName="ZESTIMATEDAT")
    private DateTime estimatedAt;
    @DatabaseField(columnName="ZCOMPLETEDAT")
    private DateTime deliveredAt;
    @DatabaseField(columnName="ZLASTMODIFIEDAT")
    private DateTime lastModifiedAt;
    @DatabaseField(columnName="ZUSERSUBMITTEDAT")
    private DateTime userSubmittedAt;
    @DatabaseField(columnName="ZLEARNINGANALYTICSENABLED", canBeNull=false)
    private boolean learningAnalyticsEnabled = false;
    @DatabaseField(columnName="ZLASTSYNCDATE")
    private DateTime lastSyncDate;
    @DatabaseField(columnName="ZFOLDER", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPLessonsFolder folder;
    @DatabaseField(columnName="ZOWNER", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPUser owner;
    @DatabaseField(columnName="ZSCENARIOSPECIFICATION", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPScenarioSpecification scenarioSpecification;
    @ForeignCollectionField
    private ForeignCollection<ILPLessonsContent> contents;
    @ForeignCollectionField
    private ForeignCollection<ILPFeedback> feedbacks;

    public ILPLessonsTask() {
    }

    public ILPLessonsTask(String string, String string2, DateTime dateTime) {
        this.taskId = string;
        this.taskAssignmentId = string2;
        this.createdAt = dateTime;
        this.receivedAt = DateTime.now();
        this.taskSyncState = LessonsTaskSyncState.LESSONS_TASK_SYNC_STATE_INCOMPLETE.getCode();
        this.state = LessonsTaskState.LESSONS_TASK_STATE_UNDEFINED.getCode();
        this.type = LessonsTaskType.LESSONS_TASK_TYPE_UNDEFINED.getCode();
        this.processingState = LessonsProcessingState.LESSONS_PROCESSING_STATE_UNDEFINED.getCode();
        this.exerciseAnswerDisplayMode = LessonsTaskExerciseAnswerDisplayMode.LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_UNDEFINED.getCode();
    }

    public boolean isOwnerCopy() {
        ILPUser iLPUser = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
        return this.owner.equals(iLPUser);
    }

    public ForeignCollection<ILPLessonsContent> getContents() {
        if (this.contents == null) {
            try {
                g.a().aU().assignEmptyForeignCollection((Object)this, "contents");
                this.contents.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for task.contents.", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.contents;
    }

    public ForeignCollection<ILPFeedback> getFeedbacks() {
        if (this.feedbacks == null) {
            try {
                g.a().aU().assignEmptyForeignCollection((Object)this, "feedbacks");
                this.feedbacks.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for task.feedbacks.", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.feedbacks;
    }

    public String getId() {
        return this.taskId;
    }

    public String getTaskAssignmentId() {
        return this.taskAssignmentId;
    }

    public LessonsTaskType getType() {
        return LessonsTaskType.get(this.type);
    }

    public void setType(Integer n2) {
        this.type = n2;
    }

    public void setType(LessonsTaskType lessonsTaskType) {
        this.type = lessonsTaskType.getCode();
    }

    public Integer getTaskSyncStateCode() {
        return this.taskSyncState;
    }

    public LessonsTaskSyncState getTaskSyncState() {
        return LessonsTaskSyncState.get(this.taskSyncState);
    }

    public void setTaskSyncState(Integer n2) {
        this.taskSyncState = n2;
    }

    public LessonsTaskState getState() {
        return LessonsTaskState.get(this.state);
    }

    public void setState(Integer n2) {
        this.state = n2;
    }

    public void setState(LessonsTaskState lessonsTaskState) {
        this.state = lessonsTaskState.getCode();
    }

    public LessonsProcessingState getProcessingState() {
        return LessonsProcessingState.get(this.processingState);
    }

    public void setProcessingState(LessonsProcessingState lessonsProcessingState) {
        this.processingState = lessonsProcessingState.getCode();
    }

    public LessonsTaskExerciseAnswerDisplayMode getExerciseAnswerDisplayMode() {
        return LessonsTaskExerciseAnswerDisplayMode.get(this.exerciseAnswerDisplayMode);
    }

    public void setExerciseAnswerDisplayMode(LessonsTaskExerciseAnswerDisplayMode lessonsTaskExerciseAnswerDisplayMode) {
        this.exerciseAnswerDisplayMode = lessonsTaskExerciseAnswerDisplayMode.getCode();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public DateTime getPublishedAt() {
        return this.publishedAt;
    }

    public void setPublishedAt(DateTime dateTime) {
        this.publishedAt = dateTime;
    }

    public void setPublishedAt(OffsetDateTime offsetDateTime) {
        this.publishedAt = d.a(offsetDateTime);
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime dateTime) {
        this.createdAt = dateTime;
    }

    public void setCreatedAt(OffsetDateTime offsetDateTime) {
        this.createdAt = d.a(offsetDateTime);
    }

    public DateTime getReceivedAt() {
        return this.receivedAt;
    }

    public void setReceivedAt(DateTime dateTime) {
        this.receivedAt = dateTime;
    }

    public DateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(DateTime dateTime) {
        this.startedAt = dateTime;
    }

    public void setStartedAt(OffsetDateTime offsetDateTime) {
        this.startedAt = d.a(offsetDateTime);
    }

    public DateTime getEstimatedAt() {
        return this.estimatedAt;
    }

    public void setEstimatedAt(DateTime dateTime) {
        this.estimatedAt = dateTime;
    }

    public void setEstimatedAt(OffsetDateTime offsetDateTime) {
        this.estimatedAt = d.a(offsetDateTime);
    }

    public DateTime getDeliveredAt() {
        return this.deliveredAt;
    }

    public void setDeliveredAt(DateTime dateTime) {
        this.deliveredAt = dateTime;
    }

    public void setDeliveredAt(OffsetDateTime offsetDateTime) {
        this.deliveredAt = d.a(offsetDateTime);
    }

    public DateTime getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public void setLastModifiedAt(DateTime dateTime) {
        this.lastModifiedAt = dateTime;
    }

    public void setLastModifiedAt(OffsetDateTime offsetDateTime) {
        this.lastModifiedAt = d.a(offsetDateTime);
    }

    public DateTime getUserSubmittedAt() {
        return this.userSubmittedAt;
    }

    public void setUserSubmittedAt(DateTime dateTime) {
        this.userSubmittedAt = dateTime;
    }

    public void setUserSubmittedAt(OffsetDateTime offsetDateTime) {
        this.userSubmittedAt = d.a(offsetDateTime);
    }

    public DateTime getLastSyncDate() {
        return this.lastSyncDate;
    }

    public void setLastSyncDate(DateTime dateTime) {
        this.lastSyncDate = dateTime;
    }

    public ILPLessonsFolder getFolder() {
        return this.folder;
    }

    public void setFolder(ILPLessonsFolder iLPLessonsFolder) {
        this.folder = iLPLessonsFolder;
    }

    public ILPUser getOwner() {
        return this.owner;
    }

    public void setOwner(ILPUser iLPUser) {
        this.owner = iLPUser;
    }

    public ILPScenarioSpecification getScenarioSpecification() {
        return this.scenarioSpecification;
    }

    public void setScenarioSpecification(ILPScenarioSpecification iLPScenarioSpecification) {
        this.scenarioSpecification = iLPScenarioSpecification;
    }

    public boolean isLearningAnalyticsEnabled() {
        return this.learningAnalyticsEnabled;
    }

    public void setLearningAnalyticsEnabled(boolean bl2) {
        this.learningAnalyticsEnabled = bl2;
    }

    public void addGroupObject(ILPGroup iLPGroup) throws SQLException {
        ILPLessonsTask_Group iLPLessonsTask_Group = new ILPLessonsTask_Group(this, iLPGroup);
        g.a().aZ().create((Object)iLPLessonsTask_Group);
    }

    @Override
    public String toString() {
        return "ILPLessonsTask [taskId=" + this.taskId + ", taskAssignmentId=" + this.taskAssignmentId + ", state=" + this.state + ", title=" + this.title + ", lastModifiedAt=" + this.lastModifiedAt + ", owner=" + this.owner + "]";
    }

    @Override
    public ILPLessonsContent getContentForModel(String string, Integer n2) {
        return f.a().a(string, (Long)n2.longValue(), this);
    }

    @Override
    public ILPLessonsTask getModel() {
        return this;
    }

    public static enum LessonsProcessingState {
        LESSONS_PROCESSING_STATE_UNDEFINED(0, "UNDEFINED"),
        LESSONS_PROCESSING_STATE_READY_TO_BE_PUBLISHED(1, "READY_TO_BE_PUBLISHED"),
        LESSONS_PROCESSING_STATE_WAITING_FOR_STUDENT(2, "WAITING_FOR_STUDENT"),
        LESSONS_PROCESSING_STATE_WAITING_FOR_TEACHER(3, "WAITING_FOR_TEACHER"),
        LESSONS_PROCESSING_STATE_ONE_WAY(4, "ONE_WAY"),
        LESSONS_PROCESSING_STATE_OPEN_FOR_ALL(5, "OPEN_FOR_ALL"),
        LESSONS_PROCESSING_STATE_COMPLETED(6, "COMPLETED");

        private static final Map<Integer, LessonsProcessingState> lookup;
        private static final Map<String, LessonsProcessingState> valueLookup;
        private String value;
        private int code;

        static {
            lookup = new HashMap<Integer, LessonsProcessingState>();
            valueLookup = new HashMap<String, LessonsProcessingState>();
            for (LessonsProcessingState lessonsProcessingState : EnumSet.allOf(LessonsProcessingState.class)) {
                lookup.put(lessonsProcessingState.getCode(), lessonsProcessingState);
                valueLookup.put(lessonsProcessingState.value, lessonsProcessingState);
            }
        }

        private LessonsProcessingState(int n3, String string2) {
            this.code = n3;
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }

        public static LessonsProcessingState get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined LessonsProcessingState code: " + n2 + ", defaulting to " + LESSONS_PROCESSING_STATE_UNDEFINED.name()));
                return LESSONS_PROCESSING_STATE_UNDEFINED;
            }
        }

        public static LessonsProcessingState get(String string) {
            try {
                return valueLookup.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined LessonsProcessingState value: " + string + ", defaulting to " + LESSONS_PROCESSING_STATE_UNDEFINED.name()));
                return LESSONS_PROCESSING_STATE_UNDEFINED;
            }
        }

        public af asICBEnum() {
            af af2 = new af();
            switch (this) {
                case LESSONS_PROCESSING_STATE_COMPLETED: {
                    af2.b(af.a.f);
                    break;
                }
                case LESSONS_PROCESSING_STATE_ONE_WAY: {
                    af2.b(af.a.d);
                    break;
                }
                case LESSONS_PROCESSING_STATE_OPEN_FOR_ALL: {
                    af2.b(af.a.e);
                    break;
                }
                case LESSONS_PROCESSING_STATE_READY_TO_BE_PUBLISHED: {
                    af2.b(af.a.a);
                    break;
                }
                case LESSONS_PROCESSING_STATE_WAITING_FOR_STUDENT: {
                    af2.b(af.a.b);
                    break;
                }
                default: {
                    af2.b(af.a.c);
                }
            }
            return af2;
        }

        public static LessonsProcessingState fromICBEnum(af af2) {
            switch (af2.a()) {
                case f: {
                    return LESSONS_PROCESSING_STATE_COMPLETED;
                }
                case d: {
                    return LESSONS_PROCESSING_STATE_ONE_WAY;
                }
                case e: {
                    return LESSONS_PROCESSING_STATE_OPEN_FOR_ALL;
                }
                case a: {
                    return LESSONS_PROCESSING_STATE_READY_TO_BE_PUBLISHED;
                }
                case b: {
                    return LESSONS_PROCESSING_STATE_WAITING_FOR_STUDENT;
                }
                case c: {
                    return LESSONS_PROCESSING_STATE_WAITING_FOR_TEACHER;
                }
            }
            return LESSONS_PROCESSING_STATE_UNDEFINED;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum LessonsTaskExerciseAnswerDisplayMode {
        LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_UNDEFINED(0, "UNDEFINED", false, false),
        LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_NONE(1, "NONE", false, false),
        LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_CORRECTION(2, "CORRECTION", true, false),
        LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_SOLUTION(3, "SOLUTION", false, true),
        LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_CORRECTION_SOLUTION(4, "CORRECTION_SOLUTION", true, true);

        private static final Map<Integer, LessonsTaskExerciseAnswerDisplayMode> lookup;
        private static final Map<String, LessonsTaskExerciseAnswerDisplayMode> valueLookup;
        private String value;
        private int code;
        private boolean isCorrectionAllowed;
        private boolean isSolutionAllowed;

        static {
            lookup = new HashMap<Integer, LessonsTaskExerciseAnswerDisplayMode>();
            valueLookup = new HashMap<String, LessonsTaskExerciseAnswerDisplayMode>();
            for (LessonsTaskExerciseAnswerDisplayMode lessonsTaskExerciseAnswerDisplayMode : EnumSet.allOf(LessonsTaskExerciseAnswerDisplayMode.class)) {
                lookup.put(lessonsTaskExerciseAnswerDisplayMode.getCode(), lessonsTaskExerciseAnswerDisplayMode);
                valueLookup.put(lessonsTaskExerciseAnswerDisplayMode.getValue(), lessonsTaskExerciseAnswerDisplayMode);
            }
        }

        private LessonsTaskExerciseAnswerDisplayMode(int n3, String string2, boolean bl2, boolean bl3) {
            this.code = n3;
            this.value = string2;
            this.isCorrectionAllowed = bl2;
            this.isSolutionAllowed = bl3;
        }

        public static LessonsTaskExerciseAnswerDisplayMode get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined lessonsTaskAnswerDisplayMode code: " + n2 + ", defaulting to " + LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_UNDEFINED.name()));
                return LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_UNDEFINED;
            }
        }

        public static LessonsTaskExerciseAnswerDisplayMode get(String string) {
            try {
                return valueLookup.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined lessonsTaskAnswerDisplayMode value: " + string + ", defaulting to " + LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_UNDEFINED.name()));
                return LESSONS_TASK_EXERCISE_ANSWER_DISPLAY_MODE_UNDEFINED;
            }
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }

        public boolean isCorrectionAllowed() {
            return this.isCorrectionAllowed;
        }

        public boolean isSolutionAllowed() {
            return this.isSolutionAllowed;
        }
    }

    public static enum LessonsTaskState {
        LESSONS_TASK_STATE_UNDEFINED(0, "UNDEFINED"),
        LESSONS_TASK_STATE_PUBLISHED(1, "PUBLISHED"),
        LESSONS_TASK_STATE_COMPLETED(2, "COMPLETED"),
        LESSONS_TASK_STATE_CANCELED(3, "CANCELED");

        private static final Map<Integer, LessonsTaskState> codeLookup;
        private static final Map<String, LessonsTaskState> valueLookup;
        private String value;
        private int code;

        static {
            codeLookup = new HashMap<Integer, LessonsTaskState>();
            valueLookup = new HashMap<String, LessonsTaskState>();
            for (LessonsTaskState lessonsTaskState : EnumSet.allOf(LessonsTaskState.class)) {
                codeLookup.put(lessonsTaskState.getCode(), lessonsTaskState);
                valueLookup.put(lessonsTaskState.value, lessonsTaskState);
            }
        }

        private LessonsTaskState(int n3, String string2) {
            this.code = n3;
            this.value = string2;
        }

        public static LessonsTaskState get(int n2) {
            try {
                return codeLookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined lessonsTaskState code: " + n2 + ", defaulting to " + LESSONS_TASK_STATE_UNDEFINED.name()));
                return LESSONS_TASK_STATE_UNDEFINED;
            }
        }

        public static LessonsTaskState get(String string) {
            try {
                return valueLookup.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined lessonsTaskState value: " + string + ", defaulting to " + LESSONS_TASK_STATE_UNDEFINED.name()));
                return LESSONS_TASK_STATE_UNDEFINED;
            }
        }

        public an.a asICBEnum() {
            switch (this) {
                case LESSONS_TASK_STATE_CANCELED: {
                    return an.a.d;
                }
                case LESSONS_TASK_STATE_COMPLETED: {
                    return an.a.c;
                }
            }
            return an.a.b;
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum LessonsTaskSyncState {
        LESSONS_TASK_SYNC_STATE_UNDEFINED(0),
        LESSONS_TASK_SYNC_STATE_OK(1),
        LESSONS_TASK_SYNC_STATE_INCOMPLETE(2);

        private static final Map<Integer, LessonsTaskSyncState> codeLookup;
        private final int code;

        static {
            codeLookup = new HashMap<Integer, LessonsTaskSyncState>();
            for (LessonsTaskSyncState lessonsTaskSyncState : EnumSet.allOf(LessonsTaskSyncState.class)) {
                codeLookup.put(lessonsTaskSyncState.getCode(), lessonsTaskSyncState);
            }
        }

        private LessonsTaskSyncState(int n3) {
            this.code = n3;
        }

        public static LessonsTaskSyncState get(int n2) {
            try {
                return codeLookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined LessonsTaskSyncState code: " + n2 + ", defaulting to " + LESSONS_TASK_SYNC_STATE_UNDEFINED.name()));
                return LESSONS_TASK_SYNC_STATE_UNDEFINED;
            }
        }

        public int getCode() {
            return this.code;
        }

        public an.b asICBEnum() {
            switch (this) {
                case LESSONS_TASK_SYNC_STATE_OK: {
                    return an.b.a;
                }
            }
            return an.b.b;
        }
    }

    public static enum LessonsTaskType {
        LESSONS_TASK_TYPE_UNDEFINED(0, "UNDEFINED"),
        LESSONS_TASK_TYPE_ONE_WAY(1, "ONE_WAY"),
        LESSONS_TASK_TYPE_INFINITE(2, "INFINITE"),
        LESSONS_TASK_TYPE_PING_PONG(3, "PING_PONG");

        private static final Map<Integer, LessonsTaskType> lookup;
        private static final Map<String, LessonsTaskType> valueLookup;
        private String value;
        private int code;

        static {
            lookup = new HashMap<Integer, LessonsTaskType>();
            valueLookup = new HashMap<String, LessonsTaskType>();
            for (LessonsTaskType lessonsTaskType : EnumSet.allOf(LessonsTaskType.class)) {
                lookup.put(lessonsTaskType.getCode(), lessonsTaskType);
                valueLookup.put(lessonsTaskType.value, lessonsTaskType);
            }
        }

        private LessonsTaskType(int n3, String string2) {
            this.code = n3;
            this.value = string2;
        }

        public static LessonsTaskType get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined lessonsTaskType code: " + n2 + ", defaulting to " + LESSONS_TASK_TYPE_UNDEFINED.name()));
                return LESSONS_TASK_TYPE_UNDEFINED;
            }
        }

        public static LessonsTaskType get(String string) {
            try {
                return valueLookup.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined lessonsTaskType value: " + string + ", defaulting to " + LESSONS_TASK_TYPE_UNDEFINED.name()));
                return LESSONS_TASK_TYPE_UNDEFINED;
            }
        }

        public an.c asICBEnum() {
            switch (this) {
                case LESSONS_TASK_TYPE_INFINITE: {
                    return an.c.b;
                }
                case LESSONS_TASK_TYPE_ONE_WAY: {
                    return an.c.a;
                }
            }
            return an.c.c;
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }
    }
}

