/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo.lms;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.book.angular.model.g;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsFolder;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.rm.a;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@DatabaseTable(tableName="ZILPLESSONSCONTENT")
public class ILPLessonsContent
extends AbstractCoreDataModel {
    private static final long serialVersionUID = 1L;
    private static ILogger logger = ILPLogManager.getLogger(ILPLessonsContent.class);
    public static final String FILE_REFERENCE_FIELD_NAME = "ZFILEREFERENCE";
    public static final String VERSION_FIELD_NAME = "ZVERSION";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String MIME_TYPE_FIELD_NAME = "ZMIMETYPE";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String TASK_FK_FIELD_NAME = "ZTASK";
    public static final String FOLDER_FK_FIELD_NAME = "ZFOLDER";
    public static final String RESOURCE_FK_FIELD_NAME = "ZRESOURCE";
    @DatabaseField(columnName="ZFILEREFERENCE", canBeNull=false, index=true)
    private String fileReference;
    @DatabaseField(columnName="ZVERSION", canBeNull=false, index=true)
    private Long version;
    @DatabaseField(columnName="ZTITLE")
    private String title;
    @DatabaseField(columnName="ZMIMETYPE")
    private String mimeType;
    @DatabaseField(columnName="ZTYPE", index=true, canBeNull=false)
    private Integer type;
    @DatabaseField(columnName="ZTASK", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPLessonsTask task;
    @DatabaseField(columnName="ZFOLDER", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPLessonsFolder folder;
    @DatabaseField(columnName="ZRESOURCE", foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, index=true)
    private ILPResource resource;

    public ILPLessonsContent() {
    }

    public ILPLessonsContent(LessonsContentModel lessonsContentModel, String string, long l2, String string2, LessonsContentType lessonsContentType, String string3) throws SQLException {
        Object object = lessonsContentModel.getModel();
        if (object instanceof ILPLessonsTask) {
            this.task = (ILPLessonsTask)object;
        } else if (object instanceof ILPLessonsFolder) {
            this.folder = (ILPLessonsFolder)object;
        }
        this.fileReference = string;
        this.version = l2;
        this.type = lessonsContentType.getCode();
        this.title = string2;
        this.mimeType = string3;
    }

    public boolean download() throws IOException, SQLException {
        return a.a().a(this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public Integer getType() {
        return this.type;
    }

    public LessonsContentType getTypeEnum() {
        return LessonsContentType.get(this.type);
    }

    public void setType(LessonsContentType lessonsContentType) {
        this.type = lessonsContentType.getCode();
    }

    public void setType(Integer n2) {
        this.type = n2;
    }

    public ILPLessonsTask getTask() {
        return this.task;
    }

    public void setTask(ILPLessonsTask iLPLessonsTask) {
        this.task = iLPLessonsTask;
    }

    public ILPResource getResource() {
        return this.resource;
    }

    public void setResource(ILPResource iLPResource) {
        this.resource = iLPResource;
    }

    public boolean isContentDownloaded() {
        try {
            g.a().H().refresh((Object)this.resource);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not refresh resource: " + this.resource), (Throwable)exception);
        }
        return this.resource != null && this.resource.isAssetDownloaded();
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getUserContentUrl() {
        if (this.getResource() == null || this.getResource().getHref() == null) {
            return null;
        }
        return String.valueOf(h.aa()) + "/" + this.getResource().getHref();
    }

    @Override
    public String toString() {
        return "ILPLessonsContent [fileReference=" + this.fileReference + ", version=" + this.version + ", title=" + this.title + ", mimeType=" + this.mimeType + ", type=" + this.type + "]";
    }

    public static interface LessonsContentModel {
        public ILPLessonsContent getContentForModel(String var1, Integer var2);

        public Object getModel();
    }

    public static enum LessonsContentType {
        LESSONS_CONTENT_TYPE_UNDEFINED(0, "SCENARIO"),
        LESSONS_CONTENT_TYPE_SCENARIO(1, "SCENARIO"),
        LESSONS_CONTENT_TYPE_VIDEO(2, "VIDEO"),
        LESSONS_CONTENT_TYPE_AUDIO(3, "AUDIO"),
        LESSONS_CONTENT_TYPE_IMAGE(4, "IMAGE"),
        LESSONS_CONTENT_TYPE_DOCUMENT(5, "DOCUMENT");

        private static final Map<Integer, LessonsContentType> codeLookup;
        private static final Map<String, LessonsContentType> valueLookup;
        private String value;
        private int code;

        static {
            codeLookup = new HashMap<Integer, LessonsContentType>();
            valueLookup = new HashMap<String, LessonsContentType>();
            for (LessonsContentType lessonsContentType : EnumSet.allOf(LessonsContentType.class)) {
                codeLookup.put(lessonsContentType.getCode(), lessonsContentType);
                valueLookup.put(lessonsContentType.value, lessonsContentType);
            }
        }

        private LessonsContentType(int n3, String string2) {
            this.code = n3;
            this.value = string2;
        }

        public static LessonsContentType get(int n2) {
            try {
                return codeLookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined lessonsContentType code: " + n2 + ", defaulting to " + LESSONS_CONTENT_TYPE_UNDEFINED.name()));
                return LESSONS_CONTENT_TYPE_UNDEFINED;
            }
        }

        public static LessonsContentType get(String string) {
            try {
                return valueLookup.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined lessonsContentType code: " + string + ", defaulting to " + LESSONS_CONTENT_TYPE_UNDEFINED.name()));
                return LESSONS_CONTENT_TYPE_UNDEFINED;
            }
        }

        public g.a asICBEnum() {
            switch (this) {
                case LESSONS_CONTENT_TYPE_AUDIO: {
                    return g.a.c;
                }
                case LESSONS_CONTENT_TYPE_IMAGE: {
                    return g.a.d;
                }
                case LESSONS_CONTENT_TYPE_SCENARIO: {
                    return g.a.a;
                }
                case LESSONS_CONTENT_TYPE_UNDEFINED: {
                    return g.a.a;
                }
                case LESSONS_CONTENT_TYPE_VIDEO: {
                    return g.a.b;
                }
                case LESSONS_CONTENT_TYPE_DOCUMENT: {
                    return g.a.e;
                }
            }
            logger.d((Object)("No ICBContentTypeEnum1 value found for " + (Object)((Object)this)));
            return g.a.e;
        }

        public String getValue() {
            return this.value;
        }

        public int getCode() {
            return this.code;
        }
    }
}

