/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPAbstractPropertyModel;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.mo.ILPAccount;
import ch.ionesoft.ilp.book.mo.ILPGroup;
import ch.ionesoft.ilp.book.mo.ILPGroup_User;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPSharingTransaction;
import ch.ionesoft.ilp.book.mo.ILPSharingTransaction_User;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPUSER")
public class ILPUser
extends ILPAbstractPropertyModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPUser.class);
    public static final String SUBJECT_FIELD_NAME = "ZSUBJECT";
    public static final String FIRSTNAME_FIELD_NAME = "ZFIRSTNAME";
    public static final String LASTNAME_FIELD_NAME = "ZLASTNAME";
    public static final String EMAIL_FIELD_NAME = "ZEMAIL";
    public static final String GENDER_FIELD_NAME = "ZGENDER";
    public static final String AVATAR_FIELD_NAME = "ZAVATAR";
    public static final String CLOUD_ID_FIELD_NAME = "ZCLOUDID";
    public static final String PUBLIC_KEY_FIELD_NAME = "ZPUBLICKEY";
    public static final String CREATION_DATE_FIELD_NAME = "ZCREATIONDATE";
    public static final String LASTUPDATE_FIELD_NAME = "ZLASTUPDATE";
    public static final String PRIVILEGE_FIELD_NAME = "ZPRIVILEGE";
    private static final String AVATAR_DEFAULT_VALUE = "a4c844";
    @DatabaseField(columnName="ZSUBJECT", canBeNull=false, index=true, unique=true)
    private String subject;
    @DatabaseField(columnName="ZFIRSTNAME", canBeNull=true)
    private String firstname;
    @DatabaseField(columnName="ZLASTNAME", canBeNull=true)
    private String lastname;
    @DatabaseField(columnName="ZEMAIL", canBeNull=true)
    private String email;
    @DatabaseField(columnName="ZGENDER", canBeNull=true)
    private String gender;
    @DatabaseField(columnName="ZAVATAR", canBeNull=true)
    private String avatar;
    @DatabaseField(columnName="ZCLOUDID", canBeNull=true)
    private String cloudID;
    @DatabaseField(columnName="ZPUBLICKEY", canBeNull=true)
    private String publicKey;
    @DatabaseField(columnName="ZPRIVILEGE", canBeNull=true, unique=true)
    private Integer privilege;
    @DatabaseField(columnName="ZCREATIONDATE", canBeNull=false)
    private DateTime creationDate;
    @DatabaseField(columnName="ZLASTUPDATE", canBeNull=true)
    private DateTime lastUpdate;
    @ForeignCollectionField(orderColumnName="ZADMIN")
    private ForeignCollection<ILPGroup> adminGroups;
    @ForeignCollectionField(orderColumnName="ZOWNER")
    private ForeignCollection<ILPSharingTransaction> ownedTransactions;
    @ForeignCollectionField(orderColumnName="ZUSER")
    private ForeignCollection<ILPScenarioSpecification> scenarioSpecifications;
    @ForeignCollectionField
    private ForeignCollection<ILPLicense> licenseUsages;
    @ForeignCollectionField
    private ForeignCollection<ILPProperty> properties;
    @ForeignCollectionField
    private ForeignCollection<ILPAccount> accounts;

    public ILPUser() {
    }

    public ILPUser(String string) {
        this.creationDate = DateTime.now();
        this.subject = string;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String string) {
        if (string != null) {
            this.avatar = string;
        } else if (this.avatar == null) {
            this.avatar = AVATAR_DEFAULT_VALUE;
        }
    }

    public String getCloudID() {
        return ILPBookSettingsHelper.instance().decryptCloudID_forUser(this.cloudID, this);
    }

    public void setCloudID(String string) {
        String string2;
        this.cloudID = string2 = ILPBookSettingsHelper.instance().encryptCloudID_forUser(string, this);
    }

    public String getEncryptedCloudID() {
        return this.cloudID;
    }

    public String getCloudIDTruncated() {
        return StringHelper.truncateCIIDsFromString((String)this.getCloudID());
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime dateTime) {
        this.creationDate = dateTime;
    }

    public String getEmail() {
        return this.email != null ? this.email : "";
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public String getEmailOrSubject() {
        return this.email != null ? this.email : (this.subject != null ? this.subject : "");
    }

    public String getFirstname() {
        return this.firstname != null ? this.firstname : "";
    }

    public void setFirstname(String string) {
        this.firstname = string;
    }

    public String getLastname() {
        return this.lastname != null ? this.lastname : "";
    }

    public void setLastname(String string) {
        this.lastname = string;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getFirstname() != null) {
            stringBuffer.append(this.getFirstname());
            stringBuffer.append(" ");
        }
        if (this.getLastname() != null) {
            stringBuffer.append(this.getLastname());
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(this.getEmail());
        }
        return stringBuffer.toString().trim();
    }

    public ForeignCollection<ILPLicense> getLicenseUsages() {
        return this.licenseUsages;
    }

    public void setLicenseUsages(ForeignCollection<ILPLicense> foreignCollection) {
        this.licenseUsages = foreignCollection;
    }

    public String getFullname() {
        if (!(!StringUtils.isNotBlank((CharSequence)this.getFirstname()) || !StringUtils.isNotBlank((CharSequence)this.getLastname()) || this.getFirstname().equals("unkonwn") && this.getLastname().equals("unknown") || this.getFirstname().equals("null") && this.getLastname().equals("null"))) {
            return String.valueOf(this.getFirstname()) + " " + this.getLastname();
        }
        return this.getEmail();
    }

    public String getFullNameSharing() {
        if (!(!StringUtils.isNotBlank((CharSequence)this.getFirstname()) || !StringUtils.isNotBlank((CharSequence)this.getLastname()) || this.getFirstname().equals("unkonwn") && this.getLastname().equals("unknown") || this.getFirstname().equals("null") && this.getLastname().equals("null"))) {
            return String.valueOf(this.getFirstname()) + " " + this.getLastname() + ", " + this.getEmail();
        }
        return this.getEmail();
    }

    public String userInitials() {
        String string = "";
        if (!StringHelper.isBlank((String)this.firstname)) {
            string = String.valueOf(string) + this.firstname.substring(0, 1).toUpperCase();
        }
        if (!StringHelper.isBlank((String)this.lastname)) {
            string = String.valueOf(string) + this.lastname.substring(0, 1).toUpperCase();
        }
        if (string.length() == 0 && !StringHelper.isBlank((String)this.getEmailOrSubject())) {
            string = String.valueOf(string) + this.getEmailOrSubject().substring(0, 1).toUpperCase();
        }
        return string;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String string) {
        this.gender = string;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(DateTime dateTime) {
        this.lastUpdate = dateTime;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String string) {
        this.publicKey = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public Integer getPrivilege() {
        return this.privilege;
    }

    public UserPrivilege getPrivilegeEnum() {
        if (this.privilege == null) {
            return null;
        }
        return UserPrivilege.get(this.privilege);
    }

    public void setPrivilege(Integer n2) {
        this.privilege = n2;
    }

    public ForeignCollection<ILPGroup> getAdminGroups() {
        if (this.adminGroups == null) {
            try {
                g.a().U().assignEmptyForeignCollection((Object)this, "adminGroups");
                this.adminGroups.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for user.adminGroups", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.adminGroups;
    }

    public void setAdminGroups(ForeignCollection<ILPGroup> foreignCollection) {
        this.adminGroups = foreignCollection;
    }

    public ForeignCollection<ILPAccount> getAccounts() {
        if (this.accounts == null) {
            try {
                g.a().U().assignEmptyForeignCollection((Object)this, "accounts");
                this.accounts.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for user.accounts", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.accounts;
    }

    public void setAccounts(ForeignCollection<ILPAccount> foreignCollection) {
        this.accounts = foreignCollection;
    }

    public ForeignCollection<ILPProperty> getProperties() {
        if (this.properties == null) {
            try {
                g.a().U().assignEmptyForeignCollection((Object)this, "properties");
                this.properties.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for user.properties", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.properties;
    }

    public void setProperties(ForeignCollection<ILPProperty> foreignCollection) {
        this.properties = foreignCollection;
    }

    public List<ILPGroup> getJoinedGroups() {
        return f.a().c(this);
    }

    public List<ILPGroup> getPendingGroups() {
        return f.a().a(this);
    }

    public ForeignCollection<ILPSharingTransaction> getOwnedTransactions() {
        if (this.ownedTransactions == null) {
            try {
                g.a().U().assignEmptyForeignCollection((Object)this, "ownedTransactions");
                this.ownedTransactions.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for user.ownedSharingTransactions", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.ownedTransactions;
    }

    public void setOwnedTransactions(ForeignCollection<ILPSharingTransaction> foreignCollection) {
        this.ownedTransactions = foreignCollection;
    }

    public ForeignCollection<ILPScenarioSpecification> getScenarioSpecifications() {
        if (this.scenarioSpecifications == null) {
            try {
                g.a().U().assignEmptyForeignCollection((Object)this, "scenarioSpecifications");
                this.scenarioSpecifications.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for user.scenarioSpecifications", (Throwable)sQLException);
            }
        }
        return this.scenarioSpecifications;
    }

    public void setScenarioSpecifications(ForeignCollection<ILPScenarioSpecification> foreignCollection) {
        this.scenarioSpecifications = foreignCollection;
    }

    public void addGroupObject(ILPGroup iLPGroup) throws SQLException {
        ILPGroup_User iLPGroup_User = new ILPGroup_User(iLPGroup, this);
        g.a().aa().create((Object)iLPGroup_User);
    }

    public void addParticipatedSharingTransactionObject(ILPSharingTransaction iLPSharingTransaction) throws SQLException {
        ILPSharingTransaction_User iLPSharingTransaction_User = new ILPSharingTransaction_User(iLPSharingTransaction, this);
        g.a().aL().create((Object)iLPSharingTransaction_User);
    }

    @Override
    public String propertyStringById_defaultValue(String string, String string2) {
        ILPProperty iLPProperty = f.a().a(this, string);
        if (iLPProperty != null) {
            return iLPProperty.getValueDecrypted();
        }
        return string2;
    }

    public ILPProperty addPropertyInDatabase(String string, String string2, h.e e2) {
        try {
            ILPProperty iLPProperty = f.a().a(this, string);
            h.b b2 = ILPProfileManager.instance().getCurrentProfile().getAssetStage();
            if (iLPProperty == null) {
                iLPProperty = new ILPProperty();
                iLPProperty.setTargetType(e2);
                iLPProperty.setAssetStageType(b2);
                iLPProperty.setKey(string);
                iLPProperty.setValue(string2);
                iLPProperty.setUser(this);
            } else if (!iLPProperty.getValue().equals(string2)) {
                iLPProperty.setValue(string2);
                if (e2.b(iLPProperty.getTargetType())) {
                    iLPProperty.setTargetType(e2);
                }
                if (b2.a(iLPProperty.getAssetStageType())) {
                    iLPProperty.setAssetStageType(b2);
                }
            }
            if (iLPProperty.notInDatabase()) {
                g.a().Q().create((Object)iLPProperty);
            } else {
                g.a().Q().update((Object)iLPProperty);
            }
            return iLPProperty;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not add property: " + string), (Throwable)exception);
            return null;
        }
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.subject == null ? 0 : this.subject.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPUser iLPUser = (ILPUser)object;
        return !(this.subject == null ? iLPUser.subject != null : !this.subject.equals(iLPUser.subject));
    }

    @Override
    public String toString() {
        return "ILPUser [Subject=" + this.subject + ", firstname=" + this.firstname + ", lastname=" + this.lastname + "]";
    }

    public static enum UserPrivilege {
        USER_PRIVILEGE_APP(0),
        USER_PRIVILEGE_SYSTEM(1);

        private int code;
        private static final Map<Integer, UserPrivilege> codeLookup;

        static {
            codeLookup = new HashMap<Integer, UserPrivilege>();
            for (UserPrivilege userPrivilege : EnumSet.allOf(UserPrivilege.class)) {
                codeLookup.put(userPrivilege.getCode(), userPrivilege);
            }
        }

        public static UserPrivilege get(int n2) {
            return codeLookup.get(n2);
        }

        private UserPrivilege(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }
    }
}

