/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.HTMLUtils;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPNote;
import ch.ionesoft.ilp.book.mo.SharingModel;
import ch.ionesoft.ilp.book.pe.f;
import java.util.ArrayList;
import java.util.List;

public class ILPTransientAggregatedNote
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPTransientAggregatedNote.class);
    private List<Integer> notePks = new ArrayList<Integer>();
    private int modelPk;
    private Integer colorIndex;
    private ILPNote.NoteType type;
    private ILPNote.ContentType contentType;
    private String title;

    public ILPTransientAggregatedNote(ILPNote iLPNote) {
        this.notePks.add(iLPNote.getPk());
        this.modelPk = iLPNote.getTopic() != null ? iLPNote.getTopic().getPk() : iLPNote.getExercise().getPk();
        if (iLPNote.getNoteType() == ILPNote.NoteType.NOTE_TYPE_SIDENOTE) {
            this.colorIndex = iLPNote.getColorIndex();
            this.title = StringHelper.truncate_toLength((String)HTMLUtils.stringByConvertingHTMLToPlainText((String)StringHelper.replaceHtmlEncodedAposWithSingleQuote((String)iLPNote.getTitle())), (int)50);
            this.contentType = iLPNote.getContentTypeEnum();
        }
        this.type = iLPNote.getNoteType();
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public ILPNote.AnnotationColor getAnnotationColor() {
        if (this.colorIndex != null) {
            return ILPNote.AnnotationColor.get(this.colorIndex);
        }
        return null;
    }

    public ILPNote.NoteType getType() {
        return this.type;
    }

    public void aggregateNote(ILPNote iLPNote) throws Exception {
        if (iLPNote == null || iLPNote.getNoteType() != this.type) {
            throw new Exception("Note type does not match! Expected " + (Object)((Object)this.type) + ", got " + (Object)((Object)iLPNote.getNoteType()));
        }
        this.notePks.add(iLPNote.getPk());
    }

    public int getModelPk() {
        return this.modelPk;
    }

    public String getTitle() {
        return this.title;
    }

    public int getNumberOfNotes() {
        return this.notePks.size();
    }

    public List<Integer> getNotePks() {
        return this.notePks;
    }

    public ILPNote.ContentType getContentType() {
        return this.contentType;
    }

    public SharingModel loadFirstNote() {
        try {
            if (this.notePks.size() > 0) {
                Integer n2 = this.notePks.get(0);
                ILPNote iLPNote = f.a().g(n2);
                return iLPNote;
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not fetch note from notePks: " + this.notePks), (Throwable)exception);
        }
        return null;
    }

    public List<ILPNote> loadNotes() {
        ArrayList<ILPNote> arrayList = new ArrayList<ILPNote>();
        try {
            if (this.notePks.size() > 0) {
                for (int n2 : this.notePks) {
                    ILPNote iLPNote = f.a().g(n2);
                    arrayList.add(iLPNote);
                }
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not fetch note from notePks: " + this.notePks), (Throwable)exception);
        }
        return arrayList;
    }

    public String getTocTitle() {
        ILPNote.NoteType noteType = this.getType();
        String string = "";
        if (noteType == ILPNote.NoteType.NOTE_TYPE_SIDENOTE) {
            return this.getTitle();
        }
        if (noteType == ILPNote.NoteType.NOTE_TYPE_HIGHLIGHT) {
            string = "label.noteMarkers";
        } else if (noteType == ILPNote.NoteType.NOTE_TYPE_ANNOTATED_IMAGE) {
            string = "label.noteImages";
        } else if (noteType == ILPNote.NoteType.NOTE_TYPE_EDITABLE_FIELD) {
            string = "label.noteEditableFields";
        }
        return String.format("%s (%d)", o.a().d(string), this.getNotePks().size());
    }

    @Override
    public String toString() {
        return "ILPTransientAggregatedNote{notePk=" + this.notePks + ", modelPk=" + this.modelPk + ", colorIndex='" + this.colorIndex + '\'' + ", type=" + (Object)((Object)this.type) + ", title='" + this.title + '\'' + '}';
    }
}

