/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPGroup;
import ch.ionesoft.ilp.book.mo.ILPPermissionDefinition;
import ch.ionesoft.ilp.book.mo.ILPQuestion;
import ch.ionesoft.ilp.book.mo.ILPSharing;
import ch.ionesoft.ilp.book.mo.ILPSharingTransaction_Group;
import ch.ionesoft.ilp.book.mo.ILPSharingTransaction_User;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPSHARINGTRANSACTION")
public class ILPSharingTransaction
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPSharingTransaction.class);
    public static final String TABLE_NAME = "ZILPSHARINGTRANSACTION";
    public static final String OWNER_FK_FIELD_NAME = "ZOWNER";
    public static final String CREATION_DATE_NAME = "ZCREATIONDATE";
    public static final String TITLE_NAME = "ZTITLE";
    public static final String TEXT_NAME = "ZTEXT";
    public static final String TRANSACTION_ID_NAME = "ZTRANSACTIONID";
    public static final String TRANSACTION_STATE_NAME = "ZTRANSACTIONSTATE";
    @DatabaseField(columnName="ZTRANSACTIONID", canBeNull=false, index=true)
    private String transactionID;
    @DatabaseField(columnName="ZCREATIONDATE", canBeNull=false)
    private DateTime creationDate;
    @DatabaseField(columnName="ZTITLE", canBeNull=true)
    private String title;
    @DatabaseField(columnName="ZTEXT", canBeNull=true)
    private String text;
    @DatabaseField(columnName="ZTRANSACTIONSTATE", canBeNull=true)
    private Integer transactionStateType;
    @ForeignCollectionField(orderColumnName="ZCREATIONDATE")
    private ForeignCollection<ILPSharing> sharings;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZOWNER", index=true)
    private ILPUser owner;

    public ILPSharingTransaction() {
    }

    public ILPSharingTransaction(String string, DateTime dateTime) throws IllegalArgumentException {
        if (string.contains(":")) {
            throw new IllegalArgumentException("Invalid character \":\" in transaction id: " + string);
        }
        this.transactionID = string;
        this.creationDate = dateTime;
    }

    public ForeignCollection<ILPSharing> getSharings() {
        if (this.sharings == null) {
            try {
                g.a().S().assignEmptyForeignCollection((Object)this, "sharings");
                this.sharings.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for sharings", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.sharings;
    }

    public void setSharings(ForeignCollection<ILPSharing> foreignCollection) {
        this.sharings = foreignCollection;
    }

    public void addSharingsObject(ILPSharing iLPSharing) {
        this.getSharings().add((Object)iLPSharing);
    }

    public void removeSharingsObject(ILPSharing iLPSharing) {
        this.getSharings().remove((Object)iLPSharing);
    }

    public void addUserObject(ILPUser iLPUser) throws SQLException {
        ILPSharingTransaction_User iLPSharingTransaction_User = new ILPSharingTransaction_User(this, iLPUser);
        g.a().aL().create((Object)iLPSharingTransaction_User);
    }

    public void addGroupObject(ILPGroup iLPGroup) throws SQLException {
        ILPSharingTransaction_Group iLPSharingTransaction_Group = new ILPSharingTransaction_Group(this, iLPGroup);
        g.a().aK().createIfNotExists((Object)iLPSharingTransaction_Group);
    }

    public void setGroupObjects(List<ILPGroup> list) throws SQLException {
        List<ILPGroup> list2 = f.a().a(this);
        for (ILPGroup iLPGroup : list) {
            ILPSharingTransaction_Group iLPSharingTransaction_Group = new ILPSharingTransaction_Group(this, iLPGroup);
            g.a().aK().createIfNotExists((Object)iLPSharingTransaction_Group);
            list2.remove(iLPGroup);
        }
        for (ILPGroup iLPGroup : list2) {
            f.a().j(iLPGroup.getPk());
        }
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public void setTransactionID(String string) {
        if (string.contains(":")) {
            throw new IllegalArgumentException("Invalid character \":\" in transaction id: " + string);
        }
        this.transactionID = string;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime dateTime) {
        this.creationDate = dateTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public ILPUser getOwner() {
        return this.owner;
    }

    public void setOwner(ILPUser iLPUser) {
        this.owner = iLPUser;
    }

    public List<ILPGroup> getGroups() {
        return f.a().a(this);
    }

    public List<ILPCourseDef> getGrantedCourses() {
        return f.a().b(this);
    }

    public Integer getNumberOfUserTopics() {
        int n2 = 0;
        for (ILPSharing iLPSharing : this.sharings) {
            if (iLPSharing.getTopic() == null) continue;
            ++n2;
        }
        return n2;
    }

    public Integer getNumberOfNotes() {
        int n2 = 0;
        for (ILPSharing iLPSharing : this.sharings) {
            if (iLPSharing.getNote() == null) continue;
            ++n2;
        }
        return n2;
    }

    public Integer getNumberOfAnswers() {
        int n2 = 0;
        for (ILPSharing iLPSharing : this.sharings) {
            if (iLPSharing.getAnswer() == null) continue;
            ++n2;
        }
        return n2;
    }

    public Integer getNumberOfScenarios() {
        int n2 = 0;
        for (ILPSharing iLPSharing : this.sharings) {
            if (iLPSharing.getScenarioSpecification() == null) continue;
            ++n2;
        }
        return n2;
    }

    public Integer getNumberOfPermissionDefinitions() {
        int n2 = 0;
        for (ILPSharing iLPSharing : this.sharings) {
            if (iLPSharing.getPermissionDefinition() == null) continue;
            ++n2;
        }
        return n2;
    }

    public Integer getDataSize() {
        return -1;
    }

    public TransactionDirectionType getTransactionType() {
        ILPUser iLPUser = ILPBookRegistry.instance().getCurrentUser();
        if (iLPUser == null) {
            return TransactionDirectionType.TRANSACTION_DIRECTION_UNKNOWN;
        }
        if (iLPUser.equals(this.owner)) {
            return TransactionDirectionType.TRANSACTION_DIRECTION_OUT;
        }
        return TransactionDirectionType.TRANSACTION_DIRECTION_IN;
    }

    public TransactionState getTransactionState() {
        return TransactionState.get(this.transactionStateType);
    }

    public Integer getTransactionStateType() {
        return this.transactionStateType;
    }

    public void setTransactionState(TransactionState transactionState) {
        this.transactionStateType = transactionState.getCode();
    }

    public List<ILPAnswer> getSharedAnswers(ILPExercise iLPExercise) {
        ArrayList<ILPAnswer> arrayList = new ArrayList<ILPAnswer>();
        for (ILPSharing iLPSharing : this.sharings) {
            ILPAnswer iLPAnswer = iLPSharing.getAnswer();
            if (iLPAnswer == null || iLPAnswer.getQuestion() == null || !iLPExercise.equals(iLPAnswer.getQuestion().getExercise())) continue;
            arrayList.add(iLPAnswer);
        }
        return arrayList;
    }

    public ILPAnswer getSharedAnswerForQuestion(ILPQuestion iLPQuestion) {
        for (ILPSharing iLPSharing : this.sharings) {
            ILPAnswer iLPAnswer = iLPSharing.getAnswer();
            if (iLPAnswer == null || iLPAnswer.getAnswerType() != ILPAnswer.AnswerType.ANSWER_TYPE_SHARED || !iLPQuestion.equals(iLPAnswer.getQuestion())) continue;
            return iLPAnswer;
        }
        return null;
    }

    public String displayName() {
        return String.valueOf(this.title) + " | " + ConverterUtil.formatShortDate((Date)this.creationDate.toDate());
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.getTransactionID() == null ? 0 : this.getTransactionID().hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPSharingTransaction iLPSharingTransaction = (ILPSharingTransaction)object;
        return !(this.getTransactionID() == null ? iLPSharingTransaction.getTransactionID() != null : !this.getTransactionID().equals(iLPSharingTransaction.getTransactionID()));
    }

    @Override
    public String toString() {
        return "ILPSharingTransaction [title=" + this.getTitle() + ", transactionID=" + this.getTransactionID() + "]";
    }

    public List<ILPPermissionDefinition> getAllPermissionDefinitions() throws SQLException {
        return f.a().c(this);
    }

    public static enum TransactionDirectionType {
        TRANSACTION_DIRECTION_UNKNOWN("unknown", ""),
        TRANSACTION_DIRECTION_IN("in", "transactionIn"),
        TRANSACTION_DIRECTION_OUT("out", "transactionOut");

        private String localizable;
        private String cssClass;

        private TransactionDirectionType(String string2, String string3) {
            this.localizable = string2;
            this.cssClass = string3;
        }

        public String getLocalizable() {
            return o.a().d(this.localizable);
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }

    public static enum TransactionState {
        TRANSACTION_STATE_UNKNOWN(0, "sharing.label.transaction.state.unknown", "statusSharingUnknown"),
        TRANSACTION_STATE_UNSENT(1, "sharing.label.transaction.state.unsent", "statusSharingUnknown"),
        TRANSACTION_STATE_SENT(2, "sharing.label.transaction.state.sent", "statusSharingAccepted"),
        TRANSACTION_STATE_DENIED(3, "sharing.label.transaction.state.denied", "statusSharingRejected"),
        TRANSACTION_STATE_IMPORTED(4, "sharing.label.transaction.state.imported", "statusSharingAccepted"),
        TRANSACTION_STATE_MISSING_ACCEPT(5, "sharing.label.transaction.state.missingAccept", "statusSharingPartiallyAccepted"),
        TRANSACTION_STATE_MISSING_COURSE(6, "sharing.label.transaction.state.missingCourse", "statusSharingPartiallyAccepted"),
        TRANSACTION_STATE_DELETED(7, "sharing.label.transaction.state.deleted", "statusSharingUnknown"),
        TRANSACTION_STATE_RECEIVED(8, "sharing.label.transaction.state.received", "statusSharingPartiallyAccepted");

        private int code;
        private String localizable;
        private String cssClass;
        private static final Map<Integer, TransactionState> lookup;

        static {
            lookup = new HashMap<Integer, TransactionState>();
            for (TransactionState transactionState : EnumSet.allOf(TransactionState.class)) {
                lookup.put(transactionState.getCode(), transactionState);
            }
        }

        private TransactionState(int n3, String string2, String string3) {
            this.code = n3;
            this.localizable = string2;
            this.cssClass = string3;
        }

        public String getLocalizable() {
            return o.a().d(this.localizable);
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public int getCode() {
            return this.code;
        }

        public static TransactionState get(int n2) {
            return lookup.get(n2);
        }

        public static TransactionState get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }
}

