/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPNote;
import ch.ionesoft.ilp.book.mo.ILPPermissionDefinition;
import ch.ionesoft.ilp.book.mo.ILPPermissionTypeDefinition;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPSharingTransaction;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.mo.SharingModel;
import ch.ionesoft.ilp.book.pe.f;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.UUID;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPSHARING")
public class ILPSharing
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPSharing.class);
    public static final String TABLE_NAME = "ZILPSHARING";
    public static final String CREATION_DATE_FIELD_NAME = "ZCREATIONDATE";
    public static final String LASTUPDATE_NAME = "ZLASTUPDATE";
    public static final String SHARING_DELETED_NAME = "ZSHARINGDELETED";
    public static final String SHARING_ID_NAME = "ZSHARINGID";
    public static final String ANSWER_FK_FIELD_NAME = "ZANSWER";
    public static final String GROUP_FK_FIELD_NAME = "ZGROUP";
    public static final String NOTE_FK_FIELD_NAME = "ZNOTE";
    public static final String TOPIC_FK_FIELD_NAME = "ZTOPIC";
    public static final String USER_FK_FIELD_NAME = "ZUSER";
    public static final String SCENARIO_SPECIFICATION_FK_FIELD_NAME = "ZSCENARIOSPECIFICATION";
    public static final String PERMISSION_DEFINITION_FK_FIELD_NAME = "ZPERMISSIONDEFINITION";
    public static final String SHARING_TRANSACTION_FK_FIELD_NAME = "ZSHARINGTRANSACTION";
    public static final String COURSE_PRODUCT_FK_FIELD_NAME = "ZCOURSEPRODUCT";
    @DatabaseField(columnName="ZCREATIONDATE", canBeNull=false)
    private DateTime creationDate;
    @DatabaseField(columnName="ZLASTUPDATE", canBeNull=true)
    private DateTime lastUpdate;
    @DatabaseField(columnName="ZSHARINGDELETED", canBeNull=true)
    private boolean sharingDeleted;
    @DatabaseField(columnName="ZSHARINGID", canBeNull=false, index=true)
    private String sharingID;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZANSWER", index=true)
    private ILPAnswer answer;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZNOTE", index=true)
    private ILPNote note;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZTOPIC", index=true)
    private ILPTopic topic;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZSCENARIOSPECIFICATION", index=true)
    private ILPScenarioSpecification scenarioSpecification;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZPERMISSIONDEFINITION", index=true)
    private ILPPermissionDefinition permissionDefinition;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZSHARINGTRANSACTION", index=true)
    private ILPSharingTransaction sharingTransaction;

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime dateTime) {
        this.creationDate = dateTime;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(DateTime dateTime) {
        this.lastUpdate = dateTime;
    }

    public boolean getSharingDeleted() {
        return this.sharingDeleted;
    }

    public void setSharingDeleted(boolean bl2) {
        this.sharingDeleted = bl2;
    }

    public String getSharingID() {
        return this.sharingID;
    }

    public void setSharingID(String string) {
        this.sharingID = string;
    }

    public ILPAnswer getAnswer() {
        return this.answer;
    }

    public void setAnswer(ILPAnswer iLPAnswer) {
        this.answer = iLPAnswer;
    }

    public ILPNote getNote() {
        return this.note;
    }

    public void setNote(ILPNote iLPNote) {
        this.note = iLPNote;
    }

    public ILPTopic getTopic() {
        return this.topic;
    }

    public void setTopic(ILPTopic iLPTopic) {
        this.topic = iLPTopic;
    }

    public ILPScenarioSpecification getScenarioSpecification() {
        return this.scenarioSpecification;
    }

    public void setScenarioSpecification(ILPScenarioSpecification iLPScenarioSpecification) {
        this.scenarioSpecification = iLPScenarioSpecification;
    }

    public ILPPermissionDefinition getPermissionDefinition() {
        return this.permissionDefinition;
    }

    public void setPermissionDefinition(ILPPermissionDefinition iLPPermissionDefinition) {
        this.permissionDefinition = iLPPermissionDefinition;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.sharingID == null ? 0 : this.sharingID.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPSharing iLPSharing = (ILPSharing)object;
        return !(this.sharingID == null ? iLPSharing.sharingID != null : !this.sharingID.equals(iLPSharing.sharingID));
    }

    @Override
    public String toString() {
        return "ILPSharing [sharingID=" + this.sharingID + "]";
    }

    public static String newSharingID() {
        return UUID.randomUUID().toString().toUpperCase();
    }

    public ILPSharingTransaction getSharingTransaction() {
        return this.sharingTransaction;
    }

    public void setSharingTransaction(ILPSharingTransaction iLPSharingTransaction) {
        this.sharingTransaction = iLPSharingTransaction;
    }

    public String getCourseTitle() {
        try {
            if (this.getPermissionDefinition() != null && this.getPermissionDefinition().getPermissionTypeDefinition().getScopeTypeEnum() == ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_PRODUCTREFERENCE) {
                String string = this.getPermissionDefinition().getPermissionScopeValue();
                ILPEProduct iLPEProduct = f.a().M(string);
                if (iLPEProduct.isCourseProduct()) {
                    return iLPEProduct.getCourseProduct().getTitle();
                }
                if (iLPEProduct.isIssueProduct()) {
                    return iLPEProduct.getIssueProduct().getTitle();
                }
            }
            return this.getCourse() != null ? this.getCourse().getTitle() : "";
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get courseTitle from sharing. " + this), (Throwable)exception);
            return "";
        }
    }

    public ILPCourseDef getCourse() {
        if (this.getIssue() != null) {
            return this.getIssue().getCourse();
        }
        return null;
    }

    public ILPIssueDef getIssue() {
        if (this.getNote() != null) {
            return this.getNote().getIssue();
        }
        if (this.getTopic() != null) {
            return this.getTopic().getIssue();
        }
        if (this.getAnswer() != null) {
            return this.getAnswer().getQuestion().getExercise().getIssue();
        }
        if (this.getPermissionDefinition() != null && this.getPermissionDefinition().getExercise() != null) {
            return this.getPermissionDefinition().getExercise().getIssue();
        }
        return null;
    }

    public String getTitle() {
        block12: {
            block13: {
                ILPEProduct iLPEProduct;
                block14: {
                    try {
                        if (this.getTopic() != null) {
                            return this.getTopic().getTitle();
                        }
                        if (this.getNote() != null) {
                            return this.getNote().getAnyTitle();
                        }
                        if (this.getAnswer() != null) {
                            return String.valueOf(o.a().d("sharing.label.answer")) + ": " + this.answer.getQuestion().getExercise().getTitle();
                        }
                        if (this.getScenarioSpecification() != null) {
                            return this.getScenarioSpecification().getName();
                        }
                        if (this.getPermissionDefinition() == null) break block12;
                        if (this.getPermissionDefinition().getExercise() != null) {
                            if (this.getPermissionDefinition().getExercise().getNodeId() != null) {
                                String string = this.getPermissionDefinition().getExercise().getTitle();
                                if (StringHelper.isBlank((String)string)) {
                                    string = this.getPermissionDefinition().getExercise().getExerciseId();
                                }
                                string = StringHelper.truncate_toLength((String)string, (int)25);
                                return String.valueOf(string) + ", " + o.a().d("label.toolitem.node") + ": " + this.getPermissionDefinition().getExercise().getNodeId();
                            }
                            return String.valueOf(this.getPermissionDefinition().getExercise().getTitle()) + ", " + this.getPermissionDefinition().getExercise().getReference();
                        }
                        if (this.getPermissionDefinition().getPermissionTypeDefinition().getScopeTypeEnum() != ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_PRODUCTREFERENCE) break block13;
                        iLPEProduct = f.a().M(this.getPermissionDefinition().getPermissionScopeValue());
                        if (iLPEProduct != null) break block14;
                        logger.c((Object)("No eProduct found with productReference in permissionScopeValue: " + this.getPermissionDefinition()));
                        return "";
                    }
                    catch (Exception exception) {
                        logger.d((Object)("Could not determine title of sharing: " + this), (Throwable)exception);
                        return "";
                    }
                }
                if (iLPEProduct.isCourseProduct()) {
                    return o.a().d("label.sharing.whole.ebook");
                }
                if (iLPEProduct.isIssueProduct()) {
                    return String.valueOf(o.a().d("label.sharing.whole.issue")) + " " + iLPEProduct.getIssueProduct().getTitle();
                }
                return iLPEProduct.getTitle();
            }
            return "";
        }
        return "";
    }

    public SharedModelType getSharedModelType() {
        if (this.getNote() != null) {
            return SharedModelType.SHARED_MODEL_TYPE_NOTE;
        }
        if (this.getTopic() != null) {
            return SharedModelType.SHARED_MODEL_TYPE_USER_TOPIC;
        }
        if (this.getAnswer() != null) {
            return SharedModelType.SHARED_MODEL_TYPE_ANSWER;
        }
        if (this.getScenarioSpecification() != null) {
            return SharedModelType.SHARED_MODEL_TYPE_SCENARIO;
        }
        if (this.getPermissionDefinition() != null) {
            return SharedModelType.SHARED_MODEL_TYPE_PERMISSION_DEFINITION;
        }
        return SharedModelType.SHARED_MODEL_TYPE_UNKNOWN;
    }

    public SharingModel getSharedModel() {
        if (this.getNote() != null) {
            return this.getNote();
        }
        if (this.getTopic() != null) {
            return this.getTopic();
        }
        if (this.getAnswer() != null) {
            return this.getAnswer();
        }
        if (this.getScenarioSpecification() != null) {
            return this.getScenarioSpecification();
        }
        if (this.getPermissionDefinition() != null) {
            return this.getPermissionDefinition();
        }
        return null;
    }

    public void setSharedModel(SharingModel sharingModel) {
        if (sharingModel instanceof ILPTopic) {
            this.setTopic((ILPTopic)sharingModel);
        } else if (sharingModel instanceof ILPAnswer) {
            this.setAnswer((ILPAnswer)sharingModel);
        } else if (sharingModel instanceof ILPNote) {
            this.setNote((ILPNote)sharingModel);
        } else if (sharingModel instanceof ILPScenarioSpecification) {
            this.setScenarioSpecification((ILPScenarioSpecification)sharingModel);
        } else if (sharingModel instanceof ILPPermissionDefinition) {
            this.setPermissionDefinition((ILPPermissionDefinition)sharingModel);
        } else {
            logger.c((Object)("Unsupported sharing model class found: " + sharingModel.getClass().getSimpleName()));
        }
    }

    public static enum SharedModelType {
        SHARED_MODEL_TYPE_UNKNOWN("unknown", ""),
        SHARED_MODEL_TYPE_USER_TOPIC("userTopic", "userTopic"),
        SHARED_MODEL_TYPE_NOTE("note", "note"),
        SHARED_MODEL_TYPE_ANSWER("answer", "exercise"),
        SHARED_MODEL_TYPE_SCENARIO("scenario", "scenario"),
        SHARED_MODEL_TYPE_PERMISSION_DEFINITION("permissionDefinition", "permissionDefinition");

        private String localizable;
        private String cssClass;

        private SharedModelType(String string2, String string3) {
            this.localizable = string2;
            this.cssClass = string3;
        }

        public String getLocalizable() {
            return o.a().d(this.localizable);
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }
}

