/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.mo.AbstractSharingModel;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition;
import ch.ionesoft.ilp.book.mo.ILPSharing;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.mo.SharingModel;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.scenario.ILPScenarioManager;
import ch.ionesoft.ilp.book.syn.im.j;
import ch.ionesoft.ilp.book.syn.im.k;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.ArrayUtils;
import org.joda.time.DateTime;
import org.json.ionesoft.f;
import org.json.ionesoft.i;

@DatabaseTable(tableName="ZILPSCENARIOSPECIFICATION")
public class ILPScenarioSpecification
extends AbstractSharingModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPScenarioSpecification.class);
    public static final int SPECIFICATION_VERSION_LEGACY = 1;
    public static final int SPECIFICATION_VERSION_TASK = 2;
    public static final String BASE_COMMAND_DEF_PK_PLACEHOLDER = "${definitionPk}";
    private static final String JSON_KEY_SPECIFICATION_PK = "specificationPk";
    private static final String JSON_KEY_SPECIFICATION_NAME = "name";
    private static final String JSON_KEY_SPECIFICATION_DESCRIPTION = "description";
    private static final String JSON_KEY_DEFINITION_PK = "definitionPk";
    private static final String JSON_KEY_DEFINITION_DURATION = "duration";
    private static final String JSON_KEY_DEFINITION_ELEMENTS_TOTAL = "elementsSize";
    private static final String JSON_KEY_START_COMMAND = "startCommand";
    public static final String SCENARIO_FILE_PREFIX = "scenario_";
    public static final String TABLE_NAME = "ZILPSCENARIOSPECIFICATION";
    public static final String ID_FIELD_NAME = "ZID";
    public static final String NAME_FIELD_NAME = "ZNAME";
    public static final String DESCRIPTION_FIELD_NAME = "ZDESCRIPTION";
    public static final String AUTOCREATE_FIELD_NAME = "ZAUTOCREATE";
    public static final String ACTIVE_FIELD_NAME = "ZACTIVE";
    public static final String PROPERTY_FIELD_NAME = "ZPROPERTY";
    public static final String DELETED_FIELD_NAME = "ZDELETED";
    public static final String VERSION_FIELD_NAME = "ZVERSION";
    public static final String REQUIRE_ALL_ELEMENTS_FIELD_NAME = "ZREQUIREALLELEMENTS";
    public static final String CREATION_DATE_FIELD_NAME = "ZCREATIONDATE";
    public static final String LASTSYNC_FIELD_NAME = "ZLASTSYNC";
    public static final String TOUCHDATE_FIELD_NAME = "ZTOUCHDATE";
    public static final String COURSEDEF_FK_FIELD_NAME = "ZCOURSEDEF";
    public static final String USER_FK_FIELD_NAME = "ZUSER";
    public static final String RESOURCE_FK_FIELD_NAME = "ZRESOURCE";
    public static final String SCENARIO_DEFINITION_FK_FIELD_NAME = "ZDEFINITION";
    public static final String TASK_FK_FIELD_NAME = "ZTASK";
    @DatabaseField(columnName="ZID", canBeNull=false, index=true)
    private String id;
    @DatabaseField(columnName="ZNAME", canBeNull=false, index=true)
    private String name;
    @DatabaseField(columnName="ZDESCRIPTION")
    private String description;
    @DatabaseField(columnName="ZAUTOCREATE")
    private Boolean autoCreate = true;
    @DatabaseField(columnName="ZACTIVE")
    private Boolean active = true;
    @DatabaseField(columnName="ZDELETED")
    private Boolean deleted = false;
    @DatabaseField(columnName="ZCREATIONDATE")
    private DateTime creationDate;
    @DatabaseField(columnName="ZPROPERTY", canBeNull=true)
    private String property;
    @DatabaseField(columnName="ZVERSION", canBeNull=true)
    private Integer version;
    @DatabaseField(columnName="ZREQUIREALLELEMENTS")
    private Boolean requireAllElements;
    @DatabaseField(columnName="ZTOUCHDATE", canBeNull=true, index=true)
    private DateTime touchDate;
    @DatabaseField(columnName="ZLASTSYNC", canBeNull=true)
    private DateTime lastSync;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZCOURSEDEF", index=true)
    private ILPCourseDef courseDef;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZUSER", index=true)
    private ILPUser user;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZRESOURCE", index=true)
    private ILPResource resource;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZDEFINITION", index=true)
    private ILPScenarioDefinition scenarioDefinition;
    @DatabaseField(columnName="ZTASK", foreign=true, foreignAutoRefresh=true, index=true)
    private ILPLessonsTask task;
    private SpecificationType type;
    private ScenarioCommunicationService communicationService;
    private Map<ScenarioTriggerPoint, Set<ScenarioTriggerAction>> trigger;

    public ILPScenarioSpecification() {
        this.id = UUID.randomUUID().toString();
        this.user = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
    }

    public ILPScenarioSpecification(String string, ILPUser iLPUser) {
        this.id = string;
        this.user = iLPUser;
    }

    public ILPScenarioSpecification(String string, ILPCourseDef iLPCourseDef) {
        this.id = string;
        this.courseDef = iLPCourseDef;
    }

    public ILPScenarioDefinition.ScenarioOwner getOwnedBy() {
        if (this.getUser() != null && this.getUser().equals(ILPProfileManager.instance().getCurrentProfile().getCurrentUser())) {
            return ILPScenarioDefinition.ScenarioOwner.SCENARIO_OWNER_USER;
        }
        if (this.getSharingTypeEnum() == SharingModel.SharingType.SHARING_TYPE_RECEIVED) {
            return ILPScenarioDefinition.ScenarioOwner.SCENARIO_OWNER_SHARING_RECEIVED;
        }
        if (this.getCourseDef() != null) {
            return ILPScenarioDefinition.ScenarioOwner.SCENARIO_OWNER_EBOOK;
        }
        return ILPScenarioDefinition.ScenarioOwner.SCENARIO_OWNER_UNDEFINED;
    }

    public List<ILPScenarioRequirement> getRequirements() {
        if (!this.isLoaded()) {
            j j2 = new j();
            if (this.resource != null) {
                return j2.b(this.resource.getData());
            }
            return j2.c(new File(this.getLocalFilePath()));
        }
        return new ArrayList<ILPScenarioRequirement>();
    }

    public boolean hasRequirementsInstalled() {
        j j2 = new j();
        if (this.resource != null) {
            return j2.a(this.resource.getData());
        }
        File file = new File(this.getLocalFilePath());
        if (file != null && file.exists()) {
            return j2.a(file);
        }
        return true;
    }

    public boolean hasRequirementsInstalledForScenarioPlayer() {
        try {
            g.a().H().refresh((Object)this.resource);
            k k2 = new k();
            k2.a(true);
            if (this.resource != null && this.resource.getData() != null) {
                return k2.a(this.resource.getData());
            }
            File file = new File(this.getLocalFilePathForLerneinheitXML());
            if (file != null && file.exists()) {
                return k2.a(file);
            }
            return true;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not check if specification has requirements installed, specification: " + this), (Throwable)exception);
            return false;
        }
    }

    public boolean importScenarioSpecification() {
        try {
            j j2 = new j();
            if (this.resource != null) {
                j2.a(this.resource.getData(), true, false);
            } else {
                j2.a(new File(this.getLocalFilePath()), true);
            }
            if (this.isLoaded() && this.getScenarioDefinition().getType() == ILPScenarioDefinition.ScenarioType.SCENARIO_TYPE_DYNAMIC) {
                ILPScenarioManager.getInstance().buildDynamicScenarioElements(this);
            }
            logger.b((Object)("Successfully imported scenarioSpecification: " + this));
            return true;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not import scenarioSpecification: " + this), (Throwable)exception);
            return false;
        }
    }

    public boolean importScenarioSpecificationForScenarioPlayer() {
        try {
            g.a().H().refresh((Object)this.resource);
            k k2 = new k();
            k2.a(true);
            k2.a(new File(this.getLocalFilePathForLerneinheitXML()), this.getTask());
            logger.b((Object)("Successfully imported scenarioSpecification: " + this));
            return true;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not import scenarioSpecification: " + this), (Throwable)exception);
            return false;
        }
    }

    public ILPCourseProduct fetchReferencedCourseFromScenarioElementWithId(String string) {
        try {
            g.a().H().refresh((Object)this.resource);
            k k2 = new k();
            k2.a(true);
            return k2.a(new File(this.getLocalFilePathForLerneinheitXML()), string);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not fetch referenced course for element with id: " + string), (Throwable)exception);
            return null;
        }
    }

    public boolean isLoaded() {
        return this.getScenarioDefinition() != null;
    }

    public boolean allElementsLoaded() {
        return !ch.ionesoft.ilp.book.pe.f.a().a(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getSpecificationIdFromTaskScenario() {
        if (this.task == null) {
            return this.getId();
        }
        String string = this.getId();
        return string.substring(string.lastIndexOf("_") + 1);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Boolean getAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(Boolean bl2) {
        this.autoCreate = bl2;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean bl2) {
        this.active = bl2;
    }

    public ILPCourseDef getCourseDef() {
        return this.courseDef;
    }

    public void setCourseDef(ILPCourseDef iLPCourseDef) {
        this.courseDef = iLPCourseDef;
    }

    public ILPUser getUser() {
        return this.user;
    }

    public void setUser(ILPUser iLPUser) {
        this.user = iLPUser;
    }

    public ILPResource getResource() {
        return this.resource;
    }

    public void setResource(ILPResource iLPResource) {
        this.resource = iLPResource;
    }

    public ILPScenarioDefinition getScenarioDefinition() {
        return this.scenarioDefinition;
    }

    public void setScenarioDefinition(ILPScenarioDefinition iLPScenarioDefinition) {
        this.scenarioDefinition = iLPScenarioDefinition;
    }

    public DateTime getTouchDate() {
        return this.touchDate;
    }

    public void setTouchDate(DateTime dateTime) {
        this.touchDate = dateTime;
    }

    public DateTime getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(DateTime dateTime) {
        this.lastSync = dateTime;
    }

    public void setLastSync(Date date) {
        this.lastSync = date != null ? new DateTime((Object)date) : null;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean bl2) {
        this.deleted = bl2;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime dateTime) {
        this.creationDate = dateTime;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date != null ? new DateTime((Object)date) : null;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public ILPLessonsTask getTask() {
        return this.task;
    }

    public void setTask(ILPLessonsTask iLPLessonsTask) {
        this.task = iLPLessonsTask;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer n2) {
        this.version = n2;
    }

    public void setSpecificationVersionLegacy() {
        this.setVersion(1);
    }

    public void setSpecificationVersionForTaskScenario() {
        this.setVersion(2);
    }

    public Boolean isRequireAllElements() {
        return this.requireAllElements;
    }

    public void setRequireAllElements(Boolean bl2) {
        this.requireAllElements = bl2;
    }

    public boolean isETest() {
        try {
            return this.getCourseDef() != null && this.getCourseDef().propertyBooleanWithName_defaultValue("eTest", false);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not check if specification referenced course has eTest property. " + this), (Throwable)exception);
            return false;
        }
    }

    public void touchScenarioSpecification() {
        this.setTouchDate(new DateTime());
    }

    public void touchAndStore() {
        this.touchScenarioSpecification();
        this.store();
    }

    public void store() {
        try {
            g.a().aM().createOrUpdate((Object)this);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not create or update scenario specification: " + this), (Throwable)sQLException);
        }
    }

    public String getFileName() {
        return SCENARIO_FILE_PREFIX + this.id + ".xml";
    }

    public String getLocalFilePath() {
        if (this.resource == null || this.resource.getHref() == null || this.getTask() != null) {
            return new File(h.R(), this.getFileName()).getAbsolutePath();
        }
        if (this.resource.getAbsolutPath() != null) {
            return this.resource.getAbsolutPath().getAbsolutePath();
        }
        return null;
    }

    public String getLocalFilePathV2() {
        return new File(h.S(), this.getFileName()).getAbsolutePath();
    }

    public String getLocalFilePathForLerneinheitXML() {
        if (this.getTask() == null) {
            throw new NotImplementedException("ILPLessonsTask is null. This indicates that this is not an xml from lessons. Use getLocalFilePath() instead. ");
        }
        if (this.resource.getAbsolutPath() != null) {
            return this.resource.getAbsolutPath().getAbsolutePath();
        }
        return null;
    }

    public String getRelativeFilePath() {
        if (this.resource == null || this.resource.getHref() == null || this.getTask() != null) {
            return "synch/scenarios/" + this.getFileName();
        }
        return this.resource.getHref();
    }

    public String getRelativeFilePathV2() {
        return "synch/scenariosV2/" + this.getFileName();
    }

    @Override
    public ForeignCollection<ILPSharing> getSharings() {
        if (this.sharings == null) {
            try {
                g.a().aM().assignEmptyForeignCollection((Object)this, "sharings");
                this.sharings.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for sharings", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.sharings;
    }

    private void parsePropertyJSON() {
        block7: {
            try {
                if (this.getProperty() == null) {
                    return;
                }
                this.type = null;
                this.communicationService = null;
                this.trigger = null;
                i i2 = new i(this.getProperty());
                SpecificationType specificationType = SpecificationType.get(i2.a("type", "0"));
                this.setSpecificationType(specificationType);
                ScenarioCommunicationService scenarioCommunicationService = ScenarioCommunicationService.get(i2.a("communicationService", "0"));
                this.setCommunicationService(scenarioCommunicationService);
                f f2 = i2.p("triggers");
                if (f2 == null) break block7;
                HashMap<ScenarioTriggerPoint, Set<ScenarioTriggerAction>> hashMap = new HashMap<ScenarioTriggerPoint, Set<ScenarioTriggerAction>>();
                int n2 = 0;
                while (n2 < f2.a()) {
                    try {
                        ScenarioTriggerAction scenarioTriggerAction;
                        ScenarioTriggerPoint scenarioTriggerPoint;
                        i i3 = f2.o(n2);
                        if (i3 != null && (scenarioTriggerPoint = ScenarioTriggerPoint.get(i3.a("triggerPoint", "0"))) != ScenarioTriggerPoint.SCENARIO_TRIGGER_POINT_UNDEFINED && (scenarioTriggerAction = ScenarioTriggerAction.get(i3.a("action", "0"))) != ScenarioTriggerAction.SCENARIO_TRIGGER_ACTION_UNDEFINED) {
                            Set<ScenarioTriggerAction> set = !hashMap.containsKey((Object)scenarioTriggerPoint) || hashMap.containsKey((Object)scenarioTriggerPoint) && hashMap.get((Object)scenarioTriggerPoint) == null ? new HashSet<ScenarioTriggerAction>() : (Set)hashMap.get((Object)scenarioTriggerPoint);
                            set.add(scenarioTriggerAction);
                            hashMap.put(scenarioTriggerPoint, set);
                        }
                    }
                    catch (Exception exception) {
                        logger.d((Object)("Could not parse trigger json array index: " + n2 + ". array: " + ArrayUtils.toString((Object)f2)));
                    }
                    ++n2;
                }
                this.setTriggerActions(hashMap);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not parse property string field from specification. property: " + this.property), (Throwable)exception);
            }
        }
    }

    public SpecificationType getSpecificationType() {
        if (this.type == null) {
            this.parsePropertyJSON();
        }
        return this.type;
    }

    private void setSpecificationType(SpecificationType specificationType) {
        this.type = specificationType;
    }

    public ScenarioCommunicationService getCommunicationService() {
        if (this.communicationService == null) {
            this.parsePropertyJSON();
        }
        return this.communicationService;
    }

    private void setCommunicationService(ScenarioCommunicationService scenarioCommunicationService) {
        this.communicationService = scenarioCommunicationService;
    }

    private void setTriggerActions(Map<ScenarioTriggerPoint, Set<ScenarioTriggerAction>> map) {
        this.trigger = map;
    }

    public Set<ScenarioTriggerAction> getTriggerActions(ScenarioTriggerPoint scenarioTriggerPoint) {
        try {
            if (this.trigger == null) {
                this.parsePropertyJSON();
            }
            return this.trigger.get((Object)scenarioTriggerPoint);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get triggerAction for triggerPoint: " + (Object)((Object)scenarioTriggerPoint)), (Throwable)exception);
            return new HashSet<ScenarioTriggerAction>();
        }
    }

    public i toJSONObject() {
        try {
            i i2 = new i();
            i2.b(JSON_KEY_SPECIFICATION_PK, this.pk);
            i2.c(JSON_KEY_SPECIFICATION_NAME, (Object)this.name);
            i2.c(JSON_KEY_SPECIFICATION_DESCRIPTION, (Object)(this.description != null ? this.description : ""));
            if (this.scenarioDefinition != null) {
                i2.b(JSON_KEY_DEFINITION_PK, this.scenarioDefinition.getPk());
                i2.c(JSON_KEY_DEFINITION_DURATION, (Object)this.scenarioDefinition.getMaxDurationHumanReadable());
                i2.b(JSON_KEY_DEFINITION_ELEMENTS_TOTAL, this.scenarioDefinition.getScenarioElements().size());
            }
            return i2;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not generate JSON for scenarioSpecification: " + this), (Throwable)exception);
            return new i();
        }
    }

    public i toJSONObject(String string, String string2) {
        try {
            string = string.replace(BASE_COMMAND_DEF_PK_PLACEHOLDER, String.valueOf(this.scenarioDefinition.getPk()));
            i i2 = this.toJSONObject();
            i2.c(JSON_KEY_START_COMMAND, (Object)string);
            i2.c("additionalCssClass", (Object)string2);
            return i2;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not generate JSON for scenarioSpecification: " + this), (Throwable)exception);
            return new i();
        }
    }

    public float getPointsPrecision() {
        return 0.01f;
    }

    public float getRatingPrecision() {
        return 0.5f;
    }

    @Override
    public String toString() {
        return "ILPScenarioSpecification [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", autoCreate=" + this.autoCreate + ", active=" + this.active + ", courseDef=" + this.courseDef + ", user=" + this.user + ", resource=" + this.resource + "]";
    }

    public static class ILPScenarioRequirement {
        private String type;
        private String mandantIdentifier;
        private String courseId;
        private String courseReference;
        private String courseTitle;
        private String issueId;
        private String issueReference;
        private String issueTitle;

        public ILPScenarioRequirement(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            this.type = string;
            this.mandantIdentifier = string2;
            this.courseId = string3;
            this.courseReference = string4;
            this.courseTitle = string5;
            this.issueId = string6;
            this.issueReference = string7;
            this.issueTitle = string8;
        }

        public boolean isCourseRequirement() {
            return this.type.equals("COURSE");
        }

        public boolean isIssueRequirement() {
            return this.type.equals("ISSUE");
        }

        public String getType() {
            return this.type;
        }

        public String getMandantIdentifier() {
            return this.mandantIdentifier;
        }

        public String getCourseId() {
            return this.courseId;
        }

        public String getCourseReference() {
            return this.courseReference;
        }

        public String getCourseTitle() {
            return this.courseTitle;
        }

        public String getIssueId() {
            return this.issueId;
        }

        public String getIssueReference() {
            return this.issueReference;
        }

        public String getIssueTitle() {
            return this.issueTitle;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.courseId == null ? 0 : this.courseId.hashCode());
            n3 = 31 * n3 + (this.courseReference == null ? 0 : this.courseReference.hashCode());
            n3 = 31 * n3 + (this.courseTitle == null ? 0 : this.courseTitle.hashCode());
            n3 = 31 * n3 + (this.issueId == null ? 0 : this.issueId.hashCode());
            n3 = 31 * n3 + (this.issueReference == null ? 0 : this.issueReference.hashCode());
            n3 = 31 * n3 + (this.issueTitle == null ? 0 : this.issueTitle.hashCode());
            n3 = 31 * n3 + (this.mandantIdentifier == null ? 0 : this.mandantIdentifier.hashCode());
            n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ILPScenarioRequirement iLPScenarioRequirement = (ILPScenarioRequirement)object;
            if (this.courseId == null ? iLPScenarioRequirement.courseId != null : !this.courseId.equals(iLPScenarioRequirement.courseId)) {
                return false;
            }
            if (this.courseReference == null ? iLPScenarioRequirement.courseReference != null : !this.courseReference.equals(iLPScenarioRequirement.courseReference)) {
                return false;
            }
            if (this.courseTitle == null ? iLPScenarioRequirement.courseTitle != null : !this.courseTitle.equals(iLPScenarioRequirement.courseTitle)) {
                return false;
            }
            if (this.issueId == null ? iLPScenarioRequirement.issueId != null : !this.issueId.equals(iLPScenarioRequirement.issueId)) {
                return false;
            }
            if (this.issueReference == null ? iLPScenarioRequirement.issueReference != null : !this.issueReference.equals(iLPScenarioRequirement.issueReference)) {
                return false;
            }
            if (this.issueTitle == null ? iLPScenarioRequirement.issueTitle != null : !this.issueTitle.equals(iLPScenarioRequirement.issueTitle)) {
                return false;
            }
            if (this.mandantIdentifier == null ? iLPScenarioRequirement.mandantIdentifier != null : !this.mandantIdentifier.equals(iLPScenarioRequirement.mandantIdentifier)) {
                return false;
            }
            return !(this.type == null ? iLPScenarioRequirement.type != null : !this.type.equals(iLPScenarioRequirement.type));
        }

        public String toString() {
            return "ILPScenarioRequirement [type=" + this.type + ", mandantIdentifier=" + this.mandantIdentifier + ", courseId=" + this.courseId + ", courseReference=" + this.courseReference + ", courseTitle=" + this.courseTitle + ", issueId=" + this.issueId + ", issueReference=" + this.issueReference + ", issueTitle=" + this.issueTitle + "]";
        }
    }

    public static enum ScenarioCommunicationService {
        COMMUNICATION_SERVICE_NONE(0),
        COMMUNICATION_SERVICE_VELEDES_LMS(1);

        private static final Map<Integer, ScenarioCommunicationService> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ScenarioCommunicationService>();
            for (ScenarioCommunicationService scenarioCommunicationService : EnumSet.allOf(ScenarioCommunicationService.class)) {
                lookup.put(scenarioCommunicationService.getCode(), scenarioCommunicationService);
            }
        }

        private ScenarioCommunicationService(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ScenarioCommunicationService get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioCommunicationService code: " + n2 + ", defaulting to " + COMMUNICATION_SERVICE_NONE.name()));
                return COMMUNICATION_SERVICE_NONE;
            }
        }

        public static ScenarioCommunicationService get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioCommunicationService code: " + string + ", defaulting to " + COMMUNICATION_SERVICE_NONE.name()));
                return COMMUNICATION_SERVICE_NONE;
            }
        }
    }

    public static enum ScenarioTriggerAction {
        SCENARIO_TRIGGER_ACTION_UNDEFINED(0),
        SCENARIO_TRIGGER_ACTION_SUBMIT_RESULTS(1),
        SCENARIO_TRIGGER_ACTION_SCENARIO_VISITED(2);

        private static final Map<Integer, ScenarioTriggerAction> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ScenarioTriggerAction>();
            for (ScenarioTriggerAction scenarioTriggerAction : EnumSet.allOf(ScenarioTriggerAction.class)) {
                lookup.put(scenarioTriggerAction.getCode(), scenarioTriggerAction);
            }
        }

        private ScenarioTriggerAction(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ScenarioTriggerAction get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioTriggerAction code: " + n2 + ", defaulting to " + SCENARIO_TRIGGER_ACTION_UNDEFINED.name()));
                return SCENARIO_TRIGGER_ACTION_UNDEFINED;
            }
        }

        public static ScenarioTriggerAction get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioTriggerAction code: " + string + ", defaulting to " + SCENARIO_TRIGGER_ACTION_UNDEFINED.name()));
                return SCENARIO_TRIGGER_ACTION_UNDEFINED;
            }
        }
    }

    public static enum ScenarioTriggerPoint {
        SCENARIO_TRIGGER_POINT_UNDEFINED(0),
        SCENARIO_TRIGGER_POINT_START(1),
        SCENARIO_TRIGGER_POINT_END(2);

        private static final Map<Integer, ScenarioTriggerPoint> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ScenarioTriggerPoint>();
            for (ScenarioTriggerPoint scenarioTriggerPoint : EnumSet.allOf(ScenarioTriggerPoint.class)) {
                lookup.put(scenarioTriggerPoint.getCode(), scenarioTriggerPoint);
            }
        }

        private ScenarioTriggerPoint(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ScenarioTriggerPoint get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioTriggerPoint code: " + n2 + ", defaulting to " + SCENARIO_TRIGGER_POINT_UNDEFINED.name()));
                return SCENARIO_TRIGGER_POINT_UNDEFINED;
            }
        }

        public static ScenarioTriggerPoint get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioTriggerPoint code: " + string + ", defaulting to " + SCENARIO_TRIGGER_POINT_UNDEFINED.name()));
                return SCENARIO_TRIGGER_POINT_UNDEFINED;
            }
        }
    }

    public static enum SpecificationType {
        SCENARIO_SPECIFICATION_TYPE_UNDEFINED(0, ScenarioCommunicationService.COMMUNICATION_SERVICE_NONE),
        SCENARIO_SPECIFICATION_TYPE_ETEST(1, ScenarioCommunicationService.COMMUNICATION_SERVICE_VELEDES_LMS);

        private static final Map<Integer, SpecificationType> lookup;
        private int code;
        private ScenarioCommunicationService commService;

        static {
            lookup = new HashMap<Integer, SpecificationType>();
            for (SpecificationType specificationType : EnumSet.allOf(SpecificationType.class)) {
                lookup.put(specificationType.getCode(), specificationType);
            }
        }

        private SpecificationType(int n3, ScenarioCommunicationService scenarioCommunicationService) {
            this.code = n3;
            this.commService = scenarioCommunicationService;
        }

        public int getCode() {
            return this.code;
        }

        public ScenarioCommunicationService getCommunicationService() {
            return this.commService;
        }

        public static SpecificationType get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioSpecificationType code: " + n2 + ", defaulting to " + SCENARIO_SPECIFICATION_TYPE_UNDEFINED.name()));
                return SCENARIO_SPECIFICATION_TYPE_UNDEFINED;
            }
        }

        public static SpecificationType get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioSpecificationType code: " + string + ", defaulting to " + SCENARIO_SPECIFICATION_TYPE_UNDEFINED.name()));
                return SCENARIO_SPECIFICATION_TYPE_UNDEFINED;
            }
        }
    }
}

