/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.book.lr.a;
import ch.ionesoft.ilp.book.lr.b;
import ch.ionesoft.ilp.book.lr.c;
import ch.ionesoft.ilp.book.lr.d;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPLink;
import ch.ionesoft.ilp.book.mo.ILPScenario;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPScenarioEmbeddedContent;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@DatabaseTable(tableName="ZILPSCENARIOELEMENTRESULT")
public class ILPScenarioElementResult
extends AbstractCoreDataModel
implements b.a {
    private static ILogger logger = ILPLogManager.getLogger(ILPScenarioElementResult.class);
    public static final String TABLE_NAME = "ZILPSCENARIOELEMENTRESULT";
    public static final String ID_FIELD_NAME = "ZID";
    public static final String ORDER_FIELD_NAME = "ZORDER";
    public static final String CURRENT_FIELD_NAME = "ZCURRENT";
    public static final String PROCESSED_FIELD_NAME = "ZPROCESSED";
    public static final String RESULT_FIELD_NAME = "ZRESULT";
    public static final String RATING_FIELD_NAME = "ZRATING";
    public static final String ENTRY_TIME_FIELD_NAME = "ZENTRYTIME";
    public static final String DURATION_FIELD_NAME = "ZDURATION";
    public static final String SCENARIO_ELEMENT_FOREIGN_ID_FIELD_NAME = "ZSCENARIOELEMENTID";
    public static final String SCENARIO_FK_FIELD_NAME = "ZSCENARIO";
    public static final String SCENARIO_ELEMENT_FK_FIELD_NAME = "ZSCENARIOELEMENT";
    @DatabaseField(columnName="ZID", canBeNull=false, index=true)
    private String id;
    @DatabaseField(columnName="ZORDER", canBeNull=false, index=true)
    private Integer order;
    @DatabaseField(columnName="ZCURRENT", index=true)
    private boolean current;
    @DatabaseField(columnName="ZPROCESSED", index=true)
    private boolean processed;
    @DatabaseField(columnName="ZRESULT")
    private String result;
    @DatabaseField(columnName="ZRATING")
    private Float rating;
    @DatabaseField(columnName="ZENTRYTIME", index=true)
    private Date entryTime;
    @DatabaseField(columnName="ZDURATION")
    private Float duration;
    @DatabaseField(columnName="ZSCENARIOELEMENTID")
    private String scenarioElementId;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZSCENARIO", canBeNull=true, index=true)
    private ILPScenario scenario;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZSCENARIOELEMENT", canBeNull=true, index=true)
    private ILPScenarioElement scenarioElement;
    @ForeignCollectionField
    private ForeignCollection<ILPLink> links;

    public ILPScenarioElementResult() {
        this.id = UUID.randomUUID().toString();
    }

    public ILPScenarioElementResult(String string) {
        this.id = string;
    }

    public ForeignCollection<ILPLink> getLinks() {
        if (this.links == null) {
            try {
                g.a().aQ().assignEmptyForeignCollection((Object)this, "links");
                this.links.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for scenarioElementResult.links", (Throwable)sQLException);
                f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.links;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer n2) {
        this.order = n2;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean bl2) {
        this.current = bl2;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean bl2) {
        this.processed = bl2;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String string) {
        this.result = string;
    }

    public Float getRating() {
        return this.rating;
    }

    public void setRating(Float f2) {
        this.rating = f2;
    }

    public Date getEntryTime() {
        return this.entryTime;
    }

    public void setEntryTime(Date date) {
        this.entryTime = date;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float f2) {
        this.duration = f2;
    }

    public void increaseDuration(Float f2) {
        try {
            if (f2 == null) {
                return;
            }
            if (this.duration == null || this.duration.floatValue() == 0.0f) {
                this.setDuration(f2);
            } else {
                Float f3 = Float.valueOf(this.duration.floatValue() + f2.floatValue());
                this.setDuration(f3);
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not increase duration in scenario element result by " + f2), (Throwable)exception);
        }
    }

    public String getScenarioElementId() {
        return this.scenarioElementId;
    }

    public void setScenarioElementId(String string) {
        this.scenarioElementId = string;
    }

    public ILPScenario getScenario() {
        return this.scenario;
    }

    public void setScenario(ILPScenario iLPScenario) {
        this.scenario = iLPScenario;
    }

    public ILPScenarioElement getScenarioElement() {
        return this.scenarioElement;
    }

    public void setScenarioElement(ILPScenarioElement iLPScenarioElement) {
        this.scenarioElement = iLPScenarioElement;
    }

    private float getReachedPoints() {
        if (!(this.getScenarioElement().getModel() instanceof ILPExercise)) {
            return 0.0f;
        }
        ILPExercise iLPExercise = (ILPExercise)this.getScenarioElement().getModel();
        if (this.getRating() == null) {
            return 0.0f;
        }
        float f2 = 0.0f;
        f2 = this.getScenarioElement().getMaxPoints() != null ? this.getScenarioElement().getMaxPoints().floatValue() : (iLPExercise.getMaxPoints() != null ? iLPExercise.getMaxPoints().floatValue() : 1.0f);
        float f3 = f2 * this.getRating().floatValue();
        return f3;
    }

    public float getMaxPointsFromExercise() {
        if (!(this.getScenarioElement().getModel() instanceof ILPExercise)) {
            return 0.0f;
        }
        ILPExercise iLPExercise = (ILPExercise)this.getScenarioElement().getModel();
        if (iLPExercise.getMaxPoints() == null) {
            return 0.0f;
        }
        return iLPExercise.getMaxPoints().floatValue();
    }

    public float getReachedPointsWithPrecision(float f2) {
        float f3 = this.getReachedPoints();
        return ConverterUtil.roundFloatWithPrecision((float)f3, (float)f2);
    }

    @Override
    public String toString() {
        return "ILPScenarioElementResult [id=" + this.id + ", order=" + this.order + ", current=" + this.current + ", processed=" + this.processed + ", result=" + this.result + ", rating=" + this.rating + ", entryTime=" + this.entryTime + ", duration=" + this.duration + ", scenarioElementId=" + this.scenarioElementId + ", scenario=" + this.scenario + ", scenarioElement=" + this.scenarioElement + ", links=" + this.links + "]";
    }

    @Override
    public void unpackInto(List<a> list) {
        if (this.getScenarioElement().isLearningAnalyticsEnabled() == null || !this.getScenarioElement().isLearningAnalyticsEnabled().booleanValue()) {
            return;
        }
        Object object = this.getScenarioElement().getModel();
        if (object instanceof ILPTopic) {
            logger.b((Object)("Element is attached to expressible topic: " + object));
            list.add(new ch.ionesoft.ilp.book.lr.g(this.getScenarioElement().getScenarioDefinition().getScenarioSpecification().getTask(), this, (ILPTopic)object));
        } else if (object instanceof ILPExercise) {
            logger.b((Object)("Element is attached to expressible topic: " + object));
            list.add(new c(this.getScenarioElement().getScenarioDefinition().getScenarioSpecification().getTask(), this, (ILPExercise)object));
        } else if (object instanceof ILPScenarioEmbeddedContent) {
            logger.b((Object)("Element is attached to expressible embeddedContent: " + object));
            list.add(new d(this.getScenarioElement().getScenarioDefinition().getScenarioSpecification().getTask(), this, (ILPScenarioEmbeddedContent)object));
        }
    }

    @Override
    public boolean containsData() {
        Object object = this.getScenarioElement().getModel();
        if (object == null) {
            return false;
        }
        return object instanceof ILPTopic || object instanceof ILPExercise;
    }
}

