/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.au.c;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition;
import ch.ionesoft.ilp.book.mo.ILPScenarioEmbeddedContent;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.scenario.a;
import ch.ionesoft.ilp.book.scenario.h;
import ch.ionesoft.ilp.book.scenario.i;
import ch.ionesoft.ilp.book.scenario.j;
import ch.ionesoft.ilp.book.scenario.k;
import ch.ionesoft.ilp.book.scenario.l;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@DatabaseTable(tableName="ZILPSCENARIOELEMENT")
public class ILPScenarioElement
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPScenarioElement.class);
    public static final String TABLE_NAME = "ZILPSCENARIOELEMENT";
    public static final String ID_FIELD_NAME = "ZID";
    public static final String ORDER_FIELD_NAME = "ZORDER";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String CONFIGURATION_FIELD_NAME = "ZCONFIGURATION";
    public static final String LEARNING_ANALYTICS_FIELD_NAME = "ZLEARNINGANALYTICS";
    public static final String MAX_POINTS = "ZMAXPOINTS";
    public static final String SCENARIO_DEFINITION_FK_FIELD_NAME = "ZSCENARIODEFINITION";
    public static final String TOPIC_FK_FIELD_NAME = "ZTOPIC";
    public static final String EXERCISE_FK_FIELD_NAME = "ZEXERCISE";
    public static final String RESOURCE_FK_FIELD_NAME = "ZRESOURCE";
    public static final String EMBEDDED_FK_FIELD_NAME = "ZEMBEDDED";
    public static final String DELETED_FIELD_NAME = "ZDELETED";
    @DatabaseField(columnName="ZID", canBeNull=false, index=true)
    private String id;
    @DatabaseField(columnName="ZORDER", canBeNull=false, index=true)
    private Integer order;
    @DatabaseField(columnName="ZTYPE", canBeNull=false)
    private Integer type;
    @DatabaseField(columnName="ZCONFIGURATION", canBeNull=false)
    private String configuration;
    @DatabaseField(columnName="ZLEARNINGANALYTICS")
    private Boolean learningAnalytics;
    @DatabaseField(columnName="ZMAXPOINTS", canBeNull=true)
    private Float maxPoints;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZSCENARIODEFINITION", canBeNull=false, index=true)
    private ILPScenarioDefinition scenarioDefinition;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZTOPIC", index=true)
    private ILPTopic topic;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZEXERCISE", index=true)
    private ILPExercise exercise;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZRESOURCE", index=true)
    private ILPResource resource;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZEMBEDDED", index=true)
    private ILPScenarioEmbeddedContent embeddedContent;
    @DatabaseField(columnName="ZDELETED")
    private Boolean deleted = false;
    private a elementStrategy = null;

    public ILPScenarioElement() {
        this.id = UUID.randomUUID().toString();
    }

    public ILPScenarioElement(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer n2) {
        this.order = n2;
    }

    public ScenarioElementType getType() {
        if (this.type != null) {
            return ScenarioElementType.get(this.type);
        }
        return ScenarioElementType.SCENARIO_ELEMENT_TYPE_UNDEFINED;
    }

    public void setType(ScenarioElementType scenarioElementType) {
        this.type = scenarioElementType.getCode();
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String string) {
        this.configuration = string;
    }

    public Boolean isLearningAnalyticsEnabled() {
        return this.learningAnalytics;
    }

    public void setLearningAnalyticsEnabled(Boolean bl2) {
        this.learningAnalytics = bl2;
    }

    public Float getMaxPoints() {
        return this.maxPoints;
    }

    public void setMaxPoints(Float f2) {
        this.maxPoints = f2;
    }

    public ILPScenarioDefinition getScenarioDefinition() {
        return this.scenarioDefinition;
    }

    public void setScenarioDefinition(ILPScenarioDefinition iLPScenarioDefinition) {
        this.scenarioDefinition = iLPScenarioDefinition;
    }

    public a getElementStrategy() {
        if (this.elementStrategy == null) {
            this.elementStrategy = this.createElementStrategy();
        }
        return this.elementStrategy;
    }

    public ILPCourseDef getCourseOfModel() {
        if (this.hasTopic()) {
            return this.getTopic().getIssue().getCourse();
        }
        if (this.hasExercise()) {
            return this.getExercise().getIssue().getCourse();
        }
        if (this.hasResource()) {
            return this.getResource().getCourse();
        }
        return null;
    }

    private a createElementStrategy() {
        if (this.hasTopic()) {
            c c2 = ILPBookRegistry.instance().authorizationManager();
            if (c2 != null && c2.a(this.topic)) {
                return new l(this);
            }
        } else if (this.hasExercise()) {
            c c3 = ILPBookRegistry.instance().authorizationManager();
            if (c3 != null && c3.a(this.exercise)) {
                return new i(this);
            }
        } else {
            if (this.hasResource()) {
                return new k(this);
            }
            if (this.hasEmbeddedContent()) {
                return new h(this);
            }
        }
        return new j(this);
    }

    public ILPIssueDef getIssue() {
        if (this.hasTopic()) {
            return this.topic.getIssue();
        }
        if (this.hasExercise()) {
            return this.exercise.getIssue();
        }
        if (this.hasResource()) {
            return this.resource.getIssue();
        }
        return null;
    }

    public Object getModel() {
        if (this.hasTopic()) {
            return this.getTopic();
        }
        if (this.hasExercise()) {
            return this.getExercise();
        }
        if (this.hasResource()) {
            return this.getResource();
        }
        if (this.hasEmbeddedContent()) {
            return this.getEmbeddedContent();
        }
        return null;
    }

    public void setModel(Object object) {
        if (object instanceof ILPTopic) {
            this.setTopic((ILPTopic)object);
        } else if (object instanceof ILPExercise) {
            this.setExercise((ILPExercise)object);
        } else if (object instanceof ILPResource) {
            this.setResource((ILPResource)object);
        } else if (object instanceof ILPScenarioEmbeddedContent) {
            this.setEmbeddedContent((ILPScenarioEmbeddedContent)object);
        } else {
            throw new IllegalArgumentException("Could not map model object: " + object + " to ILPTopic/ILPExercise/ILPResource");
        }
    }

    public void resetModel() {
        this.setTopic(null);
        this.setExercise(null);
        this.setResource(null);
    }

    public boolean hasTopic() {
        return this.topic != null;
    }

    public ILPTopic getTopic() {
        return this.topic;
    }

    public void setTopic(ILPTopic iLPTopic) {
        this.topic = iLPTopic;
    }

    public boolean hasExercise() {
        return this.exercise != null;
    }

    public ILPExercise getExercise() {
        return this.exercise;
    }

    public void setExercise(ILPExercise iLPExercise) {
        this.exercise = iLPExercise;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public ILPResource getResource() {
        return this.resource;
    }

    public void setResource(ILPResource iLPResource) {
        this.resource = iLPResource;
    }

    public boolean hasEmbeddedContent() {
        return this.embeddedContent != null;
    }

    public ILPScenarioEmbeddedContent getEmbeddedContent() {
        return this.embeddedContent;
    }

    public void setEmbeddedContent(ILPScenarioEmbeddedContent iLPScenarioEmbeddedContent) {
        this.embeddedContent = iLPScenarioEmbeddedContent;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean bl2) {
        this.deleted = bl2;
    }

    @Override
    public String toString() {
        return "ILPScenarioElement [id=" + this.id + ", order=" + this.order + ", type=" + this.type + ", configuration=" + this.configuration + ", learningAnalytics=" + this.learningAnalytics + ", scenarioDefinition=" + this.scenarioDefinition + ", topic=" + this.topic + ", exercise=" + this.exercise + ", resource=" + this.resource + ", deleted=" + this.deleted + ", elementStrategy=" + this.elementStrategy + "]";
    }

    public static enum ScenarioElementType {
        SCENARIO_ELEMENT_TYPE_UNDEFINED(0),
        SCENARIO_ELEMENT_TYPE_MODEL(1),
        SCENARIO_ELEMENT_TYPE_TEMPLATE(2),
        SCENARIO_ELEMENT_TYPE_DECISION(3),
        SCENARIO_ELEMENT_TYPE_INPUT(4),
        SCENARIO_ELEMENT_TYPE_PROLOG(5),
        SCENARIO_ELEMENT_TYPE_EPILOG(6);

        private static final Map<Integer, ScenarioElementType> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ScenarioElementType>();
            for (ScenarioElementType scenarioElementType : EnumSet.allOf(ScenarioElementType.class)) {
                lookup.put(scenarioElementType.getCode(), scenarioElementType);
            }
        }

        private ScenarioElementType(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ScenarioElementType get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioElementType code: " + n2 + ", defaulting to " + SCENARIO_ELEMENT_TYPE_UNDEFINED.name()));
                return SCENARIO_ELEMENT_TYPE_UNDEFINED;
            }
        }

        public static ScenarioElementType get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }
}

