/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPScenario;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition_CourseDef;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import ch.ionesoft.ilp.book.scenario.ILPScenarioManager;
import ch.ionesoft.ilp.book.scenario.b;
import ch.ionesoft.ilp.book.scenario.n;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPSCENARIODEFINITION")
public class ILPScenarioDefinition
extends AbstractCoreDataModel {
    private static final long serialVersionUID = 1L;
    private static ILogger logger = ILPLogManager.getLogger(ILPScenarioDefinition.class);
    public static final String TABLE_NAME = "ZILPSCENARIODEFINITION";
    public static final String ACTIVE_FIELD_NAME = "ZACTIVE";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String MODEL_CONTENT_FIELD_NAME = "ZMODELCONTENT";
    public static final String PLAY_MODE_FIELD_NAME = "ZPLAYMODE";
    public static final String PLAY_MODE_CHANGEABLE_FIELD_NAME = "ZPLAYMODECHANGEABLE";
    public static final String RULE_FIELD_NAME = "ZRULE";
    public static final String EDITING_FIELD_NAME = "ZEDITING";
    public static final String MAX_DURATION_FIELD_NAME = "ZMAXDURATION";
    public static final String CREATION_DATE_FIELD_NAME = "ZCREATIONDATE";
    public static final String ANNOTATABLE_FIELD_NAME = "ZANNOTATABLE";
    public static final String LOADSAVEANSWERS_FIELD_NAME = "ZLOADSAVEANSWERS";
    @DatabaseField(columnName="ZACTIVE")
    private boolean active;
    @DatabaseField(columnName="ZTYPE", canBeNull=false)
    private Integer type;
    @DatabaseField(columnName="ZMODELCONTENT", canBeNull=false)
    private Integer modelContent;
    @DatabaseField(columnName="ZPLAYMODE", canBeNull=false)
    private Integer playMode;
    @DatabaseField(columnName="ZPLAYMODECHANGEABLE")
    private boolean playModeChangeable;
    @DatabaseField(columnName="ZRULE")
    private String rule;
    @DatabaseField(columnName="ZEDITING", index=true)
    private boolean editing;
    @DatabaseField(columnName="ZMAXDURATION")
    private Float maxDuration;
    @DatabaseField(columnName="ZANNOTATABLE")
    private boolean annotatable;
    @DatabaseField(columnName="ZLOADSAVEANSWERS")
    private Boolean loadSaveAnswersOnScenario;
    @ForeignCollectionField(orderColumnName="ZCREATIONDATE", orderAscending=false)
    private ForeignCollection<ILPScenario> scenarios;
    @ForeignCollectionField(orderColumnName="ZORDER")
    private ForeignCollection<ILPScenarioElement> scenarioElements;

    public String getName() {
        return this.getScenarioSpecification().getName();
    }

    public String getDescription() {
        return this.getScenarioSpecification().getDescription();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl2) {
        this.active = bl2;
    }

    public ScenarioDefinitionStatus getScenarioStatus() {
        if (CollectionUtils.isEmpty(this.getScenarioElementsNotDeleted())) {
            return ScenarioDefinitionStatus.SCENARIO_DEF_STATUS_NO_ELEMENTS;
        }
        ILPScenario iLPScenario = ILPScenarioManager.getInstance().getLatestScenarioWithDefinitionPK(this.getPk());
        if (iLPScenario == null || iLPScenario.isFinished() || iLPScenario.getStatusEnum() == ILPScenario.ScenarioStatus.SCENARIO_STATUS_DURATION_REACHED) {
            return ScenarioDefinitionStatus.SCENARIO_DEF_STATUS_READY;
        }
        return ScenarioDefinitionStatus.SCENARIO_DEF_STATUS_IN_PROGRESS;
    }

    public boolean hasExercises() {
        Dao<ILPScenarioElement, Integer> dao = g.a().aP();
        Where where = dao.queryBuilder().where();
        try {
            return where.isNotNull("ZEXERCISE").and().eq("ZSCENARIODEFINITION", (Object)this.getPk()).countOf() > 0L;
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Failed to test if the definition contains exercises: " + this), (Throwable)sQLException);
            return false;
        }
    }

    public ScenarioType getType() {
        if (this.type != null) {
            return ScenarioType.get(this.type);
        }
        return ScenarioType.SCENARIO_TYPE_UNDEFINED;
    }

    public void setType(ScenarioType scenarioType) {
        this.type = scenarioType.getCode();
    }

    public boolean isModelContentUndefined() {
        return this.modelContent != null && (long)this.modelContent.intValue() == 0L;
    }

    public List<ILPExercise> fetchExerciseByRule() {
        ch.ionesoft.ilp.book.search.f f2 = new ch.ionesoft.ilp.book.search.f();
        f2.a(this.getRule());
        return f.a().b(f2);
    }

    public boolean hasModelContent(ScenarioModelContent scenarioModelContent) {
        block5: {
            block4: {
                try {
                    if (this.modelContent != null) break block4;
                    return false;
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not check if ILPScenarioDefinition has ScenarioModelContent: " + (Object)((Object)scenarioModelContent)), (Throwable)exception);
                    return false;
                }
            }
            if (this.modelContent != 0 || scenarioModelContent.getValue() != 0) break block5;
            return true;
        }
        return this.isModelContentDividableByPrimeFactor(this.modelContent, scenarioModelContent.getValue());
    }

    public boolean isAllowedToAddElementsWithModelContent(ScenarioModelContent scenarioModelContent) {
        if (this.isModelContentUndefined()) {
            return true;
        }
        return this.hasModelContent(scenarioModelContent);
    }

    public Integer getModelContent() {
        return this.modelContent;
    }

    public void setModelContent(Integer n2) {
        this.modelContent = n2;
    }

    public List<ScenarioModelContent> getModelContentList() {
        block6: {
            if (this.modelContent != null) break block6;
            return null;
        }
        try {
            ArrayList<ScenarioModelContent> arrayList = new ArrayList<ScenarioModelContent>();
            if (this.modelContent == 0) {
                arrayList.add(ScenarioModelContent.SCENARIO_MODELCONTENT_UNDEFINED);
                return arrayList;
            }
            int n2 = this.modelContent;
            ScenarioModelContent[] scenarioModelContentArray = ScenarioModelContent.values();
            int n3 = scenarioModelContentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                ScenarioModelContent scenarioModelContent = scenarioModelContentArray[n4];
                if (n2 == 0) break;
                if (scenarioModelContent != ScenarioModelContent.SCENARIO_MODELCONTENT_UNDEFINED && this.isModelContentDividableByPrimeFactor(n2, n5 = scenarioModelContent.getValue().intValue())) {
                    int n6;
                    arrayList.add(scenarioModelContent);
                    n2 = n6 = this.divideModelContentByPrimeFactor(n2, scenarioModelContent.getValue());
                }
                ++n4;
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.d((Object)"Could not get ModelContentList", (Throwable)exception);
            return null;
        }
    }

    public List<String> getModelContentStringList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getModelContentList() == null || this.getModelContentList().isEmpty()) {
            return arrayList;
        }
        for (ScenarioModelContent scenarioModelContent : this.getModelContentList()) {
            arrayList.add(scenarioModelContent.toString());
        }
        return arrayList;
    }

    public void setModelContentList(List<ScenarioModelContent> list) {
        try {
            if (list == null || list.isEmpty()) {
                return;
            }
            int n2 = 1;
            for (ScenarioModelContent scenarioModelContent : list) {
                if (scenarioModelContent == ScenarioModelContent.SCENARIO_MODELCONTENT_UNDEFINED) {
                    this.modelContent = 0;
                    return;
                }
                n2 *= scenarioModelContent.getValue().intValue();
            }
            this.modelContent = n2;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not setModelContentList: " + ArrayUtils.toString(list)), (Throwable)exception);
        }
    }

    public void addModelContent(ScenarioModelContent scenarioModelContent) {
        try {
            if (scenarioModelContent == null || this.hasModelContent(scenarioModelContent)) {
                return;
            }
            if (this.modelContent == null || this.modelContent == 0) {
                this.modelContent = 1;
            }
            this.modelContent = this.modelContent * scenarioModelContent.getValue();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not add modelContent: " + (Object)((Object)scenarioModelContent) + " to current modelContents: " + this.modelContent));
        }
    }

    private boolean isModelContentDividableByPrimeFactor(int n2, int n3) {
        block3: {
            try {
                if (n2 != 0 && n3 != 0) break block3;
                return false;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not calculate if modelContent: " + n2 + " is dividable by factor: " + n3), (Throwable)exception);
                return false;
            }
        }
        return n2 % n3 == 0;
    }

    private int divideModelContentByPrimeFactor(int n2, int n3) {
        block4: {
            try {
                if (n2 != 0 && n3 != 0) break block4;
                return 0;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not calculate if product: " + n2 + " is dividable by factor: " + n3), (Throwable)exception);
                return n2;
            }
        }
        if (n2 % n3 == 0) {
            return n2 / n3;
        }
        return n2;
    }

    public List<ILPCourseDef> getRelatedCoursesOfElements() {
        ArrayList<ILPCourseDef> arrayList = new ArrayList<ILPCourseDef>();
        List<ILPScenarioElement> list = this.getScenarioElementsNotDeleted();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        for (ILPScenarioElement iLPScenarioElement : list) {
            ILPCourseDef iLPCourseDef = iLPScenarioElement.getCourseOfModel();
            if (arrayList.contains(iLPCourseDef)) continue;
            arrayList.add(iLPCourseDef);
        }
        return arrayList;
    }

    public List<ILPIssueDef> getRelatedIssuesOfElements(ILPCourseDef iLPCourseDef) {
        HashSet<ILPIssueDef> hashSet = new HashSet<ILPIssueDef>();
        for (ILPScenarioElement iLPScenarioElement : this.getScenarioElementsNotDeleted()) {
            ILPIssueDef iLPIssueDef;
            ILPCourseDef iLPCourseDef2 = iLPScenarioElement.getCourseOfModel();
            if (!iLPCourseDef2.isIssueBased() || iLPScenarioElement.getType() != ILPScenarioElement.ScenarioElementType.SCENARIO_ELEMENT_TYPE_MODEL || !iLPCourseDef2.equals(iLPCourseDef) || (iLPIssueDef = iLPScenarioElement.getIssue()) == null) continue;
            hashSet.add(iLPIssueDef);
        }
        return new ArrayList<ILPIssueDef>(hashSet);
    }

    public Integer getModelContentValue() {
        return this.modelContent;
    }

    public void resetModelContent() {
        this.modelContent = null;
    }

    public ScenarioPlayMode getPlayMode() {
        if (this.playMode != null) {
            return ScenarioPlayMode.get(this.playMode);
        }
        return ScenarioPlayMode.SCENARIO_PLAYMODE_UNDEFINED;
    }

    public boolean isETest() {
        return ScenarioPlayMode.SCENARIO_PLAYMODE_ETEST.getCode() == this.playMode.intValue();
    }

    public void setPlayMode(ScenarioPlayMode scenarioPlayMode) {
        this.playMode = scenarioPlayMode.getCode();
    }

    public boolean isPlayModeChangeable() {
        return this.playModeChangeable;
    }

    public void setPlayModeChangeable(boolean bl2) {
        this.playModeChangeable = bl2;
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String string) {
        this.rule = string;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean bl2) {
        this.editing = bl2;
    }

    public Float getMaxDuration() {
        return this.maxDuration;
    }

    public String getMaxDurationHumanReadable() {
        return ILPScenarioManager.getInstance().getDurationForUserOutput(this.maxDuration.floatValue(), true);
    }

    public void setMaxDuration(Float f2) {
        this.maxDuration = f2;
    }

    public boolean hasMaxDuration() {
        return this.maxDuration != null && this.maxDuration.floatValue() > 0.0f;
    }

    public Boolean isLoadSaveAnswersOnScenario() {
        return this.loadSaveAnswersOnScenario;
    }

    public void setLoadSaveAnswersOnScenario(Boolean bl2) {
        this.loadSaveAnswersOnScenario = bl2;
    }

    public ILPScenarioSpecification getScenarioSpecification() {
        return f.a().g(this);
    }

    public ForeignCollection<ILPScenario> getScenarios() {
        if (this.scenarios == null) {
            try {
                g.a().aO().assignEmptyForeignCollection((Object)this, "scenarios");
                this.scenarios.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for scenarioDefinition.scenarios", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.scenarios;
    }

    public void setScenarios(ForeignCollection<ILPScenario> foreignCollection) {
        this.scenarios = foreignCollection;
    }

    public List<ILPScenarioElement> getScenarioElementsNotDeleted() {
        return f.a().h(this);
    }

    public ForeignCollection<ILPScenarioElement> getScenarioElements() {
        if (this.scenarioElements == null) {
            try {
                g.a().aO().assignEmptyForeignCollection((Object)this, "scenarioElements");
                this.scenarioElements.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for scenarioDefinition.scenarioElements", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.scenarioElements;
    }

    public void setScenarioElements(ForeignCollection<ILPScenarioElement> foreignCollection) {
        this.scenarioElements = foreignCollection;
    }

    public void addCourseObject(ILPCourseDef iLPCourseDef) throws SQLException {
        ILPScenarioDefinition_CourseDef iLPScenarioDefinition_CourseDef = new ILPScenarioDefinition_CourseDef(this, iLPCourseDef);
        g.a().aR().create((Object)iLPScenarioDefinition_CourseDef);
    }

    public List<ILPCourseDef> getReferencedCourses() {
        try {
            return f.a().d(this);
        }
        catch (j j2) {
            logger.d((Object)"Could not get courses of scenario definition");
            return null;
        }
    }

    public boolean hasReferencedCourse(ILPCourseDef iLPCourseDef) {
        try {
            return f.a().d(this).contains(iLPCourseDef);
        }
        catch (j j2) {
            logger.d((Object)"Could not get referenced courses of scenario definition");
            return false;
        }
    }

    public DateTime getCreationDate() {
        return this.getScenarioSpecification().getCreationDate();
    }

    public boolean isAnnotatable() {
        return this.annotatable;
    }

    public void setAnnotatable(boolean bl2) {
        this.annotatable = bl2;
    }

    public ILPScenarioElement getProlog() {
        return f.a().a(this, ILPScenarioElement.ScenarioElementType.SCENARIO_ELEMENT_TYPE_PROLOG);
    }

    public ILPScenarioElement getEpilog() {
        return f.a().a(this, ILPScenarioElement.ScenarioElementType.SCENARIO_ELEMENT_TYPE_EPILOG);
    }

    public boolean isDynamicScenario() {
        return this.getType() == ScenarioType.SCENARIO_TYPE_DYNAMIC;
    }

    public b getPlayConfiguration() throws n {
        return ILPScenarioManager.getInstance().getPlayConfiguration(this);
    }

    public void touchAndStoreScenarioSpecification() {
        if (this.getScenarioSpecification() != null) {
            this.getScenarioSpecification().touchAndStore();
        } else {
            logger.c((Object)("ScenarioDefinition does not have a specification: " + this));
        }
    }

    public void store() {
        try {
            g.a().aO().createOrUpdate((Object)this);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not create or update scenario definition: " + this), (Throwable)sQLException);
        }
    }

    public void touchAndStore() {
        this.touchAndStoreScenarioSpecification();
        this.store();
    }

    @Override
    public String toString() {
        return "ILPScenarioDefinition [active=" + this.active + ", type=" + this.type + ", modelContent=" + this.modelContent + ", playMode=" + this.playMode + ", playModeChangeable=" + this.playModeChangeable + ", rule=" + this.rule + ", editing=" + this.editing + ", maxDuration=" + this.maxDuration + ", annotatable=" + this.annotatable + "]";
    }

    public static enum ScenarioDefinitionStatus {
        SCENARIO_DEF_STATUS_UNDEFINED(0, "scenario.label.definition.status", "statusUndefined"),
        SCENARIO_DEF_STATUS_READY(1, "scenario.label.definition.status.ready", "statusReady"),
        SCENARIO_DEF_STATUS_IN_PROGRESS(2, "scenario.label.definition.status.running", "statusProcess"),
        SCENARIO_DEF_STATUS_NO_ELEMENTS(3, "scenario.label.definition.status.noElements", "statusNoElements");

        private static final Map<Integer, ScenarioDefinitionStatus> lookup;
        private int code;
        private String localizable;
        private String cssClass;

        static {
            lookup = new HashMap<Integer, ScenarioDefinitionStatus>();
            for (ScenarioDefinitionStatus scenarioDefinitionStatus : EnumSet.allOf(ScenarioDefinitionStatus.class)) {
                lookup.put(scenarioDefinitionStatus.getCode(), scenarioDefinitionStatus);
            }
        }

        private ScenarioDefinitionStatus(int n3, String string2, String string3) {
            this.code = n3;
            this.localizable = string2;
            this.cssClass = string3;
        }

        public int getCode() {
            return this.code;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public static ScenarioDefinitionStatus get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioStatus code: " + n2 + ", defaulting to " + SCENARIO_DEF_STATUS_UNDEFINED.name()));
                return SCENARIO_DEF_STATUS_UNDEFINED;
            }
        }

        public static ScenarioDefinitionStatus get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioStatus code: " + string + ", defaulting to " + SCENARIO_DEF_STATUS_UNDEFINED.name()));
                return SCENARIO_DEF_STATUS_UNDEFINED;
            }
        }
    }

    public static enum ScenarioModelContent {
        SCENARIO_MODELCONTENT_UNDEFINED(0),
        SCENARIO_MODELCONTENT_TOPIC(2),
        SCENARIO_MODELCONTENT_EXERCISE(3),
        SCENARIO_MODELCONTENT_RESOURCE(5);

        private static final Map<Integer, ScenarioModelContent> lookup;
        private Integer primeNumber;

        static {
            lookup = new HashMap<Integer, ScenarioModelContent>();
            for (ScenarioModelContent scenarioModelContent : EnumSet.allOf(ScenarioModelContent.class)) {
                lookup.put(scenarioModelContent.getValue(), scenarioModelContent);
            }
        }

        private ScenarioModelContent(Integer n3) {
            this.primeNumber = n3;
        }

        public Integer getValue() {
            return this.primeNumber;
        }

        public static ScenarioModelContent get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioModelContent code: " + n2 + ", defaulting to " + SCENARIO_MODELCONTENT_UNDEFINED.name()));
                return SCENARIO_MODELCONTENT_UNDEFINED;
            }
        }

        public static ScenarioModelContent get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }

    public static enum ScenarioOwner {
        SCENARIO_OWNER_UNDEFINED(0, "scenario.label.owner"),
        SCENARIO_OWNER_USER(1, "scenario.label.owner.user"),
        SCENARIO_OWNER_EBOOK(2, "label.ebook"),
        SCENARIO_OWNER_SHARING_RECEIVED(3, "scenario.label.owner.received");

        private static final Map<Integer, ScenarioOwner> lookup;
        private int code;
        private String localizable;

        static {
            lookup = new HashMap<Integer, ScenarioOwner>();
            for (ScenarioOwner scenarioOwner : EnumSet.allOf(ScenarioOwner.class)) {
                lookup.put(scenarioOwner.getCode(), scenarioOwner);
            }
        }

        private ScenarioOwner(int n3, String string2) {
            this.code = n3;
            this.localizable = string2;
        }

        public int getCode() {
            return this.code;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public static ScenarioOwner get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioOwner code: " + n2 + ", defaulting to " + SCENARIO_OWNER_UNDEFINED.name()));
                return SCENARIO_OWNER_UNDEFINED;
            }
        }

        public static ScenarioOwner get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioOwner code: " + string + ", defaulting to " + SCENARIO_OWNER_UNDEFINED.name()));
                return SCENARIO_OWNER_UNDEFINED;
            }
        }
    }

    public static enum ScenarioPlayMode {
        SCENARIO_PLAYMODE_UNDEFINED(0, "scenario.label.playmode"),
        SCENARIO_PLAYMODE_CORRECTION(1, "scenario.label.playmode.correction"),
        SCENARIO_PLAYMODE_EDITONLY(2, "scenario.label.playmode.editonly"),
        SCENARIO_PLAYMODE_EXAM(3, "scenario.label.playmode.exam"),
        SCENARIO_PLAYMODE_FREE_CHOICE(4, "scenario.label.playmode.freechoice"),
        SCENARIO_PLAYMODE_ETEST(5, "scenario.label.playmode.etest"),
        SCENARIO_PLAYER_PLAYMODE(6, "scenario.player.label.playmode"),
        SCENARIO_PLAYER_PLAYMODE_REVIEW(7, "scenario.player.label.playmode");

        private static final Map<Integer, ScenarioPlayMode> lookup;
        private int code;
        private String localizable;

        static {
            lookup = new HashMap<Integer, ScenarioPlayMode>();
            for (ScenarioPlayMode scenarioPlayMode : EnumSet.allOf(ScenarioPlayMode.class)) {
                lookup.put(scenarioPlayMode.getCode(), scenarioPlayMode);
            }
        }

        private ScenarioPlayMode(int n3, String string2) {
            this.code = n3;
            this.localizable = string2;
        }

        public int getCode() {
            return this.code;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public static ScenarioPlayMode get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioPlayMode code: " + n2 + ", defaulting to " + SCENARIO_PLAYMODE_UNDEFINED.name()));
                return SCENARIO_PLAYMODE_UNDEFINED;
            }
        }

        public static ScenarioPlayMode get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioPlayMode code: " + string + ", defaulting to " + SCENARIO_PLAYMODE_UNDEFINED.name()));
                return SCENARIO_PLAYMODE_UNDEFINED;
            }
        }
    }

    public static enum ScenarioRepeatOption {
        SCENARIO_REPEAT_OPTION_UNDEFINED(0, "", ""),
        SCENARIO_REPEAT_OPTION_CORRECT(1, "Richtige Aufgaben", "repeatCorrect"),
        SCENARIO_REPEAT_OPTION_INCORRECT(2, "Falsche Aufgaben", "repeatWrong"),
        SCENARIO_REPEAT_OPTION_UNANSWERED(3, "Unbeantwortete Aufgaben", "repeatUnanswered");

        private static final Map<Integer, ScenarioRepeatOption> lookup;
        private int code;
        private String localizable;
        private String formAttr;

        static {
            lookup = new HashMap<Integer, ScenarioRepeatOption>();
            for (ScenarioRepeatOption scenarioRepeatOption : EnumSet.allOf(ScenarioRepeatOption.class)) {
                lookup.put(scenarioRepeatOption.getCode(), scenarioRepeatOption);
            }
        }

        private ScenarioRepeatOption(int n3, String string2, String string3) {
            this.code = n3;
            this.localizable = string2;
            this.formAttr = string3;
        }

        public int getCode() {
            return this.code;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public String getFormAttribute() {
            return this.formAttr;
        }

        public static ScenarioRepeatOption get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioRepeatOption code: " + n2 + ", defaulting to " + SCENARIO_REPEAT_OPTION_UNDEFINED.name()));
                return SCENARIO_REPEAT_OPTION_UNDEFINED;
            }
        }

        public static ScenarioRepeatOption get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioRepeatOption code: " + string + ", defaulting to " + SCENARIO_REPEAT_OPTION_UNDEFINED.name()));
                return SCENARIO_REPEAT_OPTION_UNDEFINED;
            }
        }
    }

    public static enum ScenarioType {
        SCENARIO_TYPE_UNDEFINED(0, "scenario.label.type"),
        SCENARIO_TYPE_STATIC(1, "scenario.label.definition.type.static"),
        SCENARIO_TYPE_DYNAMIC(2, "scenario.label.definition.type.dynamic");

        private static final Map<Integer, ScenarioType> lookup;
        private int code;
        private String localizable;

        static {
            lookup = new HashMap<Integer, ScenarioType>();
            for (ScenarioType scenarioType : EnumSet.allOf(ScenarioType.class)) {
                lookup.put(scenarioType.getCode(), scenarioType);
            }
        }

        private ScenarioType(int n3, String string2) {
            this.code = n3;
            this.localizable = string2;
        }

        public int getCode() {
            return this.code;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public static ScenarioType get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioType code: " + n2 + ", defaulting to " + SCENARIO_TYPE_UNDEFINED.name()));
                return SCENARIO_TYPE_UNDEFINED;
            }
        }

        public static ScenarioType get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioType code: " + string + ", defaulting to " + SCENARIO_TYPE_UNDEFINED.name()));
                return SCENARIO_TYPE_UNDEFINED;
            }
        }
    }
}

