/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.fo.x;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.lr.a;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPScenarioElementResult;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.scenario.ILPScenarioManager;
import ch.ionesoft.ilp.book.scenario.b;
import ch.ionesoft.ilp.book.scenario.c;
import ch.ionesoft.ilp.book.scenario.d;
import ch.ionesoft.ilp.book.scenario.n;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.json.ionesoft.f;
import org.json.ionesoft.i;

@DatabaseTable(tableName="ZILPSCENARIO")
public class ILPScenario
extends AbstractCoreDataModel
implements ch.ionesoft.ilp.book.lr.b {
    public static final String RATING_PRECISION = "ILPETest.ratingPrecision";
    public static final String POINTS_PRECISION = "ILPETest.pointsPrecision";
    private static ILogger logger = ILPLogManager.getLogger(ILPScenario.class);
    private static final String JSON_KEY_PK = "pk";
    private static final String JSON_KEY_ID = "id";
    private static final String JSON_KEY_NAME = "name";
    private static final String JSON_KEY_DURATION = "duration";
    private static final String JSON_KEY_PLAYMODE = "playMode";
    private static final String JSON_KEY_EXERCISES_CORRECT = "exercisesCorrect";
    private static final String JSON_KEY_EXERCISES_TOTAL = "exercisesTotal";
    private static final String JSON_KEY_ELEMENTS_PROCESSED = "elementsProcessed";
    private static final String JSON_KEY_ELEMENTS_TOTAL = "elementsTotal";
    private static final String JSON_KEY_STARTABLE = "startable";
    private static final String JSON_KEY_COMMAND_START = "commandStart";
    private static final String JSON_KEY_COMMAND_BACK = "commandBack";
    public static final String TABLE_NAME = "ZILPSCENARIO";
    public static final String ID_FIELD_NAME = "ZID";
    public static final String NAME_FIELD_NAME = "ZNAME";
    public static final String CREATION_DATE_FIELD_NAME = "ZCREATIONDATE";
    public static final String START_DATE_FIELD_NAME = "ZSTARTDATE";
    public static final String COMPLETION_DATE_FIELD_NAME = "ZCOMPLETIONDATE";
    public static final String DURATION_FIELD_NAME = "ZDURATION";
    public static final String CURRENT_FIELD_NAME = "ZCURRENT";
    public static final String PLAY_MODE_FIELD_NAME = "ZPLAYMODE";
    public static final String STATUS_FIELD_NAME = "ZSTATUS";
    public static final String LOADSAVEANSWERS_FIELD_NAME = "ZLOADSAVEANSWERS";
    public static final String PROLOG_TOPIC_FK_FIELD_NAME = "ZPROLOG";
    public static final String EPILOG_TOPIC_FK_FIELD_NAME = "ZEPILOG";
    public static final String SCENARIO_DEFINITION_FK_FIELD_NAME = "ZSCENARIODEFINITION";
    @DatabaseField(columnName="ZID", canBeNull=false, index=true)
    private String id;
    @DatabaseField(columnName="ZNAME", canBeNull=false, index=true)
    private String name;
    @DatabaseField(columnName="ZCREATIONDATE", canBeNull=false, index=true)
    private Date creationDate;
    @DatabaseField(columnName="ZSTARTDATE", index=true)
    private Date startDate;
    @DatabaseField(columnName="ZCOMPLETIONDATE", index=true)
    private Date completionDate;
    @DatabaseField(columnName="ZDURATION")
    private Float duration;
    @DatabaseField(columnName="ZCURRENT", index=true)
    private boolean current;
    @DatabaseField(columnName="ZPLAYMODE", canBeNull=false)
    private Integer playMode;
    @DatabaseField(columnName="ZSTATUS", canBeNull=false)
    private Integer status;
    @DatabaseField(columnName="ZLOADSAVEANSWERS")
    private Boolean loadSaveAnswersOnScenario;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=1, columnName="ZSCENARIODEFINITION", canBeNull=false, index=true)
    private ILPScenarioDefinition scenarioDefinition;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZPROLOG")
    private ILPScenarioElement prolog;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZEPILOG")
    private ILPScenarioElement epilog;
    @ForeignCollectionField(orderColumnName="ZORDER")
    private ForeignCollection<ILPScenarioElementResult> scenarioElementResults;

    public ILPScenario() {
        this.id = UUID.randomUUID().toString();
    }

    public ILPScenario(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Date date) {
        this.completionDate = date;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float f2) {
        this.duration = f2;
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean bl2) {
        this.current = bl2;
    }

    public ILPScenarioDefinition.ScenarioPlayMode getPlayMode() {
        if (this.playMode != null) {
            return ILPScenarioDefinition.ScenarioPlayMode.get(this.playMode);
        }
        return ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_UNDEFINED;
    }

    public void setPlayMode(ILPScenarioDefinition.ScenarioPlayMode scenarioPlayMode) {
        this.playMode = scenarioPlayMode.getCode();
    }

    public ScenarioStatus getStatusEnum() {
        if (this.status != null) {
            return ScenarioStatus.get(this.status);
        }
        return ScenarioStatus.SCENARIO_STATUS_UNDEFINED;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(ScenarioStatus scenarioStatus) {
        this.status = scenarioStatus.getCode();
    }

    public ILPScenarioDefinition getScenarioDefinition() {
        return this.scenarioDefinition;
    }

    public void setScenarioDefinition(ILPScenarioDefinition iLPScenarioDefinition) {
        this.scenarioDefinition = iLPScenarioDefinition;
    }

    public ForeignCollection<ILPScenarioElementResult> getScenarioElementResults() {
        if (this.scenarioElementResults == null) {
            try {
                g.a().aN().assignEmptyForeignCollection((Object)this, "scenarioElementResults");
                this.scenarioElementResults.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for scenario.scenarioElementResults", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.scenarioElementResults;
    }

    public void setScenarioElementResults(ForeignCollection<ILPScenarioElementResult> foreignCollection) {
        this.scenarioElementResults = foreignCollection;
    }

    public boolean isFinished() {
        Dao<ILPScenarioElementResult, Integer> dao = g.a().aQ();
        Where where = dao.queryBuilder().where();
        try {
            return where.eq("ZSCENARIO", (Object)this.getPk()).and().eq("ZPROCESSED", (Object)false).countOf() == 0L;
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Failed to count the processed elements for scenario: " + this.getPk()));
            return false;
        }
    }

    private float getSafeRate(float f2) {
        return Math.max(Math.min(f2, 1.0f), 0.0f);
    }

    public float getProgressRate() {
        int n2 = this.getScenarioElementResults().size();
        if (n2 > 0) {
            return this.getSafeRate((float)this.getProcessedElementCount() / (float)n2);
        }
        return 0.0f;
    }

    public long getProcessedElementCount() {
        Dao<ILPScenarioElementResult, Integer> dao = g.a().aQ();
        Where where = dao.queryBuilder().where();
        try {
            where.eq("ZPROCESSED", (Object)true);
            where = where.and();
            where.eq("ZSCENARIO", (Object)this.getPk());
            return where.countOf();
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Failed to calculate the progress rate of scenario: " + this.getPk()));
            return 0L;
        }
    }

    public int getProgressPercentage() {
        return (int)(this.getProgressRate() * 100.0f);
    }

    public long getNumberOfExercises() {
        return ch.ionesoft.ilp.book.pe.f.a().g(this);
    }

    public long getNumberOfCorrectExercises() {
        return ch.ionesoft.ilp.book.pe.f.a().c(this);
    }

    public float getSuccessRate() {
        long l2 = this.getNumberOfCorrectExercises();
        long l3 = this.getNumberOfExercises();
        if (l2 == 0L || l3 == 0L) {
            return 0.0f;
        }
        return this.getSafeRate((float)l2 / (float)l3);
    }

    public int getSuccessPercentage() {
        return (int)(this.getSuccessRate() * 100.0f);
    }

    public String getRate() {
        return ConverterUtil.convertNumberToString_defaultValue((Number)Float.valueOf(ConverterUtil.roundFloatWithPrecision((float)(this.getSuccessRate() * 5.0f + 1.0f), (float)0.5f)), (String)"");
    }

    public float getTotalDurationFromElementResults() {
        Dao<ILPScenarioElementResult, Integer> dao = g.a().aQ();
        String string = String.format(Locale.ENGLISH, "SELECT SUM(%4$s) FROM %1$s WHERE %2$s = %3$s AND %4$s IS NOT NULL;", "ZILPSCENARIOELEMENTRESULT", "ZSCENARIO", this.getPk(), DURATION_FIELD_NAME);
        try {
            GenericRawResults genericRawResults = dao.queryRaw(string, new String[0]);
            String string2 = ((String[])genericRawResults.getFirstResult())[0];
            return string2 == null ? 0.0f : Float.parseFloat(string2);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Failed to retrieve the used time of the scenario: " + this.getPk()));
            return 0.0f;
        }
    }

    public Float getTimeLeftSeconds() {
        if (!this.hasDuration()) {
            return null;
        }
        return Float.valueOf(this.getDuration().floatValue() - this.getTotalDurationFromElementResults());
    }

    public String getDurationHumanReadable() {
        return ILPScenarioManager.getInstance().getDurationForUserOutput(this.getTotalDurationFromElementResults(), false);
    }

    public String getMaxDurationHumanReadable() {
        return ILPScenarioManager.getInstance().getDurationForUserOutput(this.getDuration().floatValue(), true);
    }

    public float getDurationRate() {
        return this.getSafeRate(this.getTotalDurationFromElementResults() / this.getDuration().floatValue());
    }

    public float getDurationPercentage() {
        return this.getDurationRate() * 100.0f;
    }

    public long getIterationNumber() {
        Dao<ILPScenario, Integer> dao = g.a().aN();
        Where where = dao.queryBuilder().where();
        try {
            return where.eq(SCENARIO_DEFINITION_FK_FIELD_NAME, (Object)this.getScenarioDefinition().getPk()).and().lt(CREATION_DATE_FIELD_NAME, (Object)this.getCreationDate()).countOf() + 1L;
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Failed to count the scenarios which were created before this scenario: " + this.getPk()));
            return 1L;
        }
    }

    public Boolean isLoadSaveAnswersOnScenario() {
        return this.loadSaveAnswersOnScenario;
    }

    public void setLoadSaveAnswersOnScenario(Boolean bl2) {
        this.loadSaveAnswersOnScenario = bl2;
    }

    public boolean isETest() {
        return ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_ETEST.getCode() == this.playMode.intValue();
    }

    public boolean hasExercises() {
        Dao<ILPScenarioElementResult, Integer> dao = g.a().aQ();
        QueryBuilder queryBuilder = dao.queryBuilder();
        Dao<ILPScenarioElement, Integer> dao2 = g.a().aP();
        QueryBuilder queryBuilder2 = dao2.queryBuilder();
        try {
            queryBuilder2.where().isNotNull("ZEXERCISE");
            queryBuilder.where().eq("ZSCENARIO", (Object)this.getPk());
            return queryBuilder.join(queryBuilder2).countOf() > 0L;
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Failed to test if scenario has exercises attached: " + this), (Throwable)sQLException);
            return false;
        }
    }

    public boolean hasPrologPage() {
        return this.prolog != null;
    }

    public ILPScenarioElement getProlog() {
        return this.prolog;
    }

    public void setProlog(ILPScenarioElement iLPScenarioElement) {
        this.prolog = iLPScenarioElement;
    }

    public boolean hasEpilogPage() {
        return this.epilog != null;
    }

    public ILPScenarioElement getEpilog() {
        return this.epilog;
    }

    public void setEpilog(ILPScenarioElement iLPScenarioElement) {
        this.epilog = iLPScenarioElement;
    }

    public b getPlayConfiguration() throws n {
        return ILPScenarioManager.getInstance().getPlayConfiguration(this);
    }

    public b getPlayConfigurationOrDefault() {
        try {
            return this.getPlayConfiguration();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get PlayConfiguration from scenario: " + this), (Throwable)exception);
            return new c();
        }
    }

    public d getETestResults() throws n {
        try {
            d d2 = new d(this);
            float f2 = this.getScenarioDefinition().getScenarioSpecification().getPointsPrecision();
            float f3 = 0.95f;
            float f4 = 0.95f;
            d2.a(f3, f4, f2);
            return d2;
        }
        catch (Exception exception) {
            logger.d((Object)"Could not create test rating: ", (Throwable)exception);
            throw new n("Could not create test rating.", exception);
        }
    }

    public String getElementResultsJSON(String string, String string2) {
        List<ILPScenarioElementResult> list = ch.ionesoft.ilp.book.pe.f.a().h(this);
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        float f2 = this.getScenarioDefinition().getScenarioSpecification().getPointsPrecision();
        f f3 = new f();
        for (ILPScenarioElementResult iLPScenarioElementResult : list) {
            try {
                i i2 = new i();
                i2.c("title", (Object)iLPScenarioElementResult.getScenarioElement().getElementStrategy().b().replace("\"", "\\\""));
                i2.b("reachedPoints", (double)iLPScenarioElementResult.getReachedPointsWithPrecision(f2));
                i2.b("maxPoints", (double)iLPScenarioElementResult.getMaxPointsFromExercise());
                i2.c("pointsLoc", (Object)string);
                i2.c("ofLoc", (Object)string2);
                i2.c("navigateTo", (Object)(String.valueOf(h.W()) + "scenario/scenario/jumpTo?isReviewElementCall=true&pk=" + iLPScenarioElementResult.getPk()));
                f3.a((Object)i2);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not get result data for json for scenarioElementResult: " + iLPScenarioElementResult), (Throwable)exception);
            }
        }
        return f3.toString();
    }

    public String toJSON(String string, boolean bl2, boolean bl3) {
        try {
            d d2 = this.getETestResults();
            i i2 = new i();
            i2.b(JSON_KEY_PK, this.pk);
            i2.c(JSON_KEY_ID, (Object)this.id);
            i2.c(JSON_KEY_NAME, (Object)this.name.replace("\"", "\\\""));
            i2.c("username", (Object)string);
            i2.b("pointsReached", (double)d2.e());
            i2.b("pointsTotal", (double)d2.f());
            i2.b(JSON_KEY_EXERCISES_CORRECT, d2.a());
            i2.b("exercisesUnsolved", d2.b());
            i2.c("durationSpend", (Object)this.getDurationHumanReadable());
            i2.b("grade", (double)d2.a(0.5f));
            i2.b("networkActive", x.a().a(false));
            i2.b("serverConnActive", x.a().a(false));
            i2.c("appVersion", (Object)SystemHelper.programVersion());
            i2.c("appVersion", (Object)SystemHelper.programVersion());
            i2.b("showTransmissionSuccess", bl2);
            i2.b("showTransmissionFail", bl3);
            return i2.toString();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not generate JSON for from scenario: " + this), (Throwable)exception);
            return "";
        }
    }

    @Override
    public String toString() {
        return "ILPScenario [name=" + this.name + ", creationDate=" + this.creationDate + ", startDate=" + this.startDate + ", completionDate=" + this.completionDate + ", duration=" + this.duration + ", current=" + this.current + ", playMode=" + this.playMode + ", scenarioDefinition=" + this.scenarioDefinition + "]";
    }

    @Override
    public void unpackInto(List<a> list) {
        ForeignCollection<ILPScenarioElementResult> foreignCollection = this.getScenarioElementResults();
        if (foreignCollection == null || foreignCollection.size() < 1) {
            logger.b((Object)("No Scenario Element Results. No statements can get formalized because no corresponding information given." + this));
            return;
        }
        for (ILPScenarioElementResult iLPScenarioElementResult : foreignCollection) {
            iLPScenarioElementResult.unpackInto(list);
        }
    }

    public static enum ScenarioStatus {
        SCENARIO_STATUS_UNDEFINED(0, "", false),
        SCENARIO_STATUS_CREATED(1, "scenario.label.status.ready", true),
        SCENARIO_STATUS_RUNNING(2, "scenario.label.status.running", true),
        SCENARIO_STATUS_INTERRUPTED(3, "", true),
        SCENARIO_STATUS_FINISHED(4, "scenario.label.status.finished", false),
        SCENARIO_STATUS_DURATION_REACHED(5, "scenario.label.status.duration.reached", false);

        private static final Map<Integer, ScenarioStatus> lookup;
        private int code;
        private String localizable;
        private boolean startable;

        static {
            lookup = new HashMap<Integer, ScenarioStatus>();
            for (ScenarioStatus scenarioStatus : EnumSet.allOf(ScenarioStatus.class)) {
                lookup.put(scenarioStatus.getCode(), scenarioStatus);
            }
        }

        private ScenarioStatus(int n3, String string2, boolean bl2) {
            this.code = n3;
            this.localizable = string2;
            this.startable = bl2;
        }

        public int getCode() {
            return this.code;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public boolean isStartable() {
            return this.startable;
        }

        public static ScenarioStatus get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioStatus code: " + n2 + ", defaulting to " + SCENARIO_STATUS_UNDEFINED.name()));
                return SCENARIO_STATUS_UNDEFINED;
            }
        }

        public static ScenarioStatus get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined ScenarioStatus code: " + string + ", defaulting to " + SCENARIO_STATUS_UNDEFINED.name()));
                return SCENARIO_STATUS_UNDEFINED;
            }
        }
    }
}

