/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.fo.o;
import ch.ionesoft.ilp.base.fo.p;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.base.he.HTMLUtils;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAssetDefinition;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPExerciseDefinition;
import ch.ionesoft.ilp.book.mo.ILPExercise_Resource;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.mo.ILPTopicDefinition;
import ch.ionesoft.ilp.book.mo.ILPTopic_Resource;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsContent;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.rm.a;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPRESOURCE")
public class ILPResource
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPResource.class);
    private static final int MAX_BLOB_SIZE = 0x100000;
    public static final String TABLE_NAME = "ZILPRESOURCE";
    public static final String IDENTIFIER_FIELD_NAME = "ZIDENTIFIER";
    public static final String HREF_FIELD_NAME = "ZHREF";
    public static final String RESOURCE_LOCATION_FIELD_NAME = "ZRESOURCELOCATION";
    public static final String LOCAL_RELATIVE_PATH_NAME = "ZLOCALPATH";
    public static final String MEDIATYPE_FIELD_NAME = "ZMEDIATYPE";
    public static final String RESOURCE_GROUP_FIELD_NAME = "ZGROUP";
    public static final String RESOURCE_REFERENCE_FIELD_NAME = "ZREFERENCETYPE";
    public static final String LASTUPDATE_FIELD_NAME = "ZLASTUPDATE";
    public static final String DATA_FIELD_NAME = "ZDATA";
    public static final String PLAINDATA_FIELD_NAME = "ZPLAINDATA";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String SIZEBYTES_FIELD_NAME = "ZSIZEBYTES";
    public static final String ORDER_FIELD_NAME = "ZORDER";
    public static final String ISSUE_FK_FIELD_NAME = "ZISSUE";
    public static final String TOPIC_FK_FIELD_NAME = "ZTOPIC";
    public static final String EXERCISE_FK_FIELD_NAME = "ZEXERCISE";
    public static final String TOPIC_DEFINITION_FK_FIELD_NAME = "ZTOPICDEFINITION";
    public static final String EXERCISE_DEFINITION_FK_FIELD_NAME = "ZEXERCISEDEFINITION";
    public static final String ASSET_DEFINITION_FK_FIELD_NAME = "ZASSETDEFINITION";
    public static final String LMS_CONTENT_FK_FIELD_NAME = "ZLMSCONTENT";
    @DatabaseField(columnName="ZIDENTIFIER", canBeNull=true, index=true)
    private String identifier;
    @DatabaseField(columnName="ZHREF", canBeNull=true, index=true)
    private String href;
    @DatabaseField(columnName="ZRESOURCELOCATION", canBeNull=true, index=true)
    private Integer resourceLocation;
    @DatabaseField(columnName="ZLOCALPATH", canBeNull=true, index=false)
    private String localRelativePath;
    @DatabaseField(columnName="ZMEDIATYPE", canBeNull=true, index=true)
    private String mediaType;
    @DatabaseField(columnName="ZGROUP", canBeNull=true, index=true)
    private Integer resourceGroupType;
    @DatabaseField(columnName="ZREFERENCETYPE", canBeNull=true, index=true)
    private Integer resourceReferenceType;
    @DatabaseField(columnName="ZLASTUPDATE", canBeNull=true)
    private DateTime lastUpdate;
    @DatabaseField(columnName="ZDATA", dataType=DataType.BYTE_ARRAY, canBeNull=true)
    private byte[] data;
    @DatabaseField(columnName="ZPLAINDATA", dataType=DataType.BYTE_ARRAY, canBeNull=true)
    private byte[] plainData;
    @DatabaseField(columnName="ZTITLE", canBeNull=true, index=true)
    private String title;
    @DatabaseField(columnName="ZSIZEBYTES", canBeNull=true)
    private Long sizeBytes;
    @DatabaseField(columnName="ZORDER", canBeNull=true, index=true)
    private Long order;
    private Boolean selected;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZISSUE", canBeNull=true, index=true)
    private ILPIssueDef issue;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZTOPIC", canBeNull=true, index=true)
    private ILPTopic topic;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZEXERCISE", canBeNull=true, index=true)
    private ILPExercise exericse;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZTOPICDEFINITION", index=true, canBeNull=true)
    private ILPTopicDefinition topicDefinition;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZEXERCISEDEFINITION", index=true, canBeNull=true)
    private ILPExerciseDefinition exerciseDefinition;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZASSETDEFINITION", index=true, canBeNull=true)
    private ILPAssetDefinition assetDefinition;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZLMSCONTENT", index=true, canBeNull=true)
    private ILPLessonsContent lmsContent;
    @ForeignCollectionField(orderColumnName="ZEXERCISE")
    private ForeignCollection<ILPScenarioElement> scenarioElements;

    public ILPResource(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation.getCode();
    }

    public ILPResource() {
    }

    public ILPTopicDefinition getTopicDefinition() {
        return this.topicDefinition;
    }

    public void setTopicDefinition(ILPTopicDefinition iLPTopicDefinition) {
        this.topicDefinition = iLPTopicDefinition;
    }

    public ILPExerciseDefinition getExerciseDefinition() {
        return this.exerciseDefinition;
    }

    public void setExerciseDefinition(ILPExerciseDefinition iLPExerciseDefinition) {
        this.exerciseDefinition = iLPExerciseDefinition;
    }

    public ILPAssetDefinition getAssetDefinition() {
        return this.assetDefinition;
    }

    public void setAssetDefinition(ILPAssetDefinition iLPAssetDefinition) {
        this.assetDefinition = iLPAssetDefinition;
    }

    public ILPLessonsContent getLmsContent() {
        return this.lmsContent;
    }

    public void setLmsContent(ILPLessonsContent iLPLessonsContent) {
        this.lmsContent = iLPLessonsContent;
    }

    public ForeignCollection<ILPScenarioElement> getScenarioElements() {
        if (this.scenarioElements == null) {
            try {
                g.a().H().assignEmptyForeignCollection((Object)this, "scenarioElements");
                this.scenarioElements.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for resource.scenarioElements", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.scenarioElements;
    }

    public void setScenarioItems(ForeignCollection<ILPScenarioElement> foreignCollection) {
        this.scenarioElements = foreignCollection;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String string) {
        this.href = string;
    }

    public ResourceLocation getResourceLocation() {
        return ResourceLocation.get(this.getResourceLocationType());
    }

    public Integer getResourceLocationType() {
        return this.resourceLocation;
    }

    public void setResourceLocation(Integer n2) {
        this.resourceLocation = n2;
    }

    public void setResourceLocation(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation.getCode();
    }

    public String getLocalRelativePath() {
        return this.localRelativePath;
    }

    public void setLocalRelativePath(String string) {
        this.localRelativePath = string;
    }

    public String downloadOrHrefUrl() {
        if (this.getLocalRelativePath() != null) {
            return this.getLocalUrlString();
        }
        return this.getHref();
    }

    public String getLocalUrlString() {
        if (this.getLocalRelativePath() != null) {
            return this.getAbsolutPath().getAbsolutePath();
        }
        return null;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String string) {
        this.mediaType = string;
        this.fixResourceGroup();
    }

    public Integer getResourceGroupType() {
        return this.resourceGroupType;
    }

    public void setResourceGroupType(Integer n2) {
        this.resourceGroupType = n2;
    }

    public ResourceGroup getResourceGroup() {
        if (this.getResourceGroupType() != null) {
            return ResourceGroup.getByCode(this.getResourceGroupType());
        }
        return ResourceGroup.RESOURCE_GROUP_UNDEFINED;
    }

    public void setResourceGroup(ResourceGroup resourceGroup) {
        this.setResourceGroupType(resourceGroup.getCode());
    }

    public ResourceGroup detectResourceGroup() {
        return ResourceGroup.fromMimeType(this.getMediaType());
    }

    public void fixResourceGroup() {
        this.setResourceGroup(this.detectResourceGroup());
    }

    public Integer getResourceReferenceType() {
        return this.resourceReferenceType;
    }

    public void setResourceReferenceType(Integer n2) {
        this.resourceReferenceType = n2;
    }

    public ResourceReference getResourceReference() {
        if (this.resourceReferenceType != null) {
            return ResourceReference.get(this.getResourceReferenceType());
        }
        return ResourceReference.RESOURCE_REFERENCE_UNDEFINED;
    }

    public void setResourceReference(ResourceReference resourceReference) {
        this.setResourceReferenceType(resourceReference.getCode());
    }

    public List<ILPTopic> getReferencingTopics() {
        try {
            return g.a().a(this);
        }
        catch (SQLException sQLException) {
            logger.d((Object)"Could not fetch referencingTopics", (Throwable)sQLException);
            return null;
        }
    }

    public ILPTopic getFirstReferencingTopicPreferringIssue(ILPIssueDef iLPIssueDef) {
        List<ILPTopic> list = this.getReferencingTopics();
        if (list == null) {
            return null;
        }
        for (ILPTopic iLPTopic : list) {
            if (!iLPTopic.getIssue().equals(iLPIssueDef)) continue;
            return iLPTopic;
        }
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<ILPExercise> getReferencingExercises() {
        try {
            return g.a().b(this);
        }
        catch (SQLException sQLException) {
            logger.d((Object)"Could not fetch referencingExercises", (Throwable)sQLException);
            return null;
        }
    }

    public ILPExercise getFirstReferencingExercisePreferringIssue(ILPIssueDef iLPIssueDef) {
        List<ILPExercise> list = this.getReferencingExercises();
        if (list == null) {
            return null;
        }
        for (ILPExercise iLPExercise : list) {
            if (!iLPExercise.getIssue().equals(iLPIssueDef)) continue;
            return iLPExercise;
        }
        return list.size() > 0 ? list.get(0) : null;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(DateTime dateTime) {
        this.lastUpdate = dateTime;
    }

    public void setLastUpdate(Date date) {
        if (date != null) {
            this.lastUpdate = new DateTime((Object)date);
        } else {
            date = null;
        }
    }

    public byte[] getData() {
        if (SystemHelper.isAndroidSystem() && this.sizeBytes != null && this.sizeBytes >= 0x100000L) {
            try {
                File file = ILPBookSettingsHelper.instance().blobFilepathForResourceData(this);
                if (file.exists()) {
                    return FileHelper.readFile((File)file);
                }
                file = ILPBookSettingsHelper.instance().blobFilepathForResourceData(f.a().d(this.getIssue().getCourse()), this.getHref());
                if (file.exists()) {
                    return FileHelper.readFile((File)file);
                }
                logger.c((Object)("No external blob found for data with href: " + this.href));
                return this.data;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not read resource data in external blob for href: " + this.getHref()), (Throwable)exception);
                return this.data;
            }
        }
        return this.data;
    }

    public String getDataString() {
        byte[] byArray = this.getData();
        if (byArray != null) {
            return new String(byArray, Charset.forName("UTF-8"));
        }
        return "";
    }

    public void setDataString(String string) {
        this.setData(string.getBytes(Charset.forName("UTF-8")));
    }

    public void setData(byte[] byArray) {
        if (SystemHelper.isAndroidSystem() && byArray != null && byArray.length >= 0x100000) {
            this.data = null;
            try {
                FileHelper.writeFile((File)ILPBookSettingsHelper.instance().blobFilepathForResourceData(this), (byte[])byArray);
                this.setSizeBytes(Long.valueOf(byArray.length));
            }
            catch (IOException iOException) {
                logger.d((Object)("Could not store resource data in external blob for href: " + this.getHref()), (Throwable)iOException);
            }
        } else {
            this.data = byArray;
        }
    }

    public void setData(o o2) {
        this.setData(o2.c());
    }

    public byte[] getPlainData() {
        if (SystemHelper.isAndroidSystem() && this.sizeBytes != null && this.sizeBytes >= 0x100000L) {
            try {
                File file = ILPBookSettingsHelper.instance().blobFilepathForResourcePlainData(this);
                if (file.exists()) {
                    return FileHelper.readFile((File)file);
                }
                file = ILPBookSettingsHelper.instance().blobFilepathForResourcePlainData(f.a().d(this.getIssue().getCourse()), this.getHref());
                if (file.exists()) {
                    return FileHelper.readFile((File)file);
                }
                if (this.plainData == null) {
                    logger.c((Object)("No external blob found for plain data with href: " + this.href));
                }
                return this.plainData;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not read resource plain data in external blob for href: " + this.getHref()), (Throwable)exception);
                return this.plainData;
            }
        }
        return this.plainData;
    }

    public String getPlainDataString() {
        byte[] byArray = this.getPlainData();
        if (byArray != null) {
            return new String(byArray, Charset.forName("UTF-8"));
        }
        return "";
    }

    public void setPlainData(byte[] byArray) {
        if (SystemHelper.isAndroidSystem() && byArray != null && byArray.length >= 0x100000) {
            this.plainData = null;
            try {
                FileHelper.writeFile((File)ILPBookSettingsHelper.instance().blobFilepathForResourcePlainData(this), (byte[])byArray);
            }
            catch (IOException iOException) {
                logger.d((Object)("Could not store resource plain data in external blob for href: " + this.getHref()), (Throwable)iOException);
            }
        } else {
            this.plainData = byArray;
        }
    }

    public void setPlainDataString(String string) {
        this.setPlainData(string.getBytes(Charset.forName("UTF-8")));
    }

    public void fillData_mediaType_plainText(o o2, String string, String string2) {
        this.setData(o2);
        this.setSizeBytes(Long.valueOf(o2.a()));
        try {
            if (string != null && (string.equals("text/html") || string.equals("text/plain") || string.equals("application/xhtml+xml"))) {
                if (string2 == null) {
                    String string3 = o2.toString();
                    String string4 = null;
                    p p2 = p.a((String)string3);
                    p2.a(false);
                    if (p2.b("<body", null) && p2.a("<body", null)) {
                        p2.b(">", null);
                        string4 = p2.d().substring(p2.c() + 1);
                    }
                    if (string4 == null || string4.length() <= 1) {
                        string4 = string3;
                    }
                    if (string4 != null) {
                        string4 = string4.replaceAll("<br\\s*\\/?>", " ");
                    }
                    string2 = StringHelper.trim((String)HTMLUtils.stringByConvertingHTMLToPlainText((String)string4));
                }
                this.setPlainData(string2.getBytes());
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not fillData for resource: " + this), (Throwable)exception);
        }
    }

    public ILPIssueDef getIssue() {
        return this.issue;
    }

    public void setIssue(ILPIssueDef iLPIssueDef) {
        this.issue = iLPIssueDef;
    }

    public ILPTopic getTopic() {
        return this.topic;
    }

    public void setTopic(ILPTopic iLPTopic) {
        this.topic = iLPTopic;
    }

    public boolean isAssetDownloaded() {
        return a.a().h(this);
    }

    public boolean isAssetResource() {
        return this.getAssetDefinition() != null;
    }

    public boolean isUCSResource() {
        ResourceLocation resourceLocation = this.getResourceLocation();
        return resourceLocation == ResourceLocation.RESOURCE_LOCATION_UCS_LOCAL || resourceLocation == ResourceLocation.RESOURCE_LOCATION_UCS_SERVER;
    }

    public boolean isExternalDownloadable() {
        if (StringHelper.isEmpty((String)this.href)) {
            return false;
        }
        if (this.href.startsWith("http://localhost")) {
            return false;
        }
        if (this.href.contains("www.youtube.com") || this.href.contains("youtu.be") || this.href.contains("vimeo.com")) {
            return false;
        }
        if (StringHelper.isEmpty((String)this.getMediaType())) {
            return false;
        }
        return !this.getResourceLocation().equals((Object)ResourceLocation.RESOURCE_LOCATION_DATABASE);
    }

    public ResourceDetailState getResourceState() {
        a a2 = a.a();
        if (a2.h(this)) {
            return ResourceDetailState.RESOURCE_STATE_SAVED_LOCALLY;
        }
        if (a2.b(this) && this.isAssetResource() || this.isExternalDownloadable()) {
            return ResourceDetailState.RESOURCE_STATE_READY_TO_DOWNLOAD;
        }
        if (this.getResourceLocation() == ResourceLocation.RESOURCE_LOCATION_DATABASE) {
            return ResourceDetailState.RESOURCE_STATE_EMBEDDED;
        }
        return ResourceDetailState.RESOURCE_STATE_ONLY_STREAM_AVAILABLE;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Long getSizeBytes() {
        return this.sizeBytes != null ? this.sizeBytes : 0L;
    }

    public void setSizeBytes(Long l2) {
        this.sizeBytes = l2;
    }

    public Long getOrder() {
        return this.order;
    }

    public void setOrder(Long l2) {
        this.order = l2;
    }

    public Boolean isSelected() {
        if (this.selected != null && this.selected.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setSelected(Boolean bl2) {
        this.selected = bl2;
    }

    public void addTopicObject(ILPTopic iLPTopic) throws SQLException {
        ILPTopic_Resource iLPTopic_Resource = new ILPTopic_Resource(iLPTopic, this);
        g.a().ab().create((Object)iLPTopic_Resource);
    }

    public void addExerciseObject(ILPExercise iLPExercise) throws SQLException {
        ILPExercise_Resource iLPExercise_Resource = new ILPExercise_Resource(iLPExercise, this);
        g.a().ac().create((Object)iLPExercise_Resource);
    }

    public String getResourceIconCss() {
        String string = "";
        ResourceGroup resourceGroup = this.getResourceGroup();
        if (!resourceGroup.equals((Object)ResourceGroup.RESOURCE_GROUP_DOCUMENT)) {
            string = resourceGroup.getCssClass();
        } else {
            String string2;
            String string3 = "";
            string3 = this.getLocalRelativePath() != null ? this.getLocalRelativePath() : this.getHref();
            if (string3 == null) {
                string3 = this.getResourceLocation() == ResourceLocation.RESOURCE_LOCATION_UCS_SERVER ? String.valueOf(this.getTitle()) + "." + ConverterUtil.getFileExtensionForMimeType((String)this.getMediaType()) : this.getAssetDefinition().getRelativeFilePath();
            }
            if (StringHelper.isEmpty((String)(string2 = StringHelper.pathExtension((String)string3)))) {
                logger.c((Object)("Could not extract suffix from resource with identifier: " + this.getIdentifier() + " No icon will be displayed"));
                return string;
            }
            string = ILPResource.getResourceCssClassFromSuffix(string2);
        }
        return string;
    }

    public String getExternalVideoIconCss() {
        return "resourceVideoExternal";
    }

    public static String getResourceCssClassFromSuffix(String string) {
        String string2 = "";
        List<String> list = Arrays.asList("doc", "docx", "dot", "dotx", "odt", "ost", "ott", "pdf", "pot", "ppt", "pptx", "pst", "xls", "xlsx", "xlt", "xltx");
        string2 = list.contains(string.toLowerCase()) ? "resource" + StringHelper.capitalizeFirstLetter((String)string.toLowerCase()) : "resourceOther";
        return string2;
    }

    public String getFileReferenceFromUCSResource() {
        if (this.getResourceLocation() != ResourceLocation.RESOURCE_LOCATION_UCS_LOCAL && this.getResourceLocation() != ResourceLocation.RESOURCE_LOCATION_UCS_SERVER) {
            throw new UnsupportedOperationException("Only supported for resources with resourceLocation UCS_LOCAL or UCS_SERVER");
        }
        String[] stringArray = this.getIdentifier().split("_");
        return String.valueOf(stringArray[0]) + "_" + stringArray[1];
    }

    public Long getFileVersionFromUCSResource() {
        if (this.getResourceLocation() != ResourceLocation.RESOURCE_LOCATION_UCS_LOCAL && this.getResourceLocation() != ResourceLocation.RESOURCE_LOCATION_UCS_SERVER) {
            throw new UnsupportedOperationException("Only supported for resources with resourceLocation UCS_LOCAL or UCS_SERVER");
        }
        return Long.parseLong(this.getIdentifier().split("_")[2]);
    }

    @Override
    public String toString() {
        return "ILPResource [identifier=" + this.identifier + ", href=" + this.href + ", mediaType=" + this.mediaType + ", pk=" + this.pk + ", issue=" + this.issue + ", topic=" + this.topic + "]";
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.identifier == null ? 0 : this.identifier.hashCode());
        n3 = 31 * n3 + (this.issue == null ? 0 : this.issue.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPResource iLPResource = (ILPResource)object;
        if (this.identifier == null ? iLPResource.identifier != null : !this.identifier.equals(iLPResource.identifier)) {
            return false;
        }
        return !(this.issue == null ? iLPResource.issue != null : !this.issue.equals(iLPResource.issue));
    }

    public File getRootPath() {
        return this.getResourceLocation().getRootPath();
    }

    public File getAbsolutPath() {
        File file;
        block3: {
            try {
                file = this.getRootPath();
                if (file != null) break block3;
                return null;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not detect localPath of resource: " + this), (Throwable)exception);
                return null;
            }
        }
        return new File(file, this.getHref());
    }

    public ILPCourseDef getCourse() {
        if (this.getIssue() != null) {
            return this.getIssue().getCourse();
        }
        if (this.getTopicDefinition() != null) {
            return this.getTopicDefinition().getTopicProduct().getEProduct().determineCourseProduct().getCourse();
        }
        if (this.getExerciseDefinition() != null) {
            return this.getExerciseDefinition().getExerciseProduct().getEProduct().determineCourseProduct().getCourse();
        }
        return null;
    }

    public static enum MediaType {
        IMAGE_TOPIC,
        IMAGE_EXERCISE,
        VIDEO,
        AUDIO,
        DOCUMENT;

    }

    public static enum ResourceDetailState {
        RESOURCE_STATE_UNDEFINED("resourceDetail.label.status.undefined", "statusUndefined"),
        RESOURCE_STATE_READY_TO_DOWNLOAD("resourceDetail.label.status.readyToDownload", "statusReadyToDownload"),
        RESOURCE_STATE_ONLY_STREAM_AVAILABLE("resourceDetail.label.status.onlyStreamAvailable", "statusOnlyStreamAvailable"),
        RESOURCE_STATE_SAVED_LOCALLY("resourceDetail.label.status.savedLocally", "statusSavedLocally"),
        RESOURCE_STATE_INVALID_SOURCE("resourceDetail.label.status.invalidSource", "statusInvalidSource"),
        RESOURCE_STATE_EMBEDDED("resourceDetail.label.status.embedded", "statusEmbeddedSource");

        private String localizable;
        private String cssClass;

        private ResourceDetailState(String string2, String string3) {
            this.localizable = string2;
            this.cssClass = string3;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }

    public static enum ResourceGroup {
        RESOURCE_GROUP_UNDEFINED(0, "undefined", "resourceUndefined"),
        RESOURCE_GROUP_AUDIO(1, "audio", "resourceAudio"),
        RESOURCE_GROUP_VIDEO(2, "video", "resourceVideo"),
        RESOURCE_GROUP_IMAGE(3, "image", "resourceImage"),
        RESOURCE_GROUP_DOCUMENT(4, "document", "resourceDocument"),
        RESOURCE_GROUP_FONT(5, "font", "resourceFont"),
        RESOURCE_GROUP_HTML(6, "html", "resourceHtml"),
        RESOURCE_GROUP_CSS(7, "css", "resourceCss"),
        RESOURCE_GROUP_PLAINTEXT(8, "plaintext", "resourcePlaintext"),
        RESOURCE_GROUP_JS(9, "js", "resourceJS"),
        RESOURCE_GROUP_ZIP(10, "zip", "resourceZip");

        private static final Map<Integer, ResourceGroup> lookupCode;
        private static final Map<String, ResourceGroup> lookupKey;
        private int code;
        private String key;
        private String cssClass;

        static {
            lookupCode = new HashMap<Integer, ResourceGroup>();
            lookupKey = new HashMap<String, ResourceGroup>();
            for (ResourceGroup resourceGroup : EnumSet.allOf(ResourceGroup.class)) {
                lookupCode.put(resourceGroup.getCode(), resourceGroup);
                lookupKey.put(resourceGroup.getKey(), resourceGroup);
            }
        }

        private ResourceGroup(int n3, String string2, String string3) {
            this.code = n3;
            this.key = string2;
            this.cssClass = string3;
        }

        public int getCode() {
            return this.code;
        }

        public String getKey() {
            return this.key;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public String localizedName() {
            return ch.ionesoft.ilp.base.co.o.a().d("label.resourceGroup." + this.getCode());
        }

        public String localizedPluralName() {
            return ch.ionesoft.ilp.base.co.o.a().d("label.resourceGroup.plural." + this.getCode());
        }

        public static ResourceGroup getByCode(int n2) {
            try {
                return lookupCode.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined resourceGroup code: " + n2 + ", defaulting to " + RESOURCE_GROUP_UNDEFINED.name()));
                return RESOURCE_GROUP_UNDEFINED;
            }
        }

        public static ResourceGroup getByKey(String string) {
            try {
                return lookupKey.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined resourceGroup key: " + string + ", defaulting to " + RESOURCE_GROUP_UNDEFINED.name()));
                return RESOURCE_GROUP_UNDEFINED;
            }
        }

        public static ResourceGroup getByCodeString(String string) {
            int n2 = ConverterUtil.convertToInteger_defaultValue((String)string, (Integer)0);
            return lookupCode.get(n2);
        }

        public static ResourceGroup fromMimeType(String string) {
            if (string == null || string.isEmpty()) {
                return RESOURCE_GROUP_UNDEFINED;
            }
            if (string.equals("text/html") || string.equals("application/xhtml+xml") || string.equals("application/x-httpd-php")) {
                return RESOURCE_GROUP_HTML;
            }
            if (string.equals("text/css")) {
                return RESOURCE_GROUP_CSS;
            }
            if (string.equals("text/plain")) {
                return RESOURCE_GROUP_PLAINTEXT;
            }
            if (string.equals("text/javascript") || string.equals("application/javascript")) {
                return RESOURCE_GROUP_JS;
            }
            if (string.startsWith("audio/") || string.equals("application/mp3")) {
                return RESOURCE_GROUP_AUDIO;
            }
            if (string.startsWith("video/") || string.equals("application/mp4")) {
                return RESOURCE_GROUP_VIDEO;
            }
            if (string.startsWith("image/")) {
                return RESOURCE_GROUP_IMAGE;
            }
            if (string.startsWith("font/") || string.equals("application/font-woff") || string.equals("application/font-ttf") || string.equals("application/x-font-ttf") || string.equals("application/vnd.ms-opentype")) {
                return RESOURCE_GROUP_FONT;
            }
            if (string.equals("application/msword") || string.equals("application/pdf") || string.equals("text/richtext") || string.startsWith("application/vnd.")) {
                return RESOURCE_GROUP_DOCUMENT;
            }
            if (string.equals("application/zip")) {
                return RESOURCE_GROUP_DOCUMENT;
            }
            logger.c((Object)("Unrecognized mimeType for resourceGroup: " + string));
            return RESOURCE_GROUP_UNDEFINED;
        }
    }

    public static enum ResourceLocation {
        RESOURCE_LOCATION_UNDEFINED(0, false, false, false),
        RESOURCE_LOCATION_DATABASE(1, false, false, false),
        RESOURCE_LOCATION_ASSET_LOCAL(2, true, true, false),
        RESOURCE_LOCATION_ASSET_SERVER(3, false, true, true),
        RESOURCE_LOCATION_FILE_SYSTEM(4, true, false, false),
        RESOURCE_LOCATION_CLOUD_DATA(5, true, true, false),
        RESOURCE_LOCATION_SHARED_DATA(6, true, true, false),
        RESOURCE_LOCATION_WEB(7, false, true, false),
        RESOURCE_LOCATION_WEB_MEDIA(8, false, true, true),
        RESOURCE_LOCATION_INTERNAL_LINK(9, false, true, false),
        RESOURCE_LOCATION_MEDIA_EDIT_LOCAL(10, true, false, false),
        RESOURCE_LOCATION_MEDIA_EDIT_SERVER(11, false, false, true),
        RESOURCE_LOCATION_UCS_LOCAL(12, true, true, false),
        RESOURCE_LOCATION_UCS_SERVER(13, false, true, true);

        private static final Map<Integer, ResourceLocation> lookup;
        int code;
        boolean supportsFileAccess;
        boolean supportsUrlAccess;
        boolean supportsDownload;

        static {
            lookup = new HashMap<Integer, ResourceLocation>();
            for (ResourceLocation resourceLocation : EnumSet.allOf(ResourceLocation.class)) {
                lookup.put(resourceLocation.getCode(), resourceLocation);
            }
        }

        private ResourceLocation(int n3, boolean bl2, boolean bl3, boolean bl4) {
            this.code = n3;
            this.supportsFileAccess = bl2;
            this.supportsUrlAccess = bl3;
            this.supportsDownload = bl4;
        }

        public static ResourceLocation get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined resourceLocation code: " + n2 + ", defaulting to " + RESOURCE_LOCATION_UNDEFINED.name()));
                return RESOURCE_LOCATION_UNDEFINED;
            }
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int n2) {
            this.code = n2;
        }

        public boolean isSupportsFileAccess() {
            return this.supportsFileAccess;
        }

        public boolean isSupportsUrlAccess() {
            return this.supportsUrlAccess;
        }

        public boolean isSupportsDownload() {
            return this.supportsDownload;
        }

        public File getRootPath() {
            switch (this) {
                case RESOURCE_LOCATION_ASSET_LOCAL: 
                case RESOURCE_LOCATION_WEB_MEDIA: {
                    return h.I();
                }
                case RESOURCE_LOCATION_CLOUD_DATA: {
                    return h.O();
                }
                case RESOURCE_LOCATION_SHARED_DATA: {
                    return h.N();
                }
                case RESOURCE_LOCATION_MEDIA_EDIT_LOCAL: {
                    return h.L();
                }
                case RESOURCE_LOCATION_UCS_LOCAL: {
                    return h.J();
                }
            }
            return null;
        }
    }

    public static enum ResourceReference {
        RESOURCE_REFERENCE_UNDEFINED(0),
        RESOURCE_REFERENCE_TOPIC(1),
        RESOURCE_REFERENCE_USER_TOPIC(2),
        RESOURCE_REFERENCE_EXERCISE_TEXT(3),
        RESOURCE_REFERENCE_QUESTION_TEXT(4),
        RESOURCE_REFERENCE_ANSWER_TEMPLATE(5),
        RESOURCE_REFERENCE_ANSWER_CORRECT(6),
        RESOURCE_REFERENCE_ANSWER_USER(7),
        RESOURCE_REFERENCE_ISSUE(8),
        RESOURCE_REFERENCE_LESSONS_TASK(9);

        private static final Map<Integer, ResourceReference> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ResourceReference>();
            for (ResourceReference resourceReference : EnumSet.allOf(ResourceReference.class)) {
                lookup.put(resourceReference.getCode(), resourceReference);
            }
        }

        private ResourceReference(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ResourceReference get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined resourceReference code: " + n2 + ", defaulting to " + RESOURCE_REFERENCE_UNDEFINED.name()));
                return RESOURCE_REFERENCE_UNDEFINED;
            }
        }

        public static ResourceReference get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }

        public boolean showInTopicToc() {
            return this.equals((Object)RESOURCE_REFERENCE_TOPIC) || this.equals((Object)RESOURCE_REFERENCE_USER_TOPIC);
        }

        public boolean showInExerciseToc() {
            return !this.showInTopicToc();
        }
    }
}

