/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.exs.corr.b;
import ch.ionesoft.ilp.book.exs.corr.d;
import ch.ionesoft.ilp.book.exs.corr.e;
import ch.ionesoft.ilp.book.exs.corr.h;
import ch.ionesoft.ilp.book.exs.corr.i;
import ch.ionesoft.ilp.book.exs.corr.k;
import ch.ionesoft.ilp.book.exs.corr.l;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@DatabaseTable(tableName="ZILPQUESTION")
public class ILPQuestion
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPQuestion.class);
    public static final String PRESENTATION_PROPERTY_ORIENTATION = "Orientation";
    public static final String PRESENTATION_PROPERTY_ORIENTATION_HORIZONTAL = "Horizontal";
    public static final String PRESENTATION_PROPERTY_ORIENTATION_VERTICAL = "Vertical";
    public static final String PRESENTATION_PROPERTY_ANSWER_COLUMNS = "AnswerColumns";
    public static final String PRESENTATION_PROPERTY_ARRANGEMENT_TABLE = "ArrangementTable";
    public static final String PRESENTATION_PROPERTY_IMAGE_HEIGHT_PX = "ImageHeightPx";
    public static final String PRESENTATION_PROPERTY_IMAGE_WIDTH_PX = "ImageWidthPx";
    public static final String PRESENTATION_PROPERTY_IMAGE_NAME = "ImageName";
    public static final String PRESENTATION_PROPERTY_CONTENT_EDITABLE = "ContentEditable";
    public static final String PRESENTATION_PROPERTY_PUNCTUATIONS = "Punctuations";
    public static final String PRESENTATION_PROPERTY_INSERTION_ELEMENTS = "InsertionElements";
    public static final String PRESENTATION_PROPERTY_INSERTION_ELEMENT_DELIMITER = "|";
    public static final String PRESENTATION_PROPERTY_INSERTION_ALIGNMENT = "InsertionAlignment";
    public static final String PRESENTATION_PROPERTY_COLORS = "Colors";
    public static final String PRESENTATION_PROPERTY_FIXED_LAYOUT = "fixedLayout";
    public static final Integer ANSWER_FORMAT_QUESTION_WITH_ANSWER = 1;
    public static final Integer ANSWER_FORMAT_ANSWERS_PER_QUESTION = 2;
    public static final Integer ANSWER_FORMAT_FILL_PLACEHOLDER = 4;
    public static final Integer ANSWER_FORMAT_GENERATE_LIST = 8;
    public static final String TABLE_NAME = "ZILPQUESTION";
    public static final String ANSWERFORMAT_FIELD_NAME = "ZANSWERFORMAT";
    public static final String ANSWERED_FIELD_NAME = "ZANSWERED";
    public static final String NUMBER_FIELD_NAME = "ZNUMBER";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String CORRECTION_TYPE_FIELD_NAME = "ZCORRECTIONTYPE";
    public static final String CORRECTION_ARGUMENT_FIELD_NAME = "ZCORRECTIONARGUMENT";
    public static final String REFERENCE_FIELD_NAME = "ZREFERENCE";
    public static final String TEXT_FIELD_NAME = "ZTEXT";
    public static final String PRESENTATIONPROPERTIES_FIELD_NAME = "ZPRESENTATIONPROPERTIES";
    public static final String EXERCISE_FK_FIELD_NAME = "ZEXERCISE";
    @DatabaseField(columnName="ZANSWERFORMAT", canBeNull=true)
    private Integer answerFormat;
    @DatabaseField(columnName="ZANSWERED", canBeNull=true)
    private Boolean answered;
    @DatabaseField(columnName="ZNUMBER", canBeNull=true, index=true)
    private Integer number;
    @DatabaseField(columnName="ZREFERENCE", canBeNull=true, index=true)
    private String reference;
    @DatabaseField(columnName="ZTEXT", canBeNull=true)
    private String text;
    @DatabaseField(columnName="ZTYPE", canBeNull=true, index=true)
    private Integer type;
    @DatabaseField(columnName="ZCORRECTIONTYPE", canBeNull=true)
    private Integer correctionType;
    @DatabaseField(columnName="ZCORRECTIONARGUMENT", canBeNull=true)
    private String correctionArgument;
    @DatabaseField(columnName="ZPRESENTATIONPROPERTIES", canBeNull=true)
    String presentationProperties;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZEXERCISE", index=true)
    private ILPExercise exercise;
    @ForeignCollectionField(eager=true)
    private ForeignCollection<ILPAnswer> answers;
    private List<ILPAnswer> correctAnswersPossiblyRandomized;

    public Integer getAnswerFormat() {
        return this.answerFormat;
    }

    public void setAnswerFormat(Integer n2) {
        this.answerFormat = n2;
    }

    public boolean hasAnswerFormat(int n2) {
        if (this.answerFormat == null) {
            return false;
        }
        return (this.getAnswerFormat() & n2) != 0;
    }

    public boolean isAnswered() {
        return this.answered != null && this.answered != false;
    }

    public Boolean getAnswered() {
        return this.answered;
    }

    public void setAnswered(Boolean bl2) {
        this.answered = bl2;
    }

    public void setCorrectionArgument(String string) {
        this.correctionArgument = string;
    }

    public String getCorrectionArgument() {
        return this.correctionArgument;
    }

    public void setCorrectionType(Integer n2) {
        this.correctionType = n2;
    }

    public Integer getCorrectionType() {
        return this.correctionType;
    }

    public void setCorrectionTypeEnum(CorrectionType correctionType) {
        this.correctionType = correctionType.getCode();
    }

    public CorrectionType getCorrectionTypeEnum() {
        return CorrectionType.get(this.correctionType);
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer n2) {
        this.number = n2;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public void setReferenceNormalized(String string) {
        this.reference = StringHelper.normalizeForJQuery((String)string);
    }

    public String getText() {
        return ILPBookSettingsHelper.instance().decryptQuestionText_forQuestion(this.text, this);
    }

    public void setText(String string) {
        String string2;
        this.text = string2 = ILPBookSettingsHelper.instance().encryptQuestionText_forQuestion(string, this);
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer n2) {
        this.type = n2;
    }

    public ILPExercise getExercise() {
        return this.exercise;
    }

    public void setExercise(ILPExercise iLPExercise) {
        this.exercise = iLPExercise;
    }

    public ForeignCollection<ILPAnswer> getAnswers() {
        if (this.answers == null) {
            try {
                g.a().K().assignEmptyForeignCollection((Object)this, "answers");
                this.answers.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for issue.answers", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.answers;
    }

    public void setAnswers(ForeignCollection<ILPAnswer> foreignCollection) {
        this.answers = foreignCollection;
        this.correctAnswersPossiblyRandomized = null;
    }

    public List<ILPAnswer> getCorrectAnswersPossiblyRandomized() {
        if (this.correctAnswersPossiblyRandomized == null) {
            List<ILPAnswer> list = null;
            try {
                list = f.a().a(ILPAnswer.AnswerType.ANSWER_TYPE_CORRECT, (AbstractCoreDataModel)this);
            }
            catch (j j2) {
                logger.d((Object)("Could not fetch correct answers for question: " + this), (Throwable)j2);
                return new ArrayList<ILPAnswer>();
            }
            boolean bl2 = false;
            switch (this.exercise.getExerciseType()) {
                case EXERCISE_TYPE_MULTICHOICE: 
                case EXERCISE_TYPE_SINGLECHOICE: {
                    bl2 = this.exercise.isRandomized() != false && this.hasAnswerFormat(ANSWER_FORMAT_ANSWERS_PER_QUESTION) && !this.hasAnswerFormat(ANSWER_FORMAT_FILL_PLACEHOLDER);
                    break;
                }
                case EXERCISE_TYPE_MATCH_POSITION: {
                    bl2 = this.exercise.isRandomized();
                    break;
                }
                case EXERCISE_TYPE_MATCH_SINGLE_USE: 
                case EXERCISE_TYPE_MATCH_REUSE: {
                    bl2 = this.exercise.isRandomized();
                    break;
                }
            }
            if (bl2) {
                Collections.shuffle(list);
            }
            this.correctAnswersPossiblyRandomized = list;
        }
        return this.correctAnswersPossiblyRandomized;
    }

    public List<ILPAnswer> getCorrectAnswers() {
        List<ILPAnswer> list = null;
        try {
            list = f.a().a(ILPAnswer.AnswerType.ANSWER_TYPE_CORRECT, (AbstractCoreDataModel)this);
        }
        catch (j j2) {
            logger.d((Object)("Could not fetch correct answers for question: " + this), (Throwable)j2);
            list = new ArrayList<ILPAnswer>();
        }
        return list;
    }

    public List<ILPAnswer> getUserAnswers() {
        List<ILPAnswer> list = null;
        try {
            list = f.a().a(ILPAnswer.AnswerType.ANSWER_TYPE_USER, (AbstractCoreDataModel)this);
        }
        catch (j j2) {
            logger.d((Object)("Could not fetch user answers for question: " + this), (Throwable)j2);
            list = new ArrayList<ILPAnswer>();
        }
        return list;
    }

    public List<ILPAnswer> getSharedAnswers() {
        List<ILPAnswer> list = null;
        try {
            list = f.a().a(ILPAnswer.AnswerType.ANSWER_TYPE_SHARED, (AbstractCoreDataModel)this);
        }
        catch (j j2) {
            logger.d((Object)("Could not fetch shared answers for question: " + this), (Throwable)j2);
            list = new ArrayList<ILPAnswer>();
        }
        return list;
    }

    public String getPresentationProperties() {
        return this.presentationProperties;
    }

    public void setPresentationProperties(String string) {
        this.presentationProperties = string;
    }

    private String propertyFor_defaultProperty(String string, String string2) {
        return StringHelper.extractProperty_For_defaultProperty((String)this.presentationProperties, (String)string, (String)string2, (boolean)true);
    }

    public String propertyFor(String string) {
        String string2 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            logger.d((Object)String.format(Locale.ENGLISH, "No property defined for question: %s, named: %s", this.reference, string));
        }
        return string2;
    }

    public boolean propertyBoolean_defaultValue(String string, boolean bl2) {
        String string2 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return Boolean.parseBoolean(string2);
        }
        return bl2;
    }

    public float propertyFloat_defaultValue(String string, float f2) {
        String string2 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return Float.parseFloat(string2);
        }
        return f2;
    }

    public int propertyInt_defaultValue(String string, int n2) {
        String string2 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return Integer.parseInt(string2);
        }
        return n2;
    }

    public String propertyString_defaultValue(String string, String string2) {
        String string3 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            return string3;
        }
        return string2;
    }

    public boolean isOrientationVertical() {
        String string = this.propertyString_defaultValue(PRESENTATION_PROPERTY_ORIENTATION, PRESENTATION_PROPERTY_ORIENTATION_VERTICAL);
        return string.equals(PRESENTATION_PROPERTY_ORIENTATION_VERTICAL);
    }

    public b createCorrectionStrategy(String string, String string2, String string3) {
        b b2;
        try {
            Class<b> clazz = CorrectionType.getStrategy(CorrectionType.get(this.getCorrectionType()));
            b2 = clazz.newInstance();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not create correctionStrategy from " + this + " with correctionType: " + this.correctionType), (Throwable)exception);
            b2 = new l();
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.exercise.correction.wrong.strategy", new Object[0]);
        }
        b2.a(string, string2, string3);
        if (!b2.b()) {
            logger.c((Object)("Illegal correctionArgument for " + this + " with correctionStrategy: " + b2));
            b2 = new e();
            b2.a(string, string2, string3);
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.exercise.correction.wrong.strategy", new Object[0]);
        }
        return b2;
    }

    @Override
    public String toString() {
        return "ILPQuestion [reference=" + this.reference + ", type=" + this.type + ", exercise=" + this.exercise + ", pk=" + this.pk + "]";
    }

    public static enum CorrectionType {
        QUESTION_CORRECTION_UNDEFINED(0, "Undefined", l.class),
        QUESTION_CORRECTION_EXACT(1, "Exact", e.class),
        QUESTION_CORRECTION_IGNORE_CASE(2, "IgnoreCase", ch.ionesoft.ilp.book.exs.corr.f.class),
        QUESTION_CORRECTION_ACCURACY(3, "Accuracy", d.class),
        QUESTION_CORRECTION_SIMILARITY(4, "Similarity", k.class),
        QUESTION_CORRECTION_IGNORE_PUNCTUATION(5, "IgnorePunctuation", ch.ionesoft.ilp.book.exs.corr.g.class),
        QUESTION_CORRECTION_MATCH_ONE(6, "MatchOne", i.class),
        QUESTION_CORRECTION_MATCH_ALL(7, "MatchAll", h.class),
        QUESTION_CORRECTION_MATCH_REGEX(8, "MatchRegex", ch.ionesoft.ilp.book.exs.corr.j.class);

        private static final Map<Integer, CorrectionType> lookup;
        private static final Map<String, CorrectionType> stringLookup;
        private static final Map<CorrectionType, Class<b>> strategyLookup;
        private int code;
        private String entryString;
        private Class<b> strategy;

        static {
            lookup = new HashMap<Integer, CorrectionType>();
            stringLookup = new HashMap<String, CorrectionType>();
            strategyLookup = new HashMap<CorrectionType, Class<b>>();
            for (CorrectionType correctionType : EnumSet.allOf(CorrectionType.class)) {
                lookup.put(correctionType.getCode(), correctionType);
                stringLookup.put(correctionType.getEntryString(), correctionType);
                strategyLookup.put(correctionType, correctionType.getStrategy());
            }
        }

        private CorrectionType(int n3, String string2, Class<?> clazz) {
            this.code = n3;
            this.entryString = string2;
            this.strategy = clazz;
        }

        public int getCode() {
            return this.code;
        }

        public String getEntryString() {
            return this.entryString;
        }

        public Class<b> getStrategy() {
            return this.strategy;
        }

        public static CorrectionType get(Integer n2) {
            if (lookup.containsKey(n2)) {
                return lookup.get(n2);
            }
            return QUESTION_CORRECTION_UNDEFINED;
        }

        public static CorrectionType get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }

        public static CorrectionType getByEntry(String string) {
            if (stringLookup.containsKey(string)) {
                return stringLookup.get(string);
            }
            return QUESTION_CORRECTION_UNDEFINED;
        }

        public static Class<b> getStrategy(CorrectionType correctionType) {
            if (strategyLookup.containsKey((Object)correctionType)) {
                return strategyLookup.get((Object)correctionType);
            }
            return strategyLookup.get((Object)QUESTION_CORRECTION_UNDEFINED);
        }
    }

    public static enum ElementInsertionAlignment {
        ELEMENT_INSERTION_ALIGNMENT_UNDEFINED(0),
        ELEMENT_INSERTION_ALIGNMENT_LEFT(1),
        ELEMENT_INSERTION_ALIGNMENT_RIGHT(2),
        ELEMENT_INSERTION_ALIGNMENT_CENTER_PADDING(3),
        ELEMENT_INSERTION_ALIGNMENT_CENTER(4),
        ELEMENT_INSERTION_ALIGNMENT_CLICK_POSITION(5);

        private int code;

        private ElementInsertionAlignment(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }
    }
}

