/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPEnvironment;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@DatabaseTable(tableName="ZILPPERMISSIONTYPEDEFINITION")
public class ILPPermissionTypeDefinition
extends AbstractCoreDataModel {
    public static final String PERMISSION_TYPE_DEFINITION_IDENTIFIER_FIELD_NAME = "ZPERMISSIONTYPEDEFINITIONIDENTIFIER";
    public static final String KIND_FIELD_NAME = "ZKIND";
    public static final String PERMISSON_KEY_FIELD_NAME = "ZPERMISSIONKEY";
    public static final String NAME_FIELD_NAME = "ZNAME";
    public static final String DESCRIPTION_FIELD_NAME = "ZDESCRIPTION";
    public static final String ENVIRONMENT_FK_FIELD_NAME = "ZENVIRONMENT";
    public static final String SCOPE_TYPE_FIELD_NAME = "ZSCOPETYPE";
    private static ILogger logger = ILPLogManager.getLogger(ILPPermissionTypeDefinition.class);
    @DatabaseField(columnName="ZPERMISSIONTYPEDEFINITIONIDENTIFIER", index=true, canBeNull=false)
    private String permissionTypeDefinitionIdentifier;
    @DatabaseField(columnName="ZKIND", index=true, canBeNull=false)
    private Integer kind;
    @DatabaseField(columnName="ZPERMISSIONKEY", index=true, canBeNull=false)
    private String permissionKey;
    @DatabaseField(columnName="ZSCOPETYPE", index=true, canBeNull=false)
    private Integer scopeType;
    @DatabaseField(columnName="ZNAME")
    private String name;
    @DatabaseField(columnName="ZDESCRIPTION")
    private String description;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZENVIRONMENT")
    private ILPEnvironment environment;

    public String getPermissionTypeDefinitionIdentifier() {
        return this.permissionTypeDefinitionIdentifier;
    }

    public void setPermissionTypeDefinitionIdentifier(String string) {
        this.permissionTypeDefinitionIdentifier = string;
    }

    public Integer getKind() {
        return this.kind;
    }

    public void setKind(Integer n2) {
        this.kind = n2;
    }

    public void setKind(String string) {
        this.kind = PermissionKind.valueOf(string).code;
    }

    public void setKind(PermissionKind permissionKind) {
        this.kind = permissionKind.getCode();
    }

    public String getPermissionKey() {
        return this.permissionKey;
    }

    public void setPermissionKey(String string) {
        this.permissionKey = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public ILPEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ILPEnvironment iLPEnvironment) {
        this.environment = iLPEnvironment;
    }

    public Integer getScopeType() {
        return this.scopeType;
    }

    public ScopeType getScopeTypeEnum() {
        return ScopeType.get(this.scopeType);
    }

    public void setScopeType(Integer n2) {
        this.scopeType = n2;
    }

    public void setScopeType(String string) {
        this.scopeType = ScopeType.getByName(string).code;
    }

    @Override
    public String toString() {
        return "ILPPermissionTypeDefinition [permissionTypeDefinitionIdentifier=" + this.permissionTypeDefinitionIdentifier + ", kind=" + this.kind + ", name=" + this.name + "]";
    }

    public static enum PermissionKind {
        PERMISSION_TYPE_UNDEFINED(0),
        PERMISSION_TYPE_LICENSE_ASSET_STAGE_PROD(1),
        PERMISSION_TYPE_LICENSE_ASSET_STAGE_QS(2),
        PERMISSION_TYPE_LICENSE_ASSET_STAGE_DEV(3),
        PERMISSION_TYPE_APP_FEATURE(4);

        private static final Map<Integer, PermissionKind> lookup;
        private final int code;

        static {
            lookup = new HashMap<Integer, PermissionKind>();
            for (PermissionKind permissionKind : EnumSet.allOf(PermissionKind.class)) {
                lookup.put(permissionKind.getCode(), permissionKind);
            }
        }

        private PermissionKind(Integer n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static PermissionKind get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (NumberFormatException numberFormatException) {
                logger.c((Object)("Could not determine permission kind set to undefined: " + string));
                return PERMISSION_TYPE_UNDEFINED;
            }
        }

        public static PermissionKind get(int n2) {
            return lookup.get(n2);
        }
    }

    public static enum ScopeType {
        PERMISSION_SCOPE_UNDEFINED(0),
        PERMISSION_SCOPE_PRODUCTREFERENCE(1),
        PERMISSION_SCOPE_COURSEID(2),
        PERMISSION_SCOPE_MANDANT(3),
        PERMISSION_SCOPE_MANDANTID(3),
        PERMISSION_SCOPE_GLOBAL(4),
        PERMISSION_SCOPE_EXERCISEREFERENCE(5),
        PERMISSION_SCOPE_NODEID(6),
        PERMISSION_SCOPE_EXERCISEGROUP(7),
        PERMISSION_SCOPE_ISSUEID(8);

        private static final Map<Integer, ScopeType> lookup;
        private static final Map<String, ScopeType> stringLookup;
        private final int code;

        static {
            lookup = new HashMap<Integer, ScopeType>();
            stringLookup = new HashMap<String, ScopeType>();
            for (ScopeType scopeType : EnumSet.allOf(ScopeType.class)) {
                lookup.put(scopeType.getCode(), scopeType);
                stringLookup.put(scopeType.name(), scopeType);
            }
        }

        private ScopeType(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ScopeType get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (NumberFormatException numberFormatException) {
                logger.c((Object)("Could not determine scope type set to undefined: " + string));
                return PERMISSION_SCOPE_UNDEFINED;
            }
        }

        public static ScopeType get(int n2) {
            return lookup.get(n2);
        }

        public static ScopeType getByName(String string) {
            if (StringHelper.isBlank((String)string)) {
                logger.c((Object)"ScopeType name is null or emtpy. Return PERMISSION_SCOPE_UNDEFINED.");
                return PERMISSION_SCOPE_UNDEFINED;
            }
            try {
                ScopeType scopeType = stringLookup.get(string);
                if (scopeType != null) {
                    return scopeType;
                }
                logger.d((Object)("Could not find scopeType by name: " + string + ", return PERMISSION_SCOPE_UNDEFINED."));
                return PERMISSION_SCOPE_UNDEFINED;
            }
            catch (Exception exception) {
                logger.c((Object)("Could not determine scope type set to undefined: " + string));
                return PERMISSION_SCOPE_UNDEFINED;
            }
        }
    }
}

