/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.mo.ILPAbstractDefinition;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPIssueProduct;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPPermissionProduct;
import ch.ionesoft.ilp.book.mo.ILPPermissionTypeDefinition;
import ch.ionesoft.ilp.book.mo.ILPSharing;
import ch.ionesoft.ilp.book.mo.ILPSharingTransaction;
import ch.ionesoft.ilp.book.mo.SharingModel;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;

@DatabaseTable(tableName="ZILPPERMISSIONDEFINITION")
public class ILPPermissionDefinition
extends ILPAbstractDefinition
implements SharingModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPPermissionDefinition.class);
    public static final String TABLE_NAME = "ZILPPERMISSIONDEFINITION";
    public static final String PERMISSION_VALUE_FIELD_NAME = "ZPERMISSIONVALUE";
    public static final String PERMISSION_SCOPE_VALUE_FIELD_NAME = "ZPERMISSIONSCOPEVALUE";
    public static final String PERMISSION_PRODUCT_FK_FIELD_NAME = "ZPERMISSIONPRODUCT";
    public static final String PERMISSION_TYPE_DEFINITION_FK_FIELD_NAME = "ZPERMISSIONTYPEDEFINITION";
    public static final String MD5_FIELD_NAME = "ZMD5";
    public static final String SHARINGTYPE_FIELD_NAME = "ZSHARINGTYPE";
    public static final String SHARING_FK_FIELD_NAME = "ZSHARING";
    @DatabaseField(columnName="ZPERMISSIONVALUE")
    private String permissionValue;
    @DatabaseField(columnName="ZPERMISSIONSCOPEVALUE")
    private String permissionScopeValue;
    @DatabaseField(columnName="ZMD5", canBeNull=true)
    private String md5;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZPERMISSIONPRODUCT", index=true, canBeNull=false)
    private ILPPermissionProduct permissionProduct;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZPERMISSIONTYPEDEFINITION", canBeNull=false)
    private ILPPermissionTypeDefinition permissionTypeDefinition;
    @DatabaseField(columnName="ZSHARINGTYPE", canBeNull=true, index=true)
    protected Integer sharingType;
    @ForeignCollectionField(orderColumnName="ZCREATIONDATE")
    protected ForeignCollection<ILPSharing> sharings;

    public String getPermissionValue() {
        return this.permissionValue;
    }

    public void setPermissionValue(String string) {
        this.permissionValue = string;
        this.updateMd5();
    }

    public ILPPermissionProduct getPermissionProduct() {
        return this.permissionProduct;
    }

    public void setPermissionProduct(ILPPermissionProduct iLPPermissionProduct) {
        this.permissionProduct = iLPPermissionProduct;
    }

    public ILPPermissionTypeDefinition getPermissionTypeDefinition() {
        return this.permissionTypeDefinition;
    }

    public void setPermissionTypeDefinition(ILPPermissionTypeDefinition iLPPermissionTypeDefinition) {
        this.permissionTypeDefinition = iLPPermissionTypeDefinition;
        this.updateMd5();
    }

    public String getPermissionScopeValue() {
        return this.permissionScopeValue;
    }

    public void setPermissionScopeValue(String string) {
        this.permissionScopeValue = string;
        this.updateMd5();
    }

    public boolean accept(ILPExercise iLPExercise) {
        if (!this.verifyMd5()) {
            return false;
        }
        if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_GLOBAL.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum())) {
            return true;
        }
        if (iLPExercise != null) {
            String string;
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_PRODUCTREFERENCE.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum()) && iLPExercise.getExerciseDefinition().getExerciseProduct().getProductReference().equals(this.permissionScopeValue)) {
                return true;
            }
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEREFERENCE.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum())) {
                string = this.getIssueProductReference();
                ILPExercise.ExerciseGroup exerciseGroup = this.getExerciseGroup();
                String string2 = this.getExerciseReference();
                if (iLPExercise.getReference() != null && iLPExercise.getReference().equals(string2) && iLPExercise.getExerciseGroup().getCode() == exerciseGroup.getCode() && iLPExercise.getIssue().getIssueProduct().getProductReference().equals(string)) {
                    return true;
                }
            }
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_NODEID.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum())) {
                if (iLPExercise.getNodeId() != null && iLPExercise.getNodeId().equals(this.permissionScopeValue)) {
                    return true;
                }
                string = StringHelper.extractStringFrom_until((String)this.permissionScopeValue, (String)"_");
                if (iLPExercise.getNodeId() != null && iLPExercise.getNodeId().equals(string)) {
                    return true;
                }
            }
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEGROUP.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum()) && StringHelper.isNumericString((String)this.permissionScopeValue) && iLPExercise.getGroup() != null && iLPExercise.getGroup().equals(Integer.valueOf(this.permissionScopeValue))) {
                return true;
            }
            if (this.accept(iLPExercise.getIssue())) {
                return true;
            }
        }
        return false;
    }

    public boolean accept(ILPIssueDef iLPIssueDef) {
        if (!this.verifyMd5()) {
            return false;
        }
        if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_GLOBAL.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum())) {
            return true;
        }
        if (iLPIssueDef != null) {
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_PRODUCTREFERENCE.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum()) && iLPIssueDef.getIssueProduct().getProductReference().equals(this.permissionScopeValue)) {
                return true;
            }
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_PRODUCTREFERENCE.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum()) && iLPIssueDef.getCourse().getCourseProduct().getProductReference().equals(this.permissionScopeValue)) {
                return true;
            }
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_COURSEID.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum()) && iLPIssueDef.getIssueProduct().getCourseProduct().getCourseIdentifier().equals(this.permissionScopeValue)) {
                return true;
            }
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_MANDANTID.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum()) && iLPIssueDef.getIssueProduct().getCourseProduct().getMandantId().equals(this.permissionScopeValue)) {
                return true;
            }
        }
        return false;
    }

    public boolean accept(ILPCourseDef iLPCourseDef) {
        if (!this.verifyMd5()) {
            return false;
        }
        if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_GLOBAL.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum())) {
            return true;
        }
        if (iLPCourseDef != null) {
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_PRODUCTREFERENCE.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum())) {
                return iLPCourseDef.getCourseProduct().getProductReference().equals(this.permissionScopeValue);
            }
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_COURSEID.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum())) {
                return iLPCourseDef.getCourseProduct().getCourseIdentifier().equals(this.permissionScopeValue);
            }
            if (ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_MANDANTID.equals((Object)this.permissionTypeDefinition.getScopeTypeEnum())) {
                return iLPCourseDef.getCourseProduct().getMandantId().equals(this.permissionScopeValue);
            }
        }
        return false;
    }

    public boolean hasLicenseAuthorized() {
        ILPLicense iLPLicense = this.getPermissionProduct().getLicense();
        return iLPLicense != null && iLPLicense.isLicenseAuthorized();
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String string) {
        this.md5 = string;
    }

    protected String buildMd5() {
        StringBuffer stringBuffer = new StringBuffer("Yj?d#s");
        stringBuffer.append(String.format(Locale.ENGLISH, "ZH;%s", this.permissionValue));
        stringBuffer.append(String.format(Locale.ENGLISH, "q%sPs", this.permissionScopeValue != null ? this.permissionScopeValue : ""));
        stringBuffer.append(String.format(Locale.ENGLISH, "$s%sWq", this.permissionTypeDefinition != null ? this.permissionTypeDefinition.getName() : Integer.valueOf(0)));
        stringBuffer.append("sAls68U");
        return StringHelper.md5hash((String)stringBuffer.toString());
    }

    public void updateMd5() {
        this.md5 = this.buildMd5();
    }

    public ILPExercise getExercise() {
        try {
            if (this.getPermissionTypeDefinition().getScopeTypeEnum() == ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_NODEID) {
                String string = this.getPermissionScopeValue();
                ILPExercise iLPExercise = f.a().h(string, (ILPCourseDef)null);
                if (iLPExercise == null) {
                    String string2 = StringHelper.extractStringFrom_until((String)this.getPermissionScopeValue(), (String)"_");
                    iLPExercise = f.a().h(string2, (ILPCourseDef)null);
                }
                return iLPExercise;
            }
            if (this.getPermissionTypeDefinition().getScopeTypeEnum() == ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEREFERENCE) {
                ILPIssueDef iLPIssueDef = this.getIssue();
                ILPExercise.ExerciseGroup exerciseGroup = this.getExerciseGroup();
                String string = this.getExerciseReference();
                if (iLPIssueDef != null) {
                    return f.a().b(string, iLPIssueDef, exerciseGroup);
                }
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not fetch exercise from permissionDefinition: " + this), (Throwable)exception);
        }
        return null;
    }

    private String getExerciseReference() {
        if (this.getPermissionTypeDefinition() == null || this.getPermissionTypeDefinition().getScopeTypeEnum() == null || this.getPermissionTypeDefinition().getScopeTypeEnum() != ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEREFERENCE) {
            throw new UnsupportedOperationException("This method is only suppored on a definition with scopeType: ScopeType.PERMISSION_SCOPE_EXERCISEREFERENCE.");
        }
        if (StringHelper.isNotBlank((String)this.permissionScopeValue)) {
            return StringHelper.extractTrailingString_after((String)this.permissionScopeValue, (String)"-");
        }
        return null;
    }

    private String getIssueProductReference() {
        if (this.getPermissionTypeDefinition() == null || this.getPermissionTypeDefinition().getScopeTypeEnum() == null || this.getPermissionTypeDefinition().getScopeTypeEnum() != ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEREFERENCE && this.getPermissionTypeDefinition().getScopeTypeEnum() != ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEGROUP) {
            throw new UnsupportedOperationException("This method is only suppored on a definition with ScopeType: ScopeType.PERMISSION_SCOPE_EXERCISEREFERENCE and PERMISSION_SCOPE_EXERCISEGROUP");
        }
        if (StringHelper.isNotBlank((String)this.permissionScopeValue)) {
            return StringHelper.extractStringFrom_until((String)this.permissionScopeValue, (String)"-");
        }
        return "";
    }

    public ILPIssueDef getIssue() {
        String string = this.getIssueProductReference();
        ILPIssueProduct iLPIssueProduct = f.a().af(string);
        if (iLPIssueProduct != null) {
            return iLPIssueProduct.getIssue();
        }
        return null;
    }

    private ILPExercise.ExerciseGroup getExerciseGroup() {
        if (this.getPermissionTypeDefinition() == null || this.getPermissionTypeDefinition().getScopeTypeEnum() == null || this.getPermissionTypeDefinition().getScopeTypeEnum() != ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEREFERENCE && this.getPermissionTypeDefinition().getScopeTypeEnum() != ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEGROUP) {
            throw new UnsupportedOperationException("This method is only supported on a definition with scopeType: PERMISSION_SCOPE_EXERCISEREFERENCE and PERMISSION_SCOPE_EXERCISEGROUP");
        }
        String string = "";
        string = this.getPermissionTypeDefinition().getScopeTypeEnum() == ILPPermissionTypeDefinition.ScopeType.PERMISSION_SCOPE_EXERCISEREFERENCE ? StringHelper.extractStringFrom_after_until((String)this.permissionScopeValue, (String)"-", (String)"-") : StringHelper.extractStringFrom_after((String)this.permissionScopeValue, (String)"-");
        if (StringHelper.isNumericString((String)string)) {
            Integer n2 = Integer.valueOf(string);
            return ILPExercise.ExerciseGroup.get(n2);
        }
        return null;
    }

    public boolean isPermissionValueTrue() {
        return Boolean.valueOf(this.permissionValue);
    }

    public boolean verifyMd5() {
        if (this.md5 == null) {
            return false;
        }
        String string = this.buildMd5();
        boolean bl2 = this.md5.equals(string);
        if (!bl2) {
            logger.c((Object)String.format("Internal verification failed on permissionDefinition: %s", this.permissionProduct));
        }
        return bl2;
    }

    @Override
    public Integer getSharingType() {
        return this.sharingType;
    }

    @Override
    public void setSharingType(Integer n2) {
        this.sharingType = n2;
    }

    @Override
    public SharingModel.SharingType getSharingTypeEnum() {
        if (this.sharingType != null) {
            return SharingModel.SharingType.get(this.sharingType);
        }
        return SharingModel.SharingType.SHARING_TYPE_NONE;
    }

    @Override
    public void setSharingTypeEnum(SharingModel.SharingType sharingType) {
        this.sharingType = sharingType.getCode();
    }

    @Override
    public ForeignCollection<ILPSharing> getSharings() {
        if (this.sharings == null) {
            try {
                g.a().as().assignEmptyForeignCollection((Object)this, "sharings");
                this.sharings.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for sharings", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.sharings;
    }

    @Override
    public void setSharings(ForeignCollection<ILPSharing> foreignCollection) {
        this.sharings = foreignCollection;
    }

    @Override
    public void addSharingsObject(ILPSharing iLPSharing) {
        this.getSharings().add((Object)iLPSharing);
    }

    @Override
    public void removeSharingsObject(ILPSharing iLPSharing) {
        this.getSharings().remove((Object)iLPSharing);
    }

    @Override
    public ILPSharing sharingInTransaction(ILPSharingTransaction iLPSharingTransaction) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableIterator closeableIterator = this.getSharings().closeableIterator();){
                while (closeableIterator.hasNext()) {
                    ILPSharing iLPSharing = (ILPSharing)closeableIterator.next();
                    g.a().a(iLPSharing);
                    if (!iLPSharingTransaction.getSharings().contains((Object)iLPSharing)) continue;
                    return iLPSharing;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            logger.d((Object)"Could not iterate over sharings. ", (Throwable)iOException);
        }
        return null;
    }

    @Override
    public boolean isReceived() {
        return this.getSharingTypeEnum() == SharingModel.SharingType.SHARING_TYPE_RECEIVED;
    }

    @Override
    public boolean isSent() {
        return this.getSharingTypeEnum() == SharingModel.SharingType.SHARING_TYPE_SENT;
    }

    @Override
    public String toString() {
        return "ILPPermissionDefinition [permissionValue=" + this.permissionValue + ", permissionScopeValue=" + this.permissionScopeValue + ", permissionTypeDefinition=" + this.permissionTypeDefinition + "]";
    }
}

