/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.b;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.fo.w;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.HTMLUtils;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.mo.AbstractSharingModel;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPLink;
import ch.ionesoft.ilp.book.mo.ILPSharing;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.json.ionesoft.g;
import org.json.ionesoft.i;

@DatabaseTable(tableName="ZILPNOTE")
public class ILPNote
extends AbstractSharingModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPNote.class);
    public static final String TABLE_NAME = "ZILPNOTE";
    public static final String CHECKED_FIELD_NAME = "ZCHECKED";
    public static final String NODEINDEX_FIELD_NAME = "ZNODEINDEX";
    public static final String DATE_FIELD_NAME = "ZDATE";
    public static final String LASTUPDATE_FIELD_NAME = "ZLASTUPDATE";
    public static final String ACCESSPATH_FIELD_NAME = "ZACCESSPATH";
    public static final String COLOR_FIELD_NAME = "ZCOLOR";
    public static final String COLOR_INDEX_FIELD_NAME = "ZCOLORINDEX";
    public static final String ALPHA_FIELD_NAME = "ZALPHA";
    public static final String KEY_FIELD_NAME = "ZKEY";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String TEXT_FIELD_NAME = "ZTEXT";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String CONTENTTYPE_FIELD_NAME = "ZCONTENTTYPE";
    public static final String PRESENTATIONSTYLE_FIELD_NAME = "ZPRESENTATIONSTYLE";
    public static final String NOTEDELETED_FIELD_NAME = "ZNOTEDELETED";
    public static final String TOPIC_FK_FIELD_NAME = "ZTOPIC";
    public static final String EXERCISE_FK_FIELD_NAME = "ZEXERCISE";
    @DatabaseField(columnName="ZCHECKED", canBeNull=true)
    private Boolean checked;
    @DatabaseField(columnName="ZNODEINDEX", canBeNull=true, index=true)
    private Integer nodeIndex;
    @DatabaseField(columnName="ZDATE", canBeNull=true)
    private DateTime date;
    @DatabaseField(columnName="ZLASTUPDATE", canBeNull=true)
    private DateTime lastUpdate;
    @DatabaseField(columnName="ZACCESSPATH", canBeNull=true, index=true)
    private String accessPath;
    @Deprecated
    @DatabaseField(columnName="ZCOLOR", canBeNull=true)
    private String color;
    @DatabaseField(columnName="ZCOLORINDEX", canBeNull=true)
    private Integer colorIndex;
    @DatabaseField(columnName="ZALPHA", canBeNull=true)
    private Float alpha;
    @DatabaseField(columnName="ZKEY", canBeNull=true, index=true)
    private String key;
    @DatabaseField(columnName="ZTITLE", canBeNull=true)
    private String title;
    @DatabaseField(columnName="ZTEXT", canBeNull=true)
    private String text;
    @DatabaseField(columnName="ZTYPE", canBeNull=false, index=true)
    private String type;
    @DatabaseField(columnName="ZCONTENTTYPE", canBeNull=true)
    private Integer contentType;
    @DatabaseField(columnName="ZPRESENTATIONSTYLE", canBeNull=true)
    private String presentationStyle;
    @DatabaseField(columnName="ZNOTEDELETED", canBeNull=true, index=true)
    private Boolean noteDeleted;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZTOPIC", index=true)
    private ILPTopic topic;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZEXERCISE", index=true)
    private ILPExercise exercise;
    @ForeignCollectionField
    private ForeignCollection<ILPLink> links;

    public static String localizedNoteType(String string) {
        String string2 = ch.ionesoft.ilp.base.co.g.b((String)"label.noteType.", (String)string);
        return string2;
    }

    public String extractParagraphFromAccessPath() {
        String[] stringArray = this.accessPath.split("\\|");
        if (stringArray.length > 0) {
            String string = stringArray[0];
            return StringHelper.stringByDeletingLastPathComponent((String)string);
        }
        return null;
    }

    public Boolean isChecked() {
        if (this.checked != null && this.checked.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean getChecked() {
        return this.checked;
    }

    public void setChecked(Boolean bl2) {
        this.checked = bl2;
    }

    public Integer getNodeIndex() {
        return this.nodeIndex;
    }

    public void setNodeIndex(Integer n2) {
        this.nodeIndex = n2;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime dateTime) {
        this.date = dateTime;
    }

    public void setDate(Date date) {
        this.date = date != null ? new DateTime((Object)date) : null;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(DateTime dateTime) {
        this.lastUpdate = dateTime;
    }

    public void setLastUpdate(Date date) {
        this.lastUpdate = date != null ? new DateTime((Object)date) : null;
    }

    public String getAccessPath() {
        return this.accessPath;
    }

    public void setAccessPath(String string) {
        this.accessPath = string;
    }

    public w uiColor() {
        if (this.colorIndex != null) {
            w w2 = w.c((String)this.getAnnotationColor().getHexString());
            if (this.getAlpha() != null) {
                float f2 = this.getAlpha().floatValue();
                w2.b(f2);
            }
            return w2;
        }
        return null;
    }

    public void setUiColor(w w2) {
        this.setAnnotationColor(AnnotationColor.get(w2));
        this.setAlpha(Float.valueOf(w2.g()));
    }

    @Deprecated
    public String getColor() {
        if (this.color == null) {
            if (this.getNoteType().equals((Object)NoteType.NOTE_TYPE_HIGHLIGHT)) {
                this.color = this.getAnnotationColor().oldMarkerColor().m();
            } else if (this.getNoteType().equals((Object)NoteType.NOTE_TYPE_SIDENOTE)) {
                this.color = this.getAnnotationColor().oldSidenoteColor().m();
            }
        }
        return this.color;
    }

    @Deprecated
    public void setColor(String string) {
        this.color = string;
    }

    public Integer getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(Integer n2) {
        this.colorIndex = n2;
    }

    public AnnotationColor getAnnotationColor() {
        Integer n2 = this.getColorIndex();
        if (n2 == null) {
            n2 = 0;
        }
        AnnotationColor annotationColor = AnnotationColor.get(n2);
        return annotationColor;
    }

    public void setAnnotationColor(AnnotationColor annotationColor) {
        if (annotationColor != null) {
            this.setColorIndex(annotationColor.getCode());
        }
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(Float f2) {
        this.alpha = f2;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getTitle() {
        if ("null".equals(this.title)) {
            this.title = null;
        }
        return this.title;
    }

    public void setTitle(String string) {
        if ("null".equals(string)) {
            string = null;
        }
        this.title = string;
    }

    public String getTitlePlainText() {
        return this.title != null ? HTMLUtils.stringByConvertingHTMLToPlainText((String)this.title) : "";
    }

    public String getAnyTitle() {
        if (StringUtils.isNotEmpty((CharSequence)this.title)) {
            return this.title;
        }
        if (this.getNoteType() == NoteType.NOTE_TYPE_SIDENOTE && this.getContentTypeEnum() == ContentType.CONTENT_TYPE_PLAIN_TEXT && StringUtils.isNotEmpty((CharSequence)this.text)) {
            return StringHelper.truncate_toLength((String)this.text, (int)20);
        }
        return this.date != null ? ConverterUtil.formatTimestampNicely((Date)this.date.toDate()) : "-";
    }

    @Deprecated
    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public NoteType getNoteType() {
        return NoteType.get(this.type);
    }

    public void setNoteType(NoteType noteType) {
        this.type = noteType.getCode();
    }

    public Integer getContentType() {
        return this.contentType;
    }

    public void setContentType(Integer n2) {
        this.contentType = n2;
    }

    public ContentType getContentTypeEnum() {
        if (this.contentType != null) {
            return ContentType.get(this.contentType);
        }
        return ContentType.CONTENT_TYPE_NONE;
    }

    public void setContentTypeEnum(ContentType contentType) {
        this.contentType = contentType.getCode();
    }

    public String getPresentationStyle() {
        return this.presentationStyle;
    }

    public i getPresentationStyleJsonObject() {
        i i2 = new i();
        if (this.presentationStyle == null || StringHelper.isEmpty((String)this.presentationStyle)) {
            return i2;
        }
        try {
            i2 = new i(this.presentationStyle);
        }
        catch (g g2) {
            logger.c((Object)String.format(Locale.ENGLISH, "Could not create JSONObject from given string: %s. Empty JSONObject returned", this.presentationStyle), (Throwable)g2);
        }
        return i2;
    }

    public void setPresentationStyle(String string) {
        this.presentationStyle = string;
    }

    public ch.ionesoft.ilp.book.search.b getAnnotationPresentationStyle() {
        return new ch.ionesoft.ilp.book.search.b(this.getPresentationStyleJsonObject());
    }

    public void setAnnotationPresentationStyle(ch.ionesoft.ilp.book.search.b b2) {
        this.setPresentationStyle(b2.a());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Boolean getNoteDeleted() {
        return this.noteDeleted;
    }

    public boolean isDeleted() {
        return this.noteDeleted != null && this.noteDeleted != false;
    }

    public void setNoteDeleted(Boolean bl2) {
        this.noteDeleted = bl2;
    }

    public ILPTopic getTopic() {
        return this.topic;
    }

    public void setTopic(ILPTopic iLPTopic) {
        this.topic = iLPTopic;
    }

    public ILPExercise getExercise() {
        return this.exercise;
    }

    public void setExercise(ILPExercise iLPExercise) {
        this.exercise = iLPExercise;
    }

    public ILPIssueDef getIssue() {
        if (this.topic != null) {
            return this.topic.getIssue();
        }
        if (this.exercise != null) {
            return this.exercise.getIssue();
        }
        return null;
    }

    public ForeignCollection<ILPLink> getLinks() {
        if (this.links == null) {
            try {
                ch.ionesoft.ilp.book.pe.g.a().M().assignEmptyForeignCollection((Object)this, "links");
                this.links.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for note.links", (Throwable)sQLException);
            }
        }
        return this.links;
    }

    public boolean hasLinks() {
        return this.getFirstLink() != null;
    }

    public void setLinks(ForeignCollection<ILPLink> foreignCollection) {
        this.links = foreignCollection;
    }

    public void addLinksObject(ILPLink iLPLink) {
        this.getLinks().add((Object)iLPLink);
    }

    public void removeLinksObject(ILPLink iLPLink) {
        this.getLinks().remove((Object)iLPLink);
    }

    public void removeAllLinksObjects() {
        ArrayList<ILPLink> arrayList = new ArrayList<ILPLink>();
        for (ILPLink iLPLink : this.getLinks()) {
            arrayList.add(iLPLink);
        }
        for (ILPLink iLPLink : arrayList) {
            this.getLinks().remove((Object)iLPLink);
        }
    }

    public ILPLink getFirstLink() {
        block18: {
            ILPLink iLPLink;
            CloseableIterator closeableIterator = null;
            try {
                if (this.links == null) {
                    return null;
                }
                closeableIterator = this.links.closeableIterator();
                if (!closeableIterator.hasNext()) break block18;
                iLPLink = (ILPLink)closeableIterator.next();
            }
            catch (Exception exception) {
                break block18;
            }
            finally {
                if (closeableIterator != null) {
                    try {
                        closeableIterator.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return iLPLink;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public ILPLink getLinkMatching(ILPLink.LinkType var1_1, String var2_2, String var3_3, String var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String toString() {
        return "ILPNote [title= " + this.title + ", type=" + this.type + ", contentType=" + this.contentType + ", pk=" + this.pk + "]";
    }

    public String getReferencingModelId() {
        if (this.getTopic() != null) {
            return this.getTopic().getAccessPath() != null ? this.getTopic().getAccessPath() : "";
        }
        if (this.getExercise() != null) {
            return this.getExercise().getExerciseId() != null ? this.getExercise().getExerciseId() : "";
        }
        return "";
    }

    public String getReferencingModelTitle() {
        if (this.getTopic() != null) {
            return this.getTopic().getTitle() != null ? this.getTopic().getTitle() : "";
        }
        if (this.getExercise() != null) {
            return this.getExercise().getTitle() != null ? this.getExercise().getTitle() : "";
        }
        return "";
    }

    public Integer getLevel() {
        if (this.getTopic() != null) {
            return this.getTopic().getLevel();
        }
        if (this.getExercise() != null) {
            return this.getExercise().getLevel();
        }
        return 0;
    }

    @Override
    public ForeignCollection<ILPSharing> getSharings() {
        if (this.sharings == null) {
            try {
                ch.ionesoft.ilp.book.pe.g.a().M().assignEmptyForeignCollection((Object)this, "sharings");
                this.sharings.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for sharings", (Throwable)sQLException);
                f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.sharings;
    }

    public void copyInto(ILPNote iLPNote) throws SQLException {
        iLPNote.setAccessPath(this.getAccessPath());
        iLPNote.setAlpha(this.getAlpha());
        iLPNote.setAnnotationColor(this.getAnnotationColor());
        iLPNote.setAnnotationPresentationStyle(this.getAnnotationPresentationStyle());
        iLPNote.setChecked(this.getChecked());
        iLPNote.setColorIndex(this.getColorIndex());
        iLPNote.setContentType(this.getContentType());
        iLPNote.setDate(this.getDate());
        iLPNote.setKey(this.getKey());
        iLPNote.setLastUpdate(this.getLastUpdate());
        iLPNote.setNodeIndex(this.getNodeIndex());
        iLPNote.setNoteDeleted(this.getNoteDeleted());
        iLPNote.setNoteType(this.getNoteType());
        iLPNote.setPresentationStyle(this.getPresentationStyle());
        iLPNote.setText(this.getText());
        iLPNote.setTitle(this.getTitle());
        iLPNote.setSharingTypeEnum(this.getSharingTypeEnum());
        if (iLPNote.isInDatabase()) {
            ch.ionesoft.ilp.book.pe.g.a().M().update((Object)iLPNote);
        } else {
            ch.ionesoft.ilp.book.pe.g.a().M().create((Object)iLPNote);
        }
        for (ILPLink iLPLink : this.getLinks()) {
            ILPLink iLPLink2 = iLPNote.getLinkMatching(iLPLink.getLinkType(), iLPLink.getUrl(), iLPLink.getName(), iLPLink.getFileReference());
            if (iLPLink2 == null) {
                iLPLink2 = new ILPLink();
                iLPLink2.setNote(iLPNote);
            }
            iLPLink.copyInto(iLPLink2);
            if (iLPLink2.isInDatabase()) {
                ch.ionesoft.ilp.book.pe.g.a().P().update((Object)iLPLink2);
                continue;
            }
            ch.ionesoft.ilp.book.pe.g.a().P().create((Object)iLPLink2);
        }
    }

    public static enum AnnotationColor {
        ANNOTATION_COLOR_1(1, "annotation.label.color.1", "annotationColor1", "ILPBook.annotation.color.1.hex"),
        ANNOTATION_COLOR_2(2, "annotation.label.color.2", "annotationColor2", "ILPBook.annotation.color.2.hex"),
        ANNOTATION_COLOR_3(3, "annotation.label.color.3", "annotationColor3", "ILPBook.annotation.color.3.hex"),
        ANNOTATION_COLOR_4(4, "annotation.label.color.4", "annotationColor4", "ILPBook.annotation.color.4.hex");

        private static final Map<Integer, AnnotationColor> lookup;
        private int code;
        private String localizable;
        private String cssClass;
        private String hexColor;

        static {
            lookup = new HashMap<Integer, AnnotationColor>();
            for (AnnotationColor annotationColor : EnumSet.allOf(AnnotationColor.class)) {
                lookup.put(annotationColor.getCode(), annotationColor);
            }
        }

        private AnnotationColor(int n3, String string2, String string3, String string4) {
            this.hexColor = b.b().t(string4);
            this.code = n3;
            this.localizable = string2;
            this.cssClass = string3;
        }

        public int getCode() {
            return this.code;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public String getHexString() {
            return this.hexColor;
        }

        public String formatHexStringWithAlpha(float f2) {
            String string = Integer.toHexString((int)(f2 * 255.0f));
            String string2 = String.valueOf(this.getHexString()) + string;
            return string2;
        }

        public static AnnotationColor get(int n2) {
            AnnotationColor annotationColor = lookup.get(n2);
            if (annotationColor == null) {
                annotationColor = ANNOTATION_COLOR_1;
            }
            return annotationColor;
        }

        public static AnnotationColor get(w w2) {
            float f2 = -1.0f;
            AnnotationColor annotationColor = ANNOTATION_COLOR_1;
            AnnotationColor[] annotationColorArray = AnnotationColor.values();
            int n2 = annotationColorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                AnnotationColor annotationColor2 = annotationColorArray[n3];
                w w3 = w.c((String)annotationColor2.getHexString());
                float f3 = w2.b(w3);
                if (f2 < 0.0f || f2 > f3) {
                    f2 = f3;
                    annotationColor = annotationColor2;
                }
                ++n3;
            }
            return annotationColor;
        }

        public static AnnotationColor annotationColorFromColorString(String string) {
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                return AnnotationColor.get(w.b((String)string));
            }
            return ANNOTATION_COLOR_1;
        }

        @Deprecated
        public w oldMarkerColor() {
            String string = ILPBookSettingsHelper.instance().markerColorHtmlNameForIndex(this);
            w w2 = w.d((String)string);
            return w2;
        }

        @Deprecated
        public w oldSidenoteColor() {
            String string = ILPBookSettingsHelper.instance().noteColorHtmlNameForIndex(this);
            w w2 = w.d((String)string);
            return w2;
        }
    }

    public static enum ContentType {
        CONTENT_TYPE_NONE(0, "noteContentTypeNone", "none"),
        CONTENT_TYPE_PLAIN_TEXT(1, "noteContentTypePlainText", "plain"),
        CONTENT_TYPE_RICH_TEXT(2, "noteContentTypeRichText", "rich"),
        CONTENT_TYPE_LINK(3, "noteContentTypeLink", "file"),
        CONTENT_TYPE_DRAWING_TEXT(4, "noteContentTypeDrawingText", "draw"),
        CONTENT_TYPE_EDITABLE_TEXT_ENTRY(5, "noteContentTypeEditableTextEntry", "editableTextEntry"),
        CONTENT_TYPE_EDITABLE_CHECKBOX(6, "noteContentEditableCheckbox", "editableCheckbox"),
        CONTENT_TYPE_EXTERNAL_LINK(7, "noteContentTypeExternalLink", "external_link"),
        CONTENT_TYPE_READ_ONLY(8, "noteContentTypeReadOnly", "read_only");

        private static final Map<Integer, ContentType> lookup;
        private static final Map<String, ContentType> shortNameLookup;
        private int code;
        private String cssClass;
        private String shortName;

        static {
            lookup = new HashMap<Integer, ContentType>();
            shortNameLookup = new HashMap<String, ContentType>();
            for (ContentType contentType : EnumSet.allOf(ContentType.class)) {
                lookup.put(contentType.getCode(), contentType);
                shortNameLookup.put(contentType.getShortName(), contentType);
            }
        }

        private ContentType(int n3, String string2, String string3) {
            this.code = n3;
            this.cssClass = string2;
            this.shortName = string3;
        }

        public int getCode() {
            return this.code;
        }

        public static ContentType get(int n2) {
            return lookup.get(n2);
        }

        public static ContentType get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }

        public static ContentType getForShortName(String string) {
            if (StringHelper.isBlank((String)string)) {
                return CONTENT_TYPE_NONE;
            }
            return shortNameLookup.get(string);
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public String getShortName() {
            return this.shortName;
        }
    }

    public static enum NoteType {
        NOTE_TYPE_UNDEFINED("", ""),
        NOTE_TYPE_SUMMARY("S", "summary"),
        NOTE_TYPE_SIDENOTE("N", "sidenote"),
        NOTE_TYPE_SIDENOTE_V2("N2", "sidenoteV2"),
        NOTE_TYPE_HIGHLIGHT("H", "highlight"),
        NOTE_TYPE_EDITABLE_FIELD("E", "editableField"),
        NOTE_TYPE_ANNOTATED_IMAGE("A", "annotatedImage");

        private static final Map<String, NoteType> lookup;
        private static final Map<String, NoteType> shortNameLookup;
        private String code;
        private String shortName;

        static {
            lookup = new HashMap<String, NoteType>();
            shortNameLookup = new HashMap<String, NoteType>();
            for (NoteType noteType : EnumSet.allOf(NoteType.class)) {
                lookup.put(noteType.getCode(), noteType);
                shortNameLookup.put(noteType.getShortName(), noteType);
            }
        }

        private NoteType(String string2, String string3) {
            this.code = string2;
            this.shortName = string3;
        }

        public String getCode() {
            return this.code;
        }

        public String getShortName() {
            return this.shortName;
        }

        public static NoteType get(String string) {
            if (StringHelper.isBlank((String)string)) {
                return NOTE_TYPE_UNDEFINED;
            }
            NoteType noteType = lookup.get(string);
            if (noteType == null) {
                noteType = NOTE_TYPE_UNDEFINED;
            }
            return noteType;
        }

        public static NoteType getForShortName(String string) {
            if (StringHelper.isBlank((String)string)) {
                return NOTE_TYPE_UNDEFINED;
            }
            NoteType noteType = shortNameLookup.get(string);
            if (noteType == null) {
                noteType = NOTE_TYPE_UNDEFINED;
            }
            return noteType;
        }
    }
}

