/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.angular.model.ab;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPNEWS")
public class ILPNews
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPNews.class);
    public static final String TABLE_NAME = "ZILPNEWS";
    public static final String KEY_FIELD_NAME = "ZKEY";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String EXCERPT_FIELD_NAME = "ZEXCERPT";
    public static final String DESCRIPTION_FIELD_NAME = "ZDESCRIPTION";
    public static final String ITEM_LEVEL_FIELD_NAME = "ZITEMLEVEL";
    public static final String ITEM_CONTEXT_FIELD_NAME = "ZITEMCONTEXT";
    public static final String NEWS_READ_FIELD_NAME = "ZNEWSREAD";
    public static final String CREATED_AT_FIELD_NAME = "ZCREATEDAT";
    @DatabaseField(columnName="ZKEY")
    private String key;
    @DatabaseField(columnName="ZTITLE")
    private String title;
    @DatabaseField(columnName="ZEXCERPT")
    private String excerpt;
    @DatabaseField(columnName="ZDESCRIPTION")
    private String description;
    @DatabaseField(columnName="ZITEMLEVEL")
    private Integer itemLevel;
    @DatabaseField(columnName="ZITEMCONTEXT")
    private Integer itemContext;
    @DatabaseField(columnName="ZNEWSREAD")
    private Boolean newsRead;
    @DatabaseField(columnName="ZCREATEDAT")
    private DateTime createdAt;

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPreparedTitle() {
        String string = this.title;
        string = StringHelper.replaceAposWithAlphaNumValue((String)string);
        string = StringHelper.prepareStringForJavaScriptExecution((String)string);
        return string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getExcerpt() {
        return this.excerpt;
    }

    public String getPreparedExcerpt() {
        String string = this.excerpt;
        string = StringHelper.replaceAposWithAlphaNumValue((String)string);
        string = StringHelper.prepareStringForJavaScriptExecution((String)string);
        return string;
    }

    public void setExcerpt(String string) {
        this.excerpt = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPreparedDescription() {
        String string = this.description;
        string = StringHelper.replaceAposWithAlphaNumValue((String)string);
        string = StringHelper.prepareStringForJavaScriptExecution((String)string);
        return string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public ItemLevel getItemLevel() {
        if (this.itemLevel != null) {
            return ItemLevel.get(this.itemLevel);
        }
        return ItemLevel.ITEM_LEVEL_UNDEFINED;
    }

    public void setItemContext(ItemContext itemContext) {
        this.itemContext = itemContext.getCode();
    }

    public ItemContext getItemContext() {
        if (this.itemContext != null) {
            return ItemContext.get(this.itemContext);
        }
        return ItemContext.ITEM_CONTEXT_UNDEFINED;
    }

    public void setItemLevel(ItemLevel itemLevel) {
        this.itemLevel = itemLevel.getCode();
    }

    public Boolean getNewsRead() {
        return this.newsRead;
    }

    public void setNewsRead(Boolean bl2) {
        this.newsRead = bl2;
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime dateTime) {
        this.createdAt = dateTime;
    }

    @Override
    public String toString() {
        return "ILPNews [pk=" + this.pk + ", title=" + this.title + ", excerpt=" + this.excerpt + ", description=" + this.description + ", itemLevel=" + this.itemLevel + ", itemContext=" + this.itemContext + ", newsRead=" + this.newsRead + ", createdAt=" + this.createdAt + "]";
    }

    public static enum ItemContext {
        ITEM_CONTEXT_UNDEFINED(0),
        ITEM_CONTEXT_GENERAL(1),
        ITEM_CONTEXT_SYSTEM(2),
        ITEM_CONTEXT_SUPPORT(3),
        ITEM_CONTEXT_UPDATE_EBOOK(4),
        ITEM_CONTEXT_UPDATE_APP(5),
        ITEM_CONTEXT_MESSAGE(6),
        ITEM_CONTEXT_FEEDBACK(7),
        ITEM_CONTEXT_SHARING(8),
        ITEM_CONTEXT_TASK(9);

        private static final Map<Integer, ItemContext> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ItemContext>();
            for (ItemContext itemContext : EnumSet.allOf(ItemContext.class)) {
                lookup.put(itemContext.getCode(), itemContext);
            }
        }

        private ItemContext(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ItemContext get(int n2) {
            return lookup.get(n2);
        }

        public static ItemContext getByStringCode(String string) {
            try {
                int n2 = Integer.parseInt(string);
                ItemContext itemContext = lookup.get(n2);
                return itemContext != null ? itemContext : ITEM_CONTEXT_UNDEFINED;
            }
            catch (Exception exception) {
                return ITEM_CONTEXT_UNDEFINED;
            }
        }

        public static ItemContext getByName(String string) {
            try {
                ItemContext itemContext = ItemContext.valueOf(string);
                return itemContext != null ? itemContext : ITEM_CONTEXT_UNDEFINED;
            }
            catch (Exception exception) {
                return ITEM_CONTEXT_UNDEFINED;
            }
        }

        public ab.a asICBEnum() {
            switch (this) {
                case ITEM_CONTEXT_GENERAL: {
                    return ab.a.b;
                }
                case ITEM_CONTEXT_SYSTEM: {
                    return ab.a.c;
                }
                case ITEM_CONTEXT_SUPPORT: {
                    return ab.a.d;
                }
                case ITEM_CONTEXT_UPDATE_EBOOK: {
                    return ab.a.e;
                }
                case ITEM_CONTEXT_UPDATE_APP: {
                    return ab.a.f;
                }
                case ITEM_CONTEXT_MESSAGE: {
                    return ab.a.g;
                }
                case ITEM_CONTEXT_FEEDBACK: {
                    return ab.a.h;
                }
                case ITEM_CONTEXT_SHARING: {
                    return ab.a.i;
                }
                case ITEM_CONTEXT_TASK: {
                    return ab.a.j;
                }
            }
            return ab.a.a;
        }
    }

    public static enum ItemLevel {
        ITEM_LEVEL_UNDEFINED(0),
        ITEM_LEVEL_INFO(1),
        ITEM_LEVEL_WARN(2),
        ITEM_LEVEL_DANGER(3);

        private static final Map<Integer, ItemLevel> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ItemLevel>();
            for (ItemLevel itemLevel : EnumSet.allOf(ItemLevel.class)) {
                lookup.put(itemLevel.getCode(), itemLevel);
            }
        }

        private ItemLevel(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ItemLevel get(int n2) {
            return lookup.get(n2);
        }

        public static ItemLevel getByStringCode(String string) {
            try {
                int n2 = Integer.parseInt(string);
                ItemLevel itemLevel = lookup.get(n2);
                return itemLevel != null ? itemLevel : ITEM_LEVEL_UNDEFINED;
            }
            catch (Exception exception) {
                return ITEM_LEVEL_UNDEFINED;
            }
        }

        public static ItemLevel getByName(String string) {
            try {
                ItemLevel itemLevel = ItemLevel.valueOf(string);
                return itemLevel != null ? itemLevel : ITEM_LEVEL_UNDEFINED;
            }
            catch (Exception exception) {
                return ITEM_LEVEL_UNDEFINED;
            }
        }

        public ab.b asICBEnum() {
            switch (this) {
                case ITEM_LEVEL_INFO: {
                    return ab.b.b;
                }
                case ITEM_LEVEL_WARN: {
                    return ab.b.c;
                }
                case ITEM_LEVEL_DANGER: {
                    return ab.b.d;
                }
            }
            return ab.b.a;
        }
    }
}

