/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.book.co.ILPConfigurationManager;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPMandant;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;

@DatabaseTable(tableName="ZILPMANDANTCONFIG")
public class ILPMandantConfig
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPMandantConfig.class);
    public static final String TABLE_NAME = "ZILPMANDANTCONFIG";
    public static final String FILE_REFERENCE_FIELD_NAME = "ZFILEREFERENCE";
    public static final String FILE_PATH_FIELD_NAME = "ZFILEPATH";
    public static final String CURRENT_VERSION_FIELD_NAME = "ZCURRENTVERSION";
    public static final String LATEST_VERSION_FIELD_NAME = "ZLATESTVERSION";
    public static final String PRELOAD_FIELD_NAME = "ZPRELOAD";
    public static final String MANDANT_FK_FIELD_NAME = "ZMANDANT";
    @DatabaseField(columnName="ZFILEREFERENCE", canBeNull=false, index=true)
    private String fileReference;
    @DatabaseField(columnName="ZFILEPATH", canBeNull=false)
    private String filePath;
    @DatabaseField(columnName="ZCURRENTVERSION")
    private Integer currentVersion;
    @DatabaseField(columnName="ZLATESTVERSION")
    private Integer latestVersion;
    @DatabaseField(columnName="ZPRELOAD", canBeNull=false)
    private Boolean preload;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZMANDANT", index=true)
    private ILPMandant mandant;
    @ForeignCollectionField
    private ForeignCollection<ILPEProduct> eProducts;

    public boolean isInstalled() {
        if (this.currentVersion == null) {
            return false;
        }
        return this.currentVersion.equals(this.latestVersion);
    }

    public void install() {
        logger.b((Object)("Installing mandantConfig: " + this.getFilePath() + " of mandant: " + this.getMandant().getMandantIdentifier() + "."));
        ILPConfigurationManager iLPConfigurationManager = new ILPConfigurationManager();
        iLPConfigurationManager.downloadAndInstallMandantConfig(this);
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(String string) {
        this.fileReference = string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public Integer getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(Integer n2) {
        this.currentVersion = n2;
    }

    public Integer getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(Integer n2) {
        this.latestVersion = n2;
    }

    public Boolean getPreload() {
        return this.preload;
    }

    public void setPreload(Boolean bl2) {
        this.preload = bl2;
    }

    public ForeignCollection<ILPEProduct> getEProducts() {
        if (this.eProducts == null) {
            try {
                g.a().aC().assignEmptyForeignCollection((Object)this, "eProducts");
                this.eProducts.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for mandantConfig.eProducts", (Throwable)sQLException);
                f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.eProducts;
    }

    public void seteProducts(ForeignCollection<ILPEProduct> foreignCollection) {
        this.eProducts = foreignCollection;
    }

    public ILPMandant getMandant() {
        return this.mandant;
    }

    public void setMandant(ILPMandant iLPMandant) {
        this.mandant = iLPMandant;
    }
}

