/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.fo.z;
import ch.ionesoft.ilp.book.co.ILPAbstractPropertyModel;
import ch.ionesoft.ilp.book.co.ILPConfigurationManager;
import ch.ionesoft.ilp.book.mo.ILPAgent;
import ch.ionesoft.ilp.book.mo.ILPDestinationDefinition;
import ch.ionesoft.ilp.book.mo.ILPEnvironmentConfig;
import ch.ionesoft.ilp.book.mo.ILPImageZipDescriptor;
import ch.ionesoft.ilp.book.mo.ILPMandantConfig;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

@DatabaseTable(tableName="ZILPMANDANT")
public class ILPMandant
extends ILPAbstractPropertyModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPMandant.class);
    public static final String TABLE_NAME = "ZILPMANDANT";
    public static final String MANDANT_IDENTIFIER_FIELD_NAME = "ZMANDANTIDENTIFIER";
    public static final String NAME_FIELD_NAME = "ZNAME";
    public static final String INCOGNITO_FIELD_NAME = "ZINCOGNITO";
    public static final String ENVIRONMENT_CONFIG_FIELD_NAME = "ZENVIRONMENTCONFIG";
    public static final String IMAGE_ZIP_DESCRIPTOR_FK_FIELD_NAME = "ZIMAGEZIPDESCRIPTOR";
    public static final String COVER_FILENAME_FIELD_NAME = "ZCOVERFILENAME";
    @DatabaseField(columnName="ZMANDANTIDENTIFIER", canBeNull=false, index=true)
    private String mandantIdentifier;
    @DatabaseField(columnName="ZNAME", canBeNull=false)
    private String name;
    @DatabaseField(columnName="ZCOVERFILENAME")
    private String coverFilename;
    @DatabaseField(columnName="ZINCOGNITO", canBeNull=false)
    private Boolean incognito;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZIMAGEZIPDESCRIPTOR")
    private ILPImageZipDescriptor imageZipDescriptor;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZENVIRONMENTCONFIG", canBeNull=false)
    private ILPEnvironmentConfig environmentConfig;
    @ForeignCollectionField
    private ForeignCollection<ILPMandantConfig> mandantConfigs;
    @ForeignCollectionField
    private ForeignCollection<ILPProperty> properties;
    @ForeignCollectionField
    private ForeignCollection<ILPAgent> agents;
    @ForeignCollectionField
    private ForeignCollection<ILPDestinationDefinition> destinationDefinitions;

    public String getMandantIdentifier() {
        return this.mandantIdentifier;
    }

    public void setMandantIdentifier(String string) {
        this.mandantIdentifier = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getCoverFilename() {
        return this.coverFilename;
    }

    public void setCoverFilename(String string) {
        this.coverFilename = string;
    }

    public Boolean getIncognito() {
        return this.incognito;
    }

    public void setIncognito(Boolean bl2) {
        this.incognito = bl2;
    }

    public ILPEnvironmentConfig getEnvironmentConfig() {
        g.a().a(this.environmentConfig);
        return this.environmentConfig;
    }

    public void setEnvironmentConfig(ILPEnvironmentConfig iLPEnvironmentConfig) {
        this.environmentConfig = iLPEnvironmentConfig;
    }

    public ForeignCollection<ILPMandantConfig> getMandantConfigs() {
        if (this.mandantConfigs == null) {
            try {
                g.a().aA().assignEmptyForeignCollection((Object)this, "mandantConfigs");
                this.mandantConfigs.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for mandant.mandantConfigs", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.mandantConfigs;
    }

    public void setMandantConfigs(ForeignCollection<ILPMandantConfig> foreignCollection) {
        this.mandantConfigs = foreignCollection;
    }

    @Override
    public String propertyStringById_defaultValue(String string, String string2) {
        ILPProperty iLPProperty = f.a().a(this, string);
        if (iLPProperty != null) {
            return iLPProperty.getValue();
        }
        return string2;
    }

    public ForeignCollection<ILPProperty> getProperties() {
        if (this.properties == null) {
            try {
                g.a().aA().assignEmptyForeignCollection((Object)this, "properties");
                this.properties.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for mandant.properties", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.properties;
    }

    public void setProperties(ForeignCollection<ILPProperty> foreignCollection) {
        this.properties = foreignCollection;
    }

    public ForeignCollection<ILPDestinationDefinition> getDestinationDefinitions() {
        if (this.destinationDefinitions == null) {
            try {
                g.a().aA().assignEmptyForeignCollection((Object)this, "destinationDefinitions");
                this.destinationDefinitions.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for mandant.destinationDefinitions", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.destinationDefinitions;
    }

    public void setDestinationDefinitions(ForeignCollection<ILPDestinationDefinition> foreignCollection) {
        this.destinationDefinitions = foreignCollection;
    }

    public ILPImageZipDescriptor getImageZipDescriptor() {
        g.a().a(this.imageZipDescriptor);
        return this.imageZipDescriptor;
    }

    public void setImageZipDescriptor(ILPImageZipDescriptor iLPImageZipDescriptor) {
        this.imageZipDescriptor = iLPImageZipDescriptor;
    }

    public ForeignCollection<ILPAgent> getAgents() {
        return this.agents;
    }

    public void setAgents(ForeignCollection<ILPAgent> foreignCollection) {
        this.agents = foreignCollection;
    }

    public ILPAgent agentWithId(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return this.defaultAgent();
        }
        CloseableIterator closeableIterator = this.getAgents().closeableIterator();
        while (closeableIterator.hasNext()) {
            ILPAgent iLPAgent = (ILPAgent)closeableIterator.next();
            if (!string.equals(iLPAgent.getAgentIdentifier())) continue;
            ILPAgent iLPAgent2 = iLPAgent;
            return iLPAgent2;
        }
        logger.c((Object)("Could not find agent with key: " + string + ". Returning default agent"));
        ILPAgent iLPAgent = this.defaultAgent();
        return iLPAgent;
        finally {
            try {
                closeableIterator.close();
            }
            catch (IOException iOException) {}
        }
    }

    public ILPAgent defaultAgent() {
        CloseableIterator closeableIterator = this.getAgents().closeableIterator();
        try {
            while (closeableIterator.hasNext()) {
                ILPAgent iLPAgent = (ILPAgent)closeableIterator.next();
                if (!iLPAgent.isDefaultAgent()) continue;
                ILPAgent iLPAgent2 = iLPAgent;
                return iLPAgent2;
            }
        }
        finally {
            try {
                closeableIterator.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public z getLogoImage() {
        String string = this.coverFilename;
        String string2 = "logos";
        try {
            return z.b((String)string, (String)string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getCoverImageName(String string) {
        String string2 = this.getCoverFilename();
        if (string2 == null) {
            return null;
        }
        String string3 = FilenameUtils.getExtension((String)string2);
        String string4 = FilenameUtils.removeExtension((String)string2);
        return String.format("%s_%s.%s", string4, string, string3);
    }

    public String getCoverImageName() {
        String string = this.getCoverFilename();
        return string;
    }

    public void install() {
        logger.b((Object)("Install mandant with identifier: " + this.getMandantIdentifier() + "."));
        ILPConfigurationManager iLPConfigurationManager = new ILPConfigurationManager();
        List<ILPMandantConfig> list = f.a().a(this);
        iLPConfigurationManager.downloadAndInstallMandantConfigs(list, false, false);
    }

    public boolean isFullyInstalled() {
        List<ILPMandantConfig> list = f.a().a(this);
        return list == null || list.isEmpty();
    }

    public z coverImageForMandant() {
        return z.a((String)this.pathCoverImage());
    }

    public String pathCoverImage() {
        if (this.getImageZipDescriptor() == null) {
            logger.c((Object)("Could not create the path to cover for mandant: " + this));
            return "";
        }
        String string = new File(h.e((String)this.getImageZipDescriptor().getImageZipFileReference()), this.getCoverFilename()).getAbsolutePath();
        return string;
    }

    @Override
    public String toString() {
        return "ILPMandant [mandantIdentifier=" + this.mandantIdentifier + ", name=" + this.name + "]";
    }
}

