/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.he.e;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPNote;
import ch.ionesoft.ilp.book.mo.ILPScenarioElementResult;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.mo.SharingModel;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPLINK")
public class ILPLink
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPLink.class);
    public static final String TABLE_NAME = "ZILPLINK";
    public static final String NAME_FIELD_NAME = "ZNAME";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String URL_FIELD_NAME = "ZURL";
    public static final String CREATION_DATE_FIELD_NAME = "ZCREATIONDATE";
    public static final String TOPIC_FK_FIELD_NAME = "ZTOPIC";
    public static final String ANSWER_FK_FIELD_NAME = "ZANSWER";
    public static final String NOTE_FK_FIELD_NAME = "ZNOTE";
    public static final String SCENARIO_ELEMENT_RESULT_FK_FIELD_NAME = "ZSCENARIOELEMENTRESULT";
    public static final String FILE_REFERNCE_FIELD_NAME = "ZFILEREFERENCE";
    public static final String LOCAL_STORE_ITEM_KEY_FIELD_NAME = "ZLOCALSTOREITEMKEY";
    public static final String MIME_TYPE_FIELD_NAME = "ZMIMETYPE";
    public static final String VERSION_FIELD_NAME = "ZVERSION";
    public static final String DELETED_FIELD_NAME = "ZDELETED";
    @DatabaseField(columnName="ZNAME", canBeNull=false, index=true)
    private String name;
    @DatabaseField(columnName="ZTYPE", canBeNull=false, index=true)
    private Integer type;
    @DatabaseField(columnName="ZURL", canBeNull=true)
    private String url;
    @DatabaseField(columnName="ZCREATIONDATE", canBeNull=true)
    private DateTime creationDate;
    @DatabaseField(foreign=true, columnName="ZTOPIC", index=true)
    private ILPTopic topic;
    @DatabaseField(foreign=true, columnName="ZANSWER", index=true)
    private ILPAnswer answer;
    @DatabaseField(foreign=true, columnName="ZNOTE", index=true)
    private ILPNote note;
    @DatabaseField(foreign=true, columnName="ZSCENARIOELEMENTRESULT", index=true)
    private ILPScenarioElementResult scenarioElementResult;
    @DatabaseField(columnName="ZFILEREFERENCE", canBeNull=true)
    private String fileReference;
    @DatabaseField(columnName="ZLOCALSTOREITEMKEY", canBeNull=true)
    private String localStoreItemKey;
    @DatabaseField(columnName="ZMIMETYPE", canBeNull=true)
    private String mimeType;
    @DatabaseField(columnName="ZVERSION", canBeNull=true)
    private Integer version;
    @DatabaseField(columnName="ZDELETED", canBeNull=true)
    private Boolean deleted;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        if (this.name != null && this.name.length() > 0) {
            return this.name;
        }
        String string = StringHelper.lastPathComponent((String)this.getUrl());
        return string != null ? string : "";
    }

    public String getPreviewImage() {
        boolean bl2;
        String string = h.V();
        String string2 = ConverterUtil.mimeTypeForFilename((String)this.getUrl());
        boolean bl3 = bl2 = SystemHelper.isPictureFormat((String)string2) || SystemHelper.isAndroidSystem() && !this.getUrl().startsWith("/com.android.providers");
        if (bl2 && SystemHelper.isPictureFormat((String)string2)) {
            if (this.getLinkType() == LinkType.LINK_TYPE_ASSET_EXCHANGE) {
                return this.getAssetExchangeUrl();
            }
            if (this.getLinkType() == LinkType.LINK_TYPE_UCS) {
                return String.valueOf(h.W()) + "userContent/" + this.fileReference + "/" + this.version;
            }
            return String.valueOf(h.W()) + "imageresource/" + e.m(this.getUrl());
        }
        if (SystemHelper.isAudioFormat((String)string2)) {
            return String.valueOf(string) + "icons/common/file_audio_off.svg";
        }
        if (SystemHelper.isPDFFormat((String)string2)) {
            return String.valueOf(string) + "icons/common/file_pdf.svg";
        }
        if (SystemHelper.isVideoFormat((String)string2)) {
            return String.valueOf(string) + "icons/common/file_video_off.svg";
        }
        if (SystemHelper.isDocxFormat((String)string2)) {
            return String.valueOf(string) + "icons/common/file_doc.svg";
        }
        if (SystemHelper.isPowerpointFormat((String)string2)) {
            return String.valueOf(string) + "icons/common/file_ppt.svg";
        }
        return String.valueOf(string) + "icons/common/file_other.svg";
    }

    public Integer getTypeCode() {
        return this.type;
    }

    public void setType(Integer n2) {
        this.type = n2;
    }

    public LinkType getLinkType() {
        return LinkType.get(this.type);
    }

    public void setLinkType(LinkType linkType) {
        this.type = linkType.getCode();
    }

    public String getUrl() {
        if (this.url != null) {
            return StringHelper.normalizeForFilePath((String)this.url);
        }
        return null;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime dateTime) {
        this.creationDate = dateTime;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date != null ? new DateTime((Object)date) : null;
    }

    public ILPTopic getTopic() {
        g.a().c(this.topic);
        return this.topic;
    }

    public void setTopic(ILPTopic iLPTopic) {
        this.topic = iLPTopic;
    }

    public ILPAnswer getAnswer() {
        g.a().a(this.answer);
        return this.answer;
    }

    public void setAnswer(ILPAnswer iLPAnswer) {
        this.answer = iLPAnswer;
    }

    public SharingModel getNote() {
        g.a().a(this.note);
        return this.note;
    }

    public void setNote(ILPNote iLPNote) {
        this.note = iLPNote;
    }

    public ILPScenarioElementResult getScenarioElementResult() {
        return this.scenarioElementResult;
    }

    public void setScenarioElementResult(ILPScenarioElementResult iLPScenarioElementResult) {
        this.scenarioElementResult = iLPScenarioElementResult;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(String string) {
        this.fileReference = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer n2) {
        this.version = n2;
    }

    public String getLocalStoreItemKey() {
        return this.localStoreItemKey;
    }

    public void setLocalStoreItemKey(String string) {
        this.localStoreItemKey = string;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean bl2) {
        this.deleted = bl2;
    }

    public String getUrlSuffix() {
        if (this.url != null) {
            return StringHelper.extractPostfixAfter((String)this.url, (String)".");
        }
        return "";
    }

    public boolean urlPointsToImage() {
        List<String> list = Arrays.asList("jpg", "jpeg", "png", "svg");
        return StringHelper.isNotBlank((String)this.getUrlSuffix()) && list.contains(this.getUrlSuffix());
    }

    @Override
    public String toString() {
        return "ILPLink [name=" + this.name + ", type=" + this.type + ", url=" + this.url + ", pk=" + this.pk + "]";
    }

    public String getFullUrl() {
        if (this.getUrl().startsWith("assetExchange")) {
            return String.valueOf(h.W()) + e.m(this.getUrl());
        }
        if (this.getLinkType() == LinkType.LINK_TYPE_UCS) {
            return String.valueOf(h.W()) + "userContent/" + this.fileReference + "/" + this.version;
        }
        return String.valueOf(h.W()) + "imageresource/" + e.m(this.getUrl());
    }

    public String getHTMLType() {
        String string = ConverterUtil.mimeTypeForFilename((String)this.getUrl());
        if (SystemHelper.isPictureFormat((String)string)) {
            return "image";
        }
        if (SystemHelper.isAudioFormat((String)string)) {
            return "audio";
        }
        if (SystemHelper.isVideoFormat((String)string)) {
            return "video";
        }
        return "unknown";
    }

    public String getAssetExchangeUrl() {
        if (this.getLinkType() != LinkType.LINK_TYPE_ASSET_EXCHANGE) {
            throw new UnsupportedOperationException("getAssetExchangeURL() is not supported for other link types than: LinkType.LINK_TYPE_ASSET_EXCHANGE.");
        }
        return "assetExchange/" + this.fileReference;
    }

    public String getUserContentUrl() {
        if (this.getLinkType() != LinkType.LINK_TYPE_UCS) {
            throw new UnsupportedOperationException("getUcsUrl() is not supported for other link types than: LinkType.LINK_TYPE_UCS.");
        }
        return "userContent/" + this.fileReference + "/" + this.version;
    }

    public void copyInto(ILPLink iLPLink) {
        iLPLink.setCreationDate(this.getCreationDate());
        iLPLink.setFileReference(this.getFileReference());
        iLPLink.setLinkType(this.getLinkType());
        iLPLink.setLocalStoreItemKey(this.getLocalStoreItemKey());
        iLPLink.setMimeType(this.getMimeType());
        iLPLink.setName(this.getName());
        iLPLink.setType(this.getTypeCode());
        iLPLink.setUrl(this.getUrl());
    }

    public static enum LinkType {
        LINK_TYPE_UNDEFINED(0),
        LINK_TYPE_WEBSITE(1),
        LINK_TYPE_IMAGE_WEB(2),
        LINK_TYPE_IMAGE_LOCAL(3),
        LINK_TYPE_ONENOTE(4),
        LINK_TYPE_ASSET_EXCHANGE(5),
        LINK_TYPE_UCS(6);

        private static final Map<Integer, LinkType> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, LinkType>();
            for (LinkType linkType : EnumSet.allOf(LinkType.class)) {
                lookup.put(linkType.getCode(), linkType);
            }
        }

        private LinkType(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static LinkType get(int n2) {
            return lookup.get(n2);
        }

        public static LinkType get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                LinkType linkType = lookup.get(n2);
                if (linkType == null) {
                    linkType = LINK_TYPE_UNDEFINED;
                }
                return linkType;
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined LinkType code: " + string + ", defaulting to " + LINK_TYPE_UNDEFINED.name()));
                return LINK_TYPE_UNDEFINED;
            }
        }
    }
}

