/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.DateHelper;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.ia.d;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPLICENSE")
public class ILPLicense
extends AbstractCoreDataModel {
    private static final long serialVersionUID = 1L;
    private static final int GRACE_TIME_PERIOD_DAYS = 5;
    private static ILogger logger = ILPLogManager.getLogger(ILPLicense.class);
    public static final String LICENSE_CODE_FIELD_NAME = "ZLICENSECODE";
    public static final String LICENSE_STATE_FIELD_NAME = "ZLICENSESTATE";
    public static final String VALID_FROM_FIELD_NAME = "ZVALIDFROM";
    public static final String EXPIRATION_DATE_FIELD_NAME = "ZEXPIRATIONDATE";
    public static final String MAX_DEVICES_FIELD_NAME = "ZMAXDEVICES";
    public static final String USED_DEVICES_FIELD_NAME = "ZUSEDDEVICES";
    public static final String MAX_CONCURRENT_USAGES_FIELD_NAME = "ZMAXCONCURRENTUSAGES";
    public static final String USED_CONCURRENT_USAGES_FIELD_NAME = "ZUSEDCONCURRENTUSAGES";
    public static final String LICENSE_USAGE_FIELD_NAME = "ZLICENSEUSAGE";
    public static final String LICENSE_STRATEGY_FIELD_NAME = "ZLICENSESTRATEGY";
    public static final String LICENSE_POLICY_FIELD_NAME = "ZLICENSEPOLICY";
    public static final String LAST_CONSOLIDATION_DATE_FIELD_NAME = "ZLASTCONSOLIDATIONDATE";
    public static final String LAST_VERIFICATION_DATE_FIELD_NAME = "ZLASTVERIFICATIONDATE";
    public static final String OVERDUE_DATE_FIELD_NAME = "ZOVERDUEDATE";
    public static final String LEASE_DATE_FIELD_NAME = "ZLEASEDATE";
    public static final String USER_FK_FIELD_NAME = "ZUSER";
    public static final String MD5_FIELD_NAME = "ZMD5";
    @DatabaseField(columnName="ZLICENSECODE", index=true, unique=true)
    private String licenseCode;
    @DatabaseField(columnName="ZLICENSESTATE")
    private Integer licenseState;
    @DatabaseField(columnName="ZVALIDFROM")
    private DateTime validFrom;
    @DatabaseField(columnName="ZEXPIRATIONDATE")
    private DateTime expirationDate;
    @DatabaseField(columnName="ZMAXDEVICES")
    private Integer maxDevices;
    @DatabaseField(columnName="ZUSEDDEVICES")
    private Integer usedDevices;
    @DatabaseField(columnName="ZMAXCONCURRENTUSAGES")
    private Integer maxConcurrentUsages;
    @DatabaseField(columnName="ZUSEDCONCURRENTUSAGES")
    private Integer usedConcurrentUsages;
    @DatabaseField(columnName="ZLICENSEUSAGE")
    private Boolean licenseUsage = false;
    @DatabaseField(columnName="ZLICENSESTRATEGY")
    private Integer licenseStrategy;
    @DatabaseField(columnName="ZLICENSEPOLICY")
    private Integer licensePolicy;
    @DatabaseField(columnName="ZLASTCONSOLIDATIONDATE")
    private DateTime lastConsolidationDate;
    @DatabaseField(columnName="ZLASTVERIFICATIONDATE")
    private DateTime lastVerificationDate;
    @DatabaseField(columnName="ZOVERDUEDATE")
    private DateTime overdueDate;
    @DatabaseField(columnName="ZLEASEDATE")
    private DateTime leaseDate;
    @DatabaseField(columnName="ZMD5", canBeNull=true)
    private String md5;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZUSER", index=true, canBeNull=false)
    private ILPUser user;

    public boolean isLicenseAuthorized() {
        if (!this.verifyMd5()) {
            return false;
        }
        LicenseState licenseState = this.getLicenseStateType();
        if (licenseState == LicenseState.LICENSE_STATE_VALID) {
            return true;
        }
        if (licenseState == LicenseState.LICENSE_STATE_OVERDUE) {
            return false;
        }
        if (licenseState == LicenseState.LICENSE_STATE_WITHDRAWN) {
            return false;
        }
        if (licenseState == LicenseState.LICENSE_STATE_EXPIRED) {
            return false;
        }
        if (licenseState == LicenseState.LICENSE_STATE_NOT_YET_AVAILABLE) {
            return false;
        }
        if (licenseState == LicenseState.LICENSE_STATE_EXCEEDED) {
            return false;
        }
        return false;
    }

    public boolean isLicenseUsageGranted() {
        return this.isLicenseAuthorized() && this.hasLicenseUsage();
    }

    public boolean isLicenseUsageGrantedOrGraceTime() {
        return this.isLicenseAuthorized() && this.hasLicenseUsage() || this.isInGraceTime(true);
    }

    public boolean isLicensePolicyGrantedAndUsageGranted() {
        return this.getLicensePolicyEnum() == LicensePolicy.LICENSE_POLICY_GRANTED && this.isLicenseUsageGrantedOrGraceTime();
    }

    public boolean isNotExpired() {
        if (this.expirationDate == null) {
            return true;
        }
        return DateHelper.timeIntervalSinceNow((Date)this.expirationDate.toDate()) > 0.0;
    }

    public boolean isExpired() {
        return !this.isNotExpired();
    }

    public boolean isExpiredFreshly() {
        return this.isExpired() && this.isLicenseAuthorized();
    }

    public boolean isVerificationNeededAnytime() {
        return this.licenseStrategy != null && (this.getLicenseStrategyType() == LicenseStrategy.LICENSE_STRATEGY_USER || this.getLicenseStrategyType() == LicenseStrategy.LICENSE_STRATEGY_SITE);
    }

    public boolean needsDeviceVerification() {
        return this.getLicenseStrategyType() != LicenseStrategy.LICENSE_STRATEGY_SITE && this.getLicenseStrategyType() != LicenseStrategy.LICENSE_STRATEGY_USER;
    }

    public boolean isFloatingLicense() {
        return this.getLicenseStrategyType() != null && this.getLicenseStrategyType() == LicenseStrategy.LICENSE_STRATEGY_FLOATING;
    }

    public boolean isInGraceTime(boolean bl2) {
        if (this.overdueDate == null && LicenseState.LICENSE_STATE_OVERDUE != this.getLicenseStateType()) {
            return false;
        }
        if (this.getLicenseStateType().equals((Object)LicenseState.LICENSE_STATE_OVERDUE) || this.overdueDate != null) {
            Date date;
            if (!this.getLicenseStateType().equals((Object)LicenseState.LICENSE_STATE_OVERDUE)) {
                this.setLicenseState(LicenseState.LICENSE_STATE_OVERDUE);
            }
            Date date2 = date = bl2 ? SystemHelper.currentNetworkTime() : SystemHelper.currentNetworkOrClockTime();
            if (date == null) {
                logger.c((Object)"Did not get networktime, so grace time will be over (temorarily)");
                date = new Date(Long.MAX_VALUE);
            }
            DateTime dateTime = new DateTime((Object)date);
            return this.overdueDate.plusDays(5).isAfter(dateTime.getMillis());
        }
        logger.c((Object)("Cannot check if grace time is active on license: " + this));
        return false;
    }

    public void putInGraceTime() {
        if (this.overdueDate != null) {
            logger.c((Object)("License has already in overdueDate set, ignoring: " + this.overdueDate));
            return;
        }
        this.setOverdueDate(new DateTime());
        this.setLicenseState(LicenseState.LICENSE_STATE_OVERDUE);
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String string) {
        this.licenseCode = string;
    }

    public DateTime getLastConsolidationDate() {
        return this.lastConsolidationDate;
    }

    public void setLastConsolidationDate(DateTime dateTime) {
        this.lastConsolidationDate = dateTime;
    }

    public Integer getMaxDevices() {
        return this.maxDevices;
    }

    public void setMaxDevices(Integer n2) {
        this.maxDevices = n2;
    }

    public ILPUser getUser() {
        g.a().c(this.user);
        return this.user;
    }

    public void setUser(ILPUser iLPUser) {
        this.user = iLPUser;
        this.updateMd5();
    }

    public ILPEProduct getEProduct() {
        return f.a().a(this);
    }

    public Integer getUsedDevices() {
        return this.usedDevices;
    }

    public Integer getLicenseState() {
        return this.licenseState;
    }

    public void setLicenseState(Integer n2) {
        this.licenseState = n2;
    }

    public LicenseState getLicenseStateType() {
        return LicenseState.get(this.getLicenseState());
    }

    public void setLicenseState(LicenseState licenseState) {
        this.licenseState = licenseState.type;
        this.updateMd5();
    }

    public void setUsedDevices(Integer n2) {
        this.usedDevices = n2;
    }

    public Integer getLicenseStrategy() {
        return this.licenseStrategy;
    }

    public void setLicenseStrategy(Integer n2) {
        this.licenseStrategy = n2;
        this.updateMd5();
    }

    public LicenseStrategy getLicenseStrategyType() {
        return LicenseStrategy.get(this.getLicenseStrategy());
    }

    public DateTime getLastVerificationDate() {
        return this.lastVerificationDate;
    }

    public void setLastVerificationDate(DateTime dateTime) {
        this.lastVerificationDate = dateTime;
    }

    public Boolean getLicenseUsage() {
        return this.licenseUsage;
    }

    public boolean hasLicenseUsage() {
        return this.licenseUsage != null ? this.licenseUsage : false;
    }

    public void setLicenseUsage(Boolean bl2) {
        this.licenseUsage = bl2;
        this.updateMd5();
    }

    public LicensePolicy getLicensePolicyEnum() {
        return LicensePolicy.get(this.licensePolicy);
    }

    public Integer getLicensePolicy() {
        return this.licensePolicy;
    }

    public void setLicensePolicy(Integer n2) {
        this.licensePolicy = n2;
        this.updateMd5();
    }

    public DateTime getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(DateTime dateTime) {
        this.validFrom = dateTime;
    }

    public DateTime getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(DateTime dateTime) {
        this.expirationDate = dateTime;
        this.updateMd5();
    }

    public Integer getMaxConcurrentUsages() {
        return this.maxConcurrentUsages;
    }

    public void setMaxConcurrentUsages(Integer n2) {
        this.maxConcurrentUsages = n2;
    }

    public Integer getUsedConcurrentUsages() {
        return this.usedConcurrentUsages;
    }

    public void setUsedConcurrentUsages(Integer n2) {
        this.usedConcurrentUsages = n2;
    }

    public DateTime getOverdueDate() {
        return this.overdueDate;
    }

    public void setOverdueDate(DateTime dateTime) {
        this.overdueDate = dateTime;
        this.updateMd5();
    }

    public DateTime getLeaseDate() {
        return this.leaseDate;
    }

    public void setLeaseDate(DateTime dateTime) {
        this.leaseDate = dateTime;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String string) {
        this.md5 = string;
    }

    protected String buildMd5() {
        StringBuffer stringBuffer = new StringBuffer("_:s\u00f6SN\u2211");
        stringBuffer.append(this.licenseCode);
        stringBuffer.append(String.format(Locale.ENGLISH, "nc;%d", this.licensePolicy));
        stringBuffer.append(String.format(Locale.ENGLISH, "\u00e9%dWS", this.licenseState));
        stringBuffer.append(String.format(Locale.ENGLISH, "-da%dW", this.licenseStrategy));
        stringBuffer.append(String.format(Locale.ENGLISH, "%s", this.licenseUsage));
        stringBuffer.append(String.format(Locale.ENGLISH, "S1%s", this.expirationDate));
        stringBuffer.append(String.format(Locale.ENGLISH, "?a%s", this.overdueDate));
        stringBuffer.append(String.format(Locale.ENGLISH, "?a%s", this.getUser() != null ? this.getUser().getSubject() : ""));
        stringBuffer.append("=ow\u00f6S!\u00acs0l");
        return StringHelper.md5hash((String)stringBuffer.toString());
    }

    public void updateMd5() {
        this.md5 = this.buildMd5();
    }

    public boolean verifyMd5() {
        if (this.md5 == null) {
            return false;
        }
        String string = this.buildMd5();
        boolean bl2 = this.md5.equals(string);
        if (!bl2) {
            logger.c((Object)String.format("Internal verification failed on license: %s", String.valueOf(this.getLicenseCode()) + " of eProduct: " + this.getEProduct()));
        }
        return bl2;
    }

    public String getLocalizedLicensingStrategy() {
        return this.getLicenseStrategyType().localizedName();
    }

    public String getLocalizedLicenseState() {
        return this.getLicenseStateType().localizedName();
    }

    @Override
    public String toString() {
        return "ILPLicense [licenseState=" + this.licenseState + ", expirationDate=" + this.expirationDate + ", maxDevices=" + this.maxDevices + ", usedDevices=" + this.usedDevices + ", licenseStrategy=" + this.licenseStrategy + ", overdueDate=" + this.overdueDate + "]";
    }

    public static enum LicensePolicy {
        LICENSE_POLICY_UNDEFINED(0),
        LICENSE_POLICY_UNRESTRICTED(1),
        LICENSE_POLICY_RESTRICTED(2),
        LICENSE_POLICY_GRANTED(3);

        private static final Map<Integer, LicensePolicy> codeLookup;
        private static final Map<String, LicensePolicy> stringLookup;
        private final int code;

        static {
            codeLookup = new HashMap<Integer, LicensePolicy>();
            stringLookup = new HashMap<String, LicensePolicy>();
            for (LicensePolicy licensePolicy : EnumSet.allOf(LicensePolicy.class)) {
                codeLookup.put(licensePolicy.getCode(), licensePolicy);
                stringLookup.put(licensePolicy.toString(), licensePolicy);
            }
        }

        private LicensePolicy(int n3) {
            this.code = n3;
        }

        public static LicensePolicy get(int n2) {
            LicensePolicy licensePolicy = codeLookup.get(n2);
            if (licensePolicy != null) {
                return licensePolicy;
            }
            return LICENSE_POLICY_UNDEFINED;
        }

        public static LicensePolicy getByStringCode(String string) {
            try {
                if (StringUtils.isBlank((CharSequence)string)) {
                    return LICENSE_POLICY_UNDEFINED;
                }
                int n2 = Integer.parseInt(string);
                return codeLookup.get(n2);
            }
            catch (Exception exception) {
                return LICENSE_POLICY_UNDEFINED;
            }
        }

        public static LicensePolicy getByName(String string) {
            return stringLookup.get(string);
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum LicenseState {
        LICENSE_STATE_UNDEFINED(0, "undefined"),
        LICENSE_STATE_VALID(1, "valid"),
        LICENSE_STATE_EXPIRED(2, "expired"),
        LICENSE_STATE_WITHDRAWN(3, "withdrawn"),
        LICENSE_STATE_EXCEEDED(4, "exceeded"),
        LICENSE_STATE_NOT_YET_AVAILABLE(5, "notyetavailable"),
        LICENSE_STATE_OVERDUE(6, "overdue"),
        LICENSE_STATE_DEVICE_FAILURE(10, "devicefailure");

        private static final Map<String, LicenseState> lookupCode;
        private static final Map<Integer, LicenseState> lookupType;
        private static final Map<String, LicenseState> lookupEnumString;
        private int type;
        private String code;

        static {
            lookupCode = new HashMap<String, LicenseState>();
            lookupType = new HashMap<Integer, LicenseState>();
            lookupEnumString = new HashMap<String, LicenseState>();
            for (LicenseState licenseState : EnumSet.allOf(LicenseState.class)) {
                lookupCode.put(licenseState.getCode(), licenseState);
                lookupType.put(licenseState.getType(), licenseState);
                lookupEnumString.put(licenseState.toString(), licenseState);
            }
        }

        private LicenseState(int n3, String string2) {
            this.type = n3;
            this.code = string2;
        }

        public String getCode() {
            return this.code;
        }

        public int getType() {
            return this.type;
        }

        public static LicenseState getByName(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return LICENSE_STATE_UNDEFINED;
            }
            LicenseState licenseState = lookupEnumString.get(string);
            if (licenseState == null) {
                licenseState = LICENSE_STATE_UNDEFINED;
            }
            return licenseState;
        }

        public static LicenseState get(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return LICENSE_STATE_UNDEFINED;
            }
            LicenseState licenseState = lookupCode.get(string);
            if (licenseState == null) {
                licenseState = LICENSE_STATE_UNDEFINED;
            }
            return licenseState;
        }

        public static LicenseState get(Integer n2) {
            LicenseState licenseState = lookupType.get(n2);
            if (licenseState == null) {
                licenseState = LICENSE_STATE_UNDEFINED;
            }
            return licenseState;
        }

        public String localizedName() {
            return o.a().d(this.name());
        }
    }

    public static enum LicenseStrategy {
        LICENSE_STRATEGY_UNDEFINED(0, "undefined"),
        LICENSE_STRATEGY_DEVICE(1, "device"),
        LICENSE_STRATEGY_FLOATING(2, "floating"),
        LICENSE_STRATEGY_SITE(3, "site"),
        LICENSE_STRATEGY_USER(4, "user"),
        LICENSE_STRATEGY_CONCURRENT(5, "concurrent");

        private static final Map<Integer, LicenseStrategy> codeLookup;
        private static final Map<String, LicenseStrategy> stringLookup;
        private final int code;
        private final String shortName;

        static {
            codeLookup = new HashMap<Integer, LicenseStrategy>();
            stringLookup = new HashMap<String, LicenseStrategy>();
            for (LicenseStrategy licenseStrategy : EnumSet.allOf(LicenseStrategy.class)) {
                codeLookup.put(licenseStrategy.getCode(), licenseStrategy);
                stringLookup.put(licenseStrategy.toString(), licenseStrategy);
            }
        }

        private LicenseStrategy(int n3, String string2) {
            this.code = n3;
            this.shortName = string2;
        }

        public static LicenseStrategy get(int n2) {
            return codeLookup.get(n2);
        }

        public static LicenseStrategy getByStringCode(String string) {
            try {
                int n2 = Integer.parseInt(string);
                LicenseStrategy licenseStrategy = codeLookup.get(n2);
                return licenseStrategy != null ? licenseStrategy : LICENSE_STRATEGY_UNDEFINED;
            }
            catch (Exception exception) {
                d.a.d((Object)("LicenseStrategy not found: " + string + " return default. LICENSE_STRATEGY_UNDEFINED"), (Throwable)exception);
                return LICENSE_STRATEGY_UNDEFINED;
            }
        }

        public static LicenseStrategy getByName(String string) {
            try {
                LicenseStrategy licenseStrategy = stringLookup.get(string);
                return licenseStrategy != null ? licenseStrategy : LICENSE_STRATEGY_UNDEFINED;
            }
            catch (Exception exception) {
                d.a.d((Object)("LicenseStrategy not found: " + string + " return default. LICENSE_STRATEGY_UNDEFINED"), (Throwable)exception);
                return LICENSE_STRATEGY_UNDEFINED;
            }
        }

        public int getCode() {
            return this.code;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String localizedName() {
            String string = o.a().d("licensingStrategy." + this.shortName);
            return string;
        }
    }
}

