/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPInitializer;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueProduct;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@DatabaseTable(tableName="ZILPISSUEDEF")
public class ILPIssueDef
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPIssueDef.class);
    public static final String TABLE_NAME = "ZILPISSUEDEF";
    public static final String ISSUEID_FIELD_NAME = "ZISSUEID";
    public static final String ISSUE_REFERENCE_FIELD_NAME = "ZREFERENCE";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String TAG_FIELD_NAME = "ZTAG";
    public static final String ORDER_FIELD_NAME = "ZORDER";
    public static final String AVAILABLEFORDOWNLOAD_FIELD_NAME = "ZAVAILABLEFORDOWNLOAD";
    public static final String LASTSYNC_FIELD_NAME = "ZLASTSYNC";
    public static final String LASTUPDATE_FIELD_NAME = "ZLASTUPDATE";
    public static final String TOUCHDATE_FIELD_NAME = "ZTOUCHDATE";
    public static final String DEFERRED_SYNC_FIELD_NAME = "ZDEFERREDSYNC";
    public static final String DEFAULTISSUE_FIELD_NAME = "ZDEFAULTISSUE";
    public static final String ABSTRACT_FK_FIELD_NAME = "ZABSTRACT";
    public static final String COURSE_FK_FIELD_NAME = "ZCOURSE";
    public static final String AUTHOR_FIELD_NAME = "ZAUTHORS";
    public static final String ISSUE_PRODUCT_FK_FIELD_NAME = "ZISSUEPRODUCT";
    @DatabaseField(columnName="ZISSUEID", canBeNull=false, index=true)
    private String issueId;
    @DatabaseField(columnName="ZTITLE", canBeNull=true, index=true)
    private String title;
    @DatabaseField(columnName="ZTAG", canBeNull=true, index=true)
    private String tag;
    @DatabaseField(columnName="ZREFERENCE", canBeNull=true, index=true)
    private String reference;
    @DatabaseField(columnName="ZORDER", canBeNull=true, index=true)
    private Integer order;
    @DatabaseField(columnName="ZAVAILABLEFORDOWNLOAD", canBeNull=true)
    private Boolean availableForDownload;
    @DatabaseField(columnName="ZLASTUPDATE", canBeNull=true)
    @Deprecated
    private DateTime lastUpdate;
    @DatabaseField(columnName="ZTOUCHDATE", canBeNull=true, index=true)
    private DateTime touchDate;
    @DatabaseField(columnName="ZLASTSYNC", canBeNull=true)
    private DateTime lastSync;
    @DatabaseField(columnName="ZDEFERREDSYNC", canBeNull=true, index=true)
    private Boolean deferredSync;
    @DatabaseField(columnName="ZDEFAULTISSUE", canBeNull=true, index=true)
    private Boolean defaultIssue;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZCOURSE", index=true)
    private ILPCourseDef course;
    @ForeignCollectionField
    private ForeignCollection<ILPResource> resources;
    @ForeignCollectionField(orderColumnName="ZORDER")
    private ForeignCollection<ILPExercise> exercises;
    @ForeignCollectionField(orderColumnName="ZORDER")
    private ForeignCollection<ILPTopic> topics;
    private Properties bookProperties;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZISSUEPRODUCT", index=true, canBeNull=true)
    private ILPIssueProduct issueProduct;

    public ILPIssueDef() {
    }

    public ILPIssueDef(String string) {
        this.issueId = string;
    }

    public ILPIssueDef(String string, String string2) {
        this.issueId = string;
        this.reference = string2;
    }

    public ILPEProduct getEProduct() {
        if (this.getIssueProduct() != null) {
            return this.getIssueProduct().getEProduct();
        }
        return null;
    }

    public int getIssueNumber() {
        try {
            String string = this.getCourse().getCourseId();
            String string2 = StringHelper.extractString_after((String)this.getIssueId(), (String)string);
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not extract issueNumber from: " + this.getIssueId()));
            return 0;
        }
    }

    public String issuePostifx() {
        String string = this.getIssueId();
        String string2 = this.getCourse().getCourseId();
        try {
            String string3 = StringHelper.extractString_after((String)string, (String)string2);
            return string3;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not extract issuePostfix from: " + this.getIssueId()));
            return string;
        }
    }

    public ILPIssueProduct getIssueProduct() {
        g.a().a(this.issueProduct);
        return this.issueProduct;
    }

    public void setIssueProduct(ILPIssueProduct iLPIssueProduct) {
        this.issueProduct = iLPIssueProduct;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public void setIssueId(String string) {
        this.issueId = string;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public String getIssueId_reference() {
        return String.valueOf(this.issueId) + "_" + this.reference;
    }

    public String getTitle() {
        return this.title != null ? this.title : (this.getIssueProduct() != null ? this.getIssueProduct().getTitle() : null);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer n2) {
        this.order = n2;
    }

    public String getIsbn() {
        return this.getIssueProduct().getIsbn();
    }

    public String getIsbnOrReference() {
        return this.getIssueProduct().getIsbnOrReference();
    }

    public Boolean isAvailableForDownload() {
        if (this.availableForDownload != null && this.availableForDownload.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setAvailableForDownload(Boolean bl2) {
        this.availableForDownload = bl2;
    }

    @Deprecated
    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @Deprecated
    public void setLastUpdate(DateTime dateTime) {
        this.lastUpdate = dateTime;
    }

    @Deprecated
    public void setLastUpdate(Date date) {
        this.lastUpdate = date != null ? new DateTime((Object)date) : null;
    }

    public DateTime getTouchDate() {
        return this.touchDate;
    }

    public void setTouchDate(DateTime dateTime) {
        this.touchDate = dateTime;
    }

    public void setTouchDate(Date date) {
        this.touchDate = date != null ? new DateTime((Object)date) : null;
    }

    public boolean isTouchedAfter(Date date) {
        if (this.touchDate == null) {
            return false;
        }
        return this.touchDate.isAfter((ReadableInstant)new DateTime((Object)date));
    }

    public DateTime getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(DateTime dateTime) {
        this.lastSync = dateTime;
    }

    public void setLastSync(Date date) {
        this.lastSync = date != null ? new DateTime((Object)date) : null;
    }

    public boolean isSynchAvailable() {
        return this.lastSync == null;
    }

    public Boolean getDeferredSync() {
        return this.deferredSync;
    }

    public boolean isDeferredSync() {
        return this.deferredSync != null ? this.deferredSync : false;
    }

    public void setDeferredSync(Boolean bl2) {
        this.deferredSync = bl2;
    }

    public ILPCourseDef getCourse() {
        g.a().c(this.course);
        return this.course;
    }

    public void setCourse(ILPCourseDef iLPCourseDef) {
        this.course = iLPCourseDef;
    }

    public ForeignCollection<ILPResource> getResources() {
        if (this.resources == null) {
            try {
                g.a().F().assignEmptyForeignCollection((Object)this, "resources");
                this.resources.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for issue.resources", (Throwable)sQLException);
                f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.resources;
    }

    public void setResources(ForeignCollection<ILPResource> foreignCollection) {
        this.resources = foreignCollection;
    }

    public ForeignCollection<ILPTopic> getTopics() {
        if (this.topics == null) {
            try {
                g.a().F().assignEmptyForeignCollection((Object)this, "topics");
                this.topics.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for issue.topics", (Throwable)sQLException);
                f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.topics;
    }

    public void setTopics(ForeignCollection<ILPTopic> foreignCollection) {
        this.topics = foreignCollection;
    }

    public ForeignCollection<ILPExercise> getExercises() {
        if (this.exercises == null && g.a().F() != null) {
            try {
                g.a().F().assignEmptyForeignCollection((Object)this, "exercises");
                this.exercises.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for issue.exercises", (Throwable)sQLException);
                f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.exercises;
    }

    public void setExercises(ForeignCollection<ILPExercise> foreignCollection) {
        this.exercises = foreignCollection;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public ILPTopic getFirstTopic() {
        CloseableIterator closeableIterator = this.getTopics().closeableIterator();
        try {
            if (closeableIterator.hasNext()) {
                ILPTopic iLPTopic = (ILPTopic)closeableIterator.next();
                return iLPTopic;
            }
        }
        finally {
            try {
                if (closeableIterator != null) {
                    closeableIterator.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public ILPExercise getFirstExercise() {
        CloseableIterator closeableIterator = this.getExercises().closeableIterator();
        try {
            if (closeableIterator.hasNext()) {
                ILPExercise iLPExercise = (ILPExercise)closeableIterator.next();
                return iLPExercise;
            }
        }
        finally {
            try {
                if (closeableIterator != null) {
                    closeableIterator.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public Boolean isDefaultIssue() {
        return this.defaultIssue;
    }

    public void setDefaultIssue(Boolean bl2) {
        this.defaultIssue = bl2;
    }

    public boolean isForceLoad() {
        String string = this.getCourse().getEProduct().propertyStringWithName_defaultValue("forceLoadIssueId", null);
        if (string != null) {
            return this.issueId.equals(string);
        }
        return false;
    }

    public String getAuthors() {
        return this.getIssueProduct().getAuthors();
    }

    public String getAuthorsAsHtml() {
        String string = this.getAuthors() != null ? this.getAuthors() : "";
        string = StringHelper.trim((String)string.replace("\n", "<br/>"));
        while (string.trim().startsWith("<br/>")) {
            string = StringHelper.extractStringFrom_after((String)string, (String)"<br/>");
        }
        return string;
    }

    public boolean propertyBooleanWithName_defaultValue(String string, boolean bl2) {
        return this.getEProduct().propertyBooleanWithName_defaultValue(string, this.getCourse().getEProduct().propertyBooleanWithName_defaultValue(string, bl2));
    }

    public float propertyFloatWithName_defaultValue(String string, float f2) {
        return this.getEProduct().propertyFloatWithName_defaultValue(string, this.getCourse().getEProduct().propertyFloatWithName_defaultValue(string, f2));
    }

    public int propertyIntWithName_defaultValue(String string, int n2) {
        return this.getEProduct().propertyIntWithName_defaultValue(string, this.getCourse().getEProduct().propertyIntWithName_defaultValue(string, n2));
    }

    public String propertyStringWithName_defaultValue(String string, String string2) {
        return this.getEProduct().propertyStringWithName_defaultValue(string, this.getCourse().getEProduct().propertyStringWithName_defaultValue(string, string2));
    }

    public Object bookPropertyForKey_defaultValue(String string, Object object) {
        if (this.bookProperties == null) {
            return object;
        }
        Object object2 = this.bookProperties.get(string);
        return object2 != null ? object2 : object;
    }

    public boolean bookPropertyBooleanForKey_defaultValue(String string, boolean bl2) {
        Object object = this.bookPropertyForKey_defaultValue(string, null);
        if (object != null && object instanceof String && StringUtils.isNotBlank((CharSequence)((String)object))) {
            return Boolean.parseBoolean((String)object);
        }
        return bl2;
    }

    public float bookPropertyFloatForKey_defaultValue(String string, float f2) {
        Object object = this.bookPropertyForKey_defaultValue(string, null);
        if (object != null && object instanceof String && StringUtils.isNotBlank((CharSequence)((String)object))) {
            return Float.parseFloat((String)object);
        }
        return f2;
    }

    public int bookPropertyIntForKey_defaultValue(String string, int n2) {
        Object object = this.bookPropertyForKey_defaultValue(string, null);
        if (object != null && object instanceof String && StringUtils.isNotBlank((CharSequence)((String)object))) {
            return Integer.parseInt((String)object);
        }
        return n2;
    }

    public String bookPropertyStringForKey_defaultValue(String string, String string2) {
        Object object = this.bookPropertyForKey_defaultValue(string, null);
        if (object != null && object instanceof String) {
            return (String)object;
        }
        return string2;
    }

    public String getEdition() {
        return this.propertyStringWithName_defaultValue("edition", null);
    }

    public boolean isIssueBasedLicensed() {
        return !this.getCourse().isCourseBased();
    }

    public boolean isExcerpt() {
        return this.getIssueProduct().isExcerpt();
    }

    public String getProductReference() {
        return this.getIssueProduct().getProductReference();
    }

    public boolean shouldRandomizeExercises(ILPExercise.ExerciseGroup exerciseGroup) {
        String string = ILPExercise.sortFieldForIssue_exerciseGroup(this, exerciseGroup);
        return "randomId".equals(string);
    }

    public boolean isUpdateAvailable() {
        return this.getIssueProduct().isUpdateAvailable();
    }

    public Properties getBookProperties() {
        return this.bookProperties;
    }

    public void setBookProperties(Properties properties) {
        this.bookProperties = properties;
    }

    public void reloadBookProperties() {
        try {
            this.setBookProperties(null);
            ILPInitializer.instance().configureBookPropertiesForResourceNamed_issue(ILPInitializer.ILPBOOKADDITIONS_PROPERTIES, this);
            ILPInitializer.instance().configureBookPropertiesForResourceNamed_issue(ILPInitializer.ILPEXERCISEADDITIONS_PROPERTIES, this);
        }
        catch (j j2) {
            logger.d((Object)("Could not reload book properties for issue: " + this), (Throwable)j2);
        }
    }

    public int detectAuthorId() {
        try {
            int n2 = 0;
            ILPTopic iLPTopic = this.getFirstTopic();
            if (iLPTopic != null && iLPTopic.getTopicDefinition() != null && iLPTopic.getTopicDefinition().getAuthorId() != null) {
                n2 = iLPTopic.getTopicDefinition().getAuthorId();
            }
            ILPExercise iLPExercise = this.getFirstExercise();
            if (n2 == 0 && iLPExercise != null && iLPExercise.getExerciseDefinition() != null && iLPExercise.getExerciseDefinition().getAuthorId() != null) {
                n2 = iLPExercise.getExerciseDefinition().getAuthorId();
            }
            if (n2 == 0) {
                n2 = 1;
            }
            return n2;
        }
        catch (Exception exception) {
            logger.c((Object)"Could not detect authorId on issue, taking default 1", (Throwable)exception);
            return 1;
        }
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.course == null ? 0 : this.course.hashCode());
        n3 = 31 * n3 + (this.issueId == null ? 0 : this.issueId.hashCode());
        n3 = 31 * n3 + (this.reference == null ? 0 : this.reference.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPIssueDef iLPIssueDef = (ILPIssueDef)object;
        if (this.course == null ? iLPIssueDef.course != null : !this.course.equals(iLPIssueDef.course)) {
            return false;
        }
        if (this.issueId == null ? iLPIssueDef.issueId != null : !this.issueId.equals(iLPIssueDef.issueId)) {
            return false;
        }
        return !(this.reference == null ? iLPIssueDef.reference != null : !this.reference.equals(iLPIssueDef.reference));
    }

    @Override
    public String toString() {
        return "ILPIssueDef [issueId=" + this.issueId + ", reference=" + this.reference + ", pk=" + this.pk + "]";
    }
}

