/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.mo.ILPGroup;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@DatabaseTable(tableName="Z_GROUP_USER")
public class ILPGroup_User {
    private static ILogger logger = ILPLogManager.getLogger(ILPGroup_User.class);
    public static final String TABLE_NAME = "Z_GROUP_USER";
    public static final String GROUP_FK_FIELD_NAME = "Z_GROUPS";
    public static final String USER_FK_FIELD_NAME = "Z_USERS";
    public static final String PK_FIELD_NAME = "Z_PK";
    public static final String STATUS_FIELD_NAME = "ZSTATUS";
    public static final String ROLE_FIELD_NAME = "ZROLE";
    @DatabaseField(generatedId=true, columnName="Z_PK", index=true)
    private Integer pk;
    @DatabaseField(foreign=true, columnName="Z_GROUPS", index=true)
    private ILPGroup group;
    @DatabaseField(foreign=true, columnName="Z_USERS", index=true)
    private ILPUser user;
    @DatabaseField(columnName="ZSTATUS", canBeNull=true, index=true)
    private Integer status;
    @DatabaseField(columnName="ZROLE", canBeNull=true, index=true)
    private Integer role;

    public ILPGroup_User() {
    }

    public ILPGroup_User(ILPGroup iLPGroup, ILPUser iLPUser) {
        this.group = iLPGroup;
        this.user = iLPUser;
    }

    public ILPGroup getILPGroup() {
        g.a().e(this.group);
        return this.group;
    }

    public ILPUser getUser() {
        g.a().c(this.user);
        return this.user;
    }

    public MembershipStatus getStatus() {
        return MembershipStatus.get(this.status);
    }

    public MembershipRole getRole() {
        return MembershipRole.get(this.role);
    }

    public void setGroup(ILPGroup iLPGroup) {
        this.group = iLPGroup;
    }

    public void setUser(ILPUser iLPUser) {
        this.user = iLPUser;
    }

    public void setStatus(MembershipStatus membershipStatus) {
        this.status = membershipStatus.getCode();
    }

    public void setRole(MembershipRole membershipRole) {
        this.role = membershipRole.getCode();
    }

    public static MembershipStatus statusForOldGroupMemberState(ILPGroup.GroupMemberState groupMemberState, boolean bl2) {
        MembershipStatus membershipStatus;
        switch (groupMemberState) {
            case GROUP_MEMBER_STATE_JOINED: {
                membershipStatus = MembershipStatus.MEMBERSHIP_STATUS_JOINED;
                break;
            }
            case GROUP_MEMBER_STATE_LEFT: {
                membershipStatus = MembershipStatus.MEMBERSHIP_STATUS_LEFT;
                break;
            }
            case GROUP_MEMBER_STATE_PENDING: {
                membershipStatus = MembershipStatus.MEMBERSHIP_STATUS_REQUESTED;
                break;
            }
            case GROUP_MEMBER_STATE_REJECTED: {
                membershipStatus = MembershipStatus.MEMBERSHIP_STATUS_REJECTED;
                break;
            }
            case GROUP_MEMBER_STATE_REMOVED: {
                if (bl2) {
                    membershipStatus = MembershipStatus.MEMBERSHIP_STATUS_LEFT;
                    break;
                }
                membershipStatus = MembershipStatus.MEMBERSHIP_STATUS_REMOVED;
                break;
            }
            default: {
                membershipStatus = MembershipStatus.MEMBERSHIP_STATUS_UNDEFINED;
            }
        }
        return membershipStatus;
    }

    public static enum MembershipRole {
        MEMBERSHIP_ROLE_UNDEFINED(0),
        MEMBERSHIP_ROLE_OWNER(1),
        MEMBERSHIP_ROLE_ADMINISTRATOR(2),
        MEMBERSHIP_ROLE_MEMBER(3);

        private static final Map<Integer, MembershipRole> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, MembershipRole>();
            for (MembershipRole membershipRole : EnumSet.allOf(MembershipRole.class)) {
                lookup.put(membershipRole.getCode(), membershipRole);
            }
        }

        private MembershipRole(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static MembershipRole get(Integer n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                return MEMBERSHIP_ROLE_UNDEFINED;
            }
        }

        public static MembershipRole get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                MembershipRole membershipRole = lookup.get(n2);
                if (membershipRole == null) {
                    membershipRole = MEMBERSHIP_ROLE_UNDEFINED;
                }
                return membershipRole;
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined MembershipRole code: " + string + ", defaulting to " + MEMBERSHIP_ROLE_UNDEFINED.name()));
                return MEMBERSHIP_ROLE_UNDEFINED;
            }
        }
    }

    public static enum MembershipStatus {
        MEMBERSHIP_STATUS_UNDEFINED(0),
        MEMBERSHIP_STATUS_JOINED(1),
        MEMBERSHIP_STATUS_REQUESTED(2),
        MEMBERSHIP_STATUS_INVITED(3),
        MEMBERSHIP_STATUS_LEFT(4),
        MEMBERSHIP_STATUS_REMOVED(5),
        MEMBERSHIP_STATUS_REJECTED(6);

        private static final Map<Integer, MembershipStatus> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, MembershipStatus>();
            for (MembershipStatus membershipStatus : EnumSet.allOf(MembershipStatus.class)) {
                lookup.put(membershipStatus.getCode(), membershipStatus);
            }
        }

        private MembershipStatus(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static MembershipStatus get(Integer n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                return MEMBERSHIP_STATUS_UNDEFINED;
            }
        }

        public static MembershipStatus get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                MembershipStatus membershipStatus = lookup.get(n2);
                if (membershipStatus == null) {
                    membershipStatus = MEMBERSHIP_STATUS_UNDEFINED;
                }
                return membershipStatus;
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined MembershipStatus code: " + string + ", defaulting to " + MEMBERSHIP_STATUS_UNDEFINED.name()));
                return MEMBERSHIP_STATUS_UNDEFINED;
            }
        }
    }
}

