/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.DESEncrypter;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPCourseDef_Group;
import ch.ionesoft.ilp.book.mo.ILPGroup_User;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask_Group;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPGROUP")
public class ILPGroup
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPGroup.class);
    public static final String TABLE_NAME = "ZILPGROUP";
    public static final String CREATION_DATE_NAME = "ZCREATIONDATE";
    public static final String GROUP_ID_NAME = "ZGROUPID";
    public static final String INVITE_CODE_NAME = "ZINVITECODE";
    @Deprecated
    public static final String IS_ACTIVE_NAME = "ZISACTIVE";
    @Deprecated
    public static final String IS_OPEN_NAME = "ZIOPEN";
    public static final String GROUP_MEMBER_STATE_NAME = "ZGROUPMEMBERSTATE";
    public static final String GROUP_ADMIN_STATE_NAME = "ZGROUPADMINSTATE";
    public static final String LASTUPDATE_NAME = "ZLASTUPDATE";
    public static final String PUBLIC_KEY_NAME = "ZPUBLICKEY";
    public static final String ENCRYPTION_KEY_NAME = "ZENCRYPTIONKEY";
    public static final String NAME_NAME = "ZNAME";
    public static final String GROUP_TYPE_NAME = "ZGROUPTYPE";
    public static final String ADMIN_FK_FIELD_NAME = "ZADMIN";
    @DatabaseField(columnName="ZCREATIONDATE", canBeNull=false)
    private DateTime creationDate = new DateTime();
    @DatabaseField(columnName="ZGROUPID", canBeNull=true, index=true)
    private String groupID = UUID.randomUUID().toString().toUpperCase();
    @DatabaseField(columnName="ZINVITECODE", canBeNull=true)
    private String inviteCode;
    @DatabaseField(columnName="ZGROUPADMINSTATE", canBeNull=true, index=true)
    private Integer groupAdminStateType;
    @DatabaseField(columnName="ZGROUPMEMBERSTATE", canBeNull=true, index=true)
    private Integer groupMemberStateType;
    @DatabaseField(columnName="ZGROUPTYPE")
    private Integer groupType;
    @DatabaseField(columnName="ZPUBLICKEY", canBeNull=true)
    private String publicKey;
    @DatabaseField(columnName="ZENCRYPTIONKEY", canBeNull=true)
    private String groupEncryptionKey;
    @DatabaseField(columnName="ZLASTUPDATE", canBeNull=true)
    private DateTime lastUpdate;
    @DatabaseField(columnName="ZNAME", canBeNull=false, index=true)
    private String name;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZADMIN", index=true)
    private ILPUser admin;

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime dateTime) {
        this.creationDate = dateTime;
    }

    public String getGroupID() {
        return ILPBookSettingsHelper.instance().decryptGroupID_forGroup(this.groupID, this);
    }

    public void setGroupID(String string) {
        String string2;
        this.groupID = string2 = ILPBookSettingsHelper.instance().encryptGroupID_forGroup(string, this);
    }

    public String getGroupIDTruncated() {
        return StringHelper.truncateCIIDsFromString((String)this.getGroupID());
    }

    public String getInviteCode() {
        return this.inviteCode;
    }

    public void setInviteCode(String string) {
        this.inviteCode = string;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(DateTime dateTime) {
        this.lastUpdate = dateTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public GroupAdminState getGroupAdminState() {
        return GroupAdminState.get(this.groupAdminStateType);
    }

    public Integer getGroupAdminStateType() {
        return this.groupAdminStateType;
    }

    public void setGroupAdminState(GroupAdminState groupAdminState) {
        this.groupAdminStateType = groupAdminState.getCode();
    }

    public GroupMemberState getGroupMemberState() {
        if (this.groupMemberStateType != null) {
            return GroupMemberState.get(this.groupMemberStateType);
        }
        return GroupMemberState.GROUP_MEMBER_STATE_UNKNOWN;
    }

    public GroupMemberState getGroupMemberStateOfUser(ILPUser iLPUser) {
        f f2 = f.a();
        ILPGroup_User iLPGroup_User = f2.a(this, iLPUser);
        if (iLPGroup_User == null || iLPGroup_User.getStatus() == null) {
            return GroupMemberState.GROUP_MEMBER_STATE_UNKNOWN;
        }
        GroupMemberState groupMemberState = GroupMemberState.GROUP_MEMBER_STATE_UNKNOWN;
        switch (iLPGroup_User.getStatus()) {
            case MEMBERSHIP_STATUS_INVITED: {
                groupMemberState = GroupMemberState.GROUP_MEMBER_STATE_PENDING;
                break;
            }
            case MEMBERSHIP_STATUS_JOINED: {
                groupMemberState = GroupMemberState.GROUP_MEMBER_STATE_JOINED;
                break;
            }
            case MEMBERSHIP_STATUS_LEFT: {
                groupMemberState = GroupMemberState.GROUP_MEMBER_STATE_LEFT;
                break;
            }
            case MEMBERSHIP_STATUS_REMOVED: {
                groupMemberState = GroupMemberState.GROUP_MEMBER_STATE_REMOVED;
                break;
            }
            case MEMBERSHIP_STATUS_REQUESTED: {
                groupMemberState = GroupMemberState.GROUP_MEMBER_STATE_PENDING;
                break;
            }
            case MEMBERSHIP_STATUS_REJECTED: {
                groupMemberState = GroupMemberState.GROUP_MEMBER_STATE_REJECTED;
            }
        }
        return groupMemberState;
    }

    public Integer getGroupMemberStateType() {
        return this.groupMemberStateType;
    }

    public void setGroupMemberState(GroupMemberState groupMemberState) {
        this.groupMemberStateType = groupMemberState.getCode();
    }

    public GroupType getGroupType() {
        return GroupType.get(this.groupType);
    }

    public void setGroupType(Integer n2) {
        this.groupType = n2;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType.getCode();
    }

    public DESEncrypter createDESEncrypterForGroup() {
        DESEncrypter dESEncrypter = null;
        String string = this.getGroupEncryptionKey();
        if (string != null) {
            try {
                dESEncrypter = new DESEncrypter(string, ILPBookSettingsHelper.instance().getGlobalSharingEncryptionIV());
                return dESEncrypter;
            }
            catch (Exception exception) {
                logger.d((Object)("Could no create DES Encrypter fo group " + this + ", reason: " + exception));
            }
        } else {
            logger.c((Object)"Cannot create des encryptor. Empty group-key");
        }
        return null;
    }

    public String getGroupEncryptionKey() {
        String string = null;
        if (this.groupEncryptionKey != null && this.groupEncryptionKey.length() > 0) {
            string = ILPBookSettingsHelper.instance().decryptGroupString(this.groupEncryptionKey);
        }
        return string;
    }

    public void setGroupEncryptionKey(String string) {
        this.groupEncryptionKey = ILPBookSettingsHelper.instance().encryptGroupString(string);
    }

    public ILPUser getAdmin() {
        List<ILPUser> list = f.a().a(this, ILPGroup_User.MembershipRole.MEMBERSHIP_ROLE_OWNER);
        if (list == null || list.size() == 0) {
            return this.admin;
        }
        return list.get(0);
    }

    public void setAdmin(ILPUser iLPUser) {
        this.admin = iLPUser;
    }

    public void addUserObject(ILPUser iLPUser) throws SQLException {
        if (this.getUsers() == null || this.getUsers().contains(iLPUser) || this.getAdmin().equals(iLPUser)) {
            return;
        }
        ILPGroup_User iLPGroup_User = new ILPGroup_User(this, iLPUser);
        g.a().aa().create((Object)iLPGroup_User);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.groupID == null ? 0 : this.groupID.hashCode());
        return n3;
    }

    @Override
    public String toString() {
        return "ILPGroup [groupID=" + this.groupID + ", name=" + this.name + ", groupType=" + this.groupType + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPGroup iLPGroup = (ILPGroup)object;
        return !(this.groupID == null ? iLPGroup.groupID != null : !this.groupID.equals(iLPGroup.groupID));
    }

    public List<ILPUser> getUsers() {
        return f.a().c(this);
    }

    public List<ILPUser> getRequestingUsers() {
        List<ILPGroup_User.MembershipStatus> list = Arrays.asList(ILPGroup_User.MembershipStatus.MEMBERSHIP_STATUS_REQUESTED);
        return f.a().a(this, list);
    }

    public List<ILPUser> getJoiningUsers() {
        List<ILPGroup_User.MembershipStatus> list = Arrays.asList(ILPGroup_User.MembershipStatus.MEMBERSHIP_STATUS_INVITED, ILPGroup_User.MembershipStatus.MEMBERSHIP_STATUS_REQUESTED);
        return f.a().a(this, list);
    }

    public List<ILPUser> getMembers() {
        List<ILPGroup_User.MembershipStatus> list = Arrays.asList(ILPGroup_User.MembershipStatus.MEMBERSHIP_STATUS_JOINED);
        return f.a().a(this, list);
    }

    public int getNumberOfSharedContents() {
        return 0;
    }

    public List<ILPCourseDef> getGrantedCourses() {
        return f.a().a(this);
    }

    public void setGrantedCourses(List<ILPCourseDef> list) {
        for (ILPCourseDef iLPCourseDef : list) {
            try {
                ILPCourseDef_Group iLPCourseDef_Group = new ILPCourseDef_Group(iLPCourseDef, this);
                g.a().Y().create((Object)iLPCourseDef_Group);
            }
            catch (Exception exception) {
                logger.c((Object)("Could not create granted courses in group " + this + ", reason: " + exception));
            }
        }
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String string) {
        this.publicKey = string;
    }

    public void addTaskObject(ILPLessonsTask iLPLessonsTask) throws SQLException {
        ILPLessonsTask_Group iLPLessonsTask_Group = new ILPLessonsTask_Group(iLPLessonsTask, this);
        g.a().aZ().create((Object)iLPLessonsTask_Group);
    }

    public static enum GroupAdminState {
        GROUP_ADMIN_STATE_UNKNOWN(0, "sharing.label.group.unknown", "statusGroupUnknown"),
        GROUP_ADMIN_STATE_OPEN(1, "sharing.label.group.open", "statusGroupOpen"),
        GROUP_ADMIN_STATE_CLOSED(2, "sharing.label.group.closed", "statusGroupClosed"),
        GROUP_ADMIN_STATE_TRANSITION(3, "sharing.label.group.transition", "statusGroupClosed");

        private int code;
        private String localizable;
        private String cssClass;
        private static final Map<Integer, GroupAdminState> lookup;

        static {
            lookup = new HashMap<Integer, GroupAdminState>();
            for (GroupAdminState groupAdminState : EnumSet.allOf(GroupAdminState.class)) {
                lookup.put(groupAdminState.getCode(), groupAdminState);
            }
        }

        private GroupAdminState(int n3, String string2, String string3) {
            this.code = n3;
            this.localizable = string2;
            this.cssClass = string3;
        }

        public String getLocalizable() {
            return o.a().d(this.localizable);
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public int getCode() {
            return this.code;
        }

        public static GroupAdminState get(int n2) {
            return lookup.get(n2);
        }

        public static GroupAdminState get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }

    public static enum GroupMemberState {
        GROUP_MEMBER_STATE_PENDING(0, "sharing.label.group.pending", "statusGroupPending"),
        GROUP_MEMBER_STATE_JOINED(1, "sharing.label.group.joined", "statusGroupJoined"),
        GROUP_MEMBER_STATE_LEFT(2, "sharing.label.group.left", "statusGroupLeft"),
        GROUP_MEMBER_STATE_REQUEST_UNSENT(3, "sharing.label.group.request.unsent", "statusGroupRequestUnsent"),
        GROUP_MEMBER_STATE_UNKNOWN(4, "sharing.label.group.unknwon", "statusGroupUnknown"),
        GROUP_MEMBER_STATE_REMOVED(5, "sharing.label.group.removed", "statusGroupRemoved"),
        GROUP_MEMBER_STATE_REJECTED(6, "sharing.label.group.rejected", "statusGroupRejected");

        private int code;
        private String localizable;
        private String cssClass;
        private static final Map<Integer, GroupMemberState> lookup;

        static {
            lookup = new HashMap<Integer, GroupMemberState>();
            for (GroupMemberState groupMemberState : EnumSet.allOf(GroupMemberState.class)) {
                lookup.put(groupMemberState.getCode(), groupMemberState);
            }
        }

        private GroupMemberState(int n3, String string2, String string3) {
            this.code = n3;
            this.localizable = string2;
            this.cssClass = string3;
        }

        public String getLocalizable() {
            return o.a().d(this.localizable);
        }

        public String getCssClass() {
            return this.cssClass;
        }

        public int getCode() {
            return this.code;
        }

        public static GroupMemberState get(int n2) {
            return lookup.get(n2);
        }

        public static GroupMemberState get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }

    public static enum GroupType {
        GROUP_TYPE_UNDEFINED(0, "UNDEFINED"),
        GROUP_TYPE_SHARING(1, "BEOOK_1"),
        GROUP_TYPE_LESSONS(2, "LESSONS_1");

        private static final Map<Integer, GroupType> codeLookup;
        private static final Map<String, GroupType> valueLookup;
        private int code;
        private String providerId;

        static {
            codeLookup = new HashMap<Integer, GroupType>();
            valueLookup = new HashMap<String, GroupType>();
            for (GroupType groupType : EnumSet.allOf(GroupType.class)) {
                codeLookup.put(groupType.getCode(), groupType);
                valueLookup.put(groupType.getProviderId(), groupType);
            }
        }

        private GroupType(int n3, String string2) {
            this.code = n3;
            this.providerId = string2;
        }

        public static GroupType get(Integer n2) {
            try {
                if (n2 == null) {
                    return GROUP_TYPE_UNDEFINED;
                }
                return codeLookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined groupType code: " + n2 + ", defaulting to " + GROUP_TYPE_UNDEFINED.name()));
                return GROUP_TYPE_UNDEFINED;
            }
        }

        public static GroupType get(String string) {
            try {
                return valueLookup.get(string);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined groupType providerId: " + string + ", defaulting to " + GROUP_TYPE_UNDEFINED.name()));
                return GROUP_TYPE_UNDEFINED;
            }
        }

        public String getProviderId() {
            return this.providerId;
        }

        public int getCode() {
            return this.code;
        }
    }
}

