/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;

public class ILPExerciseAnswerRating {
    private static ILogger logger = ILPLogManager.getLogger(ILPExerciseAnswerRating.class);
    private float numTotalAnswers;
    private float numCorrectAnswers;
    private float numWrongAnswers;
    private ExerciseRatingType ratingType;

    public ILPExerciseAnswerRating(ExerciseRatingType exerciseRatingType) {
        this.ratingType = exerciseRatingType;
    }

    public ILPExerciseAnswerRating(String string) {
        try {
            this.ratingType = ExerciseRatingType.valueOf(string);
        }
        catch (Exception exception) {
            logger.d((Object)("Undefined ExerciseRatingType: " + string + ", defaulting to " + (Object)((Object)ExerciseRatingType.kExerciseRatingTypeDefault)));
            this.ratingType = ExerciseRatingType.kExerciseRatingTypeDefault;
        }
    }

    public Float getRating() {
        float f2 = 0.0f;
        switch (this.ratingType) {
            case ExerciseRatingTypeBonus: {
                f2 = this.numCorrectAnswers;
                break;
            }
            case ExerciseRatingTypeMalus: {
                f2 = this.numCorrectAnswers - this.numWrongAnswers;
                break;
            }
            case ExerciseRatingTypeAllIn: {
                if (this.numWrongAnswers == 0.0f) {
                    f2 = this.numCorrectAnswers;
                    break;
                }
                f2 = 0.0f;
                break;
            }
            default: {
                logger.d((Object)"Undefined rating type, using ExerciseRatingTypeBonus");
                f2 = this.numCorrectAnswers;
            }
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (this.numTotalAnswers > 0.0f) {
            return Float.valueOf(f2 / this.numTotalAnswers);
        }
        return null;
    }

    public void incrementNumTotalAnswers() {
        this.incrementNumTotalAnswers(1.0f);
    }

    public void incrementNumTotalAnswers(float f2) {
        this.setNumTotalAnswers(this.getNumTotalAnswers() + f2);
    }

    public void incrementNumCorrectAnswers() {
        this.incrementNumCorrectAnswers(1.0f);
    }

    private void incrementNumCorrectAnswers(float f2) {
        this.setNumCorrectAnswers(this.getNumCorrectAnswers() + f2);
    }

    public void incrementNumWrongAnswers() {
        this.incrementNumWrongAnswers(1.0f);
    }

    private void incrementNumWrongAnswers(float f2) {
        this.setNumWrongAnswers(this.getNumWrongAnswers() + f2);
    }

    public float getNumTotalAnswers() {
        return this.numTotalAnswers;
    }

    public void setNumTotalAnswers(float f2) {
        this.numTotalAnswers = f2;
    }

    public float getNumCorrectAnswers() {
        return this.numCorrectAnswers;
    }

    public void setNumCorrectAnswers(float f2) {
        this.numCorrectAnswers = f2;
    }

    public String toString() {
        return "ILPExerciseAnswerRating (" + this.numCorrectAnswers + "/" + this.numTotalAnswers + ") = " + this.getRating();
    }

    public float getNumWrongAnswers() {
        return this.numWrongAnswers;
    }

    public void setNumWrongAnswers(float f2) {
        this.numWrongAnswers = f2;
    }

    public static enum ExerciseRatingType {
        ExerciseRatingTypeBonus,
        ExerciseRatingTypeMalus,
        ExerciseRatingTypeAllIn;

        public static ExerciseRatingType kExerciseRatingTypeDefault;

        static {
            kExerciseRatingTypeDefault = ExerciseRatingTypeBonus;
        }
    }
}

