/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.HTMLUtils;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPBookHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.lag.model.o;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPClassification;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExerciseAnswerRating;
import ch.ionesoft.ilp.book.mo.ILPExerciseDefinition;
import ch.ionesoft.ilp.book.mo.ILPExercise_Classification;
import ch.ionesoft.ilp.book.mo.ILPExercise_Resource;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPLocalStoreItem;
import ch.ionesoft.ilp.book.mo.ILPNote;
import ch.ionesoft.ilp.book.mo.ILPQuestion;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPSharing;
import ch.ionesoft.ilp.book.mo.ILPSharingTransaction;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@DatabaseTable(tableName="ZILPEXERCISE")
public class ILPExercise
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPExercise.class);
    public static final String PRESENTATION_PROPERTY_CROSSWORD_HEIGHT = "CrosswordHeight";
    public static final String PRESENTATION_PROPERTY_CROSSWORD_WIDTH = "CrosswordWidth";
    public static final String PRESENTATION_PROPERTY_FIXED_LAYOUT = "fixedLayout";
    public static final String TABLE_NAME = "ZILPEXERCISE";
    public static final String EXERCISEID_FIELD_NAME = "ZEXERCISEID";
    public static final String GROUP_FIELD_NAME = "ZGROUP";
    public static final String SUBGROUP_FIELD_NAME = "ZSUBGROUP";
    public static final String ORDER_FIELD_NAME = "ZORDER";
    public static final String LEVEL_FIELD_NAME = "ZLEVEL";
    public static final String PROCESSED_FIELD_NAME = "ZPROCESSED";
    public static final String SELECTED_FIELD_NAME = "ZSELECTED";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String PROCESSEDDATE_FIELD_NAME = "ZPROCESSEDDATE";
    public static final String LASTACCESS_FIELD_NAME = "ZLASTACCESS";
    public static final String DUEDATE_FIELD_NAME = "ZDUEDATE";
    public static final String REFERENCE_FIELD_NAME = "ZREFERENCE";
    public static final String TAG_FIELD_NAME = "ZTAG";
    public static final String NODEID_FIELD_NAME = "ZNODEID";
    public static final String TOPIC_REFERENCE_FIELD_NAME = "ZTOPICREFERENCE";
    public static final String SORTKEY_FIELD_NAME = "ZSORTKEY";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String RANDOMIZED_FIELD_NAME = "ZRANDOMIZED";
    public static final String RANDOMID_FIELD_NAME = "ZRANDOMID";
    public static final String MAX_POINTS = "ZMAXPOINTS";
    public static final String EXPLANATION_TEXT = "ZEXPLANATIONTEXT";
    public static final String PRESENTATIONPROPERTIES_FIELD_NAME = "ZPRESENTATIONPROPERTIES";
    public static final String BOOKMARK_COLOR_INDEX_FIELD_NAME = "ZBOOKMARKCOLORINDEX";
    public static final String DIFFICULTY_FIELD_NAME = "ZDIFFICULTY";
    public static final String HINTTEXT_FIELD_NAME = "ZHINTTEXT";
    public static final String RATING_FIELD_NAME = "ZRATING";
    public static final String TOPIC_ID_FIELD_NAME = "ZTOPIC";
    public static final String ISSUE_FK_FIELD_NAME = "ZISSUE";
    public static final String PARENT_FK_FIELD_NAME = "ZPARENT";
    public static final String EXERCISE_DEFINITION_FK_FIELD_NAME = "ZTOPICDEFINITION";
    public static final String RESOURCE_FK_FIELD_NAME = "ZRESOURCE";
    @DatabaseField(columnName="ZEXERCISEID", canBeNull=false, index=true)
    private String exerciseId;
    @DatabaseField(columnName="ZGROUP", canBeNull=true, index=true)
    private Integer group;
    @DatabaseField(columnName="ZSUBGROUP", canBeNull=true, index=true)
    private Integer subGroup;
    @DatabaseField(columnName="ZORDER", canBeNull=true, index=true)
    private Integer order;
    @DatabaseField(columnName="ZLEVEL", canBeNull=true, index=true)
    private Integer level;
    @DatabaseField(columnName="ZPROCESSED", canBeNull=true, index=true)
    private Boolean processed;
    @DatabaseField(columnName="ZPROCESSEDDATE", canBeNull=true)
    private DateTime processedDate;
    @DatabaseField(columnName="ZDUEDATE", canBeNull=true)
    private DateTime dueDate;
    @DatabaseField(columnName="ZLASTACCESS", canBeNull=true)
    private DateTime lastAccess;
    @DatabaseField(columnName="ZREFERENCE", canBeNull=true, index=true)
    private String reference;
    @DatabaseField(columnName="ZSELECTED", canBeNull=true, index=true)
    private Boolean selected;
    @DatabaseField(columnName="ZTITLE", canBeNull=true, index=true)
    private String title;
    @DatabaseField(columnName="ZTOPICREFERENCE", canBeNull=true, index=true)
    private String topicReference;
    @DatabaseField(columnName="ZSORTKEY", canBeNull=true, index=true)
    private String sortKey;
    @DatabaseField(columnName="ZTAG", canBeNull=true, index=true)
    private String tag;
    @DatabaseField(columnName="ZNODEID", canBeNull=true, index=true)
    private String nodeId;
    @DatabaseField(columnName="ZHINTTEXT", canBeNull=true)
    private String hintText;
    @DatabaseField(columnName="ZTYPE", canBeNull=false, index=true)
    private Integer type;
    @DatabaseField(columnName="ZDIFFICULTY", canBeNull=true, index=true)
    private Integer difficulty;
    @DatabaseField(columnName="ZRATING", canBeNull=true, index=true)
    private Float rating;
    @DatabaseField(columnName="ZRANDOMIZED", canBeNull=true)
    private Boolean randomized;
    @DatabaseField(columnName="ZRANDOMID", canBeNull=true, index=true)
    private Integer randomId;
    @DatabaseField(columnName="ZMAXPOINTS", canBeNull=true)
    private Float maxPoints;
    @DatabaseField(columnName="ZEXPLANATIONTEXT", canBeNull=true)
    private String explanationText;
    @DatabaseField(columnName="ZPRESENTATIONPROPERTIES", canBeNull=true)
    private String presentationProperties;
    @DatabaseField(columnName="ZBOOKMARKCOLORINDEX", canBeNull=true, index=true)
    private Integer bookmarkColorIndex;
    @DatabaseField(foreign=true, columnName="ZTOPIC", index=true)
    private ILPTopic topic;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZISSUE", index=true)
    private ILPIssueDef issue;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, columnName="ZPARENT", index=true)
    private ILPExercise parent;
    @ForeignCollectionField(orderColumnName="ZNUMBER")
    private ForeignCollection<ILPQuestion> questions;
    @ForeignCollectionField(orderColumnName="ZNODEINDEX")
    private ForeignCollection<ILPNote> notes;
    @ForeignCollectionField(orderColumnName="ZEXERCISE")
    private ForeignCollection<ILPLocalStoreItem> localStoreItems;
    @ForeignCollectionField(orderColumnName="ZEXERCISE")
    private ForeignCollection<ILPScenarioElement> scenarioElements;
    @ForeignCollectionField(orderColumnName="ZORDER")
    private ForeignCollection<ILPExercise> children;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZTOPICDEFINITION", index=true, canBeNull=true)
    private ILPExerciseDefinition exerciseDefinition;
    private List<ILPQuestion> questionsPossiblyRandomized;
    @DatabaseField(foreign=true, columnName="ZRESOURCE", index=true)
    private ILPResource resource;

    public ILPExerciseDefinition getExerciseDefinition() {
        g.a().a(this.exerciseDefinition);
        return this.exerciseDefinition;
    }

    public void setExerciseDefinition(ILPExerciseDefinition iLPExerciseDefinition) {
        this.exerciseDefinition = iLPExerciseDefinition;
    }

    public String getExerciseId() {
        return this.exerciseId;
    }

    public void setExerciseId(String string) {
        this.exerciseId = string;
    }

    public Integer getGroup() {
        return this.group;
    }

    public void setGroup(Integer n2) {
        this.group = n2;
    }

    public ExerciseGroup getExerciseGroup() {
        if (this.group == null) {
            return null;
        }
        return ExerciseGroup.get(this.group);
    }

    public void setExerciseGroup(ExerciseGroup exerciseGroup) {
        this.group = exerciseGroup.getCode();
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer n2) {
        this.order = n2;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer n2) {
        this.level = n2;
    }

    public Boolean isProcessed() {
        if (this.processed != null && this.processed.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean getProcessed() {
        return this.processed;
    }

    public void setProcessed(Boolean bl2) {
        this.processed = bl2;
    }

    public DateTime getProcessedDate() {
        return this.processedDate;
    }

    public void setProcessedDate(DateTime dateTime) {
        this.processedDate = dateTime;
    }

    public void setProcessedDate(Date date) {
        this.processedDate = date != null ? new DateTime((Object)date) : null;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public void setReferenceNormalized(String string) {
        this.reference = StringHelper.normalizeForJQuery((String)string);
    }

    public Boolean isSelected() {
        if (this.selected != null && this.selected.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean bl2) {
        this.selected = bl2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public ILPResource getResource() {
        g.a().c(this.resource);
        return this.resource;
    }

    public void setResource(ILPResource iLPResource) {
        this.resource = iLPResource;
    }

    public String getFullTitle() {
        String string = this.title;
        if (this.exerciseId != null) {
            string = String.format("%s %s", this.exerciseId, this.title);
        }
        return string;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public String getTagRecursively() {
        if (this.tag != null) {
            return this.tag;
        }
        if (this.getParent() != null && !this.getParent().equals(this)) {
            return this.getParent().getTagRecursively();
        }
        return null;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String string) {
        this.nodeId = string;
    }

    public String getTopicReference() {
        return this.topicReference;
    }

    public void setTopicReference(String string) {
        this.topicReference = string;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String string) {
        this.sortKey = string;
    }

    public String getText() {
        return ILPBookSettingsHelper.instance().decryptExerciseText_forExercise(this.getResource().getDataString(), this);
    }

    public void setText(String string) {
        g.a().c(this.resource);
        if (string != null) {
            string = ILPBookSettingsHelper.instance().encryptExerciseText_forExercise(string, this);
            this.resource.setData(string.getBytes());
        } else {
            this.resource.setData((byte[])null);
        }
    }

    public String getPlainText() {
        String string = ILPBookSettingsHelper.instance().decryptExerciseText_forExercise(this.getResource().getPlainDataString(), this);
        return string;
    }

    public void setPlainText(String string) {
        if (string != null) {
            string = ILPBookSettingsHelper.instance().encryptExerciseText_forExercise(string, this);
            this.resource.setPlainDataString(string);
        } else {
            this.resource.setPlainData(null);
        }
    }

    public void buildPlainText() {
        try {
            String string;
            List<ILPClassification> list;
            boolean bl2 = ILPBookHelper.hasFeatureAccessOrLicensePermissionsToToggleExerciseAnswerCorrection(this);
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.getTitle() != null) {
                stringBuffer.append(this.getTitle());
            }
            if ((list = this.getClassifications()) != null) {
                for (ILPClassification iLPClassification : list) {
                    stringBuffer.append(" [" + iLPClassification.localizedName() + "] ");
                }
            }
            if ((string = this.getText()) != null) {
                stringBuffer.append(" ");
                stringBuffer.append(HTMLUtils.prettyPrintHTMLToPlainText((String)string));
            }
            if (this.getHintText() != null) {
                stringBuffer.append(" ");
                stringBuffer.append(HTMLUtils.prettyPrintHTMLToPlainText((String)this.getHintText()));
            }
            if (bl2 && this.getExplanationText() != null) {
                stringBuffer.append(" ");
                stringBuffer.append(HTMLUtils.prettyPrintHTMLToPlainText((String)this.getExplanationText()));
            }
            for (Object object : this.getQuestions()) {
                if (((ILPQuestion)object).getText() != null) {
                    Object object2 = HTMLUtils.prettyPrintHTMLToPlainText((String)((ILPQuestion)object).getText());
                    object2 = ((String)object2).replaceAll("\\{[0-9]*\\}", "");
                    object2 = ((String)object2).replaceAll("$\\{[a-zA-Z0-9_]*\\}", "");
                    object2 = ((String)object2).replace("|    |", "");
                    stringBuffer.append(" ");
                    stringBuffer.append((String)object2);
                }
                if (!bl2) continue;
                for (Object object2 : ((ILPQuestion)object).getCorrectAnswers()) {
                    stringBuffer.append(" ");
                    String string2 = ((ILPAnswer)object2).getText();
                    if (StringHelper.startsNumeric((String)string2) && string2.contains("=")) {
                        string2 = StringHelper.extractStringFrom_after((String)string2, (String)"=");
                    }
                    stringBuffer.append(HTMLUtils.prettyPrintHTMLToPlainText((String)string2));
                }
            }
            this.getResource().setPlainDataString(stringBuffer.toString());
        }
        catch (Exception exception) {
            logger.d((Object)("Could not build plain text of exercise: " + this), (Throwable)exception);
            this.getResource().setPlainData(null);
        }
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer n2) {
        this.type = n2;
    }

    public DateTime getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(DateTime dateTime) {
        this.lastAccess = dateTime;
    }

    public void setLastAccess(Date date) {
        this.lastAccess = date != null ? new DateTime((Object)date) : null;
    }

    public ExerciseType getExerciseType() {
        if (this.type != null) {
            return ExerciseType.get(this.type);
        }
        return null;
    }

    public void setExerciseType(ExerciseType exerciseType) {
        this.type = exerciseType.getCode();
    }

    public ExerciseSubGroup getSubGroup() {
        if (this.subGroup != null) {
            return ExerciseSubGroup.get(this.subGroup);
        }
        return null;
    }

    public void setSubGroup(ExerciseSubGroup exerciseSubGroup) {
        this.subGroup = exerciseSubGroup.getCode();
    }

    public void setSubGroupCode(int n2) {
        this.subGroup = n2;
    }

    public DateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(DateTime dateTime) {
        this.dueDate = dateTime;
    }

    public void setDueDate(Date date) {
        this.dueDate = date != null ? new DateTime((Object)date) : null;
    }

    public String getHintText() {
        return this.hintText;
    }

    public void setHintText(String string) {
        this.hintText = string;
    }

    public Integer getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Integer n2) {
        this.difficulty = n2;
    }

    public ExerciseDifficultyType getExerciseDifficultyType() {
        if (this.difficulty != null) {
            return ExerciseDifficultyType.get(this.difficulty);
        }
        return null;
    }

    public void setDifficultyType(ExerciseDifficultyType exerciseDifficultyType) {
        this.difficulty = exerciseDifficultyType.getCode();
    }

    public Float getRating() {
        return this.rating;
    }

    public void setRating(Float f2) {
        this.rating = f2;
    }

    public ILPExerciseAnswerRating.ExerciseRatingType getRatingType() {
        String string = this.getIssue().propertyStringWithName_defaultValue("exerciseRatingType", ILPExerciseAnswerRating.ExerciseRatingType.kExerciseRatingTypeDefault.name());
        return ILPExerciseAnswerRating.ExerciseRatingType.valueOf(string);
    }

    public Boolean getRandomized() {
        return this.randomized;
    }

    public Boolean isRandomized() {
        if (this.randomized != null && this.randomized.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setRandomized(Boolean bl2) {
        this.randomized = bl2;
    }

    public Integer getRandomId() {
        return this.randomId;
    }

    public void setRandomId(Integer n2) {
        this.randomId = n2;
    }

    public ILPTopic getTopic() {
        g.a().c(this.topic);
        return this.topic;
    }

    public void setTopic(ILPTopic iLPTopic) {
        this.topic = iLPTopic;
    }

    public ILPIssueDef getIssue() {
        return this.issue;
    }

    public void setIssue(ILPIssueDef iLPIssueDef) {
        this.issue = iLPIssueDef;
    }

    public ILPExercise getParent() {
        return this.parent;
    }

    public void setParent(ILPExercise iLPExercise) {
        this.parent = iLPExercise;
    }

    public ForeignCollection<ILPExercise> getChildren() {
        if (this.children == null) {
            try {
                g.a().J().assignEmptyForeignCollection((Object)this, "children");
                this.children.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for exercise.children", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.children;
    }

    public void setChildren(ForeignCollection<ILPExercise> foreignCollection) {
        this.children = foreignCollection;
    }

    public ForeignCollection<ILPQuestion> getQuestions() {
        if (this.questions == null) {
            try {
                g.a().J().assignEmptyForeignCollection((Object)this, "questions");
                this.questions.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for exercise.questions", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.questions;
    }

    public void setQuestions(ForeignCollection<ILPQuestion> foreignCollection) {
        this.questions = foreignCollection;
        this.questionsPossiblyRandomized = null;
    }

    public List<ILPQuestion> getQuestionsPossiblyRandomized() {
        if (this.questionsPossiblyRandomized == null) {
            ArrayList<ILPQuestion> arrayList = new ArrayList<ILPQuestion>();
            for (ILPQuestion iLPQuestion : this.getQuestions()) {
                arrayList.add(iLPQuestion);
            }
            if (arrayList.size() > 0) {
                ILPQuestion iLPQuestion;
                iLPQuestion = (ILPQuestion)arrayList.get(0);
                boolean bl2 = false;
                switch (this.getExerciseType()) {
                    case EXERCISE_TYPE_MULTICHOICE: 
                    case EXERCISE_TYPE_SINGLECHOICE: {
                        bl2 = this.isRandomized() != false && (iLPQuestion.hasAnswerFormat(ILPQuestion.ANSWER_FORMAT_QUESTION_WITH_ANSWER) || iLPQuestion.hasAnswerFormat(ILPQuestion.ANSWER_FORMAT_FILL_PLACEHOLDER));
                        break;
                    }
                }
                if (bl2) {
                    Collections.shuffle(arrayList);
                }
            }
            this.questionsPossiblyRandomized = arrayList;
        }
        return this.questionsPossiblyRandomized;
    }

    public void setQuestionsPossiblyRandomized(List<ILPQuestion> list) {
        this.questionsPossiblyRandomized = list;
    }

    public ILPQuestion getFirstQuestion() {
        CloseableIterator closeableIterator = this.getQuestions().closeableIterator();
        try {
            if (closeableIterator.hasNext()) {
                ILPQuestion iLPQuestion = (ILPQuestion)closeableIterator.next();
                return iLPQuestion;
            }
        }
        finally {
            try {
                if (closeableIterator != null) {
                    closeableIterator.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public ILPQuestion getLastQuestion() {
        CloseableIterator closeableIterator = this.getQuestions().closeableIterator();
        ILPQuestion iLPQuestion = null;
        try {
            while (closeableIterator.hasNext()) {
                iLPQuestion = (ILPQuestion)closeableIterator.next();
            }
            ILPQuestion iLPQuestion2 = iLPQuestion;
            return iLPQuestion2;
        }
        finally {
            try {
                if (closeableIterator != null) {
                    closeableIterator.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public ForeignCollection<ILPNote> getNotes() {
        if (this.notes == null) {
            try {
                g.a().J().assignEmptyForeignCollection((Object)this, "notes");
                this.notes.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for exercise.notes", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.notes;
    }

    public void setNotes(ForeignCollection<ILPNote> foreignCollection) {
        this.notes = foreignCollection;
    }

    public ForeignCollection<ILPLocalStoreItem> getLocalStoreItems() {
        if (this.localStoreItems == null) {
            try {
                g.a().J().assignEmptyForeignCollection((Object)this, "localStoreItems");
                this.localStoreItems.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for exercise.localStoreItems", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.localStoreItems;
    }

    public void setLocalStoreItems(ForeignCollection<ILPLocalStoreItem> foreignCollection) {
        this.localStoreItems = foreignCollection;
    }

    public ForeignCollection<ILPScenarioElement> getScenarioElements() {
        if (this.scenarioElements == null) {
            try {
                g.a().J().assignEmptyForeignCollection((Object)this, "scenarioElements");
                this.scenarioElements.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for exercise.scenarioElements", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.scenarioElements;
    }

    public void setScenarioItems(ForeignCollection<ILPScenarioElement> foreignCollection) {
        this.scenarioElements = foreignCollection;
    }

    public String getPresentationProperties() {
        return this.presentationProperties;
    }

    public void setPresentationProperties(String string) {
        this.presentationProperties = string;
    }

    public Float getMaxPoints() {
        return this.maxPoints;
    }

    public void setMaxPoints(Float f2) {
        this.maxPoints = f2;
    }

    public boolean isSupportAutoRating() {
        if (this.getExerciseType() != null) {
            return this.getExerciseType().isSupportsAutoRating();
        }
        return false;
    }

    public float getReachedPoints() {
        if (this.getRating() == null) {
            return 0.0f;
        }
        float f2 = this.getMaxPoints() != null ? this.getMaxPoints().floatValue() : 1.0f;
        float f3 = f2 * this.getRating().floatValue();
        return f3;
    }

    public float getReachedPointsWithPrecision(float f2) {
        float f3 = this.getReachedPoints();
        return ConverterUtil.roundFloatWithPrecision((float)f3, (float)f2);
    }

    public String formatReachedPointsWithMaxDigits(int n2) {
        if (this.isSupportAutoRating()) {
            float f2 = this.getReachedPoints();
            return ConverterUtil.convertFloatToTrimmedFraction_maxDigits((Float)Float.valueOf(f2), (int)n2);
        }
        return "";
    }

    public String formatMaxPointsWithMaxDigits(int n2) {
        if (this.isSupportAutoRating()) {
            float f2 = this.getMaxPoints() != null ? this.getMaxPoints().floatValue() : 1.0f;
            return ConverterUtil.convertFloatToTrimmedFraction_maxDigits((Float)Float.valueOf(f2), (int)n2);
        }
        return "";
    }

    public String getExplanationText() {
        return ILPBookSettingsHelper.instance().decryptExerciseExplanationText_forExercise(this.explanationText, this);
    }

    public void setExplanationText(String string) {
        String string2;
        this.explanationText = string2 = ILPBookSettingsHelper.instance().encryptExerciseExplanationText_forExercise(string, this);
    }

    public boolean isAnswerPopupSupported() {
        return this.getExerciseType() == ExerciseType.EXERCISE_TYPE_CHANGE_CASE || this.getExerciseType() == ExerciseType.EXERCISE_TYPE_ESSAY || this.getExerciseType() == ExerciseType.EXERCISE_TYPE_INSERT_ELEMENT || this.getExerciseType() == ExerciseType.EXERCISE_TYPE_MARK || this.getExerciseType() == ExerciseType.EXERCISE_TYPE_PLAINANSWER || this.getExerciseType() == ExerciseType.EXERCISE_TYPE_SHORTANSWER || this.getExerciseType() == ExerciseType.EXERCISE_TYPE_SKETCHPAD || this.getExerciseType() == ExerciseType.EXERCISE_TYPE_SVG_EDIT;
    }

    public void addClassificationObject(ILPClassification iLPClassification) throws SQLException {
        ILPExercise_Classification iLPExercise_Classification = new ILPExercise_Classification(this, iLPClassification);
        g.a().W().create((Object)iLPExercise_Classification);
    }

    public void linkWithClassificationType_name(ILPClassification.ClassificationType classificationType, String string) {
        try {
            f f2 = f.a();
            ILPClassification iLPClassification = f2.a(classificationType, string, this);
            if (iLPClassification == null) {
                List<ILPClassification> list = f2.a(classificationType, string, this.issue.getCourse().getMandantId());
                if (list != null) {
                    for (ILPClassification iLPClassification2 : list) {
                        ILPCourseDef iLPCourseDef = this.issue.getCourse();
                        List<ILPExercise> list2 = iLPClassification2.getRelatedExercises(null, this.getExerciseGroup(), this.issue);
                        for (ILPExercise iLPExercise : list2) {
                            if (iLPExercise.getIssue() == null || iLPExercise.getIssue().getCourse() == null || !iLPExercise.getIssue().getCourse().equals(iLPCourseDef)) continue;
                            iLPClassification = iLPClassification2;
                            break;
                        }
                        if (iLPClassification != null) break;
                    }
                }
                if (iLPClassification == null) {
                    iLPClassification = new ILPClassification();
                    iLPClassification.setType(classificationType.getCode());
                    iLPClassification.setName(string);
                    iLPClassification.setMandantId(this.getIssue().getCourse().getMandantId());
                    iLPClassification.setLanguageCode(this.getIssue().getCourse().getLanguageCode());
                    g.a().O().create((Object)iLPClassification);
                }
                this.addClassificationObject(iLPClassification);
            }
        }
        catch (Exception exception) {
            logger.c((Object)("Could not link topic with classification: " + string), (Throwable)exception);
        }
    }

    public List<ILPClassification> getClassifications() {
        try {
            return f.a().f(this);
        }
        catch (j j2) {
            logger.d((Object)("Could not get classifications of exercise: " + this), (Throwable)j2);
            return null;
        }
    }

    public boolean hasAspectClassificationWithName(String string) {
        return this.hasClassificationWithType_name(ILPClassification.ClassificationType.CLASSIFICATION_TYPE_ASPECT, string);
    }

    public boolean hasClassificationWithType_name(ILPClassification.ClassificationType classificationType, String string) {
        try {
            ILPClassification iLPClassification = f.a().a(classificationType, string, this);
            return iLPClassification != null;
        }
        catch (j j2) {
            logger.d((Object)("Could not get classifications of exercise: " + this), (Throwable)j2);
            return false;
        }
    }

    public boolean hasClassificationType(ILPClassification.ClassificationType classificationType) {
        try {
            ILPClassification iLPClassification = f.a().a(classificationType, this);
            return iLPClassification != null;
        }
        catch (j j2) {
            logger.d((Object)("Could not get classifications of exercise: " + this), (Throwable)j2);
            return false;
        }
    }

    public void addReferencedResourceObject(ILPResource iLPResource) throws SQLException {
        ILPExercise_Resource iLPExercise_Resource = new ILPExercise_Resource(this, iLPResource);
        g.a().ac().create((Object)iLPExercise_Resource);
    }

    public boolean hasReferencedResource(ILPResource iLPResource, ILPResource.ResourceReference[] resourceReferenceArray) {
        try {
            return f.a().a(this, resourceReferenceArray).contains(iLPResource);
        }
        catch (j j2) {
            logger.d((Object)"Could not get referenced resources of exercise");
            return false;
        }
    }

    public List<ILPResource> getReferencedResources(ILPResource.ResourceReference[] resourceReferenceArray) {
        try {
            return f.a().a(this, resourceReferenceArray);
        }
        catch (j j2) {
            logger.d((Object)"Could not get referenced resources of exercise");
            return null;
        }
    }

    public List<ILPExercise> getAncestorsAndSelf() {
        ArrayList<ILPExercise> arrayList = new ArrayList<ILPExercise>();
        arrayList.add(this);
        ILPExercise iLPExercise = this;
        while ((iLPExercise = iLPExercise.getParent()) != null) {
            arrayList.add(iLPExercise);
        }
        return arrayList;
    }

    private String propertyFor_defaultProperty(String string, String string2) {
        return StringHelper.extractProperty_For_defaultProperty((String)this.presentationProperties, (String)string, (String)string2, (boolean)true);
    }

    public String propertyFor(String string) {
        String string2 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            logger.d((Object)String.format(Locale.ENGLISH, "No property defined for exercise: %s, named: %s", this.exerciseId, string));
        }
        return string2;
    }

    public boolean propertyBoolean_defaultValue(String string, boolean bl2) {
        String string2 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return Boolean.parseBoolean(string2);
        }
        return bl2;
    }

    public float propertyFloat_defaultValue(String string, float f2) {
        String string2 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return Float.parseFloat(string2);
        }
        return f2;
    }

    public int propertyInt_defaultValue(String string, int n2) {
        String string2 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return Integer.parseInt(string2);
        }
        return n2;
    }

    public String propertyString_defaultValue(String string, String string2) {
        String string3 = this.propertyFor_defaultProperty(string, null);
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            return string3;
        }
        return string2;
    }

    public static String sortFieldForIssue_exerciseGroup(ILPIssueDef iLPIssueDef, ExerciseGroup exerciseGroup) {
        String string;
        String string2 = string = iLPIssueDef.propertyStringWithName_defaultValue("exerciseSortField", "order");
        if (exerciseGroup != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(";");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                String[] stringArray3 = string3.split("=");
                if (stringArray3.length == 1) {
                    string2 = stringArray3[0];
                } else if (stringArray3.length == 2 && stringArray3[0].trim().equals("" + exerciseGroup.code)) {
                    string2 = stringArray3[1];
                }
                ++n3;
            }
        }
        if (StringUtils.isBlank((CharSequence)string2) || string2.contains(";")) {
            string2 = "order";
        }
        return string2;
    }

    public static String sqlFieldForName(String string) {
        if (string == null) {
            logger.d((Object)"Undefined field specified in sqlFieldForName. Defaulting to ORDER");
            return ORDER_FIELD_NAME;
        }
        if (string.equals("title")) {
            return TITLE_FIELD_NAME;
        }
        if (string.equals("order")) {
            return ORDER_FIELD_NAME;
        }
        if (string.equals("tag")) {
            return TAG_FIELD_NAME;
        }
        if (string.equals("exerciseId")) {
            return EXERCISEID_FIELD_NAME;
        }
        if (string.equals("reference")) {
            return REFERENCE_FIELD_NAME;
        }
        if (string.equals("sortKey")) {
            return SORTKEY_FIELD_NAME;
        }
        if (string.equals("randomId")) {
            return RANDOMID_FIELD_NAME;
        }
        return ORDER_FIELD_NAME;
    }

    public ILPSharingTransaction getDefaultTransaction() {
        List<ILPSharingTransaction> list = this.getTransactionWithAnswersForExercise();
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public boolean hasSharedAnswers() {
        return this.getTransactionWithAnswersForExercise().size() > 0;
    }

    public boolean hasValidContent() {
        if (this.title != null && !this.title.equals("")) {
            return true;
        }
        if (this.getResource().getDataString() != null && !this.getResource().getDataString().equals("")) {
            return true;
        }
        for (ILPQuestion iLPQuestion : this.getQuestions()) {
            if (iLPQuestion.getText() == null || iLPQuestion.getText().equals("")) continue;
            return true;
        }
        return false;
    }

    public List<ILPSharingTransaction> getTransactionWithAnswersForExercise() {
        List<ILPAnswer> list;
        HashSet<ILPSharingTransaction> hashSet = new HashSet<ILPSharingTransaction>();
        try {
            list = f.a().a(ILPAnswer.AnswerType.ANSWER_TYPE_SHARED, this);
            for (ILPAnswer iLPAnswer : list) {
                for (ILPSharing iLPSharing : iLPAnswer.getSharings()) {
                    if (iLPSharing.getSharingTransaction() == null) continue;
                    hashSet.add(iLPSharing.getSharingTransaction());
                }
            }
        }
        catch (j j2) {
            logger.c((Object)("Could not fetch sharing transactions for exercise " + this + ", reason: " + j2));
        }
        list = new ArrayList<ILPAnswer>(hashSet);
        Collections.sort(list, new Comparator<ILPSharingTransaction>(){

            @Override
            public int compare(ILPSharingTransaction iLPSharingTransaction, ILPSharingTransaction iLPSharingTransaction2) {
                return iLPSharingTransaction.getCreationDate().compareTo((ReadableInstant)iLPSharingTransaction2.getCreationDate());
            }
        });
        return list;
    }

    public Integer getBookmarkColorIndex() {
        return this.bookmarkColorIndex;
    }

    public void setBookmarkColorIndex(Integer n2) {
        this.bookmarkColorIndex = n2;
    }

    public boolean isBookmarked() {
        return this.bookmarkColorIndex != null;
    }

    public void setBookmarked(boolean bl2) {
        if (bl2) {
            this.setBookmarkColorIndex(1);
        } else {
            this.setBookmarkColorIndex(null);
        }
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.exerciseId == null ? 0 : this.exerciseId.hashCode());
        n3 = 31 * n3 + (this.issue == null ? 0 : this.issue.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPExercise iLPExercise = (ILPExercise)object;
        if (this.exerciseId == null ? iLPExercise.exerciseId != null : !this.exerciseId.equals(iLPExercise.exerciseId)) {
            return false;
        }
        return !(this.issue == null ? iLPExercise.issue != null : !this.issue.equals(iLPExercise.issue));
    }

    @Override
    public String toString() {
        return "ILPExercise [exerciseId=" + this.exerciseId + ", processed=" + this.processed + ", processedDate=" + this.processedDate + ", reference=" + this.reference + ", title=" + this.title + ", nodeId=" + this.nodeId + ", type=" + this.type + ", pk=" + this.pk + "]";
    }

    public static enum ExerciseDifficultyType {
        EXERCISE_DIFFICULTY_UNDEFINED(0),
        EXERCISE_DIFFICULTY_EASY(1),
        EXERCISE_DIFFICULTY_MODERATE(5),
        EXERCISE_DIFFICULTY_HEAVY(10),
        EXERCISE_DIFFICULTY_ALL(15);

        private static final Map<Integer, ExerciseDifficultyType> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ExerciseDifficultyType>();
            for (ExerciseDifficultyType exerciseDifficultyType : EnumSet.allOf(ExerciseDifficultyType.class)) {
                lookup.put(exerciseDifficultyType.getCode(), exerciseDifficultyType);
            }
        }

        private ExerciseDifficultyType(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ExerciseDifficultyType get(int n2) {
            return lookup.get(n2);
        }

        public static ExerciseDifficultyType get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }

        public static ExerciseDifficultyType parseGermanString(String string) {
            if ("leicht".equalsIgnoreCase(string) || "einfach".equalsIgnoreCase(string)) {
                return EXERCISE_DIFFICULTY_EASY;
            }
            if ("mittel".equalsIgnoreCase(string)) {
                return EXERCISE_DIFFICULTY_MODERATE;
            }
            if ("schwer".equalsIgnoreCase(string)) {
                return EXERCISE_DIFFICULTY_HEAVY;
            }
            if ("alle".equalsIgnoreCase(string)) {
                return EXERCISE_DIFFICULTY_ALL;
            }
            return EXERCISE_DIFFICULTY_UNDEFINED;
        }
    }

    public static class ExerciseGroup {
        public static String CONTENT_TYPE_EXERCISE_COMPREHENSION = "exercise_comprehension";
        public static String CONTENT_TYPE_EXERCISE_KNOWLEDGE_USE = "exercise_knowledge_use";
        public static String CONTENT_TYPE_EXERCISE_INTERACTIVE = "exercise_interactive";
        public static String CONTENT_TYPE_EXERCISE_FLASHCARDS = "exercise_flashcards";
        public static String CONTENT_TYPE_EXERCISE_OTHER_PREFIX = "exercise_group_";
        protected static String EXERCISE_GROUP_COMPREHENSION_STRING = "EXERCISE_GROUP_COMPREHENSION";
        protected static String EXERCISE_GROUP_KNOWLEDGE_USE_STRING = "EXERCISE_GROUP_KNOWLEDGE_USE";
        protected static String EXERCISE_GROUP_INTERACTIVE_STRING = "EXERCISE_GROUP_INTERACTIVE";
        protected static String EXERCISE_GROUP_FLASHCARDS_STRING = "EXERCISE_GROUP_FLASHCARDS";
        public static final ExerciseGroup EXERCISE_GROUP_ANY = new ExerciseGroup(0, String.valueOf(CONTENT_TYPE_EXERCISE_OTHER_PREFIX) + "_0");
        public static final ExerciseGroup EXERCISE_GROUP_COMPREHENSION = new ExerciseGroup(1, CONTENT_TYPE_EXERCISE_COMPREHENSION);
        public static final ExerciseGroup EXERCISE_GROUP_KNOWLEDGE_USE = new ExerciseGroup(2, CONTENT_TYPE_EXERCISE_KNOWLEDGE_USE);
        public static final ExerciseGroup EXERCISE_GROUP_INTERACTIVE = new ExerciseGroup(3, CONTENT_TYPE_EXERCISE_INTERACTIVE);
        public static final ExerciseGroup EXERCISE_GROUP_FLASHCARDS = new ExerciseGroup(4, CONTENT_TYPE_EXERCISE_FLASHCARDS);
        private int code;
        private String contentType;

        private ExerciseGroup(int n2) {
            this.code = n2;
            switch (n2) {
                case 1: {
                    this.contentType = CONTENT_TYPE_EXERCISE_COMPREHENSION;
                    break;
                }
                case 2: {
                    this.contentType = CONTENT_TYPE_EXERCISE_KNOWLEDGE_USE;
                    break;
                }
                case 3: {
                    this.contentType = CONTENT_TYPE_EXERCISE_INTERACTIVE;
                    break;
                }
                case 4: {
                    this.contentType = CONTENT_TYPE_EXERCISE_FLASHCARDS;
                    break;
                }
                default: {
                    this.contentType = String.format(String.valueOf(CONTENT_TYPE_EXERCISE_OTHER_PREFIX) + "%d", n2);
                }
            }
        }

        private ExerciseGroup(int n2, String string) {
            this.code = n2;
            this.contentType = string;
        }

        public int getCode() {
            return this.code;
        }

        public String getContentType() {
            return this.contentType;
        }

        public static ExerciseGroup get(int n2) {
            return new ExerciseGroup(n2);
        }

        public static ExerciseGroup get(String string) {
            return ExerciseGroup.valueOf(string);
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.code;
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ExerciseGroup exerciseGroup = (ExerciseGroup)object;
            return this.code == exerciseGroup.code;
        }

        public String name() {
            return String.format(String.valueOf(CONTENT_TYPE_EXERCISE_OTHER_PREFIX) + "%d", this.code);
        }

        public static ExerciseGroup valueOf(String string) {
            if (EXERCISE_GROUP_COMPREHENSION_STRING.equals(string)) {
                return EXERCISE_GROUP_COMPREHENSION;
            }
            if (EXERCISE_GROUP_KNOWLEDGE_USE_STRING.equals(string)) {
                return EXERCISE_GROUP_KNOWLEDGE_USE;
            }
            if (EXERCISE_GROUP_INTERACTIVE_STRING.equals(string)) {
                return EXERCISE_GROUP_INTERACTIVE;
            }
            if (EXERCISE_GROUP_FLASHCARDS_STRING.equals(string)) {
                return EXERCISE_GROUP_FLASHCARDS;
            }
            if (CONTENT_TYPE_EXERCISE_COMPREHENSION.equals(string)) {
                return EXERCISE_GROUP_COMPREHENSION;
            }
            if (CONTENT_TYPE_EXERCISE_KNOWLEDGE_USE.equals(string)) {
                return EXERCISE_GROUP_KNOWLEDGE_USE;
            }
            if (CONTENT_TYPE_EXERCISE_INTERACTIVE.equals(string)) {
                return EXERCISE_GROUP_INTERACTIVE;
            }
            if (CONTENT_TYPE_EXERCISE_FLASHCARDS.equals(string)) {
                return EXERCISE_GROUP_FLASHCARDS;
            }
            String string2 = null;
            string2 = string.startsWith(CONTENT_TYPE_EXERCISE_OTHER_PREFIX) ? StringHelper.extractString_after((String)string, (String)CONTENT_TYPE_EXERCISE_OTHER_PREFIX) : string;
            try {
                int n2 = Integer.parseInt(string2);
                return ExerciseGroup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not get value of ExerciseGroup: " + string + ". Returning " + EXERCISE_GROUP_COMPREHENSION.name()));
                return EXERCISE_GROUP_COMPREHENSION;
            }
        }

        public String localizedPluralName() {
            if (this.equals(EXERCISE_GROUP_ANY)) {
                return "";
            }
            String string = ch.ionesoft.ilp.base.co.g.b((String)"label.exerciseGroup.", (String)("" + this.getCode()));
            if (string.startsWith("label.exerciseGroup.") || StringUtils.isEmpty((CharSequence)string)) {
                logger.c((Object)String.format("No localized name for label.exerciseGroup.%d found in ILPBookAdditions.strings. Taking default", this.getCode()));
                string = o.a().d("label.exerciseGroup.1");
            }
            return string;
        }

        public String localizedSingularName() {
            if (this.equals(EXERCISE_GROUP_ANY)) {
                return "";
            }
            String string = ch.ionesoft.ilp.base.co.g.b((String)"label.exerciseGroup.label.", (String)("" + this.getCode()));
            if (string.startsWith("label.exerciseGroup.label")) {
                string = "";
            }
            return string;
        }

        public String toString() {
            return "ExerciseGroup: " + this.localizedPluralName();
        }
    }

    public static enum ExerciseSubGroup {
        EXERCISE_SUBGROUP_ANY(0),
        EXERCISE_SUBGROUP_QUIZ_DONE(1),
        EXERCISE_SUBGROUP_QUIZ_BOX0(2),
        EXERCISE_SUBGROUP_QUIZ_BOX1(3),
        EXERCISE_SUBGROUP_QUIZ_BOX2(4),
        EXERCISE_SUBGROUP_QUIZ_BOX3(5);

        private static final Map<Integer, ExerciseSubGroup> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ExerciseSubGroup>();
            for (ExerciseSubGroup exerciseSubGroup : EnumSet.allOf(ExerciseSubGroup.class)) {
                lookup.put(exerciseSubGroup.getCode(), exerciseSubGroup);
            }
        }

        private ExerciseSubGroup(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ExerciseSubGroup get(int n2) {
            return lookup.get(n2);
        }

        public static ExerciseSubGroup get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }

    public static enum ExerciseType {
        EXERCISE_TYPE_UNDEFINED(0, false),
        EXERCISE_TYPE_ESSAY(1, false),
        EXERCISE_TYPE_SHORTANSWER(2, true),
        EXERCISE_TYPE_MULTIANSWER(3, false),
        EXERCISE_TYPE_MULTICHOICE(4, true),
        EXERCISE_TYPE_SINGLECHOICE(5, true),
        EXERCISE_TYPE_MARK(6, false),
        EXERCISE_TYPE_WEBPAGE(7, false),
        EXERCISE_TYPE_LEARNINGAPPS(8, false),
        EXERCISE_TYPE_LMS(9, false),
        EXERCISE_TYPE_HTML(10, false),
        EXERCISE_TYPE_FLASHCARD(11, false),
        EXERCISE_TYPE_SVG_EDIT(12, false),
        EXERCISE_TYPE_MATCH_SINGLE_USE(13, true),
        EXERCISE_TYPE_MATCH_REUSE(14, true),
        EXERCISE_TYPE_MATCH_KEYBOARD(15, true),
        EXERCISE_TYPE_MATCH_POSITION(16, true),
        EXERCISE_TYPE_EXTERNAL_WEBPAGE(17, false),
        EXERCISE_TYPE_IMAGEMAP_SINGLE(18, true),
        EXERCISE_TYPE_IMAGEMAP_MULTI(19, true),
        EXERCISE_TYPE_CROSSWORD(20, true),
        EXERCISE_TYPE_SVG_EDIT_FULLSCREEN(21, false),
        EXERCISE_TYPE_CHANGE_CASE(22, false),
        EXERCISE_TYPE_INSERT_ELEMENT(23, false),
        EXERCISE_TYPE_PLAINANSWER(24, true),
        EXERCISE_TYPE_SKETCHPAD(25, false),
        EXERCISE_TYPE_SKETCHPAD_FULLSCREEN(26, false),
        EXERCISE_TYPE_COMMENT_SINGLECHOICE(27, false),
        EXERCISE_TYPE_COMMENT_MULTICHOICE(28, false),
        EXERCISE_TYPE_INTRODUCTION(29, false);

        private static final Map<Integer, ExerciseType> lookup;
        private int code;
        private boolean supportsAutoRating;

        static {
            lookup = new HashMap<Integer, ExerciseType>();
            for (ExerciseType exerciseType : EnumSet.allOf(ExerciseType.class)) {
                lookup.put(exerciseType.getCode(), exerciseType);
            }
        }

        private ExerciseType(int n3, boolean bl2) {
            this.code = n3;
            this.supportsAutoRating = bl2;
        }

        public int getCode() {
            return this.code;
        }

        public static ExerciseType get(int n2) {
            return lookup.get(n2);
        }

        public static ExerciseType get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }

        public static ExerciseType getByName(String string) {
            ExerciseType[] exerciseTypeArray = ExerciseType.values();
            int n2 = exerciseTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ExerciseType exerciseType = exerciseTypeArray[n3];
                if (exerciseType.name().toLowerCase().equals(string.toLowerCase())) {
                    return exerciseType;
                }
                ++n3;
            }
            return null;
        }

        public boolean isSupportsAutoRating() {
            return this.supportsAutoRating;
        }

        public o.b asLagEnum() {
            try {
                switch (this) {
                    case EXERCISE_TYPE_UNDEFINED: {
                        return o.b.a;
                    }
                    case EXERCISE_TYPE_ESSAY: {
                        return o.b.b;
                    }
                    case EXERCISE_TYPE_SHORTANSWER: {
                        return o.b.c;
                    }
                    case EXERCISE_TYPE_MULTIANSWER: {
                        return o.b.d;
                    }
                    case EXERCISE_TYPE_MULTICHOICE: {
                        return o.b.e;
                    }
                    case EXERCISE_TYPE_SINGLECHOICE: {
                        return o.b.f;
                    }
                    case EXERCISE_TYPE_MARK: {
                        return o.b.g;
                    }
                    case EXERCISE_TYPE_WEBPAGE: {
                        return o.b.h;
                    }
                    case EXERCISE_TYPE_LEARNINGAPPS: {
                        return o.b.i;
                    }
                    case EXERCISE_TYPE_LMS: {
                        return o.b.j;
                    }
                    case EXERCISE_TYPE_HTML: {
                        return o.b.k;
                    }
                    case EXERCISE_TYPE_FLASHCARD: {
                        return o.b.l;
                    }
                    case EXERCISE_TYPE_SVG_EDIT: {
                        return o.b.m;
                    }
                    case EXERCISE_TYPE_MATCH_SINGLE_USE: {
                        return o.b.n;
                    }
                    case EXERCISE_TYPE_MATCH_REUSE: {
                        return o.b.o;
                    }
                    case EXERCISE_TYPE_MATCH_KEYBOARD: {
                        return o.b.p;
                    }
                    case EXERCISE_TYPE_MATCH_POSITION: {
                        return o.b.q;
                    }
                    case EXERCISE_TYPE_EXTERNAL_WEBPAGE: {
                        return o.b.r;
                    }
                    case EXERCISE_TYPE_IMAGEMAP_SINGLE: {
                        return o.b.s;
                    }
                    case EXERCISE_TYPE_IMAGEMAP_MULTI: {
                        return o.b.t;
                    }
                    case EXERCISE_TYPE_CROSSWORD: {
                        return o.b.u;
                    }
                    case EXERCISE_TYPE_SVG_EDIT_FULLSCREEN: {
                        return o.b.v;
                    }
                    case EXERCISE_TYPE_CHANGE_CASE: {
                        return o.b.w;
                    }
                    case EXERCISE_TYPE_INSERT_ELEMENT: {
                        return o.b.x;
                    }
                    case EXERCISE_TYPE_PLAINANSWER: {
                        return o.b.y;
                    }
                    case EXERCISE_TYPE_SKETCHPAD: {
                        return o.b.z;
                    }
                    case EXERCISE_TYPE_SKETCHPAD_FULLSCREEN: {
                        return o.b.A;
                    }
                    case EXERCISE_TYPE_COMMENT_SINGLECHOICE: {
                        return o.b.a;
                    }
                    case EXERCISE_TYPE_COMMENT_MULTICHOICE: {
                        return o.b.C;
                    }
                    case EXERCISE_TYPE_INTRODUCTION: {
                        return o.b.D;
                    }
                }
                return o.b.a;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not get ExerciseType as ExerciseModelDTO1 TypeEnum, exerciseType: " + (Object)((Object)this)), (Throwable)exception);
                return o.b.a;
            }
        }
    }
}

