/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPBookTypes;
import ch.ionesoft.ilp.book.co.ILPConfigurationManager;
import ch.ionesoft.ilp.book.co.ILPInstallationManager;
import ch.ionesoft.ilp.book.he.c;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAbstractProduct;
import ch.ionesoft.ilp.book.mo.ILPAssetProduct;
import ch.ionesoft.ilp.book.mo.ILPClassification;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPEProduct_Classification;
import ch.ionesoft.ilp.book.mo.ILPExerciseProduct;
import ch.ionesoft.ilp.book.mo.ILPIssueProduct;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPMandantConfig;
import ch.ionesoft.ilp.book.mo.ILPOrderSystem;
import ch.ionesoft.ilp.book.mo.ILPPermissionProduct;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.mo.ILPSkuMapping;
import ch.ionesoft.ilp.book.mo.ILPTopicProduct;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPEPRODUCT")
public class ILPEProduct
extends AbstractCoreDataModel
implements Comparable<ILPEProduct> {
    private static ILogger logger = ILPLogManager.getLogger(ILPEProduct.class);
    public static final String TABLE_NAME = "ZILPEPRODUCT";
    public static final String TABLE_FIELD_NAME = "ZEPRODUCT";
    public static final String PRODUCT_REFERENCE_FIELD_NAME = "ZPRODUCTREFERENCE";
    public static final String ACTIVE_FIELD_NAME = "ZACTIVE";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String PRODUCT_TYPE_FIELD_NAME = "ZPRODUCTTYPE";
    public static final String LANGUAGECODE_FIELD_NAME = "ZLANGUAGECODE";
    public static final String RELEASE_DATE_FIELD_NAME = "ZRELEASEDATE";
    public static final String AVAILABLE_FOR_FREE_FIELD_NAME = "ZAVAILABLEFORFREE";
    public static final String CONTENT_STATE_FIELD_NAME = "ZCONTENTSTATE";
    public static final String MD5_FIELD_NAME = "ZMD5";
    public static final String LICENSE_FK_FIELD_NAME = "ZLICENSE";
    public static final String MANDANT_CONFIG_FK_FIELD_NAME = "ZMANDANTCONFIG";
    @DatabaseField(columnName="ZPRODUCTREFERENCE", canBeNull=false, index=true, unique=true)
    private String productReference;
    @DatabaseField(columnName="ZACTIVE", canBeNull=false, index=true)
    private Boolean active = true;
    @DatabaseField(columnName="ZTITLE")
    private String title;
    @DatabaseField(columnName="ZPRODUCTTYPE", canBeNull=false, index=true)
    private Integer productType;
    @DatabaseField(columnName="ZLANGUAGECODE", index=true)
    private String languageCode;
    @DatabaseField(columnName="ZRELEASEDATE")
    private DateTime releaseDate;
    @DatabaseField(columnName="ZAVAILABLEFORFREE", index=true)
    private Boolean availableForFree;
    @DatabaseField(columnName="ZMD5", canBeNull=true)
    private String md5;
    @DatabaseField(columnName="ZCONTENTSTATE", canBeNull=true, index=true)
    private Integer contentState = ILPBookTypes.ContentState.CONTENT_STATE_UNDEFINED.getType();
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZLICENSE", index=true)
    private ILPLicense license;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZMANDANTCONFIG", index=true)
    private ILPMandantConfig mandantConfig;
    @ForeignCollectionField
    private ForeignCollection<ILPSkuMapping> skuMappings;
    @ForeignCollectionField
    private ForeignCollection<ILPProperty> properties;

    public ILPEProduct() {
    }

    public ILPEProduct(String string, Boolean bl2, Integer n2, Integer n3) throws SQLException {
        this();
        this.productReference = string;
        this.active = bl2;
        this.productType = n2;
        this.contentState = n3;
        this.buildMd5();
    }

    public String getProductReference() {
        return this.productReference;
    }

    public void setProductReference(String string) {
        this.productReference = string;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean bl2) {
        this.active = bl2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Integer getProductType() {
        return this.productType;
    }

    public ProductType getProductTypeEnum() {
        return ProductType.get(this.productType);
    }

    public void setProductType(Integer n2) {
        this.productType = n2;
    }

    public void setProductTypeEnum(ProductType productType) {
        this.productType = productType.type;
    }

    public DateTime getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(DateTime dateTime) {
        this.releaseDate = dateTime;
    }

    public Boolean getAvailableForFree() {
        return this.availableForFree;
    }

    public void setAvailableForFree(Boolean bl2) {
        this.availableForFree = bl2;
    }

    public ForeignCollection<ILPSkuMapping> getSkuMappings() {
        if (this.skuMappings == null) {
            try {
                g.a().ah().assignEmptyForeignCollection((Object)this, "skuMappings");
                this.skuMappings.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for eProduct.skuMappings", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.skuMappings;
    }

    public void setSkuMappings(ForeignCollection<ILPSkuMapping> foreignCollection) {
        this.skuMappings = foreignCollection;
    }

    public List<ILPSkuMapping> getSkuMappingsWithVendorUrl(ILPOrderSystem iLPOrderSystem) {
        ArrayList<ILPSkuMapping> arrayList = new ArrayList<ILPSkuMapping>();
        for (ILPSkuMapping iLPSkuMapping : this.getSkuMappings()) {
            if (!StringUtils.isNotEmpty((CharSequence)iLPSkuMapping.getUrl()) || (iLPOrderSystem == null || !iLPSkuMapping.getOrderSystem().equals(iLPOrderSystem)) && iLPOrderSystem != null) continue;
            arrayList.add(iLPSkuMapping);
        }
        return arrayList;
    }

    public ILPCourseProduct getCourseProduct() {
        return f.a().a(this);
    }

    public ILPCourseProduct determineCourseProduct() {
        try {
            ProductType productType = ProductType.get(this.getProductType());
            switch (productType) {
                case PRODUCT_TYPE_COURSE_PRODUCT: {
                    return this.getCourseProduct();
                }
                case PRODUCT_TYPE_ISSUE_PRODUCT: {
                    return this.getIssueProduct().getCourseProduct();
                }
                case PRODUCT_TYPE_TOPIC_PRODUCT: {
                    return this.getTopicProduct().getIssueProduct().getCourseProduct();
                }
                case PRODUCT_TYPE_EXERCISE_PRODUCT: {
                    if (this.getExerciseProduct().getCourseProduct() != null) {
                        return this.getExerciseProduct().getCourseProduct();
                    }
                    return this.getExerciseProduct().getIssueProduct().getCourseProduct();
                }
                case PRODUCT_TYPE_ASSET_PRODUCT: {
                    if (this.getAssetProduct().getCourseProduct() != null) {
                        return this.getAssetProduct().getCourseProduct();
                    }
                    return this.getAssetProduct().getIssueProduct().getCourseProduct();
                }
            }
            logger.d((Object)("No product type defined in eproduct: " + this));
            return null;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not determine courseProduct from eProduct: " + this), (Throwable)exception);
            return null;
        }
    }

    public ILPIssueProduct getIssueProduct() {
        return f.a().b(this);
    }

    public ILPTopicProduct getTopicProduct() {
        return f.a().c(this);
    }

    public ILPExerciseProduct getExerciseProduct() {
        return f.a().d(this);
    }

    public ILPAssetProduct getAssetProduct() {
        return f.a().e(this);
    }

    public ILPPermissionProduct getPermissionProduct() {
        return f.a().f(this);
    }

    public ILPLicense getLicense() {
        g.a().a(this.license);
        return this.license;
    }

    public void setLicense(ILPLicense iLPLicense) {
        this.license = iLPLicense;
    }

    public boolean hasLicence() {
        return this.license != null;
    }

    public ILPLicense determineLicense() {
        if (this.getProductImpl() != null) {
            return this.getProductImpl().determineLicense();
        }
        return null;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String string) {
        this.languageCode = string;
    }

    public ForeignCollection<ILPProperty> getProperties() {
        if (this.properties == null) {
            try {
                g.a().ah().assignEmptyForeignCollection((Object)this, "properties");
                this.properties.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for eproduct.properties", (Throwable)sQLException);
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.properties;
    }

    public void setProperties(ForeignCollection<ILPProperty> foreignCollection) {
        this.properties = foreignCollection;
    }

    public void pruneSpecificTargetPropertiesNamed(String string) {
        ArrayList<ILPProperty> arrayList = new ArrayList<ILPProperty>();
        if (this.getProperties() == null) {
            return;
        }
        ForeignCollection<ILPProperty> foreignCollection = this.getProperties();
        for (ILPProperty iLPProperty : foreignCollection) {
            if (iLPProperty.getTargetType().equals((Object)h.e.a) || !iLPProperty.getKey().equals(string)) continue;
            arrayList.add(iLPProperty);
        }
        try {
            g.a().Q().delete(arrayList);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not delete properties to be pruned having name: " + string), (Throwable)sQLException);
        }
    }

    public ILPProperty propertyForExactTarget_name(h.e e2, String string) throws j {
        ILPProperty iLPProperty = this.propertyWithName_defaultProperty(string, null);
        if (iLPProperty != null && iLPProperty.getTargetType().equals((Object)e2)) {
            return iLPProperty;
        }
        return null;
    }

    public ILPProperty propertyWithName_defaultProperty(String string, ILPProperty iLPProperty) {
        try {
            ILPProperty iLPProperty2 = f.a().a(this, string);
            if (iLPProperty2 == null) {
                iLPProperty2 = iLPProperty;
            }
            return iLPProperty2;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not fetch properties with name: " + string + " on EProduct: " + this), (Throwable)exception);
            return iLPProperty;
        }
    }

    public boolean propertyBooleanWithName_defaultValue(String string, boolean bl2) {
        ILPProperty iLPProperty = this.propertyWithName_defaultProperty(string, null);
        if (iLPProperty != null && StringUtils.isNotBlank((CharSequence)iLPProperty.getValue())) {
            try {
                return iLPProperty.boolValue();
            }
            catch (Exception exception) {
                logger.d((Object)("Could not parse property: " + string + ". Returning default: " + bl2), (Throwable)exception);
                return bl2;
            }
        }
        return bl2;
    }

    public float propertyFloatWithName_defaultValue(String string, float f2) {
        ILPProperty iLPProperty = this.propertyWithName_defaultProperty(string, null);
        if (iLPProperty != null && StringUtils.isNotBlank((CharSequence)iLPProperty.getValue())) {
            try {
                return iLPProperty.floatValue().floatValue();
            }
            catch (Exception exception) {
                logger.d((Object)("Could not parse property: " + string + ". Returning default: " + f2), (Throwable)exception);
                return f2;
            }
        }
        return f2;
    }

    public int propertyIntWithName_defaultValue(String string, int n2) {
        ILPProperty iLPProperty = this.propertyWithName_defaultProperty(string, null);
        if (iLPProperty != null && StringUtils.isNotBlank((CharSequence)iLPProperty.getValue())) {
            try {
                return iLPProperty.intValue();
            }
            catch (Exception exception) {
                logger.d((Object)("Could not parse property: " + string + ". Returning default: " + n2), (Throwable)exception);
                return n2;
            }
        }
        return n2;
    }

    public String propertyStringWithName_defaultValue(String string, String string2) {
        ILPProperty iLPProperty = this.propertyWithName_defaultProperty(string, null);
        if (iLPProperty != null && StringUtils.isNotBlank((CharSequence)iLPProperty.getValue())) {
            return iLPProperty.stringValue();
        }
        return string2;
    }

    public boolean hasPropertyWithName_value(String string, String string2) {
        ILPProperty iLPProperty = this.propertyWithName_defaultProperty(string, null);
        return iLPProperty != null && string2 == null && iLPProperty.getValue() == null || string2.equals(iLPProperty.getValue());
    }

    public boolean hasPropertyForTarget_name(h.e e2, String string) {
        ILPProperty iLPProperty = this.propertyWithName_defaultProperty(string, null);
        return iLPProperty != null;
    }

    public ILPMandantConfig getMandantConfig() {
        if (this.mandantConfig == null) {
            return null;
        }
        g.a().a(this.mandantConfig);
        if (!this.isCourseProduct() && this.mandantConfig == null) {
            return this.determineCourseProduct().getEProduct().getMandantConfig();
        }
        return this.mandantConfig;
    }

    public void setMandantConfig(ILPMandantConfig iLPMandantConfig) {
        this.mandantConfig = iLPMandantConfig;
    }

    public String getMandantId() {
        if (this.getMandantConfig() != null && this.getMandantConfig().getMandant() != null) {
            return this.getMandantConfig().getMandant().getMandantIdentifier();
        }
        return null;
    }

    public Integer getContentState() {
        return this.contentState;
    }

    public ILPBookTypes.ContentState getContentStateEnum() {
        if (this.contentState == null) {
            return ILPBookTypes.ContentState.CONTENT_STATE_UNDEFINED;
        }
        return ILPBookTypes.ContentState.get(this.contentState);
    }

    public void setContentState(Integer n2) {
        this.contentState = n2;
    }

    public void setContentState(ILPBookTypes.ContentState contentState) {
        this.contentState = contentState.getType();
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String string) {
        this.md5 = string;
    }

    public String buildMd5() {
        StringBuffer stringBuffer = new StringBuffer("_:s\u00f6SN\u2211");
        stringBuffer.append(this.getProductReference());
        stringBuffer.append(String.format(Locale.ENGLISH, "nc;%d", this.productType));
        stringBuffer.append(this.propertyStringWithName_defaultValue("AuthorizationAccessPolicy", ""));
        stringBuffer.append(this.propertyStringWithName_defaultValue("AuthorizationAccessPolicy.numberOfAllowedAccesses", ""));
        stringBuffer.append(this.propertyStringWithName_defaultValue("AuthorizationAccessPolicy.restrictedTag", ""));
        stringBuffer.append("^dfW0#UDKhaK0l");
        return StringHelper.md5hash((String)stringBuffer.toString());
    }

    public void updateMd5() {
        this.md5 = this.buildMd5();
    }

    public boolean verifyMd5() {
        if (this.md5 == null) {
            return false;
        }
        String string = this.buildMd5();
        boolean bl2 = this.md5.equals(string);
        if (!bl2) {
            logger.c((Object)String.format("Verification failed on EProduct: %s", this.getProductReference()));
        }
        return bl2;
    }

    public boolean hasAccessGranted() {
        return false;
    }

    public boolean isUpdateAvailable() {
        return this.getProductImpl().isUpdateAvailable();
    }

    public ILPAbstractProduct getProductImpl() {
        ProductType productType = this.getProductTypeEnum();
        if (productType == ProductType.PRODUCT_TYPE_COURSE_PRODUCT) {
            return this.getCourseProduct();
        }
        if (productType == ProductType.PRODUCT_TYPE_ISSUE_PRODUCT) {
            return this.getIssueProduct();
        }
        if (productType == ProductType.PRODUCT_TYPE_ASSET_PRODUCT) {
            return this.getAssetProduct();
        }
        if (productType == ProductType.PRODUCT_TYPE_EXERCISE_PRODUCT) {
            return this.getExerciseProduct();
        }
        if (productType == ProductType.PRODUCT_TYPE_TOPIC_PRODUCT) {
            return this.getTopicProduct();
        }
        if (productType == ProductType.PRODUCT_TYPE_PERMISSION_PRODUCT) {
            return this.getPermissionProduct();
        }
        logger.d((Object)("Undefinded productType: " + (Object)((Object)productType)));
        return null;
    }

    public boolean isCourseProduct() {
        return this.getProductTypeEnum().equals((Object)ProductType.PRODUCT_TYPE_COURSE_PRODUCT);
    }

    public boolean isIssueProduct() {
        return this.getProductTypeEnum().equals((Object)ProductType.PRODUCT_TYPE_ISSUE_PRODUCT);
    }

    public boolean isAssetProduct() {
        return this.getProductTypeEnum().equals((Object)ProductType.PRODUCT_TYPE_ASSET_PRODUCT);
    }

    public boolean isExerciseProduct() {
        return this.getProductTypeEnum().equals((Object)ProductType.PRODUCT_TYPE_EXERCISE_PRODUCT);
    }

    public boolean isTopicProduct() {
        return this.getProductTypeEnum().equals((Object)ProductType.PRODUCT_TYPE_TOPIC_PRODUCT);
    }

    public boolean isPermissionProduct() {
        return this.getProductTypeEnum().equals((Object)ProductType.PRODUCT_TYPE_PERMISSION_PRODUCT);
    }

    public boolean hasExcerpt() {
        if (this.isCourseProduct()) {
            return this.getCourseProduct().hasExcerpt();
        }
        if (this.isIssueProduct()) {
            return this.getIssueProduct().hasExcerpt();
        }
        if (this.isExerciseProduct()) {
            return this.getExerciseProduct().getExcerpt();
        }
        if (this.isTopicProduct()) {
            return this.getTopicProduct().getExcerpt();
        }
        if (this.isAssetProduct()) {
            return this.getAssetProduct().getExcerpt();
        }
        return false;
    }

    public boolean areAllLicensedSubProductsInstalled() {
        if (this.isCourseProduct()) {
            return this.getCourseProduct().areAllLicensedIssueProdcutsInstalled();
        }
        return true;
    }

    public boolean isLicenseAuthorized() {
        return this.getLicense() != null && this.getLicense().isLicenseAuthorized();
    }

    public void addClassificationObject(ILPClassification iLPClassification) throws SQLException {
        ILPEProduct_Classification iLPEProduct_Classification = new ILPEProduct_Classification(this, iLPClassification);
        g.a().X().create((Object)iLPEProduct_Classification);
    }

    public void removeClassificationsObject(ILPClassification iLPClassification) {
        f.a().a(iLPClassification, this);
    }

    public ILPClassification classificationForType_name(ILPClassification.ClassificationType classificationType, String string) throws j {
        return f.a().a(classificationType, string, this);
    }

    public List<ILPClassification> classificationsForType(ILPClassification.ClassificationType classificationType) {
        try {
            return f.a().a(classificationType, this);
        }
        catch (j j2) {
            logger.d((Object)("Could fetch classifications of course: " + this), (Throwable)j2);
            return new ArrayList<ILPClassification>();
        }
    }

    public boolean hasClassification(ILPClassification iLPClassification) {
        try {
            return iLPClassification.equals(this.classificationForType_name(iLPClassification.getClassificationType(), iLPClassification.getName()));
        }
        catch (j j2) {
            logger.d((Object)("Could not check for classification: " + iLPClassification + " on course: " + this), (Throwable)j2);
            return false;
        }
    }

    public boolean hasSublicensedChildren() {
        return false;
    }

    public boolean isFullyLoaded() {
        return this.getContentStateEnum().equals((Object)ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED);
    }

    public void install(c c2) {
        ILPInstallationManager iLPInstallationManager = new ILPInstallationManager();
        this.installCourseConfig(c2);
        iLPInstallationManager.installEProduct(this, c2);
    }

    public void installCourseConfig(c c2) {
        if (!this.isCourseConfigInstalled()) {
            ILPConfigurationManager iLPConfigurationManager = new ILPConfigurationManager();
            iLPConfigurationManager.downloadAndInstallCourseConfig(this.determineCourseProduct(), c2);
        } else {
            logger.b((Object)("Course config already installed: " + this.determineCourseProduct()));
        }
    }

    public void update(boolean bl2, c c2) {
        ILPInstallationManager iLPInstallationManager = new ILPInstallationManager();
        iLPInstallationManager.updateEProduct(this, bl2, c2);
    }

    public void uninstall(boolean bl2, c c2) {
        ILPInstallationManager iLPInstallationManager = new ILPInstallationManager();
        iLPInstallationManager.uninstallEProduct(this, bl2, c2);
    }

    public boolean isCourseConfigInstalled() {
        ILPCourseProduct iLPCourseProduct = this.determineCourseProduct();
        if (iLPCourseProduct != null) {
            try {
                g.a().aj().refresh((Object)iLPCourseProduct);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return iLPCourseProduct.getConfigCurrentVersion() != null;
        }
        return true;
    }

    public File getLocalFolder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "ILPEProduct [pk=" + this.pk + ", productType=" + this.getProductTypeEnum().getCode() + ", productReference=" + this.productReference + ", title=" + this.title + ", languageCode=" + this.languageCode + ", releaseDate=" + this.releaseDate + ", contentState=" + (Object)((Object)this.getContentStateEnum()) + "]";
    }

    public String shortInfo() {
        return "ILPEProduct [productType=" + this.getProductTypeEnum().getCode() + ", productReference=" + this.productReference + ", title=" + this.title + ", releaseDate=" + this.releaseDate + "]";
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.productReference == null ? 0 : this.productReference.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPEProduct iLPEProduct = (ILPEProduct)object;
        return !(this.productReference == null ? iLPEProduct.productReference != null : !this.productReference.equals(iLPEProduct.productReference));
    }

    @Override
    public int compareTo(ILPEProduct iLPEProduct) {
        if (this.getProductTypeEnum() == iLPEProduct.getProductTypeEnum()) {
            if (this.getProductTypeEnum() != ProductType.PRODUCT_TYPE_ISSUE_PRODUCT) {
                return this.getTitle().toLowerCase().compareTo(iLPEProduct.getTitle().toLowerCase());
            }
            return this.getIssueProduct().getIssueIdentifier().toLowerCase().compareTo(iLPEProduct.getIssueProduct().getIssueIdentifier().toLowerCase());
        }
        return this.getProductType() > iLPEProduct.getProductType() ? 1 : -1;
    }

    public static enum ProductType {
        PRODUCT_TYPE_COURSE_PRODUCT(0, "courseProduct"),
        PRODUCT_TYPE_ISSUE_PRODUCT(1, "issueProduct"),
        PRODUCT_TYPE_TOPIC_PRODUCT(2, "topicProduct"),
        PRODUCT_TYPE_EXERCISE_PRODUCT(3, "exerciseProduct"),
        PRODUCT_TYPE_ASSET_PRODUCT(4, "assetProduct"),
        PRODUCT_TYPE_PERMISSION_PRODUCT(5, "permissionProduct");

        private static final Map<Integer, ProductType> lookup;
        private final int type;
        private final String code;

        static {
            lookup = new HashMap<Integer, ProductType>();
            for (ProductType productType : EnumSet.allOf(ProductType.class)) {
                lookup.put(productType.getType(), productType);
            }
        }

        private ProductType(int n3, String string2) {
            this.type = n3;
            this.code = string2;
        }

        public static ProductType get(int n2) {
            return lookup.get(n2);
        }

        public int getType() {
            return this.type;
        }

        public String getCode() {
            return this.code;
        }
    }
}

