/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPEnvironment;
import ch.ionesoft.ilp.book.mo.ILPMandant;
import ch.ionesoft.ilp.book.msg.j;
import ch.ionesoft.ilp.book.msg.m;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@DatabaseTable(tableName="ZILPDESTINATIONDEFINITION")
public class ILPDestinationDefinition
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPDestinationDefinition.class);
    public static final String TABLE_NAME = "ZILPDESTINATIONDEFINITION";
    public static final String ID_FIELD_NAME = "ZID";
    public static final String INITIAL_POLLING_INTERVAL_FIELD_NAME = "ZINIINTERVAL";
    public static final String MINIMAL_POLLING_INTERVAL_FIELD_NAME = "ZMININTERVAL";
    public static final String MAXIMAL_POLLING_INTERVAL_FIELD_NAME = "ZMAXINTERVAL";
    public static final String PERMISSION_FIELD_NAME = "ZPERMISSION";
    public static final String SELECTOR_FIELD_NAME = "ZSELECTOR";
    public static final String CONSUME_MESSAGES_FIELD_NAME = "ZCONSUMEMESSAGES";
    public static final String MESSAGE_CONTENT_TYPE_FIELD_NAME = "ZMESSAGECONTENTTYPE";
    public static final String SLEEP_INTERVAL_FIELD_NAME = "ZSLEEPINTERVAL";
    public static final String DESTINATION_TITLE_FIELD_NAME = "ZDESTINATIONTITLE";
    public static final String DESTINATION_DESCRIPTION_FIELD_NAME = "ZDESTINATIONDESCRIPTION";
    public static final String DESTINATION_OWNER_FIELD_NAME = "ZDESTINATIONOWNER";
    public static final String DESTINATION_UID_FIELD_NAME = "ZDESTINATIONUID";
    public static final String DESTINATION_NAME_FIELD_NAME = "ZDESTINATIONNAME";
    public static final String DESTINATION_ALIAS_FIELD_NAME = "ZDESTINATIONALIAS";
    public static final String DESTINATION_DOMAIN_FIELD_NAME = "ZDESTINATIONDOMAIN";
    public static final String DESTINATION_JOIN_POLICY_FIELD_NAME = "ZDESTINATIONJOINPOLICY";
    public static final String DESTINATION_TYPE_FIELD_NAME = "ZDESTINATIONTYPE";
    public static final String DESTINATION_SEND_INTERVAL_FIELD_NAME = "ZDESTINATIONSENDINTERVAL";
    public static final String DESTINATION_RECEIVE_INTERVAL_FIELD_NAME = "ZDESTINATIONRECEIVEINTERVAL";
    public static final String STATUS_FIELD_NAME = "ZSTATUS";
    public static final String ENVIRONMENT_FK_FIELD_NAME = "ZENVIRONMENT";
    public static final String MANDANT_FK_FIELD_NAME = "ZMANDANT";
    public static final String COURSE_PRODUCT_FK_FIELD_NAME = "ZCOURSEPRODUCT";
    @DatabaseField(columnName="ZID", canBeNull=false, index=true)
    private String id;
    @DatabaseField(columnName="ZINIINTERVAL")
    private Integer iniPollingIntervalSec;
    @DatabaseField(columnName="ZMININTERVAL")
    private Integer minPollingIntervalSec;
    @DatabaseField(columnName="ZMAXINTERVAL")
    private Integer maxPollingIntervalSec;
    @DatabaseField(columnName="ZPERMISSION")
    private Integer permission;
    @DatabaseField(columnName="ZSELECTOR")
    private String selector;
    @DatabaseField(columnName="ZCONSUMEMESSAGES")
    private Boolean consumeMessages;
    @DatabaseField(columnName="ZMESSAGECONTENTTYPE", canBeNull=false)
    private Integer messageContentType;
    @DatabaseField(columnName="ZSLEEPINTERVAL")
    private Integer sleepIntervalSec;
    @DatabaseField(columnName="ZDESTINATIONTITLE")
    private String destinationTitle;
    @DatabaseField(columnName="ZDESTINATIONDESCRIPTION")
    private String destinationDescription;
    @DatabaseField(columnName="ZDESTINATIONOWNER")
    private String destinationOwner;
    @DatabaseField(columnName="ZDESTINATIONUID")
    private String destinationUid;
    @DatabaseField(columnName="ZDESTINATIONNAME")
    private String destinationName;
    @DatabaseField(columnName="ZDESTINATIONALIAS")
    private String destinationAlias;
    @DatabaseField(columnName="ZDESTINATIONDOMAIN")
    private String destinationDomain;
    @DatabaseField(columnName="ZDESTINATIONJOINPOLICY")
    private Integer destinationJoinPolicy;
    @DatabaseField(columnName="ZDESTINATIONTYPE")
    private Integer destinationType;
    @DatabaseField(columnName="ZDESTINATIONSENDINTERVAL")
    private Integer destinationSendIntervalSec;
    @DatabaseField(columnName="ZDESTINATIONRECEIVEINTERVAL")
    private Integer destinationReceiveIntervalSec;
    @DatabaseField(columnName="ZSTATUS")
    private Integer status;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZENVIRONMENT")
    private ILPEnvironment environment;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZMANDANT")
    private ILPMandant mandant;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZCOURSEPRODUCT")
    private ILPCourseProduct courseProduct;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Integer getIniPollingIntervalSec() {
        return this.iniPollingIntervalSec;
    }

    public void setIniPollingIntervalSec(Integer n2) {
        this.iniPollingIntervalSec = n2;
    }

    public Integer getMinPollingIntervalSec() {
        return this.minPollingIntervalSec;
    }

    public void setMinPollingIntervalSec(Integer n2) {
        this.minPollingIntervalSec = n2;
    }

    public Integer getMaxPollingIntervalSec() {
        return this.maxPollingIntervalSec;
    }

    public void setMaxPollingIntervalSec(Integer n2) {
        this.maxPollingIntervalSec = n2;
    }

    public ILPDestinationPermission getPermission() {
        if (this.permission == null) {
            return ILPDestinationPermission.PERMISSION_UNDEFINED;
        }
        return ILPDestinationPermission.get(this.permission);
    }

    public void setPermission(ILPDestinationPermission iLPDestinationPermission) {
        this.permission = iLPDestinationPermission.getCode();
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String string) {
        this.selector = string;
    }

    public Boolean getConsumeMessages() {
        return this.consumeMessages;
    }

    public void setConsumeMessages(Boolean bl2) {
        this.consumeMessages = bl2;
    }

    public m getMessageContentType() {
        if (this.messageContentType == null) {
            return m.a;
        }
        return m.a(this.messageContentType);
    }

    public void setMessageContentType(m m2) {
        this.messageContentType = m2.a();
    }

    public Integer getSleepIntervalSec() {
        return this.sleepIntervalSec;
    }

    public void setSleepIntervalSec(Integer n2) {
        this.sleepIntervalSec = n2;
    }

    public String getDestinationTitle() {
        return this.destinationTitle;
    }

    public void setDestinationTitle(String string) {
        this.destinationTitle = string;
    }

    public String getDestinationDescription() {
        return this.destinationDescription;
    }

    public void setDestinationDescription(String string) {
        this.destinationDescription = string;
    }

    public String getDestinationOwner() {
        return this.destinationOwner;
    }

    public void setDestinationOwner(String string) {
        this.destinationOwner = string;
    }

    public String getDestinationUid() {
        return this.destinationUid;
    }

    public void setDestinationUid(String string) {
        this.destinationUid = string;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String string) {
        this.destinationName = string;
    }

    public String getDestinationAlias() {
        return this.destinationAlias;
    }

    public void setDestinationAlias(String string) {
        this.destinationAlias = string;
    }

    public String getDestinationDomain() {
        return this.destinationDomain;
    }

    public void setDestinationDomain(String string) {
        this.destinationDomain = string;
    }

    public j.a getJoinPolicy() {
        if (this.destinationJoinPolicy == null) {
            return j.a.a;
        }
        return j.a.a(this.destinationJoinPolicy);
    }

    public void setJoinPolicy(j.a a2) {
        this.destinationJoinPolicy = a2.a();
    }

    public j.b getDestinationType() {
        if (this.destinationType == null) {
            return j.b.a;
        }
        return j.b.a(this.destinationType);
    }

    public void setDestinationType(j.b b2) {
        this.destinationType = b2.a();
    }

    public Integer getDestinationSendIntervalSec() {
        return this.destinationSendIntervalSec;
    }

    public void setDestinationSendIntervalSec(Integer n2) {
        this.destinationSendIntervalSec = n2;
    }

    public Integer getDestinationReceiveIntervalSec() {
        return this.destinationReceiveIntervalSec;
    }

    public void setDestinationReceiveIntervalSec(Integer n2) {
        this.destinationReceiveIntervalSec = n2;
    }

    public ILPDestinationDefinitionStatus getStatus() {
        if (this.status == null) {
            return ILPDestinationDefinitionStatus.DESTINATION_DEFINITION_STATUS_UNDEFINED;
        }
        return ILPDestinationDefinitionStatus.get(this.status);
    }

    public void setStatus(ILPDestinationDefinitionStatus iLPDestinationDefinitionStatus) {
        this.status = iLPDestinationDefinitionStatus.getCode();
    }

    public ILPEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ILPEnvironment iLPEnvironment) {
        this.environment = iLPEnvironment;
    }

    public ILPMandant getMandant() {
        return this.mandant;
    }

    public void setMandant(ILPMandant iLPMandant) {
        this.mandant = iLPMandant;
    }

    public ILPCourseProduct getCourseProduct() {
        return this.courseProduct;
    }

    public void setCourseProduct(ILPCourseProduct iLPCourseProduct) {
        this.courseProduct = iLPCourseProduct;
    }

    public boolean isDestinationDiscoverable() {
        if (StringUtils.isNotBlank((CharSequence)this.destinationAlias) && StringUtils.isNotBlank((CharSequence)this.destinationDomain)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.destinationOwner) && StringUtils.isNotBlank((CharSequence)this.destinationName)) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this.destinationUid);
    }

    public boolean isDestinationJoinable() {
        if (!this.isDestinationDiscoverable()) {
            return false;
        }
        return this.getPermission() != ILPDestinationPermission.PERMISSION_UNDEFINED;
    }

    public boolean isDestinationCreateable() {
        return StringUtils.isNotBlank((CharSequence)this.destinationName) && StringUtils.isNotBlank((CharSequence)this.destinationDomain) && this.getJoinPolicy() != j.a.a && this.getDestinationType() != j.b.a;
    }

    public boolean shouldJoinDestination() {
        return this.getStatus() == ILPDestinationDefinitionStatus.DESTINATION_DEFINITION_STATUS_JOIN_WAITING;
    }

    public boolean shouldCreateDestination() {
        return this.getStatus() == ILPDestinationDefinitionStatus.DESTINATION_DEFINITION_STATUS_CREATE_WAITING;
    }

    public void updateDefintionWithDestination(j j2) {
        this.setDestinationUid(j2.e());
        this.setDestinationName(j2.f());
        this.setDestinationTitle(j2.g());
        this.setDestinationAlias(j2.h());
        this.setDestinationDomain(j2.i());
        this.setDestinationOwner(j2.j());
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        if (this.destinationUid != null) {
            n3 = 31 * n3 + (this.destinationUid == null ? 0 : this.destinationUid.hashCode());
        } else if (this.destinationAlias != null && this.destinationDomain != null) {
            n3 = 31 * n3 + (this.destinationAlias == null ? 0 : this.destinationAlias.hashCode());
            n3 = 31 * n3 + (this.destinationDomain == null ? 0 : this.destinationDomain.hashCode());
        } else if (this.destinationName != null && this.destinationOwner != null) {
            n3 = 31 * n3 + (this.destinationName == null ? 0 : this.destinationName.hashCode());
            n3 = 31 * n3 + (this.destinationOwner == null ? 0 : this.destinationOwner.hashCode());
        }
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPDestinationDefinition iLPDestinationDefinition = (ILPDestinationDefinition)object;
        if (this.destinationUid != null && iLPDestinationDefinition.destinationUid != null && this.destinationUid.equals(iLPDestinationDefinition.destinationUid)) {
            return true;
        }
        if (this.destinationAlias != null && iLPDestinationDefinition.destinationAlias != null && this.destinationDomain != null && iLPDestinationDefinition.destinationDomain != null && this.destinationAlias.equals(iLPDestinationDefinition.destinationAlias) && this.destinationDomain.equals(iLPDestinationDefinition.destinationDomain)) {
            return true;
        }
        return this.destinationOwner != null && iLPDestinationDefinition.destinationOwner != null && this.destinationName != null && iLPDestinationDefinition.destinationName != null && this.destinationOwner.equals(iLPDestinationDefinition.destinationOwner) && this.destinationName.equals(iLPDestinationDefinition.destinationName);
    }

    @Override
    public String toString() {
        return "ILPDestinationDefinition [id=" + this.id + ", messageContentType=" + this.messageContentType + ", destinationOwner=" + this.destinationOwner + ", destinationUid=" + this.destinationUid + ", destinationName=" + this.destinationName + ", destinationAlias=" + this.destinationAlias + ", destinationDomain=" + this.destinationDomain + "]";
    }

    public static enum ILPDestinationDefinitionStatus {
        DESTINATION_DEFINITION_STATUS_UNDEFINED(0),
        DESTINATION_DEFINITION_STATUS_JOIN_WAITING(1),
        DESTINATION_DEFINITION_STATUS_JOIN_SUCCESSFUL(2),
        DESTINATION_DEFINITION_STATUS_CREATE_WAITING(3),
        DESTINATION_DEFINITION_STATUS_CREATE_SUCCESSFUL(4);

        private static final Map<Integer, ILPDestinationDefinitionStatus> lookup;
        private Integer code;

        static {
            lookup = new HashMap<Integer, ILPDestinationDefinitionStatus>();
            for (ILPDestinationDefinitionStatus iLPDestinationDefinitionStatus : EnumSet.allOf(ILPDestinationDefinitionStatus.class)) {
                lookup.put(iLPDestinationDefinitionStatus.getCode(), iLPDestinationDefinitionStatus);
            }
        }

        private ILPDestinationDefinitionStatus(Integer n3) {
            this.code = n3;
        }

        public Integer getCode() {
            return this.code;
        }

        public static ILPDestinationDefinitionStatus get(int n2) {
            try {
                return lookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined DestinationDefinitionStatus code: " + n2 + ", defaulting to " + DESTINATION_DEFINITION_STATUS_UNDEFINED.name()));
                return DESTINATION_DEFINITION_STATUS_UNDEFINED;
            }
        }

        public static ILPDestinationDefinitionStatus get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }

        public static ILPDestinationDefinitionStatus getByName(String string) {
            try {
                ILPDestinationDefinitionStatus iLPDestinationDefinitionStatus = ILPDestinationDefinitionStatus.valueOf(string);
                return iLPDestinationDefinitionStatus != null ? iLPDestinationDefinitionStatus : DESTINATION_DEFINITION_STATUS_UNDEFINED;
            }
            catch (Exception exception) {
                logger.d((Object)("ILPDestinationDefinitionStatus not found: " + string + " return default. UNDEFINED"), (Throwable)exception);
                return DESTINATION_DEFINITION_STATUS_UNDEFINED;
            }
        }
    }

    public static enum ILPDestinationPermission {
        PERMISSION_UNDEFINED(0, null),
        PERMISSION_READ(1, "READ"),
        PERMISSION_WRITE(2, "WRITE"),
        PERMISSION_READWRITE(3, "READWRITE");

        private static final Map<Integer, ILPDestinationPermission> codeLookup;
        private static final Map<String, ILPDestinationPermission> valueLookup;
        private Integer code;
        private String iaValue;

        static {
            codeLookup = new HashMap<Integer, ILPDestinationPermission>();
            valueLookup = new HashMap<String, ILPDestinationPermission>();
            for (ILPDestinationPermission iLPDestinationPermission : EnumSet.allOf(ILPDestinationPermission.class)) {
                codeLookup.put(iLPDestinationPermission.getCode(), iLPDestinationPermission);
            }
            for (ILPDestinationPermission iLPDestinationPermission : EnumSet.allOf(ILPDestinationPermission.class)) {
                valueLookup.put(iLPDestinationPermission.getIaValue(), iLPDestinationPermission);
            }
        }

        private ILPDestinationPermission(Integer n3, String string2) {
            this.code = n3;
            this.iaValue = string2;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getIaValue() {
            return this.iaValue;
        }

        public static ILPDestinationPermission get(int n2) {
            try {
                return codeLookup.get(n2);
            }
            catch (Exception exception) {
                logger.d((Object)("Undefined DestinationPermission code: " + n2 + ", defaulting to " + PERMISSION_UNDEFINED.name()));
                return PERMISSION_UNDEFINED;
            }
        }

        public static ILPDestinationPermission get(String string) {
            int n2 = Integer.parseInt(string);
            return codeLookup.get(n2);
        }

        public static ILPDestinationPermission getByName(String string) {
            try {
                ILPDestinationPermission iLPDestinationPermission = ILPDestinationPermission.valueOf(string);
                return iLPDestinationPermission != null ? iLPDestinationPermission : PERMISSION_UNDEFINED;
            }
            catch (Exception exception) {
                logger.d((Object)("ILPDestinationPermission not found: " + string + " return default. UNDEFINED"), (Throwable)exception);
                return PERMISSION_UNDEFINED;
            }
        }

        public static ILPDestinationPermission getByIaValue(String string) {
            ILPDestinationPermission iLPDestinationPermission = valueLookup.get(string);
            if (iLPDestinationPermission == null) {
                return PERMISSION_UNDEFINED;
            }
            return iLPDestinationPermission;
        }
    }
}

