/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.au.c;
import ch.ionesoft.ilp.book.au.e;
import ch.ionesoft.ilp.book.au.f;
import ch.ionesoft.ilp.book.au.g;
import ch.ionesoft.ilp.book.co.ILPBookTypes;
import ch.ionesoft.ilp.book.co.ILPInstallationManager;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPCourseDef_Group;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPGroup;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition_CourseDef;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.pe.j;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPCOURSEDEF")
public class ILPCourseDef
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPCourseDef.class);
    public static final String TABLE_NAME = "ZILPCOURSEDEF";
    public static final String COURSEID_FIELD_NAME = "ZCOURSEID";
    public static final String REFERENCE_FIELD_NAME = "ZREFERENCE";
    public static final String TITLE_FIELD_NAME = "ZTITLE";
    public static final String EDITION_FIELD_NAME = "ZEDITION";
    public static final String LANGUAGECODE_FIELD_NAME = "ZLANGUAGECODE";
    public static final String TABORDER_FIELD_NAME = "ZTABORDER";
    public static final String COURSE_PRODUCT_FK_FIELD_NAME = "ZILPCOURSEPRODUCT";
    @DatabaseField(columnName="ZCOURSEID", canBeNull=false, index=true)
    private String courseId;
    @DatabaseField(columnName="ZREFERENCE", canBeNull=false, index=true)
    private String reference;
    @DatabaseField(columnName="ZLANGUAGECODE", canBeNull=true, index=true)
    private String languageCode;
    @DatabaseField(columnName="ZTABORDER", canBeNull=true)
    private Integer tabOrder;
    @DatabaseField(columnName="ZEDITION", canBeNull=true, index=true)
    private Integer edition;
    @ForeignCollectionField(orderColumnName="ZORDER", eager=true)
    private ForeignCollection<ILPIssueDef> issues;
    @ForeignCollectionField(orderColumnName="ZCOURSEDEF")
    private ForeignCollection<ILPScenarioSpecification> scenarioSpecifications;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZILPCOURSEPRODUCT", index=true, canBeNull=false)
    private ILPCourseProduct courseProduct;
    private c.a authorizationAccessPolicy = null;

    public ILPCourseDef() {
    }

    public ILPCourseDef(String string, String string2) {
        this.courseId = string;
        this.reference = string2;
    }

    public ILPCourseDef(String string, String string2, ILPCourseProduct iLPCourseProduct) {
        this.courseId = string;
        this.reference = string2;
        this.courseProduct = iLPCourseProduct;
    }

    public ILPEProduct getEProduct() {
        return this.getCourseProduct().getEProduct();
    }

    public String getCourseId() {
        return this.courseId;
    }

    public void setCourseId(String string) {
        this.courseId = string;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public String getCourseId_reference() {
        return String.valueOf(this.courseId) + "_" + this.reference;
    }

    public String getAuthors() {
        return this.getCourseProduct().getAuthors();
    }

    public String getAuthorsAsHtml() {
        String string = this.getAuthors() != null ? this.getAuthors() : "";
        string = StringHelper.trim((String)string.replace("\n", "<br/>"));
        while (string.trim().startsWith("<br/>")) {
            string = StringHelper.extractStringFrom_after((String)string, (String)"<br/>");
        }
        return string;
    }

    public DateTime getPublishDate() {
        return this.getCourseProduct().getPublishDate();
    }

    public String getPrintCode() {
        return this.getCourseProduct().getPrintCode();
    }

    public String getTitle() {
        return this.getCourseProduct().getTitle();
    }

    public Integer getTabOrder() {
        return this.tabOrder;
    }

    public void setTabOrder(Integer n2) {
        this.tabOrder = n2;
    }

    public Integer getEdition() {
        if (this.edition == null) {
            return 0;
        }
        return this.edition;
    }

    public void setEdition(Integer n2) {
        this.edition = n2;
    }

    public ILPCourseProduct getCourseProduct() {
        ch.ionesoft.ilp.book.pe.g.a().a(this.courseProduct);
        return this.courseProduct;
    }

    public void setCourseProduct(ILPCourseProduct iLPCourseProduct) {
        this.courseProduct = iLPCourseProduct;
    }

    public String getPrintCodeOrEdition() {
        return StringUtils.isNotBlank((CharSequence)this.getPrintCode()) ? this.getPrintCode() : "" + this.getEdition();
    }

    public ForeignCollection<ILPIssueDef> getIssues() {
        if (this.issues == null) {
            try {
                ch.ionesoft.ilp.book.pe.g.a().E().assignEmptyForeignCollection((Object)this, "issues");
                this.issues.refreshCollection();
                this.issues.refreshAll();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for course.issues", (Throwable)sQLException);
            }
        }
        return this.issues;
    }

    public void setIssues(ForeignCollection<ILPIssueDef> foreignCollection) {
        this.issues = foreignCollection;
    }

    public ForeignCollection<ILPScenarioSpecification> getScenarioSpecifications() {
        if (this.scenarioSpecifications == null) {
            try {
                ch.ionesoft.ilp.book.pe.g.a().E().assignEmptyForeignCollection((Object)this, "scenarioSpecifications");
                this.scenarioSpecifications.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for course.scenarioSpecifications", (Throwable)sQLException);
            }
        }
        return this.scenarioSpecifications;
    }

    public void setScenarioSpecifications(ForeignCollection<ILPScenarioSpecification> foreignCollection) {
        this.scenarioSpecifications = foreignCollection;
    }

    public void refreshIssuesCollection() {
        this.issues = null;
    }

    public ILPIssueDef firstIssue() {
        try {
            return ch.ionesoft.ilp.book.pe.f.a().d(this);
        }
        catch (j j2) {
            logger.d((Object)("Could not fetch first issue of course: " + this), (Throwable)j2);
            return null;
        }
    }

    public ILPIssueDef getForceLoadIssue() {
        String string = this.getEProduct().propertyStringWithName_defaultValue("forceLoadIssueId", null);
        if (string != null) {
            try {
                return ch.ionesoft.ilp.book.pe.f.a().d(string, this.getCourseId(), this.getReference());
            }
            catch (j j2) {
                logger.d((Object)("Could not fetch forceLoad issue with issueId: " + string + " for coruse: " + this), (Throwable)j2);
            }
        }
        return null;
    }

    public boolean isCourseBased() {
        return this.getCourseProduct().getCourseSeries().isCourseBased();
    }

    public boolean isIssueBased() {
        return !this.isCourseBased();
    }

    public boolean hasSplittedIssues() {
        return this.getEProduct().propertyStringWithName_defaultValue("issueAutoSplit", null) != null || this.getEProduct().propertyStringWithName_defaultValue("issueSplitExpression", null) != null || this.getEProduct().propertyStringWithName_defaultValue("issueSplitLevel", null) != null;
    }

    public ForeignCollection<ILPProperty> getProperties() {
        return this.courseProduct.getProperties();
    }

    public void addGrantedGroupObject(ILPGroup iLPGroup) throws SQLException {
        ILPCourseDef_Group iLPCourseDef_Group = new ILPCourseDef_Group(this, iLPGroup);
        ch.ionesoft.ilp.book.pe.g.a().Y().create((Object)iLPCourseDef_Group);
    }

    public void removeGrantedGroupObject(ILPGroup iLPGroup) {
        ch.ionesoft.ilp.book.pe.f.a().a(iLPGroup, this);
    }

    public String getMandantId() {
        return this.getCourseProduct().getMandantId();
    }

    public String getLanguageCode() {
        return StringUtils.isNotBlank((CharSequence)this.languageCode) ? this.languageCode : "DE";
    }

    public void setLanguageCode(String string) {
        this.languageCode = string;
    }

    public String getIsbnOrReference() {
        return this.getCourseProduct().getIsbnOrReference();
    }

    public String getProductReference() {
        return this.getCourseProduct().getProductReference();
    }

    public void updateContentState() {
        ILPInstallationManager iLPInstallationManager = new ILPInstallationManager();
        iLPInstallationManager.rebuildContentStates(this.getEProduct());
    }

    public boolean hasExcerpt() {
        return this.getCourseProduct().hasExcerpt();
    }

    public ILPProperty propertyWithName_defaultProperty(String string, ILPProperty iLPProperty) {
        return this.getEProduct().propertyWithName_defaultProperty(string, iLPProperty);
    }

    public boolean propertyBooleanWithName_defaultValue(String string, boolean bl2) {
        return this.getEProduct().propertyBooleanWithName_defaultValue(string, bl2);
    }

    public float propertyFloatWithName_defaultValue(String string, float f2) {
        return this.getEProduct().propertyFloatWithName_defaultValue(string, f2);
    }

    public int propertyIntWithName_defaultValue(String string, int n2) {
        return this.getEProduct().propertyIntWithName_defaultValue(string, n2);
    }

    public String propertyStringWithName_defaultValue(String string, String string2) {
        return this.getEProduct().propertyStringWithName_defaultValue(string, string2);
    }

    public c.a getAuthorizationAccessPolicy() {
        if (this.authorizationAccessPolicy == null) {
            this.authorizationAccessPolicy = this.createAuthorizationPolicyFromPropertiesOfCourse();
        }
        return this.authorizationAccessPolicy;
    }

    public void setAuthorizationAccessPolicy(c.a a2) {
        this.authorizationAccessPolicy = a2;
    }

    public c.a createAuthorizationPolicyFromPropertiesOfCourse() {
        String string = this.getEProduct().propertyStringWithName_defaultValue("AuthorizationAccessPolicy", "ILPRestrictedNumberPolicy");
        int n2 = this.getEProduct().propertyIntWithName_defaultValue("AuthorizationAccessPolicy.numberOfAllowedAccesses", 10);
        boolean bl2 = this.getEProduct().propertyBooleanWithName_defaultValue("AuthorizationAccessPolicy.countPerIssue", false);
        String string2 = this.getEProduct().propertyStringWithName_defaultValue("AuthorizationAccessPolicy.restrictedTag", null);
        if (string.equals("ILPRestrictedNumberPolicy")) {
            return f.a(n2, bl2);
        }
        if (string.equals("ILPRestrictedAccessAllTopicsPolicy")) {
            return e.a(string2);
        }
        if (string.equals("ILPUnrestrictedAccessPolicy")) {
            return g.d();
        }
        logger.d((Object)String.format(Locale.ENGLISH, "Undefined authorizationAccessPolicy: %s", string));
        return null;
    }

    public void addScenarioDefinitionObject(ILPScenarioDefinition iLPScenarioDefinition) throws SQLException {
        ILPScenarioDefinition_CourseDef iLPScenarioDefinition_CourseDef = new ILPScenarioDefinition_CourseDef(iLPScenarioDefinition, this);
        ch.ionesoft.ilp.book.pe.g.a().aR().create((Object)iLPScenarioDefinition_CourseDef);
    }

    public boolean isFixedLayout() {
        return this.getCourseProduct().isFixedLayout();
    }

    public boolean hasEditableFields() {
        return this.getCourseProduct().hasEditableFields();
    }

    public boolean hasSyncData() {
        boolean bl2 = false;
        for (ILPIssueDef iLPIssueDef : this.getIssues()) {
            if (iLPIssueDef.getLastSync() == null) continue;
            return true;
        }
        return bl2;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.courseId == null ? 0 : this.courseId.hashCode());
        n3 = 31 * n3 + (this.reference == null ? 0 : this.reference.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPCourseDef iLPCourseDef = (ILPCourseDef)object;
        if (this.courseId == null ? iLPCourseDef.courseId != null : !this.courseId.equals(iLPCourseDef.courseId)) {
            return false;
        }
        return !(this.reference == null ? iLPCourseDef.reference != null : !this.reference.equals(iLPCourseDef.reference));
    }

    @Override
    public String toString() {
        return "ILPCourseDef [courseId=" + this.courseId + ", reference=" + this.reference + ", productReference=" + this.getProductReference() + ", pk=" + this.pk + "]";
    }

    public boolean isFullyLoaded() {
        if (this.getCourseProduct() == null) {
            return false;
        }
        if (this.getCourseProduct().getEProduct() == null) {
            return false;
        }
        return this.getCourseProduct().getEProduct().isFullyLoaded();
    }

    public boolean isNotLoaded() {
        if (this.getCourseProduct() == null) {
            return false;
        }
        if (this.getCourseProduct().getEProduct() == null) {
            return false;
        }
        ILPBookTypes.ContentState contentState = this.getCourseProduct().getEProduct().getContentStateEnum();
        return ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED.equals((Object)contentState) || ILPBookTypes.ContentState.CONTENT_STATE_UNDEFINED.equals((Object)contentState);
    }

    public boolean isETest() {
        return this.propertyBooleanWithName_defaultValue("eTest", false);
    }
}

