/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@DatabaseTable(tableName="ZILPCLASSIFICATION")
public class ILPClassification
extends AbstractCoreDataModel
implements Comparable<ILPClassification> {
    public static String CLASSIFICATION_FEATURE_PRINT_PAGE = "printPage";
    private static ILogger logger = ILPLogManager.getLogger(ILPClassification.class);
    public static final String CLASSIFICATION_TYPE_XML_EXPORT_PREFIX = "classificationType_";
    public static final String TABLE_NAME = "ZILPCLASSIFICATION";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String NAME_FIELD_NAME = "ZNAME";
    public static final String MANDANTID_FIELD_NAME = "ZMANDANTID";
    public static final String LANGUAGECODE_FIELD_NAME = "ZLANGUAGECODE";
    public static final String ORDER_FIELD_NAME = "ZORDER";
    private static final int MAX_LOCALIZED_TYPE_LENGTH = 5;
    @DatabaseField(columnName="ZTYPE", canBeNull=false, index=true)
    private Integer type;
    @DatabaseField(columnName="ZNAME", canBeNull=false, index=true)
    private String name;
    @DatabaseField(columnName="ZMANDANTID", canBeNull=true, index=true)
    private String mandantId;
    @DatabaseField(columnName="ZLANGUAGECODE", canBeNull=true, index=true)
    private String languageCode;
    @DatabaseField(columnName="ZORDER", canBeNull=true, index=true)
    private Integer order;

    public Integer getType() {
        g.a().b(this);
        return this.type;
    }

    public ClassificationType getClassificationType() {
        return ClassificationType.get(this.getType());
    }

    public void setType(Integer n2) {
        this.type = n2;
    }

    public void setClassificationType(ClassificationType classificationType) {
        this.type = classificationType.getCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getMandantId() {
        g.a().b(this);
        return this.mandantId;
    }

    public void setMandantId(String string) {
        this.mandantId = string;
    }

    public String getLanguageCode() {
        g.a().b(this);
        return this.languageCode;
    }

    public void setLanguageCode(String string) {
        this.languageCode = string;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer n2) {
        this.order = n2;
    }

    public String localizedName() {
        g.a().b(this);
        String string = ch.ionesoft.ilp.base.co.g.b((String)"label.classification.", (String)this.name);
        return !string.startsWith("label.classification") ? string : this.name;
    }

    public String localizedType() {
        String string = ch.ionesoft.ilp.base.co.g.b((String)"label.classification.", (String)String.format(Locale.ENGLISH, "%s", this.type));
        return string;
    }

    public String localizedTypeAbbrev() {
        String string = this.localizedType();
        if (string.length() > 5) {
            string = string.substring(5);
        }
        return string;
    }

    @Override
    public int compareTo(ILPClassification iLPClassification) {
        if (this.getOrder() != null) {
            if (iLPClassification.getOrder() == null) {
                return -1;
            }
            return this.getOrder().compareTo(iLPClassification.getOrder());
        }
        if (iLPClassification.getOrder() != null) {
            return 1;
        }
        return this.getName().compareTo(iLPClassification.getName());
    }

    public List<ILPExercise> getRelatedExercises(String string, ILPExercise.ExerciseGroup exerciseGroup, ILPIssueDef iLPIssueDef) {
        try {
            return g.a().a(this, string, exerciseGroup, iLPIssueDef);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not fetch exercises of classification: " + this), (Throwable)sQLException);
            return null;
        }
    }

    public List<ILPTopic> getRelatedTopics(ILPIssueDef iLPIssueDef) {
        try {
            return g.a().a(this, iLPIssueDef);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not fetch topics of classification: " + this), (Throwable)sQLException);
            return null;
        }
    }

    public List<ILPEProduct> getRelatedEProducts() {
        try {
            return g.a().a(this);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not fetch eProducts of classification: " + this), (Throwable)sQLException);
            return null;
        }
    }

    @Override
    public String toString() {
        return "ILPClassification [type=" + this.type + ", name=" + this.name + ", mandantId=" + this.mandantId + ", languageCode=" + this.languageCode + "]";
    }

    public static enum ClassificationType {
        CLASSIFICATION_TYPE_NONE(0),
        CLASSIFICATION_TYPE_ASPECT(1),
        CLASSIFICATION_TYPE_CATEGORY(2),
        CLASSIFICATION_TYPE_LOCATION(3),
        CLASSIFICATION_TYPE_EXERCISE_CATEGORY(4),
        CLASSIFICATION_TYPE_FEATURE(5),
        CLASSIFICATION_TYPE_COMPETENCE_NUMBER(6),
        CLASSIFICATION_TYPE_ASPECT_FILTER_2(7);

        private static final Map<Integer, ClassificationType> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, ClassificationType>();
            for (ClassificationType classificationType : EnumSet.allOf(ClassificationType.class)) {
                lookup.put(classificationType.getCode(), classificationType);
            }
        }

        private ClassificationType(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static ClassificationType get(Integer n2) {
            if (lookup.containsKey(n2)) {
                return lookup.get(n2);
            }
            return CLASSIFICATION_TYPE_NONE;
        }

        public static ClassificationType get(String string) {
            try {
                int n2 = Integer.parseInt(string);
                return lookup.get(n2);
            }
            catch (NumberFormatException numberFormatException) {
                logger.d((Object)("Unknown classification type: " + string));
                return CLASSIFICATION_TYPE_NONE;
            }
        }

        public static ClassificationType getByName(String string) {
            if ("CLASSIFICATION_TYPE_NONE".equalsIgnoreCase(string)) {
                return CLASSIFICATION_TYPE_NONE;
            }
            if ("CLASSIFICATION_TYPE_ASPECT".equalsIgnoreCase(string)) {
                return CLASSIFICATION_TYPE_ASPECT;
            }
            if ("CLASSIFICATION_TYPE_CATEGORY".equalsIgnoreCase(string)) {
                return CLASSIFICATION_TYPE_CATEGORY;
            }
            if ("CLASSIFICATION_TYPE_LOCATION".equalsIgnoreCase(string)) {
                return CLASSIFICATION_TYPE_LOCATION;
            }
            if ("CLASSIFICATION_TYPE_EXERCISE_CATEGORY".equalsIgnoreCase(string)) {
                return CLASSIFICATION_TYPE_EXERCISE_CATEGORY;
            }
            if ("CLASSIFICATION_TYPE_FEATURE".equalsIgnoreCase(string)) {
                return CLASSIFICATION_TYPE_FEATURE;
            }
            if ("CLASSIFICATION_TYPE_COMPETENCE_NUMBER".equalsIgnoreCase(string)) {
                return CLASSIFICATION_TYPE_COMPETENCE_NUMBER;
            }
            logger.c((Object)("No classificationType found for string: " + string));
            return CLASSIFICATION_TYPE_NONE;
        }
    }
}

