/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.book.mo.ILPAbstractDefinition;
import ch.ionesoft.ilp.book.mo.ILPAssetProduct;
import ch.ionesoft.ilp.book.mo.ILPAssetTypeDefinition;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPIssueProduct;
import ch.ionesoft.ilp.book.mo.ILPResource;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPASSETDEFINITION")
public class ILPAssetDefinition
extends ILPAbstractDefinition {
    private static ILogger logger = ILPLogManager.getLogger(ILPAssetDefinition.class);
    public static final String FILE_DATE_FIELD_NAME = "ZFILEDATE";
    public static final String CONTENT_LOADED_FIELD_NAME = "ZCONTENTLOADED";
    public static final String IDENTIFIER_FIELD_NAME = "ZIDENTIFIER";
    public static final String STATUS_FIELD_NAME = "ZSTATUS";
    public static final String MEDIA_TYPE_FIELD_NAME = "ZMEDIATYPE";
    public static final String VARIANT_FIELD_NAME = "ZVARIANT";
    public static final String RELATIVE_FILEPATH_FIELD_NAME = "ZFILEPATH";
    public static final String FILE_SIZE_BYTES_FIELD_NAME = "ZFILESIZEBYTES";
    public static final String ASSET_PRODUCT_FK_FIELD_NAME = "ZASSETPRODUCT";
    public static final String ASSET_TYPE_DEFINITION_FK_FIELD_NAME = "ZASSETTYPEDEFINITION";
    public static final String FILE_REFERENCE_FIELD_NAME = "ZFILEREFERENCE";
    @DatabaseField(columnName="ZFILEREFERENCE", canBeNull=false, index=true, unique=true)
    private String fileReference;
    @DatabaseField(columnName="ZIDENTIFIER", index=true)
    private String identifier;
    @DatabaseField(columnName="ZSTATUS")
    private Integer status;
    @DatabaseField(columnName="ZMEDIATYPE")
    private String mediaType;
    @DatabaseField(columnName="ZVARIANT")
    private String variant;
    @DatabaseField(columnName="ZFILEPATH", canBeNull=false)
    private String relativeFilePath;
    @DatabaseField(columnName="ZFILESIZEBYTES")
    private Long fileSizeBytes;
    @DatabaseField(columnName="ZFILEDATE", canBeNull=true)
    private DateTime fileDate;
    @DatabaseField(columnName="ZCONTENTLOADED", canBeNull=false, index=true)
    private Boolean contentLoaded = false;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZASSETPRODUCT", index=true, canBeNull=false)
    private ILPAssetProduct assetProduct;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZASSETTYPEDEFINITION", canBeNull=false)
    private ILPAssetTypeDefinition assetTypeDefinition;
    @ForeignCollectionField
    private ForeignCollection<ILPResource> resources;

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer n2) {
        this.status = n2;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String string) {
        this.variant = string;
    }

    public Long getFileSizeBytes() {
        return this.fileSizeBytes;
    }

    public void setFileSizeBytes(Long l2) {
        this.fileSizeBytes = l2;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String string) {
        this.mediaType = string;
    }

    public DateTime getFileDate() {
        return this.fileDate;
    }

    public void setFileDate(DateTime dateTime) {
        this.fileDate = dateTime;
    }

    public Boolean getContentLoaded() {
        return this.contentLoaded;
    }

    public void setContentLoaded(Boolean bl2) {
        this.contentLoaded = bl2;
    }

    public ForeignCollection<ILPResource> getResources() {
        return this.resources;
    }

    public void setResources(ForeignCollection<ILPResource> foreignCollection) {
        this.resources = foreignCollection;
    }

    public ILPAssetProduct getAssetProduct() {
        return this.assetProduct;
    }

    public void setAssetProduct(ILPAssetProduct iLPAssetProduct) {
        this.assetProduct = iLPAssetProduct;
    }

    public ILPAssetTypeDefinition getAssetTypeDefinition() {
        return this.assetTypeDefinition;
    }

    public void setAssetTypeDefinition(ILPAssetTypeDefinition iLPAssetTypeDefinition) {
        this.assetTypeDefinition = iLPAssetTypeDefinition;
    }

    public String getRelativeFilePath() {
        return this.relativeFilePath;
    }

    public void setRelativeFilePath(String string) {
        this.relativeFilePath = string;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(String string) {
        this.fileReference = string;
    }

    public File getLocalFilePath() {
        String string = this.getAssetTypeDefinition().getLocalDir();
        if (StringUtils.isBlank((CharSequence)string)) {
            return new File(h.v(), this.getFileReference());
        }
        String string2 = string;
        ILPCourseProduct iLPCourseProduct = this.getCourseProduct();
        ILPIssueProduct iLPIssueProduct = this.getIssueProduct();
        string2 = string2.replace("${resourceSynch}", h.q().getAbsolutePath());
        string2 = string2.replace("${mediaEdit}", h.L().getAbsolutePath());
        if (iLPCourseProduct != null) {
            string2 = string2.replace("${courseId}", iLPCourseProduct.getCourseIdentifier());
            string2 = string2.replace("${courseReference}", iLPCourseProduct.getCourseReference());
        }
        if (iLPIssueProduct != null) {
            string2 = string2.replace("${issueId}", iLPIssueProduct.getIssueIdentifier());
            string2 = string2.replace("${issueReference}", iLPIssueProduct.getIssueReference());
        }
        return new File(string2);
    }

    public boolean isMediaEdit() {
        return this.getAssetTypeDefinition().getAssetTypeDefinitionIdentifier().equals("MEDIA-EDIT");
    }

    public boolean isLocalFilePathEmpty() {
        return StringUtils.isBlank((CharSequence)this.getAssetTypeDefinition().getLocalDir());
    }

    public ILPIssueProduct getIssueProduct() {
        return this.getAssetProduct().getIssueProduct();
    }

    public ILPCourseProduct getCourseProduct() {
        ILPIssueProduct iLPIssueProduct = this.getIssueProduct();
        if (iLPIssueProduct != null) {
            return iLPIssueProduct.getCourseProduct();
        }
        return this.getAssetProduct().getCourseProduct();
    }
}

