/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.f;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.mo.AbstractSharingModel;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPLink;
import ch.ionesoft.ilp.book.mo.ILPQuestion;
import ch.ionesoft.ilp.book.mo.ILPSharing;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

@DatabaseTable(tableName="ZILPANSWER")
public class ILPAnswer
extends AbstractSharingModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPAnswer.class);
    public static final String TABLE_NAME = "ZILPANSWER";
    public static final String CORRECT_FIELD_NAME = "ZCORRECT";
    public static final String LASTUPDATE_FIELD_NAME = "ZLASTUPDATE";
    public static final String FEEDBACKTEXT_FIELD_NAME = "ZFEEDBACKTEXT";
    public static final String REFERENCE_FIELD_NAME = "ZREFERENCE";
    public static final String TEXT_FIELD_NAME = "ZTEXT";
    public static final String TYPE_FIELD_NAME = "ZTYPE";
    public static final String NUMBER_FIELD_NAME = "ZNUMBER";
    public static final String ANSWERTIMESECS_FIELD_NAME = "ZANSWERTIMESECS";
    public static final String EASYNESS_FIELD_NAME = "ZEASYNESS";
    public static final String REPETITIONINDAYS_FIELD_NAME = "ZREPETITIONINDAYS";
    public static final String SCORE_FIELD_NAME = "ZSCORE";
    public static final String ANSWERDELETED_FIELD_NAME = "ZANSWERDELETED";
    public static final String QUESTION_FK_FIELD_NAME = "ZQUESTION";
    @DatabaseField(columnName="ZCORRECT", canBeNull=true, index=true)
    private Boolean correct;
    @DatabaseField(columnName="ZLASTUPDATE", canBeNull=true)
    private DateTime lastUpdate;
    @DatabaseField(columnName="ZFEEDBACKTEXT", canBeNull=true)
    private String feedbackText;
    @DatabaseField(columnName="ZREFERENCE", canBeNull=true, index=true)
    private String reference;
    @DatabaseField(columnName="ZTEXT", canBeNull=true)
    private String text;
    @DatabaseField(columnName="ZTYPE", canBeNull=true, index=true)
    private Integer type;
    @DatabaseField(columnName="ZNUMBER", canBeNull=true, index=true)
    private Integer number;
    @DatabaseField(columnName="ZANSWERTIMESECS", canBeNull=true)
    private Float answerTimeSecs;
    @DatabaseField(columnName="ZEASYNESS", canBeNull=true)
    private Float easyness;
    @DatabaseField(columnName="ZREPETITIONINDAYS", canBeNull=true)
    private Float repetitionInDays;
    @DatabaseField(columnName="ZSCORE", canBeNull=true)
    private Float score;
    @DatabaseField(columnName="ZANSWERDELETED", canBeNull=true, index=true)
    private Boolean answerDeleted;
    @DatabaseField(foreign=true, foreignAutoRefresh=true, maxForeignAutoRefreshLevel=3, columnName="ZQUESTION", index=true)
    private ILPQuestion question;
    @ForeignCollectionField
    private ForeignCollection<ILPLink> links;

    public Boolean isCorrect() {
        return this.correct;
    }

    public Boolean isCorrectValue() {
        if (this.correct != null && this.correct.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setCorrect(Boolean bl2) {
        this.correct = bl2;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(DateTime dateTime) {
        this.lastUpdate = dateTime;
    }

    public void setLastUpdate(Date date) {
        this.lastUpdate = date != null ? new DateTime((Object)date) : null;
    }

    public String getFeedbackText() {
        return this.feedbackText;
    }

    public void setFeedbackText(String string) {
        this.feedbackText = string;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public String getText() {
        return ILPBookSettingsHelper.instance().decryptAnswerText_forAnswer(this.text, this);
    }

    public String getEncryptedText() {
        return this.text;
    }

    public void setText(String string) {
        String string2;
        try {
            if (StringUtils.isNotBlank((CharSequence)string) && this.isAnswerDeleted().booleanValue() && this.getQuestion().getExercise().getExerciseType() != ILPExercise.ExerciseType.EXERCISE_TYPE_CROSSWORD) {
                this.answerDeleted = false;
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not set answerDeleted to false in answer: " + this), (Throwable)exception);
        }
        this.text = string2 = ILPBookSettingsHelper.instance().encryptAnswerText_forAnswer(string, this);
    }

    public void setEncryptedText(String string) {
        this.text = string;
    }

    public Integer getType() {
        return this.type;
    }

    public AnswerType getAnswerType() {
        return AnswerType.get(this.type);
    }

    public void setType(Integer n2) {
        this.type = n2;
    }

    public void setAnswerType(AnswerType answerType) {
        this.type = answerType.getCode();
    }

    public ILPQuestion getQuestion() {
        return this.question;
    }

    public void setQuestion(ILPQuestion iLPQuestion) {
        this.question = iLPQuestion;
    }

    public Float getAnswerTimeSecs() {
        return this.answerTimeSecs;
    }

    public void setAnswerTimeSecs(Float f2) {
        this.answerTimeSecs = f2;
    }

    public Float getEasyness() {
        return this.easyness;
    }

    public void setEasyness(Float f2) {
        this.easyness = f2;
    }

    public Float getRepetitionInDays() {
        return this.repetitionInDays;
    }

    public void setRepetitionInDays(Float f2) {
        this.repetitionInDays = f2;
    }

    public Float getScore() {
        return this.score;
    }

    public void setScore(Float f2) {
        this.score = f2;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer n2) {
        this.number = n2;
    }

    public Boolean getAnswerDeleted() {
        return this.answerDeleted;
    }

    public Boolean isAnswerDeleted() {
        if (this.answerDeleted != null && this.answerDeleted.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setAnswerDeleted(Boolean bl2) {
        this.answerDeleted = bl2;
    }

    public void migrateAnswerReferenceInText(String string) {
        String string2 = this.getText();
        if (StringUtils.isBlank((CharSequence)string2)) {
            return;
        }
        try {
            if (!string2.startsWith(this.getQuestion().getReference())) {
                string2 = StringHelper.extractPostfixAfterFirstOccurrence((String)string2, (String)string);
                string2 = String.valueOf(this.getQuestion().getReference()) + string + string2;
                this.setText(string2);
                g.a().L().update((Object)this);
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not replace question reference in answer text after edition migration. " + exception));
        }
    }

    public ForeignCollection<ILPLink> getLinks() {
        if (this.links == null) {
            try {
                g.a().L().assignEmptyForeignCollection((Object)this, "links");
                this.links.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for answer.links", (Throwable)sQLException);
            }
        }
        return this.links;
    }

    public void setLinks(ForeignCollection<ILPLink> foreignCollection) {
        this.links = foreignCollection;
    }

    public void addLinksObject(ILPLink iLPLink) {
        this.getLinks().add((Object)iLPLink);
    }

    public void removeLinksObject(ILPLink iLPLink) {
        this.getLinks().remove((Object)iLPLink);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasLinks() {
        CloseableIterator closeableIterator = null;
        try {
            if (this.links == null) {
                return false;
            }
            closeableIterator = this.links.closeableIterator();
            if (!closeableIterator.hasNext()) return false;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (closeableIterator != null) {
                try {
                    closeableIterator.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public ForeignCollection<ILPSharing> getSharings() {
        if (this.sharings == null) {
            try {
                g.a().L().assignEmptyForeignCollection((Object)this, "sharings");
                this.sharings.refreshCollection();
            }
            catch (SQLException sQLException) {
                logger.d((Object)"Could not create empty foreign collection for sharings", (Throwable)sQLException);
                f.b().D().displayNoticeCode("message.internalError", new Object[0]);
            }
        }
        return this.sharings;
    }

    @Override
    public void addSharingsObject(ILPSharing iLPSharing) {
        this.getSharings().add((Object)iLPSharing);
    }

    @Override
    public void removeSharingsObject(ILPSharing iLPSharing) {
        this.getSharings().remove((Object)iLPSharing);
    }

    @Override
    public String toString() {
        return "ILPAnswer [reference=" + this.reference + ", type=" + this.type + ", number=" + this.number + ", pk=" + this.pk + "]";
    }

    public void copyInto(ILPAnswer iLPAnswer) throws SQLException {
        iLPAnswer.setAnswerDeleted(this.getAnswerDeleted());
        iLPAnswer.setAnswerTimeSecs(this.getAnswerTimeSecs());
        iLPAnswer.setAnswerType(this.getAnswerType());
        iLPAnswer.setCorrect(this.isCorrect());
        iLPAnswer.setLastUpdate(this.getLastUpdate());
        iLPAnswer.setNumber(this.getNumber());
        iLPAnswer.setRepetitionInDays(this.getRepetitionInDays());
        iLPAnswer.setScore(this.getScore());
        iLPAnswer.setText(this.getText());
        for (ILPLink iLPLink : this.getLinks()) {
            ILPLink iLPLink2 = iLPAnswer.getLinkMatching(iLPLink.getLinkType(), iLPLink.getUrl(), iLPLink.getName(), iLPLink.getFileReference());
            if (iLPLink2 == null) {
                iLPLink2 = new ILPLink();
                iLPLink2.setAnswer(iLPAnswer);
            }
            iLPLink.copyInto(iLPLink2);
            if (iLPLink2.isInDatabase()) {
                g.a().P().update((Object)iLPLink2);
                continue;
            }
            g.a().P().create((Object)iLPLink2);
        }
        iLPAnswer.setSharingTypeEnum(this.getSharingTypeEnum());
    }

    /*
     * Exception decompiling
     */
    public ILPLink getLinkMatching(ILPLink.LinkType var1_1, String var2_2, String var3_3, String var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum AnswerType {
        ANSWER_TYPE_ANY(0),
        ANSWER_TYPE_TEMPLATE(1),
        ANSWER_TYPE_USER(2),
        ANSWER_TYPE_CORRECT(3),
        ANSWER_TYPE_SHARED(4);

        private static final Map<Integer, AnswerType> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, AnswerType>();
            for (AnswerType answerType : EnumSet.allOf(AnswerType.class)) {
                lookup.put(answerType.getCode(), answerType);
            }
        }

        private AnswerType(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static AnswerType get(int n2) {
            return lookup.get(n2);
        }

        public static AnswerType get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }
}

