/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.he.c;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.mo.ILPSkuMapping;
import com.j256.ormlite.dao.ForeignCollection;
import java.util.List;
import org.joda.time.DateTime;

public abstract class ILPAbstractProduct
extends AbstractCoreDataModel {
    private static ILogger logger = ILPLogManager.getLogger(ILPAbstractProduct.class);

    public abstract ILPEProduct getEProduct();

    public abstract ILPEProduct getParent();

    public abstract List<ILPEProduct> getLicensedChildren();

    public abstract List<ILPEProduct> getChildrenWithExcerpt();

    public abstract List<ILPEProduct> getInstalledChildren();

    public String getProductReference() {
        return this.getEProduct().getProductReference();
    }

    public void setProductReference(String string) {
        this.getEProduct().setProductReference(string);
    }

    public Boolean isActive() {
        return this.getEProduct().getActive();
    }

    public void setActive(boolean bl2) {
        this.getEProduct().setActive(bl2);
    }

    public String getTitle() {
        return this.getEProduct().getTitle();
    }

    public void setTitle(String string) {
        this.getEProduct().setTitle(string);
    }

    public ILPEProduct.ProductType getProductType() {
        return ILPEProduct.ProductType.get(this.getEProduct().getProductType());
    }

    public void setProductType(ILPEProduct.ProductType productType) {
        this.getEProduct().setProductType(productType.getType());
    }

    public DateTime getReleaseDate() {
        return this.getEProduct().getReleaseDate();
    }

    public void setReleaseDate(DateTime dateTime) {
        this.getEProduct().setReleaseDate(dateTime);
    }

    public Boolean isAvailableForFree() {
        return this.getEProduct().getAvailableForFree();
    }

    public void setAvailableForFree(boolean bl2) {
        this.getEProduct().setAvailableForFree(bl2);
    }

    public ForeignCollection<ILPSkuMapping> getSkuMappings() {
        return this.getEProduct().getSkuMappings();
    }

    public void setSkuMapping(ForeignCollection<ILPSkuMapping> foreignCollection) {
        this.getEProduct().setSkuMappings(foreignCollection);
    }

    public ILPLicense getLicense() {
        if (this.getEProduct() == null) {
            return null;
        }
        return this.getEProduct().getLicense();
    }

    public ForeignCollection<ILPProperty> getProperties() {
        return this.getEProduct().getProperties();
    }

    public void setProperties(ForeignCollection<ILPProperty> foreignCollection) {
        this.getEProduct().setProperties(foreignCollection);
    }

    public abstract ILPLicense determineLicense();

    public abstract ILPLicense determineLicenseWithValidUsage();

    public abstract ILPLicense determineLicenseWithPolicyGrantedAndUsageGranted();

    public boolean isLicenseAuthorized() {
        ILPLicense iLPLicense = this.determineLicense();
        if (iLPLicense != null) {
            return iLPLicense.isLicenseAuthorized();
        }
        return false;
    }

    public boolean isLicenseUsageGrantedOrInGraceTime() {
        return this.getLicense() != null && this.getLicense().isLicenseUsageGrantedOrGraceTime();
    }

    public boolean isLicenseUsageGranted() {
        return this.getLicense() != null && this.getLicense().isLicenseUsageGranted();
    }

    public boolean hasAccessGranted() {
        ILPLicense iLPLicense = this.determineLicense();
        if (iLPLicense != null) {
            return iLPLicense.isLicenseUsageGrantedOrGraceTime();
        }
        return false;
    }

    public boolean hasLicenseWithPolicyGrantedAndUsageGranted() {
        return this.determineLicenseWithPolicyGrantedAndUsageGranted() != null;
    }

    public abstract boolean isUpdateAvailable();

    public void install(c c2) {
        this.getEProduct().install(c2);
    }

    public String getDetailInfo() {
        return this.toString();
    }
}

