/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.mo;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.book.msg.m;
import ch.ionesoft.ilp.book.msg.model.M;
import ch.ionesoft.ilp.book.msg.t;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.joda.time.DateTime;
import org.json.ionesoft.i;

@DatabaseTable(tableName="ZIAMESSAGE")
public class IAMessage {
    private static ILogger logger = ILPLogManager.getLogger(IAMessage.class);
    public static final String TABLE_NAME = "ZIAMESSAGE";
    public static final String PK_FIELD_NAME = "Z_PK";
    public static final String MESSAGEUID_FIELD_NAME = "ZMESSAGEUID";
    public static final String DESTINATIONUID_FIELD_NAME = "ZDESTINATIONUID";
    public static final String ALIAS_FIELD_NAME = "ZALIAS";
    public static final String DOMAIN_FIELD_NAME = "ZDOMAIN";
    public static final String MAXATTEMPTS_FIELD_NAME = "ZMAXATTEMPTS";
    public static final String DELIVERYPOLICY_FIELD_NAME = "ZDELIVERYPOLICY";
    public static final String TTL_FIELD_NAME = "ZTTL";
    public static final String PAYLOADTYPE_FIELD_NAME = "ZPAYLOADTYPE";
    public static final String CONTENTTYPE_FIELD_NAME = "ZCONTENTTYPE";
    public static final String VERSION_FIELD_NAME = "ZVERSION";
    public static final String PROPERTIES_FIELD_NAME = "ZPROPERTIES";
    public static final String PAYLOAD_FIELD_NAME = "ZPAYLOAD";
    public static final String MESSAGESTATUS_FIELD_NAME = "ZMESSAGESTATUS";
    public static final String NEXT_DELIVERY_AT_FIELD_NAME = "ZNEXTDELIVERYAT";
    public static final String DELIVERY_ATTEMPTS_FIELD_NAME = "ZDELIVERYATTEMPTS";
    public static final String RECEIVED_AT_FIELD_NAME = "ZRECEIVEDAT";
    public static final String OBSERVER_FIELD_NAME = "ZOBSERVER";
    public static final String PRESENTATION_STATE_FIELD_NAME = "ZPRESENTATIONSTATE";
    @DatabaseField(generatedId=true, columnName="Z_PK")
    private Integer pk;
    @DatabaseField(columnName="ZMESSAGEUID")
    private String messageUid;
    @DatabaseField(columnName="ZDESTINATIONUID")
    private String destinationUid;
    @DatabaseField(columnName="ZALIAS")
    private String alias;
    @DatabaseField(columnName="ZDOMAIN")
    private String domain;
    @DatabaseField(columnName="ZMAXATTEMPTS")
    private Integer maxAttempts;
    @DatabaseField(columnName="ZDELIVERYPOLICY")
    private Integer deliveryPolicy;
    @DatabaseField(columnName="ZTTL")
    private Integer ttl;
    @DatabaseField(columnName="ZPAYLOADTYPE")
    private String payloadType;
    @DatabaseField(columnName="ZCONTENTTYPE")
    private Integer contentType;
    @DatabaseField(columnName="ZVERSION")
    private String version;
    @DatabaseField(columnName="ZPROPERTIES")
    private String properties;
    @DatabaseField(columnName="ZPAYLOAD")
    private String payload;
    @DatabaseField(columnName="ZMESSAGESTATUS")
    private Integer messageStatus;
    @DatabaseField(columnName="ZNEXTDELIVERYAT")
    private DateTime nextDeliveryAttempt;
    @DatabaseField(columnName="ZDELIVERYATTEMPTS")
    private Integer deliveryAttempts;
    @DatabaseField(columnName="ZRECEIVEDAT")
    private DateTime receivedAt;
    @DatabaseField(columnName="ZOBSERVER")
    private Integer observer;
    @DatabaseField(columnName="ZPRESENTATIONSTATE")
    private Integer presentationState;

    public Integer getPk() {
        return this.pk;
    }

    public boolean hasDestinationUid() {
        return this.destinationUid != null && !this.destinationUid.isEmpty();
    }

    public boolean hasAliasAndDomain() {
        return this.alias != null && this.domain != null && !this.alias.isEmpty() && !this.domain.isEmpty();
    }

    public String getMessageUid() {
        if (this.messageUid == null) {
            this.messageUid = "";
        }
        return this.messageUid;
    }

    public void setMessageUid(String string) {
        this.messageUid = string;
    }

    public String getDestinationUid() {
        if (this.destinationUid == null) {
            this.destinationUid = "";
        }
        return this.destinationUid;
    }

    public void setDestinationUid(String string) {
        this.destinationUid = string;
    }

    public String getAlias() {
        if (this.alias == null) {
            this.alias = "";
        }
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getDomain() {
        if (this.domain == null) {
            this.domain = "";
        }
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public boolean hasMaxAttempts() {
        return this.maxAttempts != null;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int n2) {
        this.maxAttempts = n2;
    }

    public DeliveryPolicy getDeliveryPolicy() {
        if (this.deliveryPolicy != null) {
            return DeliveryPolicy.get(this.deliveryPolicy);
        }
        return DeliveryPolicy.DELIVERY_POLICY_UNDEFINED;
    }

    public void setDeliveryPolicy(DeliveryPolicy deliveryPolicy) {
        this.deliveryPolicy = deliveryPolicy.getCode();
    }

    public boolean hasTtl() {
        return this.ttl != null;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n2) {
        this.ttl = n2;
    }

    public String getPayloadType() {
        if (this.payloadType == null) {
            this.payloadType = "";
        }
        return this.payloadType;
    }

    public t getPayloadTypeEnum() {
        return t.b(this.payloadType);
    }

    public void setPayloadType(String string) {
        this.payloadType = string;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = "";
        }
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public Map<String, String> getProperties() {
        try {
            if (this.properties == null) {
                return new HashMap<String, String>();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            i i2 = new i(this.properties);
            Iterator iterator = i2.a();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashMap.put(string, i2.h(string));
            }
            return hashMap;
        }
        catch (Exception exception) {
            logger.c((Object)("Could not return HashMap<String, String> pased on json: " + this.properties));
            return new HashMap<String, String>();
        }
    }

    public void setProperties(Map<String, String> map) {
        try {
            this.properties = new i(map).toString();
        }
        catch (Exception exception) {
            logger.d((Object)("Could parse properties map to json string. properties: " + ArrayUtils.toString(map)));
        }
    }

    public String getPropertiesAsJSON() {
        return this.properties;
    }

    public void setPropertiesJSON(String string) {
        this.properties = string;
    }

    public String getPayload() {
        if (this.payload == null) {
            this.payload = "";
        }
        return this.payload;
    }

    public void setPayload(String string) {
        this.payload = string;
    }

    public Integer getContentType() {
        return this.contentType;
    }

    public m getContentTypeEnum() {
        if (this.getContentType() != null) {
            return m.a(this.getContentType());
        }
        return m.a;
    }

    public void setContentType(Integer n2) {
        this.contentType = n2;
    }

    public void setContentTypeEnum(m m2) {
        this.contentType = m2.a();
    }

    public MessageStatus getMessageStatus() {
        if (this.messageStatus != null) {
            return MessageStatus.get(this.messageStatus);
        }
        return MessageStatus.MESSAGE_STATUS_UNDEFINED;
    }

    public void setMessageStatus(MessageStatus messageStatus) {
        this.messageStatus = messageStatus.getCode();
    }

    public PresentationStatus getPresentationStatus() {
        if (this.presentationState != null) {
            return PresentationStatus.get(this.presentationState);
        }
        return PresentationStatus.PRESENTATION_STATUS_UNDEFINED;
    }

    public void setPresentationStatus(PresentationStatus presentationStatus) {
        this.presentationState = presentationStatus.getCode();
    }

    public DateTime getNextDeliveryAttempt() {
        return this.nextDeliveryAttempt;
    }

    public void setNextDeliveryAttempt(DateTime dateTime) {
        this.nextDeliveryAttempt = dateTime;
    }

    public Integer getDeliveryAttempts() {
        if (this.deliveryAttempts == null) {
            return 0;
        }
        return this.deliveryAttempts;
    }

    public void setDeliveryAttempts(Integer n2) {
        this.deliveryAttempts = n2;
    }

    public DateTime getReceivedAt() {
        return this.receivedAt;
    }

    public void setReceivedAt(DateTime dateTime) {
        this.receivedAt = dateTime;
    }

    public Integer getObserver() {
        return this.observer;
    }

    public void setObserver(Integer n2) {
        this.observer = n2;
    }

    public static String getFileName() {
        return "messages.xml";
    }

    public static String getRelativeFilePath() {
        return "synch/messages/" + IAMessage.getFileName();
    }

    public static String getLocalFilePath() {
        return new File(h.T(), IAMessage.getFileName()).getAbsolutePath();
    }

    public static void touch() {
        g.a().b(new DateTime());
    }

    public String toString() {
        return "IAMessage [messageUid=" + this.messageUid + ", destinationUid=" + this.destinationUid + ", alias=" + this.alias + ", domain=" + this.domain + ", ttl=" + this.ttl + ", payloadType=" + this.payloadType + ", contentType=" + this.contentType + ", properties=" + this.properties + "]";
    }

    public static enum DeliveryPolicy {
        DELIVERY_POLICY_UNDEFINED(0, null),
        DELIVERY_POLICY_STATIC(1, M.a.a),
        DELIVERY_POLICY_DYNAMIC(2, M.a.b);

        private static final Map<Integer, DeliveryPolicy> lookup;
        private int code;
        private M.a deliveryPolicyEnum;

        static {
            lookup = new HashMap<Integer, DeliveryPolicy>();
            for (DeliveryPolicy deliveryPolicy : EnumSet.allOf(DeliveryPolicy.class)) {
                lookup.put(deliveryPolicy.getCode(), deliveryPolicy);
            }
        }

        private DeliveryPolicy(int n3, M.a a2) {
            this.code = n3;
            this.deliveryPolicyEnum = a2;
        }

        public int getCode() {
            return this.code;
        }

        public static DeliveryPolicy get(int n2) {
            return lookup.get(n2);
        }

        public static DeliveryPolicy get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }

        public M.a getDeliveryPolicyEnum() {
            return this.deliveryPolicyEnum;
        }

        public static DeliveryPolicy getByStringCode(String string) {
            try {
                int n2 = Integer.parseInt(string);
                DeliveryPolicy deliveryPolicy = lookup.get(n2);
                return deliveryPolicy != null ? deliveryPolicy : DELIVERY_POLICY_UNDEFINED;
            }
            catch (Exception exception) {
                return DELIVERY_POLICY_UNDEFINED;
            }
        }

        public static DeliveryPolicy getByName(String string) {
            try {
                DeliveryPolicy deliveryPolicy = DeliveryPolicy.valueOf(string);
                return deliveryPolicy != null ? deliveryPolicy : DELIVERY_POLICY_UNDEFINED;
            }
            catch (Exception exception) {
                return DELIVERY_POLICY_UNDEFINED;
            }
        }
    }

    public static enum MessageStatus {
        MESSAGE_STATUS_UNDEFINED(0),
        MESSAGE_STATUS_OUTBOUND_WAITING(1),
        MESSAGE_STATUS_OUTBOUND_DELIVERED(2),
        MESSAGE_STATUS_INBOUND_WAITING(3),
        MESSAGE_STATUS_OUTBOUND_ABORTED(4),
        MESSAGE_STATUS_INBOUND_ABORTED(5),
        MESSAGE_STATUS_INBOUND_DELIVERED(6);

        private static final Map<Integer, MessageStatus> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, MessageStatus>();
            for (MessageStatus messageStatus : EnumSet.allOf(MessageStatus.class)) {
                lookup.put(messageStatus.getCode(), messageStatus);
            }
        }

        private MessageStatus(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static MessageStatus get(int n2) {
            return lookup.get(n2);
        }

        public static MessageStatus getByStringCode(String string) {
            try {
                int n2 = Integer.parseInt(string);
                MessageStatus messageStatus = lookup.get(n2);
                return messageStatus != null ? messageStatus : MESSAGE_STATUS_UNDEFINED;
            }
            catch (Exception exception) {
                return MESSAGE_STATUS_UNDEFINED;
            }
        }

        public static MessageStatus getByName(String string) {
            try {
                MessageStatus messageStatus = MessageStatus.valueOf(string);
                return messageStatus != null ? messageStatus : MESSAGE_STATUS_UNDEFINED;
            }
            catch (Exception exception) {
                return MESSAGE_STATUS_UNDEFINED;
            }
        }
    }

    public static enum PresentationStatus {
        PRESENTATION_STATUS_UNDEFINED(0),
        PRESENTATION_STATUS_READ(1),
        PRESENTATION_STATUS_UNREAD(2),
        PRESENTATION_STATUS_HIDDEN(3);

        private static final Map<Integer, PresentationStatus> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, PresentationStatus>();
            for (PresentationStatus presentationStatus : EnumSet.allOf(PresentationStatus.class)) {
                lookup.put(presentationStatus.getCode(), presentationStatus);
            }
        }

        private PresentationStatus(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static PresentationStatus get(int n2) {
            return lookup.get(n2);
        }

        public static PresentationStatus get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }

        public static PresentationStatus getByStringCode(String string) {
            try {
                int n2 = Integer.parseInt(string);
                PresentationStatus presentationStatus = lookup.get(n2);
                return presentationStatus != null ? presentationStatus : PRESENTATION_STATUS_UNDEFINED;
            }
            catch (Exception exception) {
                return PRESENTATION_STATUS_UNDEFINED;
            }
        }

        public static PresentationStatus getByName(String string) {
            try {
                PresentationStatus presentationStatus = PresentationStatus.valueOf(string);
                return presentationStatus != null ? presentationStatus : PRESENTATION_STATUS_UNDEFINED;
            }
            catch (Exception exception) {
                return PRESENTATION_STATUS_UNDEFINED;
            }
        }
    }
}

