/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.icb;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.book.angular.model.A;
import ch.ionesoft.ilp.book.angular.model.B;
import ch.ionesoft.ilp.book.angular.model.O;
import ch.ionesoft.ilp.book.angular.model.T;
import ch.ionesoft.ilp.book.angular.model.ae;
import ch.ionesoft.ilp.book.angular.model.af;
import ch.ionesoft.ilp.book.angular.model.aj;
import ch.ionesoft.ilp.book.angular.model.ak;
import ch.ionesoft.ilp.book.angular.model.al;
import ch.ionesoft.ilp.book.angular.model.an;
import ch.ionesoft.ilp.book.angular.model.ao;
import ch.ionesoft.ilp.book.angular.model.aq;
import ch.ionesoft.ilp.book.angular.model.as;
import ch.ionesoft.ilp.book.angular.model.at;
import ch.ionesoft.ilp.book.angular.model.ay;
import ch.ionesoft.ilp.book.angular.model.az;
import ch.ionesoft.ilp.book.angular.model.c;
import ch.ionesoft.ilp.book.angular.model.e;
import ch.ionesoft.ilp.book.angular.model.g;
import ch.ionesoft.ilp.book.angular.model.r;
import ch.ionesoft.ilp.book.angular.model.s;
import ch.ionesoft.ilp.book.co.ILPLessonsManager;
import ch.ionesoft.ilp.book.ia.b;
import ch.ionesoft.ilp.book.ia.d;
import ch.ionesoft.ilp.book.icb.ICBRequestDelegateBase;
import ch.ionesoft.ilp.book.icb.ICBRequestHandler;
import ch.ionesoft.ilp.book.icb.ICBRequestHandlingException;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPScenario;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsContent;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsFolder;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask;
import ch.ionesoft.ilp.book.mo.lr.ILPFeedback;
import ch.ionesoft.ilp.book.mo.lr.ILPFeedbackData;
import ch.ionesoft.ilp.book.pe.f;
import com.j256.ormlite.dao.CloseableIterator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ICBTaskRequestDelegate
extends ICBRequestDelegateBase {
    private static ILogger logger = ILPLogManager.getLogger(ICBTaskRequestDelegate.class);
    private final ICBRequestHandler.ICBViewDelegate viewDelegate;

    public ICBTaskRequestDelegate(ICBRequestHandler.ICBViewDelegate iCBViewDelegate) {
        this.viewDelegate = iCBViewDelegate;
    }

    @Override
    public String handleRequest(String string, String string2) throws ICBRequestHandlingException {
        logger.b((Object)("Handling request: " + string));
        if (string.equals("getTasks")) {
            return this.handleGetTasksRequest();
        }
        if (string.equals("updateTasks")) {
            return this.updateTask(string2);
        }
        if (string.equals("start")) {
            this.handleStartTaskRequest(string2);
        } else if (string.equals("openContent")) {
            this.handleOpenContentRequest(string2);
        } else {
            if (string.equals("getFolderTree")) {
                return this.handleGetFolderTreeRequest(string2);
            }
            if (string.equals("synchronizeAll")) {
                this.handleSynchronizeAllTasks();
            } else if (string.equals("synchronize")) {
                this.handleSynchronizeSingleTasks(string2);
            } else if (string.equals("send")) {
                this.handleSendTask(string2);
            } else if (string.equals("close")) {
                this.handleCloseTask(string2);
            }
        }
        return null;
    }

    private String handleGetTasksRequest() throws ICBRequestHandlingException {
        O o2 = new O();
        try {
            List<ILPLessonsTask> list = f.a().av();
            for (ILPLessonsTask iLPLessonsTask : list) {
                if (!ILPLessonsManager.isTaskActive(iLPLessonsTask)) continue;
                o2.a(this.buildTaskDto(iLPLessonsTask));
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not fetch all tasks. ", (Throwable)exception);
            throw new ICBRequestHandlingException("Could not fetch all tasks, reason: " + exception.getMessage(), ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION, exception);
        }
        o2.b(super.createGlobalResponse(b.a.a));
        return this.writeResponse(o2);
    }

    private String updateTask(String string) throws ICBRequestHandlingException {
        ay ay2 = ICBTaskRequestDelegate.getObjectFromJsonPayload(string, ay.class);
        az az2 = new az();
        int n2 = ay2.a().size();
        try {
            for (as as2 : ay2.a()) {
                at at2 = new at();
                at2.b(as2);
                try {
                    String string2 = as2.a();
                    ILPLessonsTask iLPLessonsTask = f.a().aI(string2);
                    iLPLessonsTask.setProcessingState(ILPLessonsTask.LessonsProcessingState.fromICBEnum(as2.c()));
                    ch.ionesoft.ilp.book.pe.g.a().aU().update((Object)iLPLessonsTask);
                    at2.a(super.createDetailResponse(b.a.a));
                    --n2;
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not update task by dto: " + as2), (Throwable)exception);
                    at2.a(super.createDetailResponse(b.a.c));
                }
                az2.a(at2);
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not update tasks. " + ay2), (Throwable)exception);
            throw new ICBRequestHandlingException("Could not update tasks, reason: " + exception.getMessage(), ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION, exception);
        }
        if (n2 == 0) {
            az2.b(super.createGlobalResponse(b.a.a));
        } else if (n2 > 0) {
            az2.b(super.createGlobalResponse(b.a.b));
        } else {
            az2.b(super.createGlobalResponse(b.a.c));
        }
        return this.writeResponse(az2);
    }

    private void handleStartTaskRequest(String string) throws ICBRequestHandlingException {
        ak ak2 = ICBTaskRequestDelegate.getObjectFromJsonPayload(string, ak.class);
        aq aq2 = ak2.a();
        String string2 = aq2.a();
        ILPLessonsTask iLPLessonsTask = f.a().aI(string2);
        if (iLPLessonsTask == null || iLPLessonsTask.getScenarioSpecification() == null) {
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.scenario.player.task.not.found", new Object[0]);
            throw new ICBRequestHandlingException("Could not fetch task with scenario by id: " + string2, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
        ILPScenarioSpecification iLPScenarioSpecification = iLPLessonsTask.getScenarioSpecification();
        try {
            ch.ionesoft.ilp.book.pe.g.a().aM().refresh((Object)iLPScenarioSpecification);
        }
        catch (SQLException sQLException) {
            logger.d((Object)"Could not refresh scenarioSpecification");
        }
        if (iLPScenarioSpecification == null) {
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.scenario.player.specification.not.found", new Object[0]);
            String string3 = "Could not get scenarioSpecification from task: " + iLPLessonsTask;
            logger.d((Object)string3);
            throw new ICBRequestHandlingException(string3, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
        logger.b((Object)("Handle start task. Start specification with id: " + iLPScenarioSpecification.getId() + " and title: " + iLPScenarioSpecification.getName()));
        if (iLPScenarioSpecification.isRequireAllElements().booleanValue() && !iLPScenarioSpecification.hasRequirementsInstalledForScenarioPlayer()) {
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.scenario.player.specification.missing.requirements", new Object[0]);
            String string4 = "Could not create scenario from specification due to missing requirements. specification: " + iLPScenarioSpecification;
            logger.d((Object)string4);
            throw new ICBRequestHandlingException(string4, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
        if (!iLPScenarioSpecification.isLoaded() || !iLPScenarioSpecification.allElementsLoaded()) {
            boolean bl2 = iLPScenarioSpecification.importScenarioSpecificationForScenarioPlayer();
            if (!bl2) {
                logger.d((Object)"Could not start scenario due to scenarioSpecification import error");
                return;
            }
            ch.ionesoft.ilp.book.lr.e.a().a(iLPScenarioSpecification.getTask());
        }
        this.viewDelegate.startScenario(iLPScenarioSpecification.getId());
    }

    private void handleOpenContentRequest(String string) throws ICBRequestHandlingException {
        ae ae2 = ICBTaskRequestDelegate.getObjectFromJsonPayload(string, ae.class);
        String string2 = ae2.a();
        Long l2 = ae2.b();
        ILPLessonsContent iLPLessonsContent = f.a().a(string2, l2);
        if (iLPLessonsContent == null) {
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.task.attachment.not.loaded", new Object[0]);
            String string3 = "Could not fetch lessons content with fileReference: " + string2 + " and version: " + l2;
            logger.d((Object)string3);
            throw new ICBRequestHandlingException(string3, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
        if (!iLPLessonsContent.isContentDownloaded()) {
            try {
                iLPLessonsContent.download();
            }
            catch (Exception exception) {
                ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.task.attachment.not.loaded", new Object[0]);
                String string4 = "Could not download lessonsContent: " + iLPLessonsContent;
                logger.d((Object)string4, (Throwable)exception);
                throw new ICBRequestHandlingException(string4, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION, exception);
            }
        }
        ILPResource iLPResource = iLPLessonsContent.getResource();
        this.viewDelegate.openLessonsContent(iLPResource, true);
    }

    private String handleGetFolderTreeRequest(String string) throws ICBRequestHandlingException {
        List<List<ILPLessonsFolder>> list;
        A a2 = ICBTaskRequestDelegate.getObjectFromJsonPayload(string, A.class);
        boolean bl2 = a2.a();
        B b2 = new B();
        List<ILPLessonsFolder> list2 = f.a().ax();
        ArrayList<s> arrayList = new ArrayList<s>();
        if (bl2) {
            list = this.groupFoldersByName(list2);
        } else {
            list = new ArrayList<List<ILPLessonsFolder>>();
            for (ILPLessonsFolder object : list2) {
                list.add(Arrays.asList(object));
            }
        }
        for (List list3 : list) {
            arrayList.add(this.buildLessonsFolderTreeItemDto(list3, bl2));
        }
        if (arrayList != null) {
            for (s s2 : arrayList) {
                try {
                    this.countTasksInFolder(s2, true);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not count completed tasks in recursive folder tree: " + s2), (Throwable)exception);
                }
                try {
                    this.countTasksInFolder(s2, false);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not count open tasks in recursive folder tree: " + s2), (Throwable)exception);
                }
            }
        }
        b2.b(arrayList);
        return this.writeResponse(b2);
    }

    private int countTasksInFolder(s s2, boolean bl2) {
        List<an> list;
        int n2 = 0;
        List<s> list2 = s2.i();
        if (list2 != null) {
            for (s object2 : list2) {
                n2 += this.countTasksInFolder(object2, bl2);
            }
        }
        if ((list = s2.f()) != null) {
            for (Object an2 : list) {
                if (bl2 && ((an)an2).o().a() == af.a.f) {
                    ++n2;
                    continue;
                }
                if (bl2 || ((an)an2).o().a() == af.a.f) continue;
                ++n2;
            }
        }
        if (bl2) {
            s2.d(n2);
        } else {
            s2.b(n2);
        }
        return n2;
    }

    private void handleSynchronizeAllTasks() {
        try {
            ILPLessonsManager.getInstance().synchronizeTasks();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not synchronize all tasks", (Throwable)exception);
        }
    }

    private void handleSynchronizeSingleTasks(String string) throws ICBRequestHandlingException {
        al al2 = ICBTaskRequestDelegate.getObjectFromJsonPayload(string, al.class);
        String string2 = al2.a().a();
        try {
            ILPLessonsTask iLPLessonsTask = f.a().aI(string2);
            f.a().c(iLPLessonsTask);
            ILPLessonsManager.getInstance().synchronizeSingleTask(string2);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not synchronize task with id: " + string2), (Throwable)exception);
        }
    }

    private void handleSendTask(String string) throws ICBRequestHandlingException {
        aj aj2 = ICBTaskRequestDelegate.getObjectFromJsonPayload(string, aj.class);
        try {
            String string2 = aj2.a().a();
            ILPLessonsTask iLPLessonsTask = f.a().aI(string2);
            if (iLPLessonsTask == null) {
                throw new Exception("Could not submit statements, task is null");
            }
            if (iLPLessonsTask.isOwnerCopy()) {
                logger.c((Object)"Do not submit statements task owner is current user. Close the task on beooklms.");
                if (!ILPLessonsManager.getInstance().completeTask(iLPLessonsTask)) {
                    ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.task.complete.failed", new Object[0]);
                }
                return;
            }
            ch.ionesoft.ilp.book.lr.e.a().b(iLPLessonsTask);
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.task.submit.successful", new Object[0]);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not send task", (Throwable)exception);
            ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.task.submit.failed", new Object[0]);
        }
    }

    private void handleCloseTask(String string) throws ICBRequestHandlingException {
        e e2 = ICBTaskRequestDelegate.getObjectFromJsonPayload(string, e.class);
        String string2 = e2.a().a();
        ILPLessonsTask iLPLessonsTask = f.a().aI(string2);
        if (iLPLessonsTask == null) {
            ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.task.complete.failed", new Object[0]);
            return;
        }
        logger.b((Object)("User clicked on complete task for task: " + iLPLessonsTask));
        try {
            if (!ILPLessonsManager.getInstance().completeTask(iLPLessonsTask)) {
                ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.task.complete.failed", new Object[0]);
                return;
            }
        }
        catch (Exception exception) {
            ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.task.complete.failed", new Object[0]);
            String string3 = "Could not set taskAssignment COMPLETED: " + iLPLessonsTask;
            logger.d((Object)string3, (Throwable)exception);
            throw new ICBRequestHandlingException(string3, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION, exception);
        }
        logger.b((Object)"Successfully updated task assignment with ProcessingState.COMPLETED on beookLms and in local database. ");
        ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.task.complete.successful", new Object[0]);
    }

    private s buildLessonsFolderTreeItemDto(List<ILPLessonsFolder> list, boolean bl2) {
        List<ILPLessonsFolder> list2;
        ILPLessonsContent iLPLessonsContent;
        if (list == null) {
            return null;
        }
        s s2 = new s();
        List<ILPLessonsTask> list3 = f.a().k(list);
        s2.b(this.buildTaskDtos(list3));
        ILPLessonsFolder iLPLessonsFolder = list.get(0);
        s2.b(iLPLessonsFolder.getFolderColor().asICBEnum());
        s2.b(iLPLessonsFolder.getFolderId());
        s2.d(iLPLessonsFolder.getTitle());
        ILPLessonsContent iLPLessonsContent2 = iLPLessonsFolder.getBanner();
        if (iLPLessonsContent2 != null) {
            s2.b(this.buildFolderDtoBanner(iLPLessonsContent2));
        }
        if ((iLPLessonsContent = iLPLessonsFolder.getIcon()) != null) {
            s2.b(this.buildFolderDtoIcon(iLPLessonsContent));
        }
        if ((list2 = f.a().j(list)) != null && !list2.isEmpty()) {
            List<List<ILPLessonsFolder>> list4;
            if (bl2) {
                list4 = this.groupFoldersByName(list2);
            } else {
                list4 = new ArrayList<List<ILPLessonsFolder>>();
                for (ILPLessonsFolder object : list2) {
                    list4.add(Arrays.asList(object));
                }
            }
            for (List list5 : list4) {
                s2.a(this.buildLessonsFolderTreeItemDto(list5, bl2));
            }
        }
        return s2;
    }

    private List<an> buildTaskDtos(List<ILPLessonsTask> list) {
        ArrayList<an> arrayList = new ArrayList<an>();
        for (ILPLessonsTask iLPLessonsTask : list) {
            arrayList.add(this.buildTaskDto(iLPLessonsTask));
        }
        return arrayList;
    }

    private List<List<ILPLessonsFolder>> groupFoldersByName(List<ILPLessonsFolder> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, List<ILPLessonsFolder>> map = list.stream().collect(Collectors.groupingBy(ILPLessonsFolder::getTitle));
        return new ArrayList<List<ILPLessonsFolder>>(map.values());
    }

    private an buildTaskDto(ILPLessonsTask iLPLessonsTask) {
        an an2 = new an();
        an2.b(iLPLessonsTask.getId());
        an2.d(iLPLessonsTask.getTaskAssignmentId());
        an2.h(iLPLessonsTask.getTitle());
        an2.f(iLPLessonsTask.getOwner().getSubject());
        an2.d(this.buildContentsDtosForTask(iLPLessonsTask));
        an2.j(iLPLessonsTask.getDescription());
        an2.b(d.a(iLPLessonsTask.getPublishedAt()));
        an2.d(d.a(iLPLessonsTask.getCreatedAt()));
        an2.f(d.a(iLPLessonsTask.getReceivedAt()));
        an2.h(d.a(iLPLessonsTask.getStartedAt()));
        an2.l(d.a(iLPLessonsTask.getDeliveredAt()));
        an2.j(d.a(iLPLessonsTask.getEstimatedAt()));
        an2.n(d.a(iLPLessonsTask.getLastModifiedAt()));
        an2.p(d.a(iLPLessonsTask.getUserSubmittedAt()));
        an2.b(this.buildFeedbackDtosForTask(iLPLessonsTask));
        ILPLessonsFolder iLPLessonsFolder = iLPLessonsTask.getFolder();
        if (iLPLessonsFolder != null) {
            ILPLessonsContent iLPLessonsContent;
            ch.ionesoft.ilp.book.pe.g.a().a(iLPLessonsFolder);
            r r2 = new r();
            r2.b(iLPLessonsFolder.getFolderId());
            r2.d(iLPLessonsFolder.getTitle());
            r2.b(iLPLessonsFolder.getFolderColor().asICBEnum());
            ILPLessonsContent iLPLessonsContent2 = iLPLessonsFolder.getBanner();
            if (iLPLessonsContent2 != null) {
                r2.b(this.buildFolderDtoBanner(iLPLessonsContent2));
            }
            if ((iLPLessonsContent = iLPLessonsFolder.getIcon()) != null) {
                r2.b(this.buildFolderDtoIcon(iLPLessonsContent));
            }
            an2.b(r2);
        }
        an2.b(iLPLessonsTask.getProcessingState().asICBEnum());
        an2.b(iLPLessonsTask.getTaskSyncState().asICBEnum());
        if (iLPLessonsTask.getState() != null) {
            an2.b(iLPLessonsTask.getState().asICBEnum());
        }
        if (iLPLessonsTask.getType() != null) {
            an2.b(iLPLessonsTask.getType().asICBEnum());
        }
        an2.b(iLPLessonsTask.isLearningAnalyticsEnabled());
        this.setNumberOfTotalAndProcessScenarioElementsInDto(iLPLessonsTask, an2);
        return an2;
    }

    private void setNumberOfTotalAndProcessScenarioElementsInDto(ILPLessonsTask iLPLessonsTask, an an2) {
        try {
            ILPScenario iLPScenario;
            if (iLPLessonsTask.getScenarioSpecification() == null || !iLPLessonsTask.getScenarioSpecification().isLoaded()) {
                return;
            }
            List<ILPScenarioElement> list = iLPLessonsTask.getScenarioSpecification().getScenarioDefinition().getScenarioElementsNotDeleted();
            if (CollectionUtils.isNotEmpty(list)) {
                an2.d(list.size());
            }
            if ((iLPScenario = f.a().t(iLPLessonsTask.getScenarioSpecification().getScenarioDefinition().getPk())) != null) {
                an2.b((int)iLPScenario.getProcessedElementCount());
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get number if total / proccess scenario elements from task: " + iLPLessonsTask), (Throwable)exception);
        }
    }

    private T buildFolderDtoIcon(ILPLessonsContent iLPLessonsContent) {
        T t2 = new T();
        t2.b(iLPLessonsContent.getFileReference());
        t2.d(iLPLessonsContent.getTitle());
        t2.f(iLPLessonsContent.getUserContentUrl());
        return t2;
    }

    private c buildFolderDtoBanner(ILPLessonsContent iLPLessonsContent) {
        c c2 = new c();
        c2.b(iLPLessonsContent.getFileReference());
        c2.d(iLPLessonsContent.getTitle());
        c2.f(iLPLessonsContent.getUserContentUrl());
        return c2;
    }

    private List<g> buildContentsDtosForTask(ILPLessonsTask iLPLessonsTask) {
        ArrayList<g> arrayList = new ArrayList<g>();
        CloseableIterator closeableIterator = null;
        try {
            closeableIterator = iLPLessonsTask.getContents().closeableIterator();
            while (closeableIterator.hasNext()) {
                ILPLessonsContent iLPLessonsContent = (ILPLessonsContent)closeableIterator.next();
                arrayList.add(this.buildContentDto(iLPLessonsContent));
            }
        }
        finally {
            closeableIterator.closeQuietly();
        }
        return arrayList;
    }

    private g buildContentDto(ILPLessonsContent iLPLessonsContent) {
        g g2 = new g();
        g2.b(iLPLessonsContent.getTypeEnum().asICBEnum());
        g2.b(iLPLessonsContent.getFileReference());
        g2.b(iLPLessonsContent.getVersion());
        g2.f("Was sollen wir hier setzen!? Was wird erwartet? ");
        g2.d(iLPLessonsContent.getTitle());
        return g2;
    }

    private List<ao> buildFeedbackDtosForTask(ILPLessonsTask iLPLessonsTask) {
        ArrayList<ao> arrayList = new ArrayList<ao>();
        CloseableIterator closeableIterator = null;
        try {
            closeableIterator = iLPLessonsTask.getFeedbacks().closeableIterator();
            while (closeableIterator.hasNext()) {
                ILPFeedback iLPFeedback = (ILPFeedback)closeableIterator.next();
                if (iLPFeedback.getFeebackData() == null || iLPFeedback.getFeebackData().isEmpty()) continue;
                arrayList.add(this.buildFeedbackDto(iLPFeedback));
            }
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.closeQuietly();
            }
        }
        return arrayList;
    }

    private ao buildFeedbackDto(ILPFeedback iLPFeedback) {
        ao ao2 = new ao();
        ArrayList<ILPFeedbackData> arrayList = new ArrayList<ILPFeedbackData>((Collection<ILPFeedbackData>)iLPFeedback.getFeebackData());
        ao2.b(iLPFeedback.getId());
        ao2.d(((ILPFeedbackData)arrayList.get(0)).getDataEntry());
        ao2.b(d.a(iLPFeedback.getFeedbackDate()));
        ao2.f(iLPFeedback.getScoreMax());
        ao2.b(iLPFeedback.getScoreRaw());
        ao2.d(iLPFeedback.getScoreScaled());
        if (iLPFeedback.getUser() != null) {
            ao2.f(iLPFeedback.getUser().getName());
        } else if (iLPFeedback.getTask() != null && iLPFeedback.getTask().getOwner() != null) {
            ILPUser iLPUser = iLPFeedback.getTask().getOwner();
            ao2.f(iLPUser.getName());
        }
        return ao2;
    }
}

