/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.icb;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.book.angular.model.b;
import ch.ionesoft.ilp.book.ia.b;
import ch.ionesoft.ilp.book.ia.ucs.f;
import ch.ionesoft.ilp.book.icb.ICBRequestDelegateBase;
import ch.ionesoft.ilp.book.icb.ICBRequestHandler;
import ch.ionesoft.ilp.book.icb.ICBRequestHandlingException;
import ch.ionesoft.ilp.book.mo.ILPLink;
import ch.ionesoft.ilp.book.mo.ILPScenario;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition;
import ch.ionesoft.ilp.book.mo.ILPScenarioElement;
import ch.ionesoft.ilp.book.mo.ILPScenarioElementResult;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsContent;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsFolder;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask;
import ch.ionesoft.ilp.book.mo.lr.ILPFeedback;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.scenario.ILPScenarioManager;
import ch.ionesoft.ilp.book.scenario.player.model.e;
import ch.ionesoft.ilp.book.scenario.player.model.h;
import ch.ionesoft.ilp.book.scenario.player.model.j;
import ch.ionesoft.ilp.book.scenario.player.model.k;
import ch.ionesoft.ilp.book.scenario.player.model.l;
import ch.ionesoft.ilp.book.scenario.player.model.m;
import ch.ionesoft.ilp.book.scenario.player.model.n;
import ch.ionesoft.ilp.book.scenario.player.model.o;
import ch.ionesoft.ilp.book.scenario.player.model.p;
import ch.ionesoft.ilp.book.scenario.player.model.q;
import ch.ionesoft.ilp.book.scenario.player.model.r;
import ch.ionesoft.ilp.book.scenario.player.model.u;
import ch.ionesoft.ilp.book.scenario.player.model.v;
import ch.ionesoft.ilp.book.scenario.player.model.w;
import ch.ionesoft.ilp.book.scenario.player.model.x;
import ch.ionesoft.ilp.book.scenario.player.model.y;
import ch.ionesoft.ilp.book.scenario.player.model.z;
import ch.ionesoft.ilp.book.syn.ex.i;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ICBScenarioRequestDelegate
extends ICBRequestDelegateBase {
    private static ILogger logger = ILPLogManager.getLogger(ICBScenarioRequestDelegate.class);
    private final ICBRequestHandler.ICBViewDelegate viewDelegate;

    public ICBScenarioRequestDelegate(ICBRequestHandler.ICBViewDelegate iCBViewDelegate) {
        this.viewDelegate = iCBViewDelegate;
    }

    @Override
    public String handleRequest(String string, String string2) throws ICBRequestHandlingException {
        if (string.equals("initialized")) {
            this.handleInitializedRequest();
        } else {
            if (string.equals("getAppConfiguration")) {
                return this.handleGetAppConfigurationRequest();
            }
            if (string.equals("start")) {
                return this.handleStartScenarioRequest(string2);
            }
            if (string.equals("loadTopic")) {
                this.handleLoadTopicRequest(string2);
            } else if (string.equals("loadExercise")) {
                this.handleLoadExerciseRequest(string2);
            } else if (string.equals("loadAsset")) {
                this.handleLoadAssetRequest(string2);
            } else if (string.equals("loadEmbedded")) {
                this.handleLoadEmbeddedRequest(string2);
            } else {
                if (string.equals("storeTopic")) {
                    return this.handleStoreTopicRequest();
                }
                if (string.equals("storeExercise")) {
                    return this.handleStoreExerciseRequest();
                }
                if (string.equals("storeEmbedded")) {
                    return this.handleStoreEmbeddedRequest();
                }
                if (string.equals("getResultForTopic")) {
                    return this.handleGetResultForTopicRequest(string2);
                }
                if (string.equals("getResultForExercise")) {
                    return this.handleGetResultForExerciseRequest(string2);
                }
                if (string.equals("finish")) {
                    this.handleRequestFinishScenario();
                } else {
                    logger.d((Object)("Command for request unrecognized: " + string));
                    throw new ICBRequestHandlingException("Unrecognized request command", ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
                }
            }
        }
        return null;
    }

    private void handleInitializedRequest() {
        ch.ionesoft.ilp.book.scenario.p p2 = ch.ionesoft.ilp.book.scenario.p.a();
        p2.c().a(true);
        p2.e();
    }

    private String handleGetAppConfigurationRequest() throws ICBRequestHandlingException {
        ch.ionesoft.ilp.book.angular.model.v v2 = new ch.ionesoft.ilp.book.angular.model.v();
        b b2 = new b();
        b2.b(ch.ionesoft.ilp.base.co.f.b().Z());
        b2.b(this.getAppPlatformEnum());
        b2.d(ch.ionesoft.ilp.base.co.g.a().e());
        b2.b(ch.ionesoft.ilp.base.co.g.a().w());
        v2.b(this.createGlobalResponse(b.a.a, null, null));
        v2.b(b2);
        return this.writeResponse(v2);
    }

    private String handleStartScenarioRequest(String string) throws ICBRequestHandlingException {
        q q2 = ICBScenarioRequestDelegate.getObjectFromJsonPayload(string, q.class);
        p p2 = q2.a();
        String string2 = p2.a();
        logger.b((Object)("Start scenario from specification with id: " + string2));
        ILPScenarioSpecification iLPScenarioSpecification = ch.ionesoft.ilp.book.pe.f.a().aF(string2);
        if (iLPScenarioSpecification == null) {
            String string3 = "Could not find scenarioSpecification with id: " + string2;
            logger.d((Object)string3);
            throw new ICBRequestHandlingException(string3, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
        String string4 = "";
        try {
            string4 = ch.ionesoft.ilp.book.scenario.u.a().a(iLPScenarioSpecification);
        }
        catch (Exception exception) {
            throw new ICBRequestHandlingException("Could get specification file data as base64 from specification: " + iLPScenarioSpecification, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION, exception);
        }
        r r2 = new r();
        e e2 = new e();
        e2.f(string4);
        this.addModuleDataToScenarioDto(e2, iLPScenarioSpecification);
        e2.b(this.getFeedbacksForElementsOfScenarios(iLPScenarioSpecification));
        r2.b(e2);
        try {
            this.finishRunningScenario();
            this.startScenario(iLPScenarioSpecification);
        }
        catch (Exception exception) {
            String string5 = "Could not create and start scenario from specification with id: " + string2;
            throw new ICBRequestHandlingException(string5, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION, exception);
        }
        return this.writeResponse(r2);
    }

    private void addModuleDataToScenarioDto(e e2, ILPScenarioSpecification iLPScenarioSpecification) {
        try {
            ILPLessonsTask iLPLessonsTask = iLPScenarioSpecification.getTask();
            g.a().b(iLPLessonsTask);
            ILPLessonsFolder iLPLessonsFolder = iLPLessonsTask.getFolder();
            if (iLPLessonsFolder == null) {
                return;
            }
            e2.b(iLPLessonsFolder.getTitle());
            e2.b(iLPLessonsFolder.getFolderColor().asICBEnum());
            ILPLessonsContent iLPLessonsContent = iLPLessonsFolder.getBanner();
            if (iLPLessonsContent != null) {
                e2.d(iLPLessonsContent.getUserContentUrl());
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not add module data to scenarioDto from specification: " + iLPScenarioSpecification), (Throwable)exception);
        }
    }

    private List<ch.ionesoft.ilp.book.scenario.player.model.b> getFeedbacksForElementsOfScenarios(ILPScenarioSpecification iLPScenarioSpecification) {
        Collection<ILPFeedback> collection;
        block6: {
            collection = ch.ionesoft.ilp.book.pe.f.a().b(iLPScenarioSpecification);
            if (!CollectionUtils.isEmpty(collection)) break block6;
            return null;
        }
        try {
            ArrayList<ch.ionesoft.ilp.book.scenario.player.model.b> arrayList = new ArrayList<ch.ionesoft.ilp.book.scenario.player.model.b>();
            for (ILPFeedback iLPFeedback : collection) {
                try {
                    ch.ionesoft.ilp.book.scenario.player.model.b b2 = new ch.ionesoft.ilp.book.scenario.player.model.b();
                    b2.b(iLPFeedback.getElementId());
                    b2.b(iLPFeedback.getScoreRaw());
                    b2.d(iLPFeedback.getScoreMax());
                    b2.d(iLPFeedback.getFeebackData() != null && !iLPFeedback.getFeebackData().isEmpty());
                    b2.b(iLPFeedback.getSuccess());
                    arrayList.add(b2);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not create ICBElementFeedbackDTO1 from feedback: " + iLPFeedback), (Throwable)exception);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get feedbacks from scenarioSpecification: " + iLPScenarioSpecification), (Throwable)exception);
            return null;
        }
    }

    private void finishRunningScenario() {
        if (ILPScenarioManager.getInstance().isScenarioRunning()) {
            try {
                ILPScenarioManager.getInstance().finishCurrentScenario(0.0f, null);
            }
            catch (Exception exception) {
                logger.d((Object)"Could not finish current scenario", (Throwable)exception);
            }
        }
    }

    private void startScenario(ILPScenarioSpecification iLPScenarioSpecification) throws ch.ionesoft.ilp.book.scenario.n, SQLException {
        ILPScenarioDefinition iLPScenarioDefinition = iLPScenarioSpecification.getScenarioDefinition();
        try {
            g.a().aO().refresh((Object)iLPScenarioDefinition);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not refresh definition: " + iLPScenarioDefinition), (Throwable)exception);
        }
        ILPScenario iLPScenario = ILPScenarioManager.getInstance().getLatestScenario(iLPScenarioDefinition);
        if (iLPScenario != null) {
            this.checkScenarioProcessingState(iLPScenario, iLPScenarioSpecification.getTask());
            ILPScenarioManager.getInstance().continueScenario(iLPScenario);
        } else {
            String string = ILPScenarioManager.getInstance().createScenarioIdForTaskScenario(iLPScenarioSpecification);
            ILPScenarioManager.getInstance().createScenarioFromDefinition(iLPScenarioDefinition, ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYER_PLAYMODE, false, string);
        }
        this.downloadReferencedUCSLinksFromScenario(iLPScenario);
        ILPScenarioManager.getInstance().startCurrentScenario();
        ch.ionesoft.ilp.book.scenario.p.a().b().o();
        ch.ionesoft.ilp.book.scenario.p.a().b().m();
    }

    private void checkScenarioProcessingState(ILPScenario iLPScenario, ILPLessonsTask iLPLessonsTask) {
        try {
            if (iLPLessonsTask.getProcessingState() == ILPLessonsTask.LessonsProcessingState.LESSONS_PROCESSING_STATE_COMPLETED) {
                iLPScenario.setPlayMode(ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYER_PLAYMODE_REVIEW);
            } else {
                iLPScenario.setPlayMode(ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYER_PLAYMODE);
            }
            g.a().aN().update((Object)iLPScenario);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not update scenario playMode, scenario: " + iLPScenario), (Throwable)sQLException);
        }
    }

    private void downloadReferencedUCSLinksFromScenario(ILPScenario iLPScenario) {
        try {
            if (iLPScenario == null) {
                return;
            }
            List<ILPLink> list = ch.ionesoft.ilp.book.pe.f.a().i(iLPScenario);
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            for (ILPLink iLPLink : list) {
                try {
                    if (f.a(iLPLink)) continue;
                    f.a().b(iLPLink);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not download UCS Link: " + iLPLink), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not download ucsLinks from scenario: " + iLPScenario), (Throwable)exception);
        }
    }

    private void handleLoadTopicRequest(String string) throws ICBRequestHandlingException {
        n n2 = ICBScenarioRequestDelegate.getObjectFromJsonPayload(string, n.class);
        o o2 = n2.a();
        String string2 = o2.a();
        logger.b((Object)("Handle load topic request. Loading topic from scenarioElement with id: " + string2));
        ILPScenario iLPScenario = ILPScenarioManager.getInstance().getCurrentScenario();
        ILPScenarioElement iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().a(string2, iLPScenario.getScenarioDefinition());
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.pe.f.a().a(iLPScenario, iLPScenarioElement);
        ILPScenarioManager.getInstance().setActiveElementResult(iLPScenarioElementResult);
        ch.ionesoft.ilp.book.scenario.p.a().b().c(iLPScenarioElement.getTopic());
    }

    private void handleLoadExerciseRequest(String string) throws ICBRequestHandlingException {
        m m2 = ICBScenarioRequestDelegate.getObjectFromJsonPayload(string, m.class);
        ch.ionesoft.ilp.book.scenario.player.model.f f2 = m2.a();
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = f2.a();
        if (f2.b() != null) {
            bl2 = f2.b();
        }
        if (f2.c() != null) {
            bl3 = f2.c();
        }
        logger.b((Object)("Handle load exercise request. Loading exercise from scenarioElement with id: " + string2));
        ILPScenario iLPScenario = ILPScenarioManager.getInstance().getCurrentScenario();
        ILPScenarioElement iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().a(string2, iLPScenario.getScenarioDefinition());
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.pe.f.a().a(iLPScenario, iLPScenarioElement);
        ILPScenarioManager.getInstance().setActiveElementResult(iLPScenarioElementResult);
        ch.ionesoft.ilp.book.scenario.p.a().b().a(iLPScenarioElement.getExercise(), bl2, bl3);
    }

    private void handleLoadAssetRequest(String string) throws ICBRequestHandlingException {
        k k2 = ICBScenarioRequestDelegate.getObjectFromJsonPayload(string, k.class);
        o o2 = k2.a();
        String string2 = o2.a();
        logger.b((Object)("Handle load asset request. Loading asset from scenarioElement with id: " + string2));
        ILPScenario iLPScenario = ILPScenarioManager.getInstance().getCurrentScenario();
        ILPScenarioElement iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().a(string2, iLPScenario.getScenarioDefinition());
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.pe.f.a().a(iLPScenario, iLPScenarioElement);
        ILPScenarioManager.getInstance().setActiveElementResult(iLPScenarioElementResult);
        ch.ionesoft.ilp.book.scenario.p.a().b().c(iLPScenarioElement.getResource());
    }

    private void handleLoadEmbeddedRequest(String string) throws ICBRequestHandlingException {
        l l2 = ICBScenarioRequestDelegate.getObjectFromJsonPayload(string, l.class);
        o o2 = l2.a();
        String string2 = o2.a();
        logger.b((Object)("Handle load embedded request. Loading embedded content from scenarioElement with id: " + string2));
        ILPScenario iLPScenario = ILPScenarioManager.getInstance().getCurrentScenario();
        ILPScenarioElement iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().a(string2, iLPScenario.getScenarioDefinition());
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.pe.f.a().a(iLPScenario, iLPScenarioElement);
        ILPScenarioManager.getInstance().setActiveElementResult(iLPScenarioElementResult);
        ch.ionesoft.ilp.book.scenario.p.a().b().b(iLPScenarioElement.getEmbeddedContent(), iLPScenarioElement);
    }

    private String handleStoreTopicRequest() throws ICBRequestHandlingException {
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.scenario.p.a().b().j();
        z z2 = new z();
        z2.b(this.createStoreTopicDto(iLPScenarioElementResult));
        return this.writeResponse(z2);
    }

    private String handleStoreExerciseRequest() throws ICBRequestHandlingException {
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.scenario.p.a().b().k();
        x x2 = new x();
        x2.b(this.createStoreExerciseDto(iLPScenarioElementResult));
        return this.writeResponse(x2);
    }

    private String handleStoreEmbeddedRequest() throws ICBRequestHandlingException {
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.scenario.p.a().b().l();
        v v2 = new v();
        v2.b(this.createStoreEmbeddedDto(iLPScenarioElementResult));
        return this.writeResponse(v2);
    }

    private String handleGetResultForTopicRequest(String string) throws ICBRequestHandlingException {
        ch.ionesoft.ilp.book.scenario.player.model.i i2 = ICBScenarioRequestDelegate.getObjectFromJsonPayload(string, ch.ionesoft.ilp.book.scenario.player.model.i.class);
        o o2 = i2.a();
        ILPScenario iLPScenario = ILPScenarioManager.getInstance().getCurrentScenario();
        ILPScenarioElement iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().a(o2.a(), iLPScenario.getScenarioDefinition());
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.pe.f.a().a(iLPScenario, iLPScenarioElement);
        j j2 = new j();
        j2.b(this.createStoreTopicDto(iLPScenarioElementResult));
        return this.writeResponse(j2);
    }

    private String handleGetResultForExerciseRequest(String string) throws ICBRequestHandlingException {
        ch.ionesoft.ilp.book.scenario.player.model.g g2 = ICBScenarioRequestDelegate.getObjectFromJsonPayload(string, ch.ionesoft.ilp.book.scenario.player.model.g.class);
        o o2 = g2.a();
        ILPScenario iLPScenario = ILPScenarioManager.getInstance().getCurrentScenario();
        ILPScenarioElement iLPScenarioElement = ch.ionesoft.ilp.book.pe.f.a().a(o2.a(), iLPScenario.getScenarioDefinition());
        ILPScenarioElementResult iLPScenarioElementResult = ch.ionesoft.ilp.book.pe.f.a().a(iLPScenario, iLPScenarioElement);
        h h2 = new h();
        h2.b(this.createStoreExerciseDto(iLPScenarioElementResult));
        return this.writeResponse(h2);
    }

    private y createStoreTopicDto(ILPScenarioElementResult iLPScenarioElementResult) {
        y y2 = new y();
        y2.b(true);
        return y2;
    }

    private w createStoreExerciseDto(ILPScenarioElementResult iLPScenarioElementResult) {
        w w2 = new w();
        w2.b(iLPScenarioElementResult.isProcessed());
        w2.b(Float.valueOf(iLPScenarioElementResult.getReachedPointsWithPrecision(0.01f)));
        w2.d(Float.valueOf(iLPScenarioElementResult.getMaxPointsFromExercise()));
        return w2;
    }

    private u createStoreEmbeddedDto(ILPScenarioElementResult iLPScenarioElementResult) {
        u u2 = new u();
        u2.b(true);
        return u2;
    }

    private void handleRequestFinishScenario() {
        try {
            ILPScenarioManager.getInstance().finishCurrentScenario(0.0f, null);
            this.viewDelegate.navigateToDashboard();
            ch.ionesoft.ilp.book.scenario.p.a().b().n();
            ch.ionesoft.ilp.book.scenario.p.a().a((String)null);
            ILPScenarioManager.reset();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not finish current scenario", (Throwable)exception);
        }
    }

    private void testScenarioElementExporter(ILPScenario iLPScenario) {
        try {
            g.a().aN().refresh((Object)iLPScenario);
            iLPScenario.getScenarioElementResults().refreshCollection();
            File file = ch.ionesoft.ilp.base.co.h.r();
            FileHelper.assureDirectoryExistsForFilePath((File)file);
            i i2 = new i();
            i2.a(true);
            String string = new File(ch.ionesoft.ilp.base.co.h.r(), String.valueOf(iLPScenario.getId()) + ".xml").getAbsolutePath();
            File file2 = new File(string);
            i2.a(iLPScenario, file2);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not export scenario: " + iLPScenario), (Throwable)exception);
        }
    }
}

